/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.BHView;

import egan.applets.BHView.toolBar;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;

public class BHView
extends Applet
implements MouseListener {
    private static final long serialVersionUID = 1L;
    boolean mouseIN = false;
    Image I;
    Graphics G;
    public boolean needPaint = true;
    public final int defaultStars = 5000;
    int nstars;
    int nbig;
    int nvbig;
    float[] phiTab;
    float[] thetaTab;
    public double r;
    public static final double dv = 0.2617993877991494;
    public static final double cosdv = Math.cos(0.2617993877991494);
    public static final double sindv = Math.sin(0.2617993877991494);
    public double tanFW = 2.0;
    public double tanFW2 = 4.0;
    static final double r27 = Math.sqrt(27.0);
    public double[] vp = new double[3];
    public double[] rh = new double[3];
    public double[] up = new double[3];
    public static final int STATIONARY = 0;
    public static final int FREE_FALL = 1;
    public static final int ORBITING = 2;
    public int obsMotion = 0;
    toolBar tb;
    String statusString = "";

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        Dimension dimension = this.getSize();
        this.setBackground(Color.black);
        this.setFont(new Font(this.getFont().getName(), 0, 10));
        this.setStars(5000);
        this.r = 10.0;
        this.vps(-1.0, 0.0);
        this.tb = new toolBar(dimension.width, dimension.height - dimension.width, this);
        this.add("South", this.tb);
        this.tb.setEnabled(true);
        this.addKeyListener(this.tb);
        this.tb.addKeyListener(this.tb);
        this.tb.addMouseListener(this.tb);
        this.tb.addMouseMotionListener(this.tb);
        this.addMouseListener(this);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.I == null) {
            this.I = this.createImage(n, n2);
            this.G = this.I.getGraphics();
            this.needPaint = true;
        }
        if (this.needPaint) {
            double d;
            double d2;
            String string = this.statusString;
            this.showStatus("Repainting sky ...");
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 1.0;
            double d6 = 1.0;
            float f = 1.0f;
            float f2 = 1.0f;
            this.G.setColor(Color.black);
            this.G.fillRect(0, 0, n, n2);
            boolean bl = this.obsMotion == 1;
            boolean bl2 = this.obsMotion == 2;
            double d7 = this.tanFW2 / (1.0 + this.tanFW * this.tanFW) / (double)n;
            double d8 = bl && this.r == 2.0 ? 0.499999 : 1.0 / this.r;
            double d9 = 2.0 * d8;
            double d10 = Math.abs(1.0 - d9);
            double d11 = Math.sqrt(d10);
            boolean bl3 = d8 >= 0.5;
            if (bl3) {
                d2 = Math.atan(r27 * d8 * d11);
                d = 0.16 - 0.04 / d8;
            } else {
                d2 = Math.asin(r27 * d8 * d11);
                if (this.r > 3.0) {
                    d2 = Math.PI - d2;
                }
                d = 0.13 - 0.1 * d8;
            }
            double d12 = d11 / d2;
            if (bl) {
                d4 = bl3 ? 0.5 / d8 : d9;
                d6 = 1.0 - d4;
                d5 = Math.sqrt(d6);
                d3 = Math.sqrt(d4);
            } else if (bl2) {
                d4 = d8 / (1.0 - d9);
                d6 = 1.0 - d4;
                d5 = Math.sqrt(d6);
                d3 = Math.sqrt(d4);
            }
            double[] dArray = new double[3];
            if (!bl2 || !(this.r <= 3.0)) {
                for (int i = 0; i < this.nstars; ++i) {
                    double d13 = this.thetaTab[i];
                    double d14 = Math.cos(d13);
                    double d15 = Math.sin(d13);
                    boolean bl4 = true;
                    double d16 = this.phiTab[i];
                    double d17 = Math.sin(d16);
                    block1: for (int j = 1; j <= 2; ++j) {
                        if (j == 2) {
                            d16 = Math.PI * 2 - (double)this.phiTab[i];
                            d14 = -d14;
                            d15 = -d15;
                        }
                        double d18 = -1.0;
                        while (d16 < 62.83185307179586) {
                            double d19;
                            double d20 = Math.exp(-d12 * d16 - d * d16 * d16);
                            double d21 = d2 * (1.0 - d20);
                            double d22 = Math.sin(d21);
                            double d23 = Math.cos(d21);
                            f = (float)(d11 * (bl3 ? d23 : 1.0));
                            if (bl) {
                                f = (float)(d10 / (bl3 ? Math.sqrt(d9) / d23 - 1.0 : 1.0 - Math.sqrt(d9) * d23));
                                d21 = Math.atan2(d5 * d22, d23 - d3);
                                d22 = Math.sin(d21);
                                d23 = Math.cos(d21);
                            } else if (bl2) {
                                double d24 = d22 * d14;
                                double d25 = d24 * d24;
                                double d26 = (d3 * (1.0 - d25) + d6 * d24) / (1.0 - d4 * d25);
                                double d27 = d22 * d15 / d23;
                                dArray[0] = (double)(d23 > 0.0 ? 1 : -1) * Math.sqrt((1.0 - d26 * d26) / (1.0 + d27 * d27));
                                dArray[1] = d26;
                                dArray[2] = d27 * dArray[0];
                                d21 = Math.acos(dArray[0]);
                                f *= (float)((1.0 - d3 * d26) / d5);
                            }
                            if (d21 - d18 < d7) continue block1;
                            d18 = d21;
                            if (!bl2) {
                                dArray[0] = d23;
                                dArray[1] = d22 * d14;
                                dArray[2] = d22 * d15;
                            }
                            double d28 = this.Dot(dArray, this.vp);
                            if (d19 > 0.0) {
                                double d29 = this.Dot(dArray, this.rh);
                                double d30 = this.Dot(dArray, this.up);
                                int n3 = n / 2 + (int)(d29 / d28 * (double)n / this.tanFW2);
                                int n4 = n / 2 - (int)(d30 / d28 * (double)n / this.tanFW2);
                                if (n3 >= 0 && n3 < n && n4 >= 0 && n4 < n2) {
                                    float f3;
                                    Color color;
                                    f2 = (float)Math.sqrt((1.0 + 2.0 * d * d16 / d12) * d20 * d22 / d17);
                                    if (f2 < 0.2f) {
                                        f2 = 0.2f;
                                    }
                                    if (f2 > 1.0f) {
                                        f2 = 1.0f;
                                    }
                                    f *= f;
                                    Color color2 = null;
                                    Color color3 = null;
                                    if (f < 1.0f) {
                                        color = new Color(f * f2, f * f2, f2);
                                    } else {
                                        f3 = 1.0f / f;
                                        color = color2 = new Color(f2, f3 * f2, f3 * f2);
                                    }
                                    if (i < this.nbig && bl4) {
                                        Color color4;
                                        f2 = 0.6f * f2;
                                        if (f < 1.0f) {
                                            color4 = new Color(f * f2, f * f2, f2);
                                        } else {
                                            f3 = 1.0f / f;
                                            color4 = color3 = new Color(f2, f3 * f2, f3 * f2);
                                        }
                                    }
                                    if (i < this.nvbig && bl4) {
                                        this.G.setColor(color2);
                                        this.G.drawLine(n3 - 1, n4 - 1, n3 + 1, n4 + 1);
                                        this.G.drawLine(n3 - 1, n4 + 1, n3 + 1, n4 - 1);
                                        this.G.drawLine(n3 - 2, n4, n3 + 2, n4);
                                        this.G.drawLine(n3, n4 + 2, n3, n4 - 2);
                                    } else if (i < this.nbig && bl4) {
                                        this.G.setColor(color3);
                                        this.G.drawLine(n3 - 1, n4 - 1, n3 + 1, n4 + 1);
                                        this.G.drawLine(n3 - 1, n4 + 1, n3 + 1, n4 - 1);
                                        this.G.setColor(color2);
                                        this.G.drawLine(n3 - 1, n4, n3 + 1, n4);
                                        this.G.drawLine(n3, n4 + 1, n3, n4 - 1);
                                    } else {
                                        this.G.setColor(color2);
                                        this.G.drawLine(n3, n4, n3, n4);
                                    }
                                }
                            }
                            bl4 = false;
                            d16 += Math.PI * 2;
                        }
                    }
                }
            }
            this.needPaint = false;
            this.showStatus(string);
        }
        graphics.drawImage(this.I, 0, 0, null);
        super.paint(graphics);
    }

    public void setStars(int n) {
        this.nstars = n;
        this.nbig = this.nstars / 6;
        this.nvbig = this.nbig / 10;
        this.phiTab = new float[n];
        this.thetaTab = new float[n];
        Random random = new Random();
        random.setSeed(12345678L);
        for (int i = 0; i < n; ++i) {
            double d = random.nextDouble() - 0.5;
            double d2 = random.nextDouble() - 0.5;
            this.phiTab[i] = (float)Math.atan2(Math.sqrt(d * d + d2 * d2), random.nextDouble() - 0.5);
            this.thetaTab[i] = (float)Math.atan2(d2, d);
        }
    }

    double Dot(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    public void vps(double d, double d2) {
        double d3 = Math.atan2(Math.abs(d2), Math.abs(d));
        d3 = (double)Math.round(d3 / 0.2617993877991494) * 0.2617993877991494;
        double d4 = Math.cos(d3);
        if (d < 0.0) {
            d4 = -d4;
        }
        double d5 = Math.sin(d3);
        if (d2 < 0.0) {
            d5 = -d5;
        }
        this.vp[0] = d4;
        this.vp[1] = d5;
        this.vp[2] = 0.0;
        this.rh[0] = d5;
        this.rh[1] = -d4;
        this.rh[2] = 0.0;
        this.up[1] = 0.0;
        this.up[0] = 0.0;
        this.up[2] = 1.0;
    }

    public void rotView(double d, double d2) {
        double d3 = this.vp[0] * d - this.vp[1] * d2;
        double d4 = this.vp[0] * d2 + this.vp[1] * d;
        this.vp[0] = d3;
        this.vp[1] = d4;
        this.rh[0] = d4;
        this.rh[1] = -d3;
    }

    @Override
    public void showStatus(String string) {
        super.showStatus(string);
        this.statusString = string;
        this.tb.repaint();
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
        this.mouseIN = true;
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.mouseIN = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

