/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.BHView;

import egan.applets.BHView.BHView;
import egan.graphics.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class toolBar
extends Panel
implements MouseListener,
MouseMotionListener,
KeyListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    boolean mouseIN = false;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    Dimension tbd;
    BHView bhv;
    Panel p;
    Choice viewWidth;
    Choice obsVelocity;
    Choice distScale;
    Choice starCount;
    final int posRad = 7;
    final int vpRad = 18;
    final int vpRad2 = 15;
    final int vpDist = 9;
    final int ytick = 3;
    boolean posSel = false;
    boolean vpSel = false;
    boolean newView = false;
    boolean newPos = false;
    public boolean needPaint = true;
    int scaleX;
    int scaleY;
    int scaleLength;
    double scaleUnit;
    int posX;
    int posY;
    int vpX;
    int vpY;
    double[] zerRadList = new double[]{0.0, 0.0, 0.0, 2.96, 1.96};
    double[] minRadList = new double[]{0.1, 0.1, 0.1, 2.96, 1.96};
    double[] incRadList = new double[]{0.1, 0.1, 0.1, 0.001, 0.001};
    double[] bigIncList = new double[]{5.0, 2.0, 1.0, 0.01, 0.01};
    double[] maxRadList = new double[]{50.0, 24.0, 12.0, 3.04, 2.04};
    final int defaultScale = 2;
    int currentScale = 2;
    double zerRad;
    double minRad;
    double incRad;
    double bigInc;
    double maxRad;
    Image I;
    Graphics G;
    final String msg1 = "Drag circle to change viewpoint, drag line of sight to change direction of view";
    final String msg2 = "Drag circle to change viewpoint";
    final String msg3 = "Drag line of sight to change direction of view";

    @Override
    public Dimension getPreferredSize() {
        return this.tbd;
    }

    toolBar(int n, int n2, BHView bHView) {
        int n3;
        this.bhv = bHView;
        this.tbd = new Dimension(n, n2);
        this.scaleY = n2 / 2;
        this.setBackground(Color.gray);
        this.setForeground(Color.black);
        this.setLayout(new FlowLayout(0));
        this.p = new Panel();
        this.p.setSize(4 * n / 18, n2 - 2);
        this.p.setLayout(new GridLayout(0, 1));
        this.add(this.p);
        this.viewWidth = new Choice();
        this.viewWidth.addItem("Width 28 deg");
        this.viewWidth.addItem("Width 53 deg");
        this.viewWidth.addItem("Width 90 deg");
        this.viewWidth.addItem("Width 127 deg");
        this.viewWidth.select(3);
        this.viewWidth.setBackground(Color.white);
        this.p.add(this.viewWidth);
        this.viewWidth.addItemListener(this);
        this.obsVelocity = new Choice();
        this.obsVelocity.addItem("Stationary");
        this.obsVelocity.addItem("Free-falling");
        this.obsVelocity.addItem("Circular orbit (r>3M)");
        this.obsVelocity.select(0);
        this.obsVelocity.setBackground(Color.white);
        this.p.add(this.obsVelocity);
        this.obsVelocity.addItemListener(this);
        this.distScale = new Choice();
        for (n3 = 0; n3 < this.minRadList.length; ++n3) {
            this.distScale.addItem(this.minRadList[n3] + " M - " + this.maxRadList[n3] + " M");
        }
        this.distScale.select(2);
        this.distScale.setBackground(Color.white);
        this.p.add(this.distScale);
        this.distScale.addItemListener(this);
        this.starCount = new Choice();
        for (n3 = 0; n3 <= 7; ++n3) {
            this.starCount.addItem(bHView.defaultStars * (1 << n3) + " stars");
        }
        this.starCount.select(0);
        this.starCount.setBackground(Color.white);
        this.p.add(this.starCount);
        this.starCount.addItemListener(this);
    }

    void setupScale() {
        int n = this.currentScale;
        this.zerRad = this.zerRadList[n];
        this.minRad = this.minRadList[n];
        this.incRad = this.incRadList[n];
        this.bigInc = this.bigIncList[n];
        this.maxRad = this.maxRadList[n];
        int n2 = this.p.getLocation().x + this.p.getSize().width + 3;
        int n3 = this.getSize().width - 4;
        int n4 = n3 - n2;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n5 = (int)Math.round((this.maxRad - this.zerRad) / this.bigInc);
        this.scaleLength = n5 * ((n4 - (fontMetrics.stringWidth(this.zerRad + " M") + fontMetrics.stringWidth(this.maxRad + " M") + 1) / 2) / n5);
        this.scaleX = n2 + (n4 - this.scaleLength) / 2;
        this.scaleUnit = (double)this.scaleLength / (this.maxRad - this.zerRad);
        if (this.bhv.r < this.minRad) {
            this.bhv.r = this.minRad;
        }
        if (this.bhv.r > this.maxRad) {
            this.bhv.r = this.maxRad;
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.I == null) {
            this.I = this.createImage(n, n2);
            this.G = this.I.getGraphics();
            this.G.setFont(this.getFont());
            this.needPaint = true;
        }
        if (this.needPaint) {
            Object object;
            this.G.setColor(Color.gray);
            this.G.fillRect(0, 0, n, n2);
            this.G.setColor(Color.black);
            this.G.drawRect(0, 0, n - 1, n2 - 1);
            this.G.drawRect(2, 2, n - 5, n2 - 5);
            Graphics2D graphics2D = (Graphics2D)this.G;
            graphics2D.setRenderingHints(aaON);
            this.setupScale();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.G.drawLine(this.scaleX, this.scaleY, this.scaleX + this.scaleLength, this.scaleY);
            int n3 = (int)Math.round((this.maxRad - this.zerRad) / this.bigInc);
            int n4 = this.scaleLength / n3;
            for (int i = 0; i <= n3; ++i) {
                int n5 = this.scaleX + n4 * i;
                this.G.drawLine(n5, this.scaleY - 3, n5, this.scaleY + 3);
                if (i % 2 != 0) continue;
                object = this.zerRad + (double)i * this.bigInc + " M";
                this.G.drawString((String)object, n5 - fontMetrics.stringWidth((String)object) / 2, this.scaleY - 6);
            }
            this.posX = this.scaleX + (int)(this.scaleUnit * (this.bhv.r - this.zerRad));
            this.posY = this.scaleY;
            this.G.setColor(this.posSel ? Color.red : Color.blue);
            this.G.drawOval(this.posX - 7, this.posY - 7, 14, 14);
            double d = this.bhv.tanFW;
            object = this.bhv.vp;
            Object object2 = object[0];
            Object object3 = object[1];
            double[] dArray = this.bhv.rh;
            double d2 = dArray[0];
            double d3 = dArray[1];
            double d4 = Math.sqrt(1.0 + d * d);
            double d5 = 1.0 / d4;
            double d6 = d / d4;
            this.vpX = this.posX + (int)(18.0 * object2);
            this.vpY = this.posY - (int)(18.0 * object3);
            this.G.setColor(this.vpSel ? Color.red : Color.blue);
            this.G.drawLine(this.posX + (int)(8.0 * object2), this.posY - (int)(8.0 * object3), this.vpX, this.vpY);
            reference var27_21 = object2 * d5 + d2 * d6;
            reference var29_22 = object3 * d5 + d3 * d6;
            this.G.drawLine(this.posX + (int)(8.0 * var27_21), this.posY - (int)(8.0 * var29_22), this.posX + (int)(15.0 * var27_21), this.posY - (int)(15.0 * var29_22));
            reference var31_23 = object2 * d5 - d2 * d6;
            reference var33_24 = object3 * d5 - d3 * d6;
            this.G.drawLine(this.posX + (int)(8.0 * var31_23), this.posY - (int)(8.0 * var33_24), this.posX + (int)(15.0 * var31_23), this.posY - (int)(15.0 * var33_24));
            this.needPaint = false;
        }
        graphics.drawImage(this.I, 0, 0, null);
        this.maybeShowStatus(graphics);
        super.paint(graphics);
    }

    boolean okPos(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n > this.scaleX - this.scaleLength / 36 && n < this.scaleX + this.scaleLength + this.scaleLength / 36 && n2 < this.scaleY + 6 && n2 > this.scaleY - 6;
        if (bl) {
            this.bhv.r = this.zerRad + (double)Math.round((double)(n - this.scaleX) / this.scaleUnit / this.incRad) * this.incRad;
            if (this.bhv.r < this.minRad) {
                this.bhv.r = this.minRad;
            }
            if (this.bhv.r > this.maxRad) {
                this.bhv.r = this.maxRad;
            }
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        boolean bl = object == this.viewWidth;
        if (bl) {
            this.bhv.tanFW = Math.pow(2.0, (double)this.viewWidth.getSelectedIndex() - 2.0);
            this.bhv.tanFW2 = 2.0 * this.bhv.tanFW;
        } else {
            bl = object == this.obsVelocity;
            if (bl) {
                this.bhv.obsMotion = this.obsVelocity.getSelectedIndex();
            } else {
                bl = object == this.distScale;
                if (bl) {
                    this.currentScale = this.distScale.getSelectedIndex();
                    this.setupScale();
                } else {
                    bl = object == this.starCount;
                    if (bl) {
                        this.bhv.setStars((1 << this.starCount.getSelectedIndex()) * this.bhv.defaultStars);
                    }
                }
            }
        }
        if (bl) {
            this.needPaint = true;
            this.repaint();
            this.bhv.needPaint = true;
            this.bhv.repaint();
        }
    }

    void maybeShowStatus(Graphics graphics) {
        if (this.bhv.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.bhv.statusString, (Graphics)graphics, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
        this.mouseIN = true;
        this.bhv.showStatus("Drag circle to change viewpoint, drag line of sight to change direction of view");
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
        this.mouseIN = false;
        this.bhv.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.mouseIN = true;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.newPos = false;
        this.newView = false;
        int n3 = (n - this.posX) * (n - this.posX) + (n2 - this.posY) * (n2 - this.posY);
        int n4 = (n - this.vpX) * (n - this.vpX) + (n2 - this.vpY) * (n2 - this.vpY);
        this.posSel = n3 < 49;
        if (this.posSel) {
            this.needPaint = true;
            this.bhv.showStatus("Drag circle to change viewpoint");
            this.repaint();
        }
        if (this.vpSel = n4 < 81) {
            this.needPaint = true;
            this.bhv.showStatus("Drag line of sight to change direction of view");
            this.repaint();
        }
        if (!this.posSel && !this.vpSel && this.okPos(n, n2)) {
            this.newPos = true;
            this.needPaint = true;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.posSel = false;
        this.vpSel = false;
        if (this.newView || this.newPos) {
            this.bhv.needPaint = true;
            this.bhv.repaint();
        }
        this.needPaint = true;
        this.bhv.showStatus("Drag circle to change viewpoint, drag line of sight to change direction of view");
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.posSel) {
            if (this.okPos(n, n2)) {
                this.newPos = true;
            }
        } else if (this.vpSel) {
            this.bhv.vps(n - this.posX, this.posY - n2);
            this.newView = true;
        }
        this.needPaint = true;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        double d;
        double d2;
        double d3;
        int n = keyEvent.getKeyCode();
        if (keyEvent.isShiftDown()) {
            d3 = this.bigInc;
            d2 = 0.0;
            d = 1.0;
        } else {
            d3 = this.incRad;
            d2 = BHView.cosdv;
            d = BHView.sindv;
        }
        if (bl = n == 37 || n == 226) {
            double d4;
            this.bhv.r -= d3;
            if (d4 < this.minRad) {
                this.bhv.r = this.minRad;
            }
        } else {
            bl = n == 39 || n == 227;
            if (bl) {
                double d5;
                this.bhv.r += d3;
                if (d5 > this.maxRad) {
                    this.bhv.r = this.maxRad;
                }
            } else {
                boolean bl2 = n == 38 || n == 224;
                bl = bl2 || n == 40 || n == 225;
                if (bl) {
                    if (bl2) {
                        this.bhv.rotView(d2, d);
                    } else {
                        this.bhv.rotView(d2, -d);
                    }
                }
            }
        }
        if (bl) {
            this.needPaint = true;
            this.repaint();
            this.bhv.needPaint = true;
            this.bhv.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

