/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.Decoherence;

import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;

public class Decoherence
extends Applet
implements Runnable,
MouseListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    boolean mouseIN = false;
    Image I;
    Image bg;
    Font fnt;
    Graphics G;
    Graphics gg;
    long F = 0L;
    long tStep = 80L;
    long pt;
    boolean done = false;
    private volatile Thread a;
    Random ran;
    int experiment = 0;
    Choice expChoice;
    int NPHASES;
    int[] totals;
    int[] counts;
    int phase;
    int fh;
    int fd;
    int ft;
    int border;
    int xinc = 5;
    int schematicH;
    int sH;
    int sW;
    int xaxis;
    int haxis;
    int origX;
    int origY;
    int phaseDialX;
    int phaseDialY;
    int phaseDialR;
    int lreX;
    int lreY;
    int lrpX;
    int lrpY;
    static final String theta = "\u03b8";
    static final String sqrt = "\u221a";
    static final String xlabel = "phase \u03b8";
    String statusString = "";

    @Override
    public void init() {
        this.expChoice = new Choice();
        for (int i = 0; i < 3; ++i) {
            this.expChoice.addItem("Experiment " + (i + 1));
        }
        this.expChoice.select(this.experiment);
        this.add(this.expChoice);
        this.expChoice.addItemListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thread = Thread.currentThread();
        while (this.a == thread) {
            long l = System.currentTimeMillis();
            Decoherence decoherence = this;
            synchronized (decoherence) {
                if (l - this.pt > this.tStep || l < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(this.done ? 500L : 50L);
            }
            catch (Exception exception) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public synchronized void update(Graphics graphics) {
        long l = System.currentTimeMillis();
        if (l - this.pt > this.tStep || l < this.pt) {
            this.pt = l;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            if (this.I == null) {
                this.I = this.createImage(n, n2);
                this.G = this.I.getGraphics();
                this.bg = this.createImage(n, n2);
                this.gg = this.bg.getGraphics();
            }
            this.d(this.G, n, n2, this.F);
            graphics.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(graphics);
            ++this.F;
        }
    }

    public void d(Graphics graphics, int n, int n2, long l) {
        int n3;
        int n4;
        int n5;
        Object object;
        if (l == 0L) {
            int n6;
            this.ran = new Random();
            object = GraphicsUtils.getNiceFont((Component)this);
            this.fnt = new Font((String)object, 0, 16);
            FontMetrics fontMetrics = this.getFontMetrics(this.fnt);
            this.fh = fontMetrics.getAscent();
            this.fd = fontMetrics.getDescent();
            this.ft = this.fh + this.fd;
            int n7 = fontMetrics.stringWidth(xlabel);
            this.schematicH = n2 / 4;
            this.sH = this.schematicH / 3;
            this.border = Math.max(Math.max(n7 + 10, Math.max(3 * this.ft, 30)), 2 * this.expChoice.getLocation().y + this.expChoice.getSize().height);
            this.NPHASES = 10 * ((n - 2 * this.border) / this.xinc / 10);
            this.xaxis = this.xinc * this.NPHASES;
            this.border = (n - this.xaxis) / 2;
            this.sW = this.xaxis / 5;
            this.haxis = (n2 - 3 * this.border - this.schematicH) / 2;
            this.origX = this.border;
            this.origY = n2 - this.border - this.haxis - 1;
            this.phase = 0;
            this.totals = new int[this.NPHASES];
            this.counts = new int[this.NPHASES];
            this.gg.setColor(Color.white);
            this.gg.fillRect(0, 0, n, n2);
            this.gg.setColor(Color.black);
            this.gg.setFont(this.fnt);
            Graphics2D graphics2D = (Graphics2D)this.gg;
            graphics2D.setRenderingHints(aaON);
            this.gg.drawRect(this.border, this.border, this.sW, this.sH);
            String string = "electron source";
            n5 = fontMetrics.stringWidth(string);
            this.gg.drawString(string, this.border + (this.sW - n5) / 2, this.border + this.sH + this.ft);
            this.phaseDialX = this.border + this.sW / 2;
            this.phaseDialY = this.border + this.sH / 2;
            this.phaseDialR = Math.min(this.sW, this.sH) / 3;
            this.gg.drawOval(this.phaseDialX - this.phaseDialR, this.phaseDialY - this.phaseDialR, 2 * this.phaseDialR + 1, 2 * this.phaseDialR + 1);
            this.gg.drawString(theta, this.phaseDialX + this.phaseDialR + 5, this.phaseDialY + this.ft / 2 - this.fd);
            String string2 = "(UP + exp(i\u03b8) DOWN)/\u221a2";
            n4 = fontMetrics.stringWidth(string2);
            this.gg.drawString(string2, this.border + (this.sW - n4) / 2, this.border + this.sH + 2 * this.ft);
            int n8 = this.border + 4 * this.sW;
            this.gg.drawRect(n8, this.border, this.sW, this.sH);
            String string3 = "measure x-axis spin";
            n3 = fontMetrics.stringWidth(string3);
            this.gg.drawString(string3, n8 + (this.sW - n3) / 2, this.border + this.sH + this.ft);
            this.lreX = n8 + this.sW / 2 - fontMetrics.stringWidth("RIGHT") / 2;
            this.lreY = this.border + this.sH / 2 + this.ft / 2 - this.fd;
            int n9 = this.border + this.sH / 2;
            if (this.experiment == 0) {
                this.gg.setColor(Color.green);
                this.gg.drawLine(this.border + this.sW + 1, n9, n8 - 1, n9);
            } else {
                int n10;
                n6 = this.border + 2 * this.sW;
                this.gg.drawRect(n6, this.border, this.sW, this.schematicH);
                String string4 = "positron entangler";
                int n11 = fontMetrics.stringWidth(string4);
                this.gg.drawString(string4, n6 + (this.sW - n11) / 2, this.border + this.schematicH + this.ft);
                if (this.experiment == 2) {
                    n10 = this.border + 2 * this.sH;
                    this.gg.drawRect(n8, n10, this.sW, this.sH);
                    this.gg.drawString(string3, n8 + (this.sW - n3) / 2, n10 + this.sH + this.ft);
                    this.lrpX = this.lreX;
                    this.lrpY = this.lreY + 2 * this.sH;
                }
                this.gg.setColor(Color.green);
                this.gg.drawLine(this.border + this.sW + 1, n9, n6 - 1, n9);
                this.gg.drawLine(n6 + this.sW + 1, n9, n8 - 1, n9);
                this.gg.setColor(Color.blue);
                n10 = n9 + 2 * this.sH;
                this.gg.drawLine(n6 + this.sW + 1, n10, (this.experiment == 2 ? n8 : n8 + this.sW) - 1, n10);
            }
            this.gg.setColor(Color.black);
            this.gg.drawLine(this.origX, this.origY, this.origX + this.xaxis, this.origY);
            this.gg.drawLine(this.origX, this.origY - this.haxis, this.origX, this.origY + this.haxis);
            this.gg.drawString(xlabel, this.origX + this.xaxis + 5, this.origY);
            n6 = this.origX - Math.min(15, this.border / 2);
            int n12 = this.origY - this.haxis - this.fd - 4 * this.ft - (this.experiment == 2 ? this.ft : 0);
            this.gg.drawString("Average", n6, n12 += this.ft);
            this.gg.drawString("electron spin", n6, n12 += this.ft);
            if (this.experiment == 2) {
                this.gg.drawString("times positron spin", n6, n12 += this.ft);
            }
            this.gg.drawString("measured left-right", n6, n12 += this.ft);
        }
        object = (Graphics2D)graphics;
        ((Graphics2D)object).setRenderingHints(aaON);
        double d = (double)this.phase * (Math.PI * 2) / (double)this.NPHASES;
        double d2 = this.ran.nextDouble();
        n5 = 0;
        int n13 = 0;
        n4 = 0;
        if (this.experiment == 0) {
            double d3 = 0.5 * (1.0 + Math.cos(d));
            n5 = d2 < d3 ? 1 : -1;
            n4 = n5;
        } else if (this.experiment == 1) {
            n5 = d2 < 0.5 ? 1 : -1;
            n4 = n5;
        } else {
            double d4 = 0.25 * (1.0 + Math.cos(d));
            double d5 = d4 + 0.25 * (1.0 - Math.cos(d));
            double d6 = d5 + 0.25 * (1.0 - Math.cos(d));
            if (d2 < d4) {
                n5 = 1;
                n13 = 1;
            } else if (d2 < d5) {
                n5 = 1;
                n13 = -1;
            } else if (d2 < d6) {
                n5 = -1;
                n13 = 1;
            } else {
                n5 = -1;
                n13 = -1;
            }
            n4 = n5 * n13;
        }
        int n14 = this.phase;
        this.totals[n14] = this.totals[n14] + n4;
        int n15 = this.phase;
        this.counts[n15] = this.counts[n15] + 1;
        this.phase = (this.phase + 1) % this.NPHASES;
        graphics.drawImage(this.bg, 0, 0, null);
        graphics.setColor(Color.black);
        graphics.drawLine(this.phaseDialX, this.phaseDialY, this.phaseDialX + (int)((double)this.phaseDialR * Math.cos(d)), this.phaseDialY - (int)((double)this.phaseDialR * Math.sin(d)));
        graphics.setColor(Color.green);
        graphics.setFont(this.fnt);
        graphics.drawString(n5 == 1 ? "RIGHT" : "LEFT", this.lreX, this.lreY);
        if (this.experiment == 2) {
            graphics.setColor(Color.blue);
            graphics.drawString(n13 == 1 ? "RIGHT" : "LEFT", this.lrpX, this.lrpY);
        }
        graphics.setColor(Color.green);
        for (int i = 0; i < this.NPHASES; ++i) {
            if (this.counts[i] == 0) continue;
            int n16 = this.origX + this.xinc * i;
            n3 = this.origY - this.totals[i] * this.haxis / this.counts[i];
            graphics.drawRect(n16 - 2, n3 - 2, 5, 5);
            if (this.experiment != 2) continue;
            graphics.setColor(Color.blue);
            graphics.drawRect(n16 - 1, n3 - 1, 3, 3);
            graphics.setColor(Color.green);
        }
        graphics.setColor(Color.black);
        graphics.drawString(this.phase + 1 + " phase points of " + this.NPHASES + " in run " + this.counts[0], 2 * this.border, n2 - this.fd - this.ft);
    }

    @Override
    public void showStatus(String string) {
        super.showStatus(string);
        this.statusString = string;
    }

    void maybeShowStatus(Graphics graphics) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)graphics, (Component)this);
        }
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        int n;
        Object object = itemEvent.getSource();
        if (object == this.expChoice && (n = this.expChoice.getSelectedIndex()) != this.experiment) {
            this.experiment = n;
            this.F = 0L;
            this.done = false;
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
        this.mouseIN = true;
        this.showStatus("Click to restart experiment");
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.F = 0L;
        this.done = false;
        this.mouseIN = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

