/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.GWaves;

import egan.applets.GWaves.GWaves;
import egan.applets.GWaves.Offscreen;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.RenderingHints;

class Detector
extends Panel {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GWaves gw;
    Dimension pd;
    double cos2phase;
    double sin2phase;
    double effect = 0.0;
    double power = 0.0;
    static final int nring = 32;
    static final int nringQ = 40;
    float[] xtab = new float[32];
    double xSc = 0.0;
    double ySc = 0.0;
    double prevt = 0.0;
    int prevx;
    int prevy;
    boolean freshGraph = true;
    boolean freshSc = true;
    boolean done = true;
    Offscreen graph;
    Offscreen misc;

    @Override
    public Dimension getPreferredSize() {
        return this.pd;
    }

    Detector(GWaves gWaves, Dimension dimension) {
        this.gw = gWaves;
        this.pd = dimension;
        for (int i = 0; i < 32; ++i) {
            this.xtab[i] = (float)Math.cos(0.19634954084936207 * (double)i);
        }
        this.graph = new Offscreen();
        this.misc = new Offscreen();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        this.graph.ensure(this, false);
        Graphics graphics2 = this.misc.ensure(this, false);
        int n = this.misc.width;
        int n2 = this.misc.height;
        Graphics2D graphics2D = (Graphics2D)graphics2;
        graphics2D.setRenderingHints(aaON);
        if (!this.done) {
            int n3 = n / 50;
            int n4 = this.getFontMetrics(this.getFont()).getHeight();
            if (this.gw.o.mD) {
                graphics2.setColor(Color.white);
                graphics2.fillRect(1, 2, n - 3, n4);
                graphics2.fillRect(1, n2 - n4 - 1, n - 3, n4);
                graphics2.setColor(Color.red);
            } else {
                graphics2.drawImage(this.graph.i, 0, 0, null);
                graphics2.setColor(Color.red);
                int n5 = n2 > n ? 2 * n / 5 : 2 * n2 / 10;
                double d = this.effect == 0.0 ? 0.0 : 0.2;
                for (int i = 0; i < 32; ++i) {
                    int n6 = n / 2 - 3 + (int)((double)n5 * ((double)this.xtab[i] - d * ((double)this.xtab[i] * (-3.0 + this.gw.cos2Chi) * this.cos2phase + (double)(4.0f * this.xtab[(40 - i) % 32]) * this.gw.sinChi * this.sin2phase) / 2.0));
                    int n7 = n2 / 2 - 3 + (int)((double)n5 * ((double)this.xtab[(40 - i) % 32] + d * ((double)this.xtab[(40 - i) % 32] * (-3.0 + this.gw.cos2Chi) * this.cos2phase - (double)(4.0f * this.xtab[i]) * this.gw.sinChi * this.sin2phase) / 2.0));
                    if (i % 8 == 0) {
                        graphics2.fillOval(n6, n7, 6, 6);
                    }
                    graphics2.drawOval(n6, n7, 6, 6);
                }
            }
            if (this.power != 0.0) {
                graphics2.drawString("Actual distortion 100 light-years away is 1 part in " + this.makeExponential(1.0 / this.effect), n3, n2 - n4 / 2);
            }
            graphics2.drawString(this.makePower("Total power being radiated = ", this.power), n3, n4);
            this.done = true;
        }
        graphics.drawImage(this.misc.i, 0, 0, null);
    }

    public void modifyRing(double d, double d2) {
        this.cos2phase = d;
        this.sin2phase = d2;
        if (this.done) {
            this.done = false;
            this.repaint();
        }
    }

    public void modifyEffect(double d, double d2) {
        this.power = d2;
        this.effect = d;
        if (this.done) {
            this.done = false;
            this.repaint();
        }
    }

    public void modifyGraph(double d, double d2, double d3) {
        Graphics graphics = this.graph.ensure(this, this.freshGraph || this.freshSc);
        int n = this.graph.width;
        int n2 = this.graph.height;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(aaON);
        if (this.freshGraph || this.freshSc) {
            this.prevx = 0;
            this.prevt = 0;
        }
        if (this.freshSc) {
            this.ySc = (double)n2 / (this.effect * (-3.0 + this.gw.cos2Chi) / 2.0) / 6.0;
            this.xSc = 1.0 / d3;
            this.prevy = n2 / 2;
        }
        double d4 = this.xSc * d3;
        double d5 = this.prevt + d4;
        double d6 = this.ySc * (this.effect * (-3.0 + this.gw.cos2Chi) / 2.0);
        int n3 = (int)d5;
        int n4 = n2 / 2 - (int)(d6 * d);
        if (this.prevx > 0) {
            graphics.setColor(Color.black);
            graphics.drawLine(this.prevx, this.prevy, n3, n4);
        }
        this.prevx = n3;
        this.prevt = d5;
        this.prevy = n4;
        this.freshGraph = n3 > n;
        this.freshSc = 128.0 * d4 < 2.0 || d4 > (double)(n / 10) || d6 < 5.0 || d6 > 0.45 * (double)n2;
    }

    String makePower(String string, double d) {
        double d2;
        String string2 = null;
        if (d < 0.001) {
            d2 = 1.0E-6;
            string2 = " microwatt";
        } else if (d < 1.0) {
            d2 = 0.001;
            string2 = " milliwatt";
        } else if (d < 1000.0) {
            d2 = 1.0;
            string2 = " watt";
        } else if (d < 1000000.0) {
            d2 = 1000.0;
            string2 = " kilowatt";
        } else if (d < 1.0E9) {
            d2 = 1000000.0;
            string2 = " megawatt";
        } else {
            d2 = 1.0E9;
            string2 = " gigawatt";
        }
        d2 = d / d2;
        return new StringBuffer(string).append(this.makeExponential(d2)).append(string2).append(Math.round(d2) != 1L ? "s" : "").toString();
    }

    String makeExponential(double d) {
        int n = 0;
        double d2 = 1.0;
        while (Math.abs(d / d2) > 10.0) {
            ++n;
            d2 *= 10.0;
        }
        if (n == 0) {
            return Long.toString(Math.round(d));
        }
        return Math.round(d / d2) + " x 10^" + n;
    }
}

