/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.GWaves;

import egan.applets.GWaves.Detector;
import egan.applets.GWaves.Orbit;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class GWaves
extends Applet
implements ItemListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public double degChi = 30.0;
    public double sinChi = 0.5;
    public double cos2Chi = 0.5;
    public Choice aList;
    Label label;
    public Button restart;
    public Orbit o;
    public Detector d;

    @Override
    public void init() {
        String string = "RESTART";
        String string2 = "  Angle between orbital plane and line of sight: ";
        String string3 = "90 deg";
        Font font = null;
        int n = 0;
        int n2 = 16;
        while (true) {
            font = new Font(this.getFont().getName(), 0, n2);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.setFont(font);
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.setLayout(new FlowLayout(1, 0, 1));
            n = 0;
            this.restart = new Button(string);
            this.add(this.restart);
            this.restart.setEnabled(false);
            int n3 = this.restart.getPreferredSize().height;
            if (n3 > n) {
                n = n3;
            }
            this.label = new Label(string2);
            this.add(this.label);
            n3 = this.label.getPreferredSize().height;
            if (n3 > n) {
                n = n3;
            }
            this.aList = new Choice();
            this.aList.addItem(" 0 deg");
            this.aList.addItem("30 deg");
            this.aList.addItem("45 deg");
            this.aList.addItem("60 deg");
            this.aList.addItem("90 deg");
            this.aList.select(1);
            this.add(this.aList);
            n3 = this.aList.getPreferredSize().height;
            if (n3 > n) {
                n = n3;
            }
            if (this.restart.getPreferredSize().width + this.label.getPreferredSize().width + this.aList.getPreferredSize().width + 20 <= this.getSize().width || n2 == 6) break;
            --n2;
            this.remove(this.aList);
            this.remove(this.label);
            this.remove(this.restart);
        }
        this.aList.addItemListener(this);
        this.restart.addActionListener(this);
        Dimension dimension = new Dimension(this.getSize().width - 2, (this.getSize().height - n - 4) / 2);
        this.o = new Orbit(this, dimension);
        this.add(this.o);
        this.d = new Detector(this, dimension);
        this.add(this.d);
        this.o.init();
        this.repaint();
    }

    @Override
    public void start() {
        this.o.start();
    }

    @Override
    public void stop() {
        this.o.stop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.restart) {
            this.o.restart();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.aList) {
            Double d;
            try {
                d = new Double(this.aList.getSelectedItem().substring(0, 2));
            }
            catch (Exception exception) {
                d = new Double(0.0);
            }
            if (d != this.degChi) {
                this.degChi = d;
                double d2 = this.degChi * (Math.PI / 180);
                this.sinChi = Math.sin(d2);
                this.cos2Chi = Math.cos(2.0 * d2);
                this.o.checkOR();
            }
        }
    }
}

