/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.GWaves;

import egan.applets.GWaves.GWaves;
import egan.applets.GWaves.Offscreen;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class Orbit
extends Panel
implements Runnable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GWaves gw;
    Dimension pd;
    boolean done = true;
    public static final double G = 6.67E-11;
    public static final double G3 = 2.9674096299999997E-31;
    public static final double c = 3.0E8;
    public static final double c4 = 8.1E33;
    public static final double c5 = 2.4300000000000002E42;
    public static final double Msolar = 2.0E30;
    public static final double m1 = 2.8E30;
    public static final double m2 = 2.8E30;
    public static final double M = 5.6E30;
    public static final double M2 = 3.1359999999999995E61;
    public static final double mu = 1.4E30;
    public static final double mu2 = 1.9599999999999997E60;
    public static final double detDist = 9.4608E17;
    public static final double pi2 = Math.PI * Math.PI;
    public static final double pi6 = 961.3891935753043;
    static final double hSc0 = 25.0;
    static final double minRadius = 0.04;
    static final double maxRadius = 0.425;
    double oR;
    boolean changedSc;
    double aspectRatio;
    double hSc;
    int lSc;
    static final double HOURSEC = 3600.0;
    static final double DAYSEC = 86400.0;
    static final double YEARSEC = 3.1536E7;
    static final double KYSEC = 3.1536E10;
    static final double MYSEC = 3.1536E13;
    static final double GYSEC = 3.1536E16;
    static final int nTS = 50;
    double[] TS;
    int tSc;
    double sSc;
    double dt;
    double oP;
    double tsp;
    double tcoord;
    boolean decaying;
    boolean collided;
    int istar;
    public volatile Thread a;
    long stime;
    long sinc;
    static final long minStime = 60L;
    static final long maxStime = 1000L;
    public static final int nO = 128;
    public static final int nQ = 160;
    static final double aeff = 0.75;
    int skfr;
    boolean mD;
    Offscreen off;
    float[] xtab;

    Orbit(GWaves gWaves, Dimension dimension) {
        this.gw = gWaves;
        this.pd = dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pd;
    }

    public void init() {
        int n;
        this.lSc = 8;
        this.hSc = 25.0 * Math.pow(10.0, this.lSc);
        this.oR = 2.4964320495E8;
        this.changedSc = false;
        this.aspectRatio = 0.5;
        this.TS = new double[50];
        this.decaying = false;
        this.collided = false;
        this.mD = false;
        this.sinc = 1L;
        this.skfr = 1;
        this.xtab = new float[128];
        for (n = 0; n < 128; ++n) {
            this.xtab[n] = (float)Math.cos(0.04908738521234052 * (double)n);
        }
        this.istar = 0;
        this.sSc = 1000.0;
        this.TS[0] = 0.01;
        for (n = 1; n < 50; ++n) {
            this.TS[n] = n % 2 == 0 ? 2.0 * this.TS[n - 1] : 5.0 * this.TS[n - 1];
            if (this.sSc == this.TS[n]) {
                this.tSc = n;
            }
            if (this.TS[n] == 5000.0) {
                this.TS[n] = 3600.0;
                continue;
            }
            if (this.TS[n] == 72000.0) {
                this.TS[n] = 86400.0;
                continue;
            }
            if (this.TS[n] != 4.32E7) continue;
            this.TS[n] = 3.1536E7;
        }
        this.off = new Offscreen();
        this.calcPeriod(true, true);
    }

    public void start() {
        this.done = true;
        this.gw.d.done = true;
        this.a = new Thread(this);
        this.a.start();
    }

    public void stop() {
        this.a = null;
    }

    public synchronized void restart() {
        this.a = null;
        try {
            this.a.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
        this.start();
        this.gw.restart.setEnabled(false);
    }

    @Override
    public synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        Graphics graphics2 = this.off.ensure(this, true);
        int n = this.off.width;
        int n2 = this.off.height;
        Graphics2D graphics2D = (Graphics2D)graphics2;
        graphics2D.setRenderingHints(aaON);
        if (!this.done) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = n2 / 50;
            int n4 = n2 - 3 * n3;
            int n5 = n * 19 / 20;
            int n6 = n5 - n / 5;
            int n7 = n - n / 50;
            int n8 = fontMetrics.getHeight();
            graphics2.drawLine(n6, n4 - n3, n6, n4 + n3);
            graphics2.drawLine(n5, n4 - n3, n5, n4 + n3);
            graphics2.drawLine(n6, n4, n5, n4);
            String string = this.makeDist("Scale: ", this.hSc / 5.0);
            graphics2.drawString(string, n7 - fontMetrics.stringWidth(string), n4 - n8 / 2);
            String string2 = "1 sec (animation) is";
            graphics2.drawString(string2, n7 - fontMetrics.stringWidth(string2), n8);
            String string3 = this.makeTime("about ", this.sSc, 1.0);
            graphics2.drawString(string3, n7 - fontMetrics.stringWidth(string3), 2 * n8);
            this.aspectRatio = this.gw.sinChi;
            double d = 2.0 * (this.oR / this.hSc);
            int n9 = (int)(d * (double)n * this.aspectRatio);
            int n10 = (int)(d * (double)n);
            int n11 = (n - n10) / 2;
            int n12 = (n2 - n9) / 2;
            graphics2.setColor(Color.blue);
            if (n9 != 0) {
                graphics2.drawOval(n11, n12, n10, n9);
            } else {
                graphics2.drawLine(n11, n12, n11 + n10, n12);
            }
            int n13 = n / 50;
            graphics2.drawString(this.makeDist("Separation = ", 2.0 * this.oR), n13, n2 - n8);
            graphics2.drawString(this.makeTime("Period = ", this.oP, 5.0), n13, n8);
            graphics2.drawString(this.makeTime("Collision in ", -this.tcoord, 5.0), n13, 2 * n8);
            long l = this.mD ? 1L : this.sinc;
            int n14 = (int)(l - 1L) % this.skfr;
            graphics2.setColor(Color.gray);
            int n15 = n14;
            while ((long)n15 < l) {
                int n16 = (this.istar + n15) % 128;
                int n17 = (int)(this.xtab[n16] * (float)n10 / 2.0f);
                int n18 = (int)(this.xtab[(160 - n16) % 128] * (float)n9 / 2.0f);
                for (int i = -1; i <= 1; i += 2) {
                    int n19 = n / 2 + i * n17 - 5;
                    int n20 = n2 / 2 + i * n18 - 5;
                    if ((long)n15 == l - 1L) {
                        graphics2.setColor(Color.black);
                        graphics2.fillOval(n19, n20, 11, 11);
                        continue;
                    }
                    graphics2.drawOval(n19, n20, 11, 11);
                }
                n15 += this.skfr;
            }
            this.done = true;
        }
        graphics.drawImage(this.off.i, 0, 0, null);
    }

    void calcPeriod(boolean bl, boolean bl2) {
        double d = this.oR * this.oR;
        double d2 = d * d;
        this.oP = Math.PI * 2 * Math.sqrt(8.0 * this.oR * d / 3.7352E20);
        this.dt = this.oP / 128.0;
        double d3 = this.oP * this.oP;
        double d4 = d3 * d3 * d3;
        if (bl2) {
            this.tsp = 1.2150000000000002E43 * d2 / 2.084498438328319E62;
            this.tcoord = -this.tsp;
        }
        this.stime = -1L;
        if (bl) {
            this.calcAtiming();
            double d5 = this.oR / this.hSc / this.oP;
            while (d5 * this.sSc < 0.02 && 10L * this.sinc < 128L && this.tSc < 49) {
                this.sSc = this.TS[++this.tSc];
                this.calcAtiming();
            }
            while ((d5 * this.sSc > 0.2 || 10L * this.sinc > 128L) && this.tSc > 0) {
                this.sSc = this.TS[--this.tSc];
                this.calcAtiming();
            }
        }
        if (this.stime < 0L) {
            this.calcAtiming();
        }
        if (this.collided) {
            this.gw.d.modifyEffect(0.0, 0.0);
        } else {
            this.gw.d.modifyEffect(1.0532841816842564E-8 * d * 1.4E30 / (7.663248E51 * d3), 2.1856256E-6 * d2 * 1.9599999999999997E60 * 961.3891935753043 / (1.2150000000000002E43 * d4));
        }
        this.decaying = -this.tcoord / this.sSc < 7200.0;
    }

    void calcAtiming() {
        this.sinc = 1L;
        double d = 750.0 * (this.dt / this.sSc);
        this.stime = (long)d;
        if (this.tcoord + this.dt >= 0.0) {
            this.stime = 60L;
        } else if (this.stime < 60L) {
            this.sinc = Math.round(60.0 / d + 0.5);
            this.stime *= this.sinc;
        } else if (this.stime > 1000L) {
            this.stime = 1000L;
            this.sSc = 750.0 * (this.dt / (double)this.stime);
        }
    }

    String makeTime(String string, double d, double d2) {
        double d3;
        String string2 = null;
        boolean bl = false;
        if (d < 0.001) {
            d3 = 1.0E-6;
            string2 = " microsecond";
        } else if (d < d2) {
            d3 = 0.001;
            string2 = " millisecond";
        } else if (d < 7200.0) {
            d3 = 1.0;
            string2 = " second";
        } else if (d < 86400.0) {
            d3 = 3600.0;
            string2 = " hour";
        } else if (d < 3.1536E7) {
            d3 = 86400.0;
            string2 = " day";
        } else if (d < 3.1536E10) {
            d3 = 3.1536E7;
            string2 = " year";
        } else if (d < 3.1536E13) {
            d3 = 3.1536E10;
            string2 = ",000 years";
            bl = true;
        } else if (d < 3.1536E16) {
            d3 = 3.1536E13;
            string2 = " million years";
            bl = true;
        } else {
            d3 = 3.1536E16;
            string2 = " billion years";
            bl = true;
        }
        long l = Math.round(d / d3);
        return new StringBuffer(string).append(this.commaString(l)).append(string2).append(l != 1L && !bl ? "s" : "").toString();
    }

    String makeDist(String string, double d) {
        double d2;
        String string2 = null;
        if (d < 10000.0) {
            d2 = 1.0;
            string2 = " metres";
        } else if (d < 1.0E7) {
            d2 = 1000.0;
            string2 = " km";
        } else if (d < 1.0E10) {
            d2 = 1000000.0;
            string2 = ",000 km";
        } else if (d < 1.0E13) {
            d2 = 1.0E9;
            string2 = " million km";
        } else {
            d2 = 1.0E12;
            string2 = " billion km";
        }
        return new StringBuffer(string).append(this.commaString(Math.round(d / d2))).append(string2).toString();
    }

    String commaString(long l) {
        StringBuffer stringBuffer = new StringBuffer(30);
        long l2 = l;
        int n = 0;
        while (true) {
            stringBuffer.append(l2 % 10L);
            if ((l2 /= 10L) == 0L) break;
            if (++n % 3 != 0) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.reverse().toString();
    }

    public boolean checkOR() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.aspectRatio = this.gw.sinChi;
        boolean bl = false;
        double d = (double)n2 / (double)n;
        while (this.oR > 0.425 * this.hSc || this.oR * this.aspectRatio > 0.425 * this.hSc * d) {
            this.hSc = 25.0 * Math.pow(10.0, ++this.lSc);
            bl = true;
        }
        while (this.oR < 0.04 * this.hSc && this.oR * this.aspectRatio < 0.04 * this.hSc * d) {
            this.hSc = 25.0 * Math.pow(10.0, --this.lSc);
            bl = true;
        }
        this.skfr = this.oR / this.hSc < 0.1 ? 3 : (this.oR / this.hSc > 0.2 ? 1 : 2);
        return bl;
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.mD = true;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        this.aspectRatio = this.gw.sinChi;
        if (!this.changedSc && !this.collided) {
            double d = n - n3 / 2;
            double d2 = this.aspectRatio != 0.0 ? (double)(n2 - n4 / 2) / this.aspectRatio : 0.0;
            this.oR = Math.sqrt(d * d + d2 * d2) / (double)n3 * this.hSc;
            this.changedSc = this.checkOR();
            this.calcPeriod(true, true);
            this.done = false;
            this.repaint();
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        this.mD = false;
        this.changedSc = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mousePressed(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void run() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        long l = 200L;
        Thread thread = Thread.currentThread();
        while (this.a == thread) {
            if (this.mD || this.collided) {
                l = 200L;
            } else if (this.done) {
                this.done = false;
                this.istar = (int)((long)this.istar + this.sinc) % 128;
                int n = 2 * this.istar % 128;
                this.tcoord += (double)this.sinc * this.dt;
                if (this.decaying) {
                    if (this.tcoord > 0.0) {
                        this.tcoord = 0.0;
                        this.collided = true;
                        this.gw.restart.setEnabled(true);
                    }
                    this.oR = Math.sqrt(Math.sqrt(Math.abs(this.tcoord) * 16.0 * 2.9674096299999997E-31 * 3.1359999999999995E61 * 1.4E30 / 1.2150000000000002E43));
                    this.calcPeriod(false, false);
                    this.skfr = this.oR / this.hSc < 0.1 ? 3 : (this.oR / this.hSc > 0.2 ? 1 : 2);
                }
                this.repaint();
                this.gw.d.modifyRing(this.xtab[n], this.xtab[(160 - n) % 128]);
                if (!this.collided) {
                    int n2 = 0;
                    while ((long)n2 < this.sinc) {
                        n = 2 * ((this.istar + n2) % 128) % 128;
                        this.gw.d.modifyGraph(this.xtab[n], this.xtab[(160 - n) % 128], this.dt);
                        ++n2;
                    }
                }
                l = this.stime;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {}
        }
    }
}

