/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.LightMill;
import java.awt.Choice;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class CPanel
extends Panel
implements ItemListener {
    private static final long serialVersionUID = 1L;
    LightMill parent;
    public static final int rotMaxRadCh = 0;
    public static final int rotMinRadCh = 1;
    public static final int rotHolesCh = 2;
    public static final int rotHoleSizeCh = 3;
    public static final int rotDensityCh = 4;
    public static final int partNumCh = 5;
    public static final int partRadCh = 6;
    public static final int partMassCh = 7;
    public static final int partVelCh = 8;
    public static final int thermCh = 9;
    public static final int fluxCh = 10;
    public static final int iniCh = 11;
    public static final int rotorFrictionCh = 12;
    public static final int wallFrictionCh = 13;
    public static final int nCh = 14;
    public static final double frictionFactor = 10000.0;
    final int intFF = 10000;
    Choice[] clist;
    String[] clabs = new String[]{"Rotor outer radius (%): ", "Rotor inner radius (%): ", "Rotor holes: ", "Rotor hole size (%): ", "Rotor density: ", "N particles: ", "Particle radius: 10^", "Particle mass: 10^", "Initial particle velocity: ", "Rotor init therm energy density: 10^", "Energy flux density (B+, W-): 10^", "Repeatable initial conditions set: ", "Rotor friction parameter: ", "Particle/container friction par: "};
    int[][] cvals = new int[][]{{15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100}, {10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {1, 5, 10, 20, 50, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800, 1900, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000}, {-1, -2, -3, -4, -5, -6, -7, -8, -9, -10}, {-2, -3, -4, -5, -6, -7, -8, -9, -10}, {1, 2, 5, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100}, {-1, -2, -3, -4, -5, -6, -7, -8, -9, -10}, {1, 0, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000}};
    int[] defaults = new int[]{9, 2, 0, 0, 0, 6, 1, 1, 1, 1, 2, 1, 0, 0};
    int[] current;

    public CPanel(LightMill parent) {
        this.parent = parent;
    }

    public void setup() {
        this.setBackground(Color.black);
        this.setLayout(new GridLayout(7, 2, 0, 0));
        this.clist = new Choice[14];
        this.current = new int[14];
        for (int i = 0; i < 14; ++i) {
            this.clist[i] = new Choice();
            for (int j = 0; j < this.cvals[i].length; ++j) {
                if (i == 11 && j == 0) {
                    this.clist[i].addItem("Random initial conditions");
                    continue;
                }
                if (i == 12 || i == 13) {
                    if (this.cvals[i][j] == 10000) {
                        this.clist[i].addItem(this.clabs[i] + "infinite");
                        continue;
                    }
                    this.clist[i].addItem(this.clabs[i] + (double)this.cvals[i][j] / 10000.0);
                    continue;
                }
                this.clist[i].addItem(this.clabs[i] + this.cvals[i][j]);
            }
            this.clist[i].select(this.defaults[i]);
            this.current[i] = this.defaults[i];
            this.add(this.clist[i]);
            this.clist[i].addItemListener(this);
            this.clist[i].setBackground(Color.white);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int k;
        boolean hit = false;
        Object target = e.getSource();
        while (this.cvals[1][k = this.clist[1].getSelectedIndex()] >= this.getVal(0)) {
            hit = true;
            this.current[1] = k - 1;
            this.clist[1].select(this.current[1]);
        }
        int rotSpan = this.getVal(0) - this.getVal(1);
        while (this.cvals[2][k = this.clist[2].getSelectedIndex()] * this.getVal(3) >= rotSpan) {
            hit = true;
            this.current[2] = k - 1;
            this.clist[2].select(this.current[2]);
        }
        while (true) {
            int n;
            k = this.clist[5].getSelectedIndex();
            if (!((double)this.cvals[5][n] * Math.pow(10.0, 2 * this.getVal(6)) > 0.3)) break;
            hit = true;
            this.current[5] = k - 1;
            this.clist[5].select(this.current[5]);
        }
        for (int i = 0; i < 14; ++i) {
            int j = this.clist[i].getSelectedIndex();
            if (target != this.clist[i] || j == this.current[i]) continue;
            this.current[i] = j;
            if (i == 10) {
                this.parent.setThermalFlux(Math.pow(10.0, this.cvals[10][j]));
                continue;
            }
            hit = true;
        }
        if (hit) {
            this.parent.mousePressed(null);
        }
    }

    public synchronized int getVal(int indx) {
        return this.cvals[indx][this.clist[indx].getSelectedIndex()];
    }

    public void advanceIC() {
        int ii = this.clist[11].getSelectedIndex();
        if (ii == 10) {
            this.clist[11].select(1);
            this.clist[0].select(this.clist[0].getSelectedIndex() + 1);
        } else {
            this.clist[11].select(ii + 1);
        }
    }
}

