/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.HotPlate;
import java.awt.Choice;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class HPanel
extends Panel
implements ItemListener {
    private static final long serialVersionUID = 1L;
    HotPlate parent;
    public static final int plateWidthCh = 0;
    public static final int plateHolesCh = 1;
    public static final int plateHoleSizeCh = 2;
    public static final int plateDensityCh = 3;
    public static final int partNumCh = 4;
    public static final int partRadCh = 5;
    public static final int partMassCh = 6;
    public static final int partVelCh = 7;
    public static final int thermCh = 8;
    public static final int fluxCh = 9;
    public static final int iniCh = 10;
    public static final int plateFrictionCh = 11;
    public static final int wallFrictionCh = 12;
    public static final int nCh = 13;
    public static final double frictionFactor = 10000.0;
    final int intFF = 10000;
    Choice[] clist;
    String[] clabs = new String[]{"Plate width (%): ", "Plate holes: ", "Plate hole size (%): ", "Plate density: ", "N particles: ", "Particle radius: 10^", "Particle mass: 10^", "Initial particle velocity: ", "Plate init therm energy density: 10^", "Energy flux density (B+, W-): 10^", "Repeatable initial conditions set: ", "Plate friction parameter: ", "Particle/container friction par: "};
    int[][] cvals = new int[][]{{5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {5, 10, 20, 50, 100, 200, 250, 300, 400, 500, 600, 700, 800, 900, 1000, 1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800, 1900, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000}, {-1, -2, -3, -4, -5, -6, -7, -8, -9, -10}, {-2, -3, -4, -5, -6, -7, -8, -9, -10}, {1, 2, 5, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100}, {-1, -2, -3, -4, -5, -6, -7, -8, -9, -10}, {1, 0, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000}};
    int[] defaults = new int[]{5, 0, 0, 0, 5, 1, 1, 1, 1, 2, 1, 0, 0};
    int[] current;

    public HPanel(HotPlate parent) {
        this.parent = parent;
    }

    public void setup() {
        this.setBackground(Color.black);
        this.setLayout(new GridLayout(7, 2, 0, 0));
        this.clist = new Choice[13];
        this.current = new int[13];
        for (int i = 0; i < 13; ++i) {
            this.clist[i] = new Choice();
            for (int j = 0; j < this.cvals[i].length; ++j) {
                if (i == 10 && j == 0) {
                    this.clist[i].addItem("Random initial conditions");
                    continue;
                }
                if (i == 11 || i == 12) {
                    if (this.cvals[i][j] == 10000) {
                        this.clist[i].addItem(this.clabs[i] + "infinite");
                        continue;
                    }
                    this.clist[i].addItem(this.clabs[i] + (double)this.cvals[i][j] / 10000.0);
                    continue;
                }
                this.clist[i].addItem(this.clabs[i] + this.cvals[i][j]);
            }
            this.clist[i].select(this.defaults[i]);
            this.current[i] = this.defaults[i];
            this.add(this.clist[i]);
            this.clist[i].addItemListener(this);
            this.clist[i].setBackground(Color.white);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int k;
        boolean hit = false;
        Object target = e.getSource();
        int plateSpan = this.getVal(0);
        while (this.cvals[1][k = this.clist[1].getSelectedIndex()] * this.getVal(2) >= plateSpan) {
            hit = true;
            this.current[1] = k - 1;
            this.clist[1].select(this.current[1]);
        }
        while (true) {
            int n;
            k = this.clist[4].getSelectedIndex();
            if (!((double)this.cvals[4][n] * Math.pow(10.0, 2 * this.getVal(5)) > 0.1)) break;
            hit = true;
            this.current[4] = k - 1;
            this.clist[4].select(this.current[4]);
        }
        for (int i = 0; i < 13; ++i) {
            int j = this.clist[i].getSelectedIndex();
            if (target != this.clist[i] || j == this.current[i]) continue;
            this.current[i] = j;
            if (i == 9) {
                this.parent.setThermalFlux(Math.pow(10.0, this.cvals[9][j]));
                continue;
            }
            hit = true;
        }
        if (hit) {
            this.parent.mousePressed(null);
        }
    }

    public synchronized int getVal(int indx) {
        return this.cvals[indx][this.clist[indx].getSelectedIndex()];
    }

    public void advanceIC() {
        int loop1 = 10;
        int reset1 = 1;
        int top1 = 10;
        int loop2 = 4;
        int ii = this.clist[loop1].getSelectedIndex();
        if (ii == top1) {
            this.clist[loop1].select(reset1);
            int ci = this.clist[loop2].getSelectedIndex();
            if (ci == this.clist[loop2].getItemCount() - 1) {
                this.parent.stop();
            } else {
                this.clist[loop2].select(ci + 1);
            }
        } else {
            this.clist[loop1].select(ii + 1);
        }
    }
}

