/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.HPanel;
import egan.graphics.GraphicsUtils;
import egan.physics.Particle2D;
import egan.physics.Particle2Dbin;
import egan.physics.Particle2Dcollidable;
import egan.physics.Particle2DflatWall;
import egan.physics.Particle2DplateWall;
import egan.physics.Particle2Dwall;
import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextArea;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.Random;

public class HotPlate
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    boolean mouseIN = true;
    long F = 0L;
    long pt = 0L;
    long tStep = 10L;
    private volatile Thread a;
    Image I;
    Graphics o;
    int fontsize = 16;
    Font font;
    FontMetrics fm;
    DecimalFormat df3;
    DecimalFormat df12;
    int fh;
    int fd;
    int ft;
    HPanel cpanel;
    Checkbox showParticles;
    Checkbox showFlow;
    TextArea txt;
    static final String initText = "Results:";
    int nParticles;
    double particleRadius;
    double particleMass;
    double initialVelocity;
    double maxV;
    Particle2D[] particles;
    double spaceStep;
    double timeStep;
    double totalElapsedTime;
    int maxppg = 3;
    double[] XVbins = null;
    double[] XVcount = null;
    double[][][] Vbins = null;
    double[][] Vcount = null;
    Particle2Dwall[] walls;
    Particle2DplateWall plate;
    final double containerWidth = 1.0;
    final double containerHeight = 1.0;
    final int nFlatWalls = 2;
    final int nWalls = 3;
    Color[][] palette = new Color[][]{{Color.yellow}, {Color.yellow}, {Color.black, Color.white}};
    Color bgCol = new Color(0xCC99EE);
    int HundredsCount;
    Particle2Dbin bin;
    String statusString = "";

    @Override
    public void init() {
        while (true) {
            this.font = new Font(GraphicsUtils.getNiceFont((Component)this), 0, this.fontsize);
            this.setFont(this.font);
            this.fm = this.getFontMetrics(this.font);
            this.fh = this.fm.getAscent();
            this.fd = this.fm.getDescent();
            this.ft = this.fh + this.fd;
            this.df3 = new DecimalFormat();
            this.df3.setMaximumFractionDigits(3);
            this.df12 = new DecimalFormat();
            this.df12.setMaximumFractionDigits(12);
            this.cpanel = new HPanel(this);
            this.cpanel.setup();
            this.cpanel.setFont(this.font);
            this.add(this.cpanel);
            this.txt = new TextArea(initText, 1, 25);
            this.txt.setEditable(false);
            this.txt.setFont(this.font);
            this.add(this.txt);
            this.showParticles = new Checkbox("Show particles", true);
            this.showFlow = new Checkbox("Show flow", true);
            this.showParticles.setFont(this.font);
            this.showFlow.setFont(this.font);
            this.add(this.showParticles);
            this.add(this.showFlow);
            this.validate();
            this.setup(true);
            if (this.d(this.o, this.getSize().width, this.getSize().height, true)) break;
            --this.fontsize;
            this.remove(this.cpanel);
            this.remove(this.txt);
            this.remove(this.showParticles);
            this.remove(this.showFlow);
            this.validate();
        }
    }

    void setup(boolean dummy) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        this.HundredsCount = 0;
        this.txt.setText(initText);
        this.I = this.createImage(w, h);
        this.o = this.I.getGraphics();
        GraphicsUtils.setAA((Graphics)this.o);
        double plateWidth = (double)this.cpanel.getVal(0) / 100.0 * 1.0;
        double plateHoleSize = (double)this.cpanel.getVal(2) / 100.0 * 1.0;
        int plateHoleCount = this.cpanel.getVal(1);
        double plateDensity = this.cpanel.getVal(3);
        this.nParticles = dummy ? 1 : this.cpanel.getVal(4);
        this.particleRadius = Math.pow(10.0, this.cpanel.getVal(5));
        this.particleMass = Math.pow(10.0, this.cpanel.getVal(6));
        this.initialVelocity = this.cpanel.getVal(7);
        double totalThermalDensity = Math.pow(10.0, this.cpanel.getVal(8));
        double thermalFluxDensity = Math.pow(10.0, this.cpanel.getVal(9));
        double plateFrictionParam = (double)this.cpanel.getVal(11) / 10000.0;
        double wallFrictionParam = (double)this.cpanel.getVal(12) / 10000.0;
        this.walls = new Particle2Dwall[3];
        this.walls[0] = new Particle2DflatWall(0.0, 0.0, 1.0, 0.0, true, wallFrictionParam);
        this.walls[1] = new Particle2DflatWall(0.0, 1.0, 1.0, 1.0, true, wallFrictionParam);
        this.plate = new Particle2DplateWall(0.5, (1.0 + plateWidth) / 2.0, 0.5, (1.0 - plateWidth) / 2.0, plateHoleCount, plateHoleSize, 0.0, plateDensity, this.particleMass, totalThermalDensity, thermalFluxDensity, plateFrictionParam, true, false);
        this.walls[2] = this.plate;
        this.XVbins = null;
        this.Vbins = null;
        Random ran = new Random();
        int rr = this.cpanel.getVal(10);
        if (rr > 0) {
            ran.setSeed(1234512345L);
            for (int i = 0; i < rr; ++i) {
                ran.setSeed(ran.nextLong());
            }
        }
        this.particles = new Particle2D[this.nParticles];
        double partXM = 0.0;
        double partYM = 0.0;
        for (int i = 0; i < this.nParticles; ++i) {
            double theta = ran.nextDouble() * 2.0 * Math.PI;
            Particle2D p = this.particles[i] = new Particle2D(i, this.particleMass, this.particleRadius, 0.0, 0.0, this.initialVelocity * Math.cos(theta), this.initialVelocity * Math.sin(theta), true, false);
            while (true) {
                double x = p.x = ran.nextDouble() * 1.0;
                double y = p.y = ran.nextDouble() * 1.0;
                if (!this.walls[0].particleOK(p) || !this.walls[1].particleOK(p) || !this.walls[2].particleOK(p)) continue;
                boolean anyClash = false;
                for (int j = 0; j < i; ++j) {
                    if (!p.overlap(this.particles[j])) continue;
                    anyClash = true;
                    break;
                }
                if (!anyClash) break;
            }
            partXM += this.particles[i].XMomentum();
            partYM += this.particles[i].YMomentum();
        }
        double vxinc = -partXM / this.particleMass / (double)this.nParticles;
        double vyinc = -partYM / this.particleMass / (double)this.nParticles;
        for (int i = 0; i < this.nParticles; ++i) {
            Particle2D p = this.particles[i];
            p.changeVelocity(vxinc, vyinc);
        }
        this.maxV = 2.0 * this.initialVelocity;
        this.bin = new Particle2Dbin(this.particles, this.nParticles, this.walls, 3, this.particleRadius, this.maxV, 0.0, 1.0, 0.0, 1.0);
        this.spaceStep = this.bin.setupGrid(this.maxppg);
        this.timeStep = this.spaceStep / this.maxV;
        this.bin.binParticles();
        this.totalElapsedTime = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            HotPlate hotPlate = this;
            synchronized (hotPlate) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                this.setup(false);
            }
            this.d(this.o, w, h, false);
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public boolean d(Graphics g, int w, int h, boolean trial) {
        int ty1;
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        double pix = 2.0 * (double)w / 3.0;
        int ipix = (int)pix;
        int XVnb = 40;
        double XVbsize = 1.0 / (double)XVnb;
        if (this.XVbins == null) {
            this.XVbins = new double[XVnb];
            this.XVcount = new double[XVnb];
        }
        int Vnb = 40;
        double VbsizeX = 1.0 / (double)Vnb;
        double VbsizeY = 1.0 / (double)Vnb;
        if (this.Vbins == null) {
            this.Vbins = new double[Vnb][Vnb][2];
            this.Vcount = new double[Vnb][Vnb];
        }
        double partLM = 0.0;
        double plateLM = this.plate.linearMomentum();
        double plateVel = this.plate.plateNormVel;
        double plateX = this.plate.x1;
        for (int i = 0; i < this.nParticles; ++i) {
            Particle2D pi = this.particles[i];
            double xm = pi.XMomentum();
            double x = pi.x;
            double y = pi.y;
            double vx = pi.vx;
            double vy = pi.vy;
            partLM += xm;
            int ibin = (int)Math.floor(y / XVbsize);
            if (ibin >= XVnb) {
                ibin = XVnb - 1;
            } else if (ibin < 0) {
                ibin = 0;
            }
            int n = ibin;
            this.XVbins[n] = this.XVbins[n] + xm;
            int n2 = ibin;
            this.XVcount[n2] = this.XVcount[n2] + 1.0;
            double xx = (2.0 + x - plateX) % 1.0;
            int xbin = (int)Math.floor(xx / VbsizeX);
            int ybin = (int)Math.floor(y / VbsizeY);
            if (xbin >= Vnb) {
                xbin = Vnb - 1;
            } else if (xbin < 0) {
                xbin = 0;
            }
            if (ybin >= Vnb) {
                ybin = Vnb - 1;
            } else if (ybin < 0) {
                ybin = 0;
            }
            double[] dArray = this.Vbins[xbin][ybin];
            dArray[0] = dArray[0] + (vx - plateVel);
            double[] dArray2 = this.Vbins[xbin][ybin];
            dArray2[1] = dArray2[1] + vy;
            double[] dArray3 = this.Vcount[xbin];
            int n3 = ybin;
            dArray3[n3] = dArray3[n3] + 1.0;
        }
        double partKE = 0.0;
        double plateKE = this.plate.kineticEnergy();
        double bTh = this.plate.blackThermalEnergy();
        double wTh = this.plate.whiteThermalEnergy();
        for (int i = 0; i < this.nParticles; ++i) {
            partKE += this.particles[i].kineticEnergy();
        }
        double rmsVel = Math.sqrt(2.0 * partKE / (this.particleMass * (double)this.nParticles));
        double mfp = 0.0;
        for (int i = 0; i < this.nParticles; ++i) {
            mfp += this.particles[i].meanFreePath();
        }
        mfp /= (double)this.nParticles;
        g.setColor(Color.black);
        int ty2 = ty1 = this.ft + Math.max(this.txt.getLocation().y + this.txt.getSize().height, this.showFlow.getLocation().y + this.showFlow.getSize().height);
        int tx1 = this.ft;
        int tx2 = w / 2;
        int gap = this.ft / 3;
        g.drawString("Net displacement = " + this.df3.format(this.plate.plateDisplacement), tx1, ty1 += this.ft);
        g.drawString("Elapsed time = " + this.df3.format(this.totalElapsedTime), tx1, ty1 += this.ft);
        ty1 += gap;
        g.drawString("X Momentum of particles = " + this.df12.format(partLM), tx1, ty1 += this.ft);
        g.drawString("X Momentum of plate = " + this.df12.format(plateLM), tx1, ty1 += this.ft);
        g.drawString("Total X momentum = " + this.df12.format(partLM + plateLM), tx1, ty1 += this.ft);
        g.drawString("Plate's mass = " + this.df12.format(this.plate.plateMass), tx1, ty1 += this.ft);
        g.drawString("KE of plate = " + this.df12.format(plateKE), tx2, ty2 += this.ft);
        ty2 += gap;
        g.drawString("KE of particles = " + this.df12.format(partKE), tx2, ty2 += this.ft);
        g.drawString("RMS particle velocity = " + this.df12.format(rmsVel), tx2, ty2 += this.ft);
        g.drawString("Particle mean free path = " + this.df12.format(mfp), tx2, ty2 += this.ft);
        ty2 += gap;
        g.drawString("Black thermal energy = " + this.df12.format(bTh), tx2, ty2 += this.ft);
        g.drawString("Black thermal velocity = " + this.df12.format(this.plate.thermalVelocity(0)), tx2, ty2 += this.ft);
        g.drawString("White thermal energy = " + this.df12.format(wTh), tx2, ty2 += this.ft);
        g.drawString("White thermal velocity = " + this.df12.format(this.plate.thermalVelocity(1)), tx2, ty2 += this.ft);
        g.drawString("Total energy = " + this.df12.format(plateKE + partKE + bTh + wTh), tx2, ty2 += this.ft);
        int cx = (w - ipix) / 2;
        int cy = Math.max(ty1, ty2) + 2 * this.ft + ipix;
        if (!trial) {
            int i;
            g.setColor(this.bgCol);
            g.fillRect(cx, cy - ipix, ipix, ipix);
            for (int i2 = 0; i2 < 3; ++i2) {
                this.walls[i2].draw(g, this.palette[i2], cx, cy, pix);
            }
            if (this.showParticles.getState()) {
                int prad = (int)(pix * this.particleRadius);
                if (prad < 1) {
                    prad = 1;
                }
                for (int i3 = 0; i3 < this.nParticles; ++i3) {
                    Particle2D pi = this.particles[i3];
                    int ix = cx + (int)(pi.x * pix);
                    int iy = cy - (int)(pi.y * pix);
                    if (this.particles[i3].speed() > rmsVel) {
                        g.setColor(Color.red);
                    } else {
                        g.setColor(Color.blue);
                    }
                    g.drawLine(ix, iy, ix, iy);
                    g.fillOval(ix - prad, iy - prad, 2 * prad, 2 * prad);
                }
            }
            if (this.showFlow.getState()) {
                int i4;
                double Vmax = 0.0;
                for (i4 = 0; i4 < Vnb; ++i4) {
                    for (int j = 0; j < Vnb; ++j) {
                        double vy;
                        double vx;
                        double v;
                        if (!(this.Vcount[i4][j] > 0.0) || !((v = Math.sqrt((vx = this.Vbins[i4][j][0]) * vx + (vy = this.Vbins[i4][j][0]) * vy) / this.Vcount[i4][j]) > Vmax)) continue;
                        Vmax = v;
                    }
                }
                Vmax = 0.5 * Vmax / VbsizeX;
                for (i4 = 0; i4 < Vnb; ++i4) {
                    double x0 = (plateX + (0.5 + (double)i4) * VbsizeX) % 1.0;
                    for (int j = 0; j < Vnb; ++j) {
                        if (!(this.Vcount[i4][j] > 0.0)) continue;
                        double vs = Vmax * this.Vcount[i4][j];
                        double vx = this.Vbins[i4][j][0] / vs;
                        double vy = this.Vbins[i4][j][1] / vs;
                        double y0 = (0.5 + (double)j) * VbsizeY;
                        double x1 = x0 + vx;
                        double y1 = y0 + vy;
                        int ix0 = cx + (int)(x0 * pix);
                        int iy0 = cy - (int)(y0 * pix);
                        g.setColor(Color.gray);
                        g.drawLine(ix0, iy0, cx + (int)(x1 * pix), cy - (int)(y1 * pix));
                        g.setColor(Color.black);
                        g.drawLine(ix0, iy0, ix0, iy0);
                    }
                }
            }
            int aScale = (cx - 2 * this.ft) / 2;
            int aX = this.ft + aScale;
            int aY0 = cy;
            double XVmax = 0.0;
            for (i = 0; i < XVnb; ++i) {
                double aam = Math.abs(this.XVbins[i] / this.XVcount[i]);
                if (!(aam > XVmax)) continue;
                XVmax = aam;
            }
            g.setColor(Color.gray);
            for (i = 0; i < this.plate.plateSegCount; ++i) {
                g.fillRect(aX - aScale, aY0 - (int)(pix * (this.plate.y2 + this.plate.plateSegH[i])), 2 * aScale, (int)(pix * (this.plate.plateSegH[i] - this.plate.plateSegL[i])));
            }
            double bScale = pix * 1.0 / (double)XVnb;
            for (int i5 = 0; i5 < XVnb; ++i5) {
                int iam = (int)((double)aScale * this.XVbins[i5] / this.XVcount[i5] / XVmax);
                if (iam < 0) {
                    g.setColor(Color.red);
                    g.fillRect(aX + iam, aY0 - (int)((double)(i5 + 1) * bScale), -iam, (int)((double)(i5 + 1) * bScale) - (int)((double)i5 * bScale));
                    continue;
                }
                g.setColor(Color.black);
                g.fillRect(aX, aY0 - (int)((double)(i5 + 1) * bScale), iam, (int)((double)(i5 + 1) * bScale) - (int)((double)i5 * bScale));
            }
            g.setColor(Color.black);
            aY0 -= ipix + 4 * this.ft;
            g.drawString("Average", this.ft / 2, aY0 += this.ft);
            g.drawString("particle", this.ft / 2, aY0 += this.ft);
            g.drawString("X velocity", this.ft / 2, aY0 += this.ft);
        }
        int hB = 20;
        boolean hF = this.plate.hasFriction;
        int hTop = cy + 2 * this.ft;
        int hHeight = h - 2 * this.ft - hTop;
        if (trial) {
            return hHeight > 30 && this.cpanel.getSize().width <= w && this.txt.getSize().width <= w;
        }
        for (int i = 0; i < hB; ++i) {
            double diff = this.plate.momentumHist[0][i] - this.plate.momentumHist[1][i];
            if (diff > 0.0) {
                this.plate.diffHist[0][i] = diff;
                this.plate.diffHist[1][i] = 0.0;
                continue;
            }
            this.plate.diffHist[0][i] = 0.0;
            this.plate.diffHist[1][i] = -diff;
        }
        int nHist = 3;
        int hY = hTop + hHeight;
        int hCell = (w - 10) / nHist / (2 * hB);
        int hWidth = hCell * (2 * hB);
        int hGap = (w - nHist * hWidth) / (nHist + 1);
        int border = 4;
        double[][][] hhh = new double[][][]{this.plate.collisionsHist, this.plate.momentumHist, this.plate.diffHist};
        String[] labels = new String[]{"Collisions", "Linear momentum", "Momentum difference"};
        double max = 0.0;
        double bsum = 0.0;
        double wsum = 0.0;
        for (int i = 0; i < nHist; ++i) {
            int j;
            int side;
            int hExtra = 0;
            int hB2 = hB + hExtra;
            int hX = hGap + i * (hWidth + hGap);
            g.setColor(Color.gray);
            g.fillRect(hX - border, hY - hHeight - border, hWidth + 2 * border + hExtra * 2 * hCell, hHeight + 2 * border);
            double[][] hist = hhh[i];
            max = 0.0;
            bsum = 0.0;
            wsum = 0.0;
            for (side = 0; side < 2; ++side) {
                for (j = 0; j < hB2; ++j) {
                    max = Math.max(max, Math.abs(hist[side][j]));
                    if (side == 0) {
                        bsum += hist[side][j];
                        continue;
                    }
                    wsum += hist[side][j];
                }
            }
            if (max == 0.0) continue;
            for (side = 0; side < 2; ++side) {
                g.setColor(side == 0 ? Color.black : Color.white);
                for (j = 0; j < hB2; ++j) {
                    int hh;
                    if (j == hB) {
                        g.setColor(side == 0 ? Color.green : Color.red);
                    }
                    if ((hh = -((int)((double)hHeight * hist[side][j] / max))) > 0) {
                        g.fillRect(hX + (2 * j + side) * hCell, hY, hCell, hh);
                        continue;
                    }
                    g.fillRect(hX + (2 * j + side) * hCell, hY + hh, hCell, -hh);
                }
            }
            g.setColor(Color.black);
            g.drawString(labels[i], hX, hY + 2 * border + this.ft);
            g.drawString("Max " + this.df3.format(max) + " diff " + this.df3.format(bsum - wsum), hX, hY - hHeight - border - 1);
        }
        if (this.totalElapsedTime >= 100.0 * (double)(this.HundredsCount + 1)) {
            ++this.HundredsCount;
            this.txt.append("\nAt t=" + 100.0 * (double)this.HundredsCount + ", displacement was " + this.df3.format(this.plate.plateDisplacement));
        }
        double sumTime = 0.0;
        block18: while (sumTime < 0.01) {
            double elapsedTime = 0.0;
            while (true) {
                double tremainder;
                double tec;
                if ((tec = this.bin.tec(this.timeStep)) > (tremainder = this.timeStep - elapsedTime)) {
                    if (!(tremainder > 0.0)) continue block18;
                    this.bin.evolve(tremainder);
                    this.bin.resetEC();
                    sumTime += tremainder;
                    continue block18;
                }
                this.bin.evolve(tec);
                elapsedTime += tec;
                sumTime += tec;
                Particle2Dcollidable ec1 = this.bin.getEC1();
                Particle2D ec2 = this.bin.getEC2();
                if (ec1 == null) continue;
                int cc = this.bin.getCollisionCode();
                ec1.collide(ec2, cc);
                if (cc < 0) {
                    this.bin.resetEC();
                    continue;
                }
                this.maxV = this.bin.getMaxV();
                this.timeStep = this.spaceStep / this.maxV;
            }
        }
        this.totalElapsedTime += sumTime;
        return true;
    }

    public synchronized void setThermalFlux(double thermalFlux) {
        this.plate.setThermalFlux(thermalFlux);
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)g, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to restart");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

