/*
 * Decompiled with CFR 0.152.
 */
package egan.physics;

import egan.physics.Particle2Dbin;
import egan.physics.Particle2Dcollidable;

public class Particle2D
implements Particle2Dcollidable {
    public int index;
    public Particle2Dbin bin;
    public double mass;
    public double radius;
    public double x;
    public double y;
    public double vx;
    public double vy;
    public double ax;
    public double ay;
    public boolean nonInertial;
    public double v;
    public boolean wrapX;
    public boolean wrapY;
    double collisionCount;
    double sumPathLengths;
    double timeSinceCollision;

    public Particle2D(int n, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2) {
        this.index = n;
        this.mass = d;
        this.radius = d2;
        this.x = d3;
        this.y = d4;
        this.vx = d5;
        this.vy = d6;
        this.v = Math.sqrt(d5 * d5 + d6 * d6);
        this.ay = 0.0;
        this.ax = 0.0;
        this.nonInertial = false;
        this.wrapX = bl;
        this.wrapY = bl2;
        this.collisionCount = 0.0;
        this.sumPathLengths = 0.0;
        this.timeSinceCollision = 0.0;
    }

    public Particle2D(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl, boolean bl2) {
        this.index = n;
        this.mass = d;
        this.radius = d2;
        this.x = d3;
        this.y = d4;
        this.vx = d5;
        this.vy = d6;
        this.v = Math.sqrt(d5 * d5 + d6 * d6);
        this.ax = d7;
        this.ay = d8;
        this.nonInertial = true;
        this.wrapX = bl;
        this.wrapY = bl2;
        this.collisionCount = 0.0;
        this.sumPathLengths = 0.0;
        this.timeSinceCollision = 0.0;
    }

    public boolean overlap(Particle2D particle2D) {
        double d = this.x - particle2D.x;
        double d2 = this.y - particle2D.y;
        double d3 = this.radius + particle2D.radius;
        return d * d + d2 * d2 <= d3 * d3;
    }

    public void reflect(double d, double d2) {
        double d3 = -2.0 * (d * this.vx + d2 * this.vy);
        this.changeVelocity(d3 * d, d3 * d2);
    }

    public void evolve(double d) {
        this.x += d * this.vx;
        this.y += d * this.vy;
        this.timeSinceCollision += d;
        if (this.nonInertial) {
            double d2 = 0.5 * d * d;
            this.x += d2 * this.ax;
            this.y += d2 * this.ay;
            this.vx += this.ax * d;
            this.vy += this.ay * d;
        }
        if (this.wrapX) {
            while (this.x > 1.0) {
                this.x -= 1.0;
            }
            while (this.x < 0.0) {
                this.x += 1.0;
            }
        }
        if (this.wrapY) {
            while (this.y > 1.0) {
                this.y -= 1.0;
            }
            while (this.y < 0.0) {
                this.y += 1.0;
            }
        }
    }

    @Override
    public double collisionTime(Particle2D particle2D, double d) {
        double d2 = this.vx - particle2D.vx;
        double d3 = particle2D.x - this.x;
        double d4 = this.vy - particle2D.vy;
        double d5 = particle2D.y - this.y;
        double d6 = d2 * d3 + d4 * d5;
        if (d6 < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d7 = this.radius + particle2D.radius;
        double d8 = d2 * d2 + d4 * d4;
        double d9 = d4 * d3 - d2 * d5;
        double d10 = d7 * d7 * d8 - d9 * d9;
        if (d10 < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d11 = (d6 - Math.sqrt(d10)) / d8;
        if (d11 > 0.0) {
            return d11;
        }
        if (d6 > 0.0) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public int collisionCode() {
        return 0;
    }

    @Override
    public void collide(Particle2D particle2D, int n) {
        this.logCollision();
        particle2D.logCollision();
        double d = particle2D.x - this.x;
        double d2 = particle2D.y - this.y;
        double d3 = d * d + d2 * d2;
        double d4 = particle2D.vx - this.vx;
        double d5 = particle2D.vy - this.vy;
        double d6 = particle2D.mass;
        double d7 = 2.0 * (d4 * d + d5 * d2) / (this.mass + d6) / d3;
        double d8 = d * d7;
        double d9 = d2 * d7;
        this.changeVelocity(d6 * d8, d6 * d9);
        particle2D.changeVelocity(-this.mass * d8, -this.mass * d9);
    }

    public void logCollision() {
        this.sumPathLengths += this.v * this.timeSinceCollision;
        this.collisionCount += 1.0;
        this.timeSinceCollision = 0.0;
    }

    public double meanFreePath() {
        if (this.collisionCount > 0.0) {
            return this.sumPathLengths / this.collisionCount;
        }
        return 0.0;
    }

    public double kineticEnergy() {
        return 0.5 * this.mass * this.v * this.v;
    }

    public double speed() {
        return this.v;
    }

    public void changeVelocity(double d, double d2) {
        this.vx += d;
        this.vy += d2;
        this.v = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
        if (this.bin != null) {
            this.bin.updateMaxV(this.vx, this.vy);
        }
    }

    public double angularMomentum() {
        return this.mass * (this.x * this.vy - this.y * this.vx);
    }

    public double XMomentum() {
        return this.mass * this.vx;
    }

    public double YMomentum() {
        return this.mass * this.vy;
    }
}

