/*
 * Decompiled with CFR 0.152.
 */
package egan.physics;

import egan.physics.Particle2D;
import egan.physics.Particle2Dcollidable;
import egan.physics.Particle2Dwall;

public class Particle2Dbin {
    Particle2D[] particles;
    int nparticles;
    Particle2Dwall[] walls;
    int nwalls;
    boolean[][][] wallFlags;
    double maxR;
    double maxV;
    public double x1;
    public double x2;
    public int nx;
    public double y1;
    public double y2;
    public int ny;
    public double xg;
    public double yg;
    Particle2D[][][] grid;
    int[][] gridCount;
    Particle2Dcollidable ec1;
    Particle2D ec2;
    int collisionCode;

    public Particle2Dbin(Particle2D[] particle2DArray, int n, Particle2Dwall[] particle2DwallArray, int n2, double d, double d2, double d3, double d4, double d5, double d6) {
        this.particles = particle2DArray;
        this.nparticles = n;
        this.walls = particle2DwallArray;
        this.nwalls = n2;
        this.maxR = d;
        this.maxV = d2;
        this.x1 = d3;
        this.x2 = d4;
        this.y1 = d5;
        this.y2 = d6;
        for (int i = 0; i < n; ++i) {
            particle2DArray[i].bin = this;
        }
        this.ec1 = null;
        this.ec2 = null;
    }

    public double getMaxV() {
        return this.maxV;
    }

    public void updateMaxV(double d, double d2) {
        if (d > this.maxV) {
            this.maxV = d;
        } else if (-d > this.maxV) {
            this.maxV = -d;
        }
        if (d2 > this.maxV) {
            this.maxV = d2;
        } else if (-d2 > this.maxV) {
            this.maxV = -d2;
        }
    }

    public double setupGrid(int n) {
        int n2;
        int n3;
        this.nx = 1;
        this.ny = 1;
        while ((n3 = this.nparticles / (this.nx * this.ny)) >= n) {
            ++this.nx;
            ++this.ny;
        }
        if (n3 < 10) {
            n3 = 10;
        }
        double d = this.x2 - this.x1;
        double d2 = this.y2 - this.y1;
        while (true) {
            this.xg = d / (double)this.nx;
            this.yg = d2 / (double)this.ny;
            if (this.xg > 2.0 * this.maxR && this.yg > 2.0 * this.maxR || this.nx == 1 || this.ny == 1) break;
            --this.nx;
            --this.ny;
        }
        this.grid = new Particle2D[this.nx][this.ny][];
        this.gridCount = new int[this.nx][this.ny];
        for (n2 = 0; n2 < this.nx; ++n2) {
            for (int i = 0; i < this.nx; ++i) {
                this.grid[n2][i] = new Particle2D[n3];
                this.gridCount[n2][i] = 0;
            }
        }
        if (this.nwalls == 0) {
            this.wallFlags = null;
        } else {
            this.wallFlags = new boolean[this.nwalls][this.nx][this.ny];
            for (n2 = 0; n2 < this.nwalls; ++n2) {
                boolean[][] blArray = this.walls[n2].markWallOnGrid(this);
                for (int i = 0; i < this.nx; ++i) {
                    for (int j = 0; j < this.ny; ++j) {
                        if (!blArray[i][j]) continue;
                        for (int k = -1; k <= 1; ++k) {
                            int n4 = i + k;
                            if (n4 < 0 || n4 >= this.nx) continue;
                            for (int i2 = -1; i2 <= 1; ++i2) {
                                int n5 = j + i2;
                                if (n5 < 0 || n5 >= this.ny) continue;
                                this.wallFlags[n2][n4][n5] = true;
                            }
                        }
                    }
                }
            }
        }
        return Math.min(this.xg, this.yg) / 2.0 - this.maxR;
    }

    public boolean binParticles() {
        int n;
        for (n = 0; n < this.nx; ++n) {
            for (int i = 0; i < this.nx; ++i) {
                this.gridCount[n][i] = 0;
            }
        }
        for (n = 0; n < this.nparticles; ++n) {
            double d = this.particles[n].x;
            double d2 = this.particles[n].y;
            if (d < this.x1 || d > this.x2 || d2 < this.y1 || d2 > this.y2) {
                return false;
            }
            int n2 = (int)Math.floor((d - this.x1) / this.xg);
            int n3 = (int)Math.floor((d2 - this.y1) / this.yg);
            if (n2 >= this.nx) {
                n2 = this.nx - 1;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 >= this.ny) {
                n3 = this.ny - 1;
            } else if (n3 < 0) {
                n3 = 0;
            }
            Particle2D[] particle2DArray = this.grid[n2][n3];
            int n4 = particle2DArray.length;
            if (this.gridCount[n2][n3] == n4) {
                Particle2D[] particle2DArray2 = new Particle2D[n4 + 10];
                System.arraycopy(particle2DArray, 0, particle2DArray2, 0, n4);
                particle2DArray = particle2DArray2;
                this.grid[n2][n3] = particle2DArray2;
            }
            int[] nArray = this.gridCount[n2];
            int n5 = n3;
            int n6 = nArray[n5];
            nArray[n5] = n6 + 1;
            particle2DArray[n6] = this.particles[n];
        }
        return true;
    }

    public double tec(double d) {
        double d2 = 2.0 * d;
        Particle2Dcollidable particle2Dcollidable = null;
        Particle2D particle2D = null;
        int n = 0;
        for (int i = 0; i < this.nx && d2 > 0.0; ++i) {
            for (int j = 0; j < this.ny && d2 > 0.0; ++j) {
                double d3;
                Particle2D particle2D2;
                int n2;
                Particle2Dcollidable particle2Dcollidable2;
                int n3;
                Particle2D[] particle2DArray = this.grid[i][j];
                int n4 = this.gridCount[i][j];
                for (n3 = 0; n3 < n4 - 1 && d2 > 0.0; ++n3) {
                    particle2Dcollidable2 = particle2DArray[n3];
                    for (n2 = n3 + 1; n2 < n4 && d2 > 0.0; ++n2) {
                        particle2D2 = particle2DArray[n2];
                        if (particle2Dcollidable2 == this.ec1 && particle2D2 == this.ec2 || particle2Dcollidable2 == this.ec2 && particle2D2 == this.ec1 || !((d3 = ((Particle2D)particle2Dcollidable2).collisionTime(particle2D2, d2)) < d2)) continue;
                        particle2Dcollidable = particle2Dcollidable2;
                        particle2D = particle2D2;
                        d2 = d3;
                        n = 0;
                    }
                }
                for (n3 = 0; n3 < this.nwalls && d2 > 0.0; ++n3) {
                    if (!this.wallFlags[n3][i][j]) continue;
                    particle2Dcollidable2 = this.walls[n3];
                    for (n2 = 0; n2 < n4 && d2 > 0.0; ++n2) {
                        particle2D2 = particle2DArray[n2];
                        if (particle2Dcollidable2 == this.ec1 && particle2D2 == this.ec2 || !((d3 = ((Particle2Dwall)particle2Dcollidable2).collisionTime(particle2D2, d2)) < d2)) continue;
                        particle2Dcollidable = particle2Dcollidable2;
                        particle2D = particle2D2;
                        d2 = d3;
                        n = ((Particle2Dwall)particle2Dcollidable2).collisionCode();
                    }
                }
                n3 = i * this.ny + j;
                for (int k = -1; k <= 1 && d2 > 0.0; ++k) {
                    n2 = i + k;
                    if (n2 < 0 || n2 >= this.nx) continue;
                    for (int i2 = -1; i2 <= 1 && d2 > 0.0; ++i2) {
                        int n5 = j + i2;
                        if (n5 < 0 || n5 >= this.ny || n2 * this.ny + n5 >= n3) continue;
                        Particle2D[] particle2DArray2 = this.grid[n2][n5];
                        int n6 = this.gridCount[n2][n5];
                        for (int i3 = 0; i3 < n6 && d2 > 0.0; ++i3) {
                            Particle2D particle2D3 = particle2DArray2[i3];
                            for (int i4 = 0; i4 < n4 && d2 > 0.0; ++i4) {
                                double d4;
                                Particle2D particle2D4 = particle2DArray[i4];
                                if (particle2D3 == this.ec1 && particle2D4 == this.ec2 || !((d4 = particle2D3.collisionTime(particle2D4, d2)) < d2)) continue;
                                particle2Dcollidable = particle2D3;
                                particle2D = particle2D4;
                                d2 = d4;
                                n = 0;
                            }
                        }
                    }
                }
            }
        }
        this.ec1 = particle2Dcollidable;
        this.ec2 = particle2D;
        this.collisionCode = n;
        return d2;
    }

    public Particle2Dcollidable getEC1() {
        return this.ec1;
    }

    public Particle2D getEC2() {
        return this.ec2;
    }

    public int getCollisionCode() {
        return this.collisionCode;
    }

    public void resetEC() {
        this.ec1 = null;
        this.ec2 = null;
    }

    public void evolve(double d) {
        int n;
        for (n = 0; n < this.nparticles; ++n) {
            this.particles[n].evolve(d);
        }
        for (n = 0; n < this.nwalls; ++n) {
            this.walls[n].evolve(d);
        }
        this.binParticles();
    }
}

