/*
 * Decompiled with CFR 0.152.
 */
package egan.physics;

import egan.physics.Particle2D;
import egan.physics.Particle2Dbin;
import egan.physics.Particle2Dwall;
import java.awt.Color;
import java.awt.Graphics;

public class Particle2DcircularWall
extends Particle2Dwall {
    public double wcx;
    public double wcy;
    public double wrad;
    public double wradsq;
    public double arad;
    public double diameter;
    public boolean inner;
    public boolean outer;
    boolean hasFriction;
    double frictionPar;
    double frictionFactor;

    public Particle2DcircularWall(double d, double d2, double d3, double d4) {
        this.wcx = d;
        this.wcy = d2;
        this.wrad = d3;
        this.wradsq = d3 * d3;
        this.arad = Math.abs(d3);
        this.diameter = 2.0 * this.arad;
        this.outer = d3 < 0.0;
        this.inner = d3 > 0.0;
        this.hasFriction = d4 != 0.0;
        this.frictionPar = d4;
        this.frictionFactor = 1.0 - d4;
    }

    @Override
    public boolean particleOK(Particle2D particle2D) {
        double d = particle2D.x - this.wcx;
        double d2 = particle2D.y - this.wcy;
        double d3 = Math.sqrt(d * d + d2 * d2);
        return this.outer && d3 < -this.wrad - particle2D.radius || this.inner && d3 > this.wrad + particle2D.radius;
    }

    @Override
    public double collisionTime(Particle2D particle2D, double d) {
        double d2 = particle2D.x - this.wcx;
        double d3 = particle2D.y - this.wcy;
        double d4 = particle2D.vx;
        double d5 = particle2D.vy;
        double d6 = -d4 * d2 - d5 * d3;
        if (this.inner && d6 < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d7 = this.wrad + particle2D.radius;
        double d8 = d7 * d7;
        double d9 = d4 * d4 + d5 * d5;
        double d10 = d5 * d2 - d4 * d3;
        double d11 = d10 * d10;
        double d12 = d8 * d9 - d11;
        if (d12 < 0.0) {
            if (this.inner) {
                return Double.POSITIVE_INFINITY;
            }
            double d13 = 0.9999 * Math.sqrt(d8 * d9 / d11);
            particle2D.x = this.wcx + d13 * d2;
            particle2D.y = this.wcy + d13 * d3;
            return Double.POSITIVE_INFINITY;
        }
        double d14 = Math.sqrt(d12);
        double d15 = (d6 - d14) / d9;
        if (d15 >= 0.0 && this.inner) {
            return d15;
        }
        double d16 = (d6 + d14) / d9;
        double d17 = d2 * d2 + d3 * d3;
        if (this.outer && (d17 > d8 || d15 >= 0.0)) {
            if (d6 < 0.0) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (this.inner && (d17 < d8 || d16 >= 0.0)) {
            if (d6 > 0.0) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (d16 >= 0.0) {
            return d16;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public void collide(Particle2D particle2D, int n) {
        particle2D.logCollision();
        double d = particle2D.x - this.wcx;
        double d2 = particle2D.y - this.wcy;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d / d3;
        double d5 = d2 / d3;
        particle2D.reflect(d4, d5);
        if (this.hasFriction) {
            double d6 = particle2D.vx;
            double d7 = particle2D.vy;
            double d8 = -d5 * d6 + d4 * d7;
            double d9 = d4 * d6 + d5 * d7;
            d9 = (d9 < 0.0 ? -1.0 : 1.0) * Math.sqrt(d6 * d6 + d7 * d7 - (d8 *= this.frictionFactor) * d8);
            double d10 = d9 * d4 - d8 * d5;
            double d11 = d9 * d5 + d8 * d4;
            particle2D.changeVelocity(d10 - d6, d11 - d7);
        }
    }

    @Override
    public boolean[][] markWallOnGrid(Particle2Dbin particle2Dbin) {
        int n;
        double d;
        int n2;
        double d2;
        double d3;
        double d4;
        int n3;
        int n4 = particle2Dbin.nx;
        int n5 = particle2Dbin.ny;
        boolean[][] blArray = new boolean[n4][n5];
        double d5 = particle2Dbin.x1;
        double d6 = particle2Dbin.x2;
        double d7 = particle2Dbin.y1;
        double d8 = particle2Dbin.y2;
        double d9 = particle2Dbin.xg;
        double d10 = particle2Dbin.yg;
        boolean bl = false;
        for (n3 = 0; n3 <= n4; ++n3) {
            d4 = d5 + (double)n3 * d9 - this.wcx;
            d3 = this.wradsq - d4 * d4;
            if (!(d3 >= 0.0)) continue;
            bl = true;
            d2 = Math.sqrt(d3);
            for (n2 = -1; n2 <= 1; n2 += 2) {
                d = this.wcy + (double)n2 * d2;
                if (!(d >= d7) || !(d <= d8)) continue;
                n = (int)Math.floor((d - d7) / d10);
                if (n >= n5) {
                    n = n5 - 1;
                } else if (n < 0) {
                    n = 0;
                }
                if (n3 < n4) {
                    blArray[n3][n] = true;
                }
                if (n3 <= 0) continue;
                blArray[n3 - 1][n] = true;
            }
        }
        for (n3 = 0; n3 <= n5; ++n3) {
            d4 = d7 + (double)n3 * d10 - this.wcy;
            d3 = this.wradsq - d4 * d4;
            if (!(d3 >= 0.0)) continue;
            bl = true;
            d2 = Math.sqrt(d3);
            for (n2 = -1; n2 <= 1; n2 += 2) {
                d = this.wcx + (double)n2 * d2;
                if (!(d >= d5) || !(d <= d6)) continue;
                n = (int)Math.floor((d - d5) / d9);
                if (n >= n4) {
                    n = n4 - 1;
                } else if (n < 0) {
                    n = 0;
                }
                if (n3 < n5) {
                    blArray[n][n3] = true;
                }
                if (n3 <= 0) continue;
                blArray[n][n3 - 1] = true;
            }
        }
        if (!bl && this.diameter < d9 && this.diameter < d10 && this.wcx > d5 && this.wcx < d6 && this.wcy > d7 && this.wcy < d8) {
            n3 = (int)Math.floor((this.wcx - d5) / d9);
            if (n3 >= n4) {
                n3 = n4 - 1;
            } else if (n3 < 0) {
                n3 = 0;
            }
            int n6 = (int)Math.floor((this.wcy - d7) / d10);
            if (n6 >= n5) {
                n6 = n5 - 1;
            } else if (n6 < 0) {
                n6 = 0;
            }
            blArray[n3][n6] = true;
        }
        return blArray;
    }

    @Override
    public void draw(Graphics graphics, Color[] colorArray, int n, int n2, double d) {
        int n3 = (int)(d * this.arad);
        int n4 = 2 * n3;
        int n5 = n + (int)(d * this.wcx);
        int n6 = n2 - (int)(d * this.wcy);
        graphics.setColor(colorArray[0]);
        graphics.fillOval(n5 - n3, n6 - n3, n4, n4);
    }
}

