/*
 * Decompiled with CFR 0.152.
 */
package egan.physics;

import egan.physics.Particle2D;
import egan.physics.Particle2Dbin;
import egan.physics.Particle2Dwall;
import java.awt.Color;
import java.awt.Graphics;

public class Particle2DflatWall
extends Particle2Dwall {
    public double x1;
    public double y1;
    public double x2;
    public double y2;
    public double wallLength;
    public double px;
    public double py;
    public double nx;
    public double ny;
    boolean infiniteWall;
    boolean hasFriction;
    double frictionPar;
    double frictionFactor;
    int cc;
    double collisionMomentum;

    public Particle2DflatWall(double d, double d2, double d3, double d4, boolean bl, double d5) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.infiniteWall = bl;
        this.px = d3 - d;
        this.py = d4 - d2;
        this.wallLength = Math.sqrt(this.px * this.px + this.py * this.py);
        this.px /= this.wallLength;
        this.py /= this.wallLength;
        this.nx = -this.py;
        this.ny = this.px;
        this.hasFriction = d5 != 0.0;
        this.frictionPar = d5;
        this.frictionFactor = 1.0 - d5;
        this.collisionMomentum = 0.0;
    }

    @Override
    public boolean particleOK(Particle2D particle2D) {
        double d = particle2D.x - this.x1;
        double d2 = particle2D.y - this.y1;
        double d3 = this.nx * d + this.ny * d2;
        double d4 = particle2D.radius;
        if (d3 > d4 || d3 < -d4) {
            return true;
        }
        double d5 = this.px * d + this.py * d2;
        return d5 < -d4 || d5 > this.wallLength + d4;
    }

    @Override
    public double collisionTime(Particle2D particle2D, double d) {
        if (particle2D.nonInertial) {
            return this.collisionTimeAccelerating(particle2D, d);
        }
        return this.collisionTimeNonAccelerating(particle2D, d);
    }

    private double collisionTimeNonAccelerating(Particle2D particle2D, double d) {
        this.cc = -1;
        double d2 = particle2D.x - this.x1;
        double d3 = particle2D.y - this.y1;
        double d4 = this.nx * d2 + this.ny * d3;
        double d5 = particle2D.vx;
        double d6 = particle2D.vy;
        double d7 = this.nx * d5 + this.ny * d6;
        if (d4 * d7 >= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        int n = d4 < 0.0 ? 0 : 1;
        int n2 = d4 < 0.0 ? -1 : 1;
        double d8 = particle2D.radius;
        double d9 = this.px * d2 + this.py * d3;
        if (Math.abs(d4) <= d8 && this.onSeg(d9, d8)) {
            this.cc = n;
            return 0.0;
        }
        double d10 = ((double)n2 * d8 - d4) / d7;
        if (d10 > d) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.infiniteWall) {
            this.cc = n;
            if (d10 < 0.0) {
                d10 = 0.0;
            }
            return d10;
        }
        double d11 = this.px * d5 + this.py * d6;
        double d12 = d9 + d11 * d10;
        if (this.onSeg(d12, d8)) {
            this.cc = n;
            if (d10 < 0.0) {
                d10 = 0.0;
            }
            return d10;
        }
        return Double.POSITIVE_INFINITY;
    }

    private double collisionTimeAccelerating(Particle2D particle2D, double d) {
        this.cc = -1;
        double d2 = particle2D.x - this.x1;
        double d3 = particle2D.y - this.y1;
        double d4 = this.nx * d2 + this.ny * d3;
        double d5 = this.px * d2 + this.py * d3;
        double d6 = particle2D.vx;
        double d7 = particle2D.vy;
        double d8 = this.nx * d6 + this.ny * d7;
        double d9 = this.px * d6 + this.py * d7;
        double d10 = particle2D.ax;
        double d11 = particle2D.ay;
        double d12 = this.nx * d10 + this.ny * d11;
        double d13 = (this.px * d10 + this.py * d11) / 2.0;
        int n = d4 < 0.0 ? 0 : 1;
        int n2 = d4 < 0.0 ? -1 : 1;
        double d14 = particle2D.radius;
        if (Math.abs(d4) <= d14 && this.onSeg(d5, d14)) {
            if (d4 * d8 >= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            this.cc = n;
            return 0.0;
        }
        if (d12 == 0.0) {
            if (d4 * d8 >= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            double d15 = ((double)n2 * d14 - d4) / d8;
            if (d15 < 0.0) {
                d15 = 0.0;
            }
            if (d15 > d) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.infiniteWall) {
                this.cc = n;
                return d15;
            }
            double d16 = d5 + d9 * d15 + d13 * d15 * d15;
            if (this.onSeg(d16, d14)) {
                this.cc = n;
                return d15;
            }
            return Double.POSITIVE_INFINITY;
        }
        double d17 = d;
        double d18 = d8 * d8;
        double d19 = 2.0 * d12;
        for (int i = -1; i <= 1; i += 2) {
            double d20 = d4 + (double)i * d14;
            double d21 = d18 - d19 * d20;
            if (!(d21 > 0.0)) continue;
            d21 = Math.sqrt(d21);
            for (int j = -1; j <= 1; j += 2) {
                double d22 = (-d8 + (double)j * d21) / d12;
                if (!(d22 >= 0.0) || !(d22 < d17)) continue;
                if (this.infiniteWall) {
                    n = (i + 1) / 2;
                    d17 = d22;
                    continue;
                }
                double d23 = d5 + d9 * d22 + d13 * d22 * d22;
                if (!this.onSeg(d23, d14)) continue;
                n = (i + 1) / 2;
                d17 = d22;
            }
        }
        if (d17 >= d) {
            return Double.POSITIVE_INFINITY;
        }
        this.cc = n;
        return d17;
    }

    @Override
    public int collisionCode() {
        return this.cc;
    }

    @Override
    public void collide(Particle2D particle2D, int n) {
        if (n < 0) {
            return;
        }
        particle2D.logCollision();
        double d = particle2D.vx;
        double d2 = particle2D.vy;
        double d3 = this.px * d + this.py * d2;
        double d4 = this.nx * d + this.ny * d2;
        if (this.hasFriction) {
            double d5 = (d4 < 0.0 ? 1.0 : -1.0) * Math.sqrt(d * d + d2 * d2 - (d3 *= this.frictionFactor) * d3);
            double d6 = d3 * this.px + d5 * this.nx;
            double d7 = d3 * this.py + d5 * this.ny;
            particle2D.changeVelocity(d6 - d, d7 - d2);
            this.collisionMomentum += particle2D.mass * (d5 - d4);
        } else {
            double d8 = -2.0 * d4;
            particle2D.changeVelocity(d8 * this.nx, d8 * this.ny);
            this.collisionMomentum += particle2D.mass * d8;
        }
    }

    @Override
    public double getAveragePressure(double d) {
        double d2 = this.collisionMomentum / this.wallLength / d;
        this.collisionMomentum = 0.0;
        return d2;
    }

    @Override
    public boolean[][] markWallOnGrid(Particle2Dbin particle2Dbin) {
        int n = particle2Dbin.nx;
        int n2 = particle2Dbin.ny;
        boolean[][] blArray = new boolean[n][n2];
        double d = particle2Dbin.x1;
        double d2 = particle2Dbin.x2;
        double d3 = particle2Dbin.y1;
        double d4 = particle2Dbin.y2;
        double d5 = particle2Dbin.xg;
        double d6 = particle2Dbin.yg;
        for (int i = 0; i < n; ++i) {
            double d7 = d + (double)i * d5;
            for (int j = 0; j < n2; ++j) {
                double d8 = d3 + (double)j * d5;
                blArray[i][j] = true;
            }
        }
        return blArray;
    }

    @Override
    public void draw(Graphics graphics, Color[] colorArray, int n, int n2, double d) {
        int n3 = n + (int)(d * this.x1);
        int n4 = n + (int)(d * this.x2);
        int n5 = n2 - (int)(d * this.y1);
        int n6 = n2 - (int)(d * this.y2);
        graphics.setColor(colorArray[0]);
        graphics.drawLine(n3, n5, n4, n6);
    }

    public boolean onSeg(double d, double d2) {
        return this.infiniteWall || d > -d2 && d < this.wallLength + d2;
    }
}

