/*
 * Decompiled with CFR 0.152.
 */
package egan.physics;

import egan.physics.Particle2D;
import egan.physics.Particle2Dbin;
import egan.physics.Particle2Dwall;
import java.awt.Color;
import java.awt.Graphics;

public class Particle2DplateWall
extends Particle2Dwall {
    public double x1;
    public double y1;
    public double x2;
    public double y2;
    public double plateSpan;
    public double px;
    public double py;
    public double nx;
    public double ny;
    public double plateNormVel;
    public double plateDisplacement = 0.0;
    public int plateHoleCount;
    public int plateSegCount;
    public double plateHoleSize;
    public double[] plateSegL;
    public double[] plateSegH;
    public double plateMass;
    public double plateParticleMass;
    public double blackThermal;
    public double whiteThermal;
    public double thermalFlux;
    public double minTherm;
    public double plateFriction;
    public boolean hasFriction;
    public boolean infiniteFriction;
    public boolean wrapX;
    public boolean wrapY;
    int cc = 0;
    public static final int histogramBins = 20;
    public double[][] collisionsHist;
    public double[][] momentumHist;
    public double[][] diffHist;

    public Particle2DplateWall(double d, double d2, double d3, double d4, int n, double d5, double d6, double d7, double d8, double d9, double d10, double d11, boolean bl, boolean bl2) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.px = d3 - d;
        this.py = d4 - d2;
        this.plateSpan = Math.sqrt(this.px * this.px + this.py * this.py);
        this.px /= this.plateSpan;
        this.py /= this.plateSpan;
        this.nx = -this.py;
        this.ny = this.px;
        this.plateHoleCount = n;
        this.plateHoleSize = d5;
        this.plateNormVel = d6;
        this.plateParticleMass = d8;
        this.plateFriction = d11;
        this.hasFriction = d11 != 0.0;
        this.infiniteFriction = d11 == 1.0;
        this.wrapX = bl;
        this.wrapY = bl2;
        this.plateSegCount = n + 1;
        this.plateSegL = new double[this.plateSegCount];
        this.plateSegH = new double[this.plateSegCount];
        double d12 = 0.0;
        double d13 = (this.plateSpan - (double)n * d5) / (double)this.plateSegCount;
        double d14 = d13 + d5;
        for (int i = 0; i < this.plateSegCount; ++i) {
            this.plateSegL[i] = (double)i * d14;
            this.plateSegH[i] = this.plateSegL[i] + d13;
            d12 += this.plateSegH[i] - this.plateSegL[i];
        }
        this.plateMass = d7 * d12;
        this.blackThermal = this.whiteThermal = d9 * d12 / 2.0;
        this.minTherm = this.whiteThermal / 2.0;
        this.thermalFlux = d10 * d12;
        this.collisionsHist = new double[2][20];
        this.momentumHist = new double[2][20];
        this.diffHist = new double[2][20];
    }

    @Override
    public boolean particleOK(Particle2D particle2D) {
        double d = particle2D.x - this.x1;
        double d2 = particle2D.y - this.y1;
        double d3 = this.nx * d + this.ny * d2;
        double d4 = particle2D.radius;
        if (d3 > d4 || d3 < -d4) {
            return true;
        }
        double d5 = this.px * d + this.py * d2;
        return d5 < -d4 || d5 > this.plateSpan + d4;
    }

    @Override
    public double collisionTime(Particle2D particle2D, double d) {
        this.cc = -1;
        double d2 = particle2D.x - this.x1;
        double d3 = particle2D.y - this.y1;
        double d4 = this.nx * d2 + this.ny * d3;
        double d5 = particle2D.vx;
        double d6 = particle2D.vy;
        double d7 = this.nx * d5 + this.ny * d6 - this.plateNormVel;
        if (d4 * d7 >= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        int n = d4 < 0.0 ? 0 : 1;
        int n2 = d4 < 0.0 ? -1 : 1;
        double d8 = particle2D.radius;
        double d9 = this.px * d2 + this.py * d3;
        if (Math.abs(d4) <= d8 && this.onSeg(d9, d8)) {
            this.cc = n;
            return Double.POSITIVE_INFINITY;
        }
        double d10 = ((double)n2 * d8 - d4) / d7;
        if (d10 > d) {
            return Double.POSITIVE_INFINITY;
        }
        double d11 = this.px * d5 + this.py * d6;
        double d12 = d9 + d11 * d10;
        if (this.onSeg(d12, d8)) {
            this.cc = n;
            if (d10 < 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return d10;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public int collisionCode() {
        return this.cc;
    }

    @Override
    public void collide(Particle2D particle2D, int n) {
        double d;
        double d2;
        double d3;
        if (n < 0) {
            return;
        }
        double d4 = particle2D.x - this.x1;
        double d5 = particle2D.y - this.y1;
        double d6 = this.px * d4 + this.py * d5;
        double d7 = particle2D.radius;
        int n2 = (int)(20.0 * d6 / this.plateSpan);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= 20) {
            n2 = 19;
        }
        particle2D.logCollision();
        int n3 = n % 2;
        int n4 = 2 * n3 - 1;
        double[] dArray = this.collisionsHist[n3];
        int n5 = n2;
        dArray[n5] = dArray[n5] + 1.0;
        double d8 = (double)n4 * this.nx;
        double d9 = (double)n4 * this.ny;
        for (int i = 0; i < 10 && !((d3 = d8 * (d2 = particle2D.vx) + d9 * (d = particle2D.vy)) > 0.0); ++i) {
            double d10 = particle2D.mass;
            double d11 = this.plateParticleMass;
            double d12 = d10 + d11;
            double d13 = this.thermalVelocity(n3);
            double d14 = d13 + (double)n4 * this.plateNormVel;
            double d15 = 2.0 * d11 / d12 * (d14 - d3);
            particle2D.changeVelocity(d15 * d8, d15 * d9);
            double d16 = 2.0 * d10 * d11 * (d3 - d14) * (d11 * d14 + d10 * d3) / (d12 * d12);
            double d17 = (double)(-n4) * d10 * d15;
            double d18 = d16 - d17 * (this.plateNormVel + 0.5 * d17 / this.plateMass);
            if (n3 == 0) {
                this.blackThermal += d18;
            } else {
                this.whiteThermal += d18;
            }
            this.plateNormVel += d17 / this.plateMass;
            double[] dArray2 = this.momentumHist[n3];
            int n6 = n2;
            dArray2[n6] = dArray2[n6] + d10 * d15;
        }
    }

    @Override
    public boolean[][] markWallOnGrid(Particle2Dbin particle2Dbin) {
        int n = particle2Dbin.nx;
        int n2 = particle2Dbin.ny;
        boolean[][] blArray = new boolean[n][n2];
        double d = particle2Dbin.x1;
        double d2 = particle2Dbin.x2;
        double d3 = particle2Dbin.y1;
        double d4 = particle2Dbin.y2;
        double d5 = particle2Dbin.xg;
        double d6 = particle2Dbin.yg;
        for (int i = 0; i < n; ++i) {
            double d7 = d + (double)i * d5;
            for (int j = 0; j < n2; ++j) {
                double d8 = d3 + (double)j * d5;
                blArray[i][j] = true;
            }
        }
        return blArray;
    }

    @Override
    public void evolve(double d) {
        double d2;
        double d3;
        double d4;
        if (!this.infiniteFriction) {
            d4 = this.plateNormVel * d;
            this.plateDisplacement += d4;
            d3 = d4 * this.nx;
            d2 = d4 * this.ny;
            this.x1 += d3;
            this.x2 += d3;
            this.y1 += d2;
            this.y2 += d2;
            if (this.wrapX) {
                while (this.x1 > 1.0) {
                    this.x1 -= 1.0;
                }
                while (this.x2 > 1.0) {
                    this.x2 -= 1.0;
                }
                while (this.x1 < 0.0) {
                    this.x1 += 1.0;
                }
                while (this.x2 < 0.0) {
                    this.x2 += 1.0;
                }
            }
            if (this.wrapY) {
                while (this.y1 > 1.0) {
                    this.y1 -= 1.0;
                }
                while (this.y2 > 1.0) {
                    this.y2 -= 1.0;
                }
                while (this.y1 < 0.0) {
                    this.y1 += 1.0;
                }
                while (this.y2 < 0.0) {
                    this.y2 += 1.0;
                }
            }
        }
        if (this.whiteThermal - (d4 = d * this.thermalFlux) > this.minTherm) {
            this.blackThermal += d4;
            this.whiteThermal -= d4;
        } else {
            this.blackThermal += this.whiteThermal - this.minTherm;
            this.whiteThermal = this.minTherm;
        }
        if (this.hasFriction && this.plateNormVel != 0.0) {
            d3 = this.kineticEnergy();
            double d5 = d2 = this.infiniteFriction ? Math.abs(this.plateNormVel) : this.plateFriction * d;
            if (this.plateNormVel > 0.0) {
                this.plateNormVel -= d2;
                if (this.plateNormVel < 0.0) {
                    this.plateNormVel = 0.0;
                }
            } else {
                this.plateNormVel += d2;
                if (this.plateNormVel > 0.0) {
                    this.plateNormVel = 0.0;
                }
            }
            double d6 = this.kineticEnergy();
            double d7 = (d3 - d6) / 2.0;
            this.blackThermal += d7;
            this.whiteThermal += d7;
        }
    }

    @Override
    public void draw(Graphics graphics, Color[] colorArray, int n, int n2, double d) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (int i = 0; i < this.plateSegCount; ++i) {
            double d2 = this.plateSegL[i];
            double d3 = this.plateSegH[i];
            for (int j = 0; j < 2; ++j) {
                graphics.setColor(colorArray[j]);
                double d4 = 3.0 * (double)(2 * j - 1) / d;
                double d5 = -this.py * d4;
                double d6 = this.px * d4;
                double d7 = this.x1 + this.px * d2;
                double d8 = this.y1 + this.py * d2;
                double d9 = this.x1 + this.px * d3;
                double d10 = this.y1 + this.py * d3;
                double d11 = d7 + d5;
                double d12 = d8 + d6;
                double d13 = d9 + d5;
                double d14 = d10 + d6;
                nArray[0] = n + (int)(d * d7);
                nArray2[0] = n2 - (int)(d * d8);
                nArray[1] = n + (int)(d * d9);
                nArray2[1] = n2 - (int)(d * d10);
                nArray[2] = n + (int)(d * d13);
                nArray2[2] = n2 - (int)(d * d14);
                nArray[3] = n + (int)(d * d11);
                nArray2[3] = n2 - (int)(d * d12);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
        }
    }

    public double kineticEnergy() {
        return 0.5 * this.plateMass * this.plateNormVel * this.plateNormVel;
    }

    public double linearMomentum() {
        return this.plateMass * this.plateNormVel;
    }

    public double blackThermalEnergy() {
        return this.blackThermal;
    }

    public double whiteThermalEnergy() {
        return this.whiteThermal;
    }

    public double thermalVelocity(int n) {
        return Math.sqrt(2.0 * (n == 0 ? this.blackThermal : this.whiteThermal) / (0.5 * this.plateMass));
    }

    public void setThermalFlux(double d) {
        this.thermalFlux = d;
    }

    public boolean onSeg(double d, double d2) {
        for (int i = 0; i < this.plateSegCount; ++i) {
            if (!(d > this.plateSegL[i] - d2) || !(d < this.plateSegH[i] + d2)) continue;
            return true;
        }
        return false;
    }
}

