/*
 * Decompiled with CFR 0.152.
 */
package egan.physics;

import egan.physics.Particle2D;
import egan.physics.Particle2Dbin;
import egan.physics.Particle2Dwall;
import java.awt.Color;
import java.awt.Graphics;

public class Particle2DrotorWall
extends Particle2Dwall {
    public double wcx;
    public double wcy;
    public double minRad;
    public double maxRad;
    public double minRadSq;
    public double maxRadSq;
    public double diameter;
    public int rotorHoleCount;
    public int rotorSegCount;
    public double rotorHoleSize;
    public double[] rotorSegL;
    public double[] rotorSegH;
    public int rotorVanes;
    public double rotorPhase;
    public double rotorAV;
    public double vaneAngle;
    public double cosVaneAngle;
    public double rotorMass;
    public double rotorParticleMass;
    public double rotorI;
    public double[] vanePhases;
    public double[] vaneC;
    public double[] vaneS;
    public double blackThermal;
    public double whiteThermal;
    public double thermalFlux;
    public double minTherm;
    public double rotorFriction;
    public boolean hasFriction;
    public boolean infiniteFriction;
    int cc = 0;
    public static final int histogramBins = 20;
    public double[][] collisionsHist;
    public double[][] momentumHist;
    public double[][] diffHist;
    public double[][] amHist;

    public Particle2DrotorWall(double d, double d2, double d3, double d4, int n, double d5, int n2, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        int n3;
        this.wcx = d;
        this.wcy = d2;
        this.minRad = d3;
        this.maxRad = d4;
        this.rotorHoleCount = n;
        this.rotorHoleSize = d5;
        this.rotorVanes = n2;
        this.rotorPhase = d6;
        this.rotorAV = d7;
        this.rotorParticleMass = d9;
        this.rotorFriction = d12;
        this.hasFriction = d12 != 0.0;
        this.infiniteFriction = d12 == 1.0;
        this.minRadSq = d3 * d3;
        this.maxRadSq = d4 * d4;
        this.rotorSegCount = n + 1;
        this.rotorSegL = new double[this.rotorSegCount];
        this.rotorSegH = new double[this.rotorSegCount];
        double d13 = 0.0;
        double d14 = d4 - d3;
        double d15 = (d14 - (double)n * d5) / (double)this.rotorSegCount;
        double d16 = d15 + d5;
        for (n3 = 0; n3 < this.rotorSegCount; ++n3) {
            this.rotorSegL[n3] = d3 + (double)n3 * d16;
            this.rotorSegH[n3] = this.rotorSegL[n3] + d15;
            d13 += (double)n2 * (this.rotorSegH[n3] - this.rotorSegL[n3]);
        }
        this.rotorMass = d8 * d13;
        this.blackThermal = this.whiteThermal = d10 * d13 / 2.0;
        this.minTherm = this.whiteThermal / 2.0;
        this.thermalFlux = d11 * d13;
        this.rotorI = 0.0;
        for (n3 = 0; n3 < this.rotorSegCount; ++n3) {
            this.rotorI += this.rotorMass / 3.0 / (double)this.rotorSegCount * (this.rotorSegL[n3] * this.rotorSegL[n3] + this.rotorSegH[n3] * this.rotorSegH[n3] + this.rotorSegL[n3] * this.rotorSegH[n3]);
        }
        if (d5 == 0.0) {
            this.rotorI = this.rotorMass / 3.0 * (this.minRadSq + this.maxRadSq + d3 * d4);
        }
        this.diameter = 2.0 * d4;
        this.vaneAngle = Math.PI * 2 / (double)n2;
        this.cosVaneAngle = Math.cos(this.vaneAngle);
        this.vanePhases = new double[n2];
        this.vaneC = new double[n2];
        this.vaneS = new double[n2];
        this.setVanePhases();
        this.collisionsHist = new double[2][20];
        this.momentumHist = new double[2][20];
        this.diffHist = new double[2][20];
        this.amHist = new double[2][20 + (this.hasFriction ? 1 : 0)];
    }

    void setVanePhases() {
        for (int i = 0; i < this.rotorVanes; ++i) {
            double d = this.rotorPhase + (double)i * this.vaneAngle;
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            this.vanePhases[i] = d;
            this.vaneC[i] = d2;
            this.vaneS[i] = d3;
        }
    }

    public boolean withinOuterCircle(double d, double d2) {
        double d3 = d - this.wcx;
        double d4 = d2 - this.wcy;
        double d5 = d3 * d3 + d4 * d4;
        return d5 <= this.maxRadSq;
    }

    public boolean withinInnerCircle(double d, double d2) {
        double d3 = d - this.wcx;
        double d4 = d2 - this.wcy;
        double d5 = d3 * d3 + d4 * d4;
        return d5 <= this.minRadSq;
    }

    @Override
    public boolean particleOK(Particle2D particle2D) {
        double d = 1.05;
        double d2 = particle2D.x - this.wcx;
        double d3 = particle2D.y - this.wcy;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        if (d4 > this.maxRad + d * particle2D.radius || d4 < this.minRad - d * particle2D.radius) {
            return true;
        }
        for (int i = 0; i < this.rotorVanes; ++i) {
            if (!(Math.abs(-this.vaneS[i] * d2 + this.vaneC[i] * d3) <= d * particle2D.radius)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double collisionTime(Particle2D particle2D, double d) {
        this.cc = -1;
        double d2 = 0.001;
        double d3 = particle2D.x - this.wcx;
        double d4 = particle2D.y - this.wcy;
        double d5 = d3 * d3 + d4 * d4;
        double d6 = Math.sqrt(d5);
        double d7 = this.maxRad + particle2D.radius;
        double d8 = d7 * d7;
        double d9 = particle2D.vx;
        double d10 = particle2D.vy;
        double d11 = d9 * d9 + d10 * d10;
        double d12 = d10 * d3 - d9 * d4;
        double d13 = d12 * d12;
        double d14 = d8 * d11 - d13;
        if (d14 < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d15 = Math.sqrt(d14);
        double d16 = -d9 * d3 - d10 * d4;
        double d17 = (d16 - d15) / d11;
        double d18 = (d16 + d15) / d11;
        if (d17 > d) {
            return Double.POSITIVE_INFINITY;
        }
        if (d18 < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d17 > d2) {
            return d17;
        }
        int n = -1;
        double d19 = 0.0;
        double d20 = 0.0;
        for (int i = 0; i < this.rotorVanes; ++i) {
            d19 = (d3 * this.vaneC[i] + d4 * this.vaneS[i]) / d6;
            if (!(d19 > this.cosVaneAngle)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            double d21;
            double d22 = this.vaneC[n];
            double d23 = this.vaneS[n];
            d20 = -d4 * d22 + d3 * d23;
            int n2 = d20 > 0.0 ? -1 : 1;
            int n3 = d20 > 0.0 ? 0 : 1;
            int n4 = 1 - n3;
            int n5 = (n + this.rotorVanes + n2) % this.rotorVanes;
            int n6 = 2 * n + n3;
            int n7 = 2 * n5 + n4;
            double d24 = d4 * d22 - d3 * d23;
            if ((double)n2 * d24 < particle2D.radius + d2 && (double)n2 * d24 > 0.0) {
                if (!this.onSeg(d6, particle2D.radius)) {
                    return Double.POSITIVE_INFINITY;
                }
                if ((double)n2 * (-d9 * d23 + d10 * d22) < 0.0) {
                    this.cc = n6;
                    return 0.0;
                }
                return Double.POSITIVE_INFINITY;
            }
            double d25 = this.vaneC[n5];
            double d26 = this.vaneS[n5];
            double d27 = d4 * d25 - d3 * d26;
            if ((double)(-n2) * d27 < particle2D.radius + d2 && (double)(-n2) * d27 > 0.0) {
                if (!this.onSeg(d6, particle2D.radius)) {
                    return Double.POSITIVE_INFINITY;
                }
                if ((double)(-n2) * (-d9 * d26 + d10 * d25) < 0.0) {
                    this.cc = n7;
                    return 0.0;
                }
                return Double.POSITIVE_INFINITY;
            }
            double d28 = this.ctime(d3, d4, d9, d10, (double)n2 * particle2D.radius, n);
            if (d28 < (d21 = this.ctime(d3, d4, d9, d10, (double)(-n2) * particle2D.radius, n5))) {
                double d29 = this.dt(d3, d4, d9, d10, (double)n2 * particle2D.radius, n, d28);
                if (d28 > d18) {
                    return Double.POSITIVE_INFINITY;
                }
                if (Math.abs(d29) < d2) {
                    this.cc = n6;
                    return d28;
                }
                return Double.POSITIVE_INFINITY;
            }
            double d30 = this.dt(d3, d4, d9, d10, (double)(-n2) * particle2D.radius, n5, d21);
            if (d21 > d18) {
                return Double.POSITIVE_INFINITY;
            }
            if (Math.abs(d30) < d2) {
                if (!Double.isInfinite(d21)) {
                    this.cc = n7;
                }
                return d21;
            }
            return Double.POSITIVE_INFINITY;
        }
        return Double.POSITIVE_INFINITY;
    }

    double ctime(double d, double d2, double d3, double d4, double d5, int n) {
        double d6;
        double d7 = Double.POSITIVE_INFINITY;
        double d8 = this.vaneC[n];
        double d9 = this.vaneS[n];
        double d10 = -(this.rotorAV * ((2.0 * d3 + this.rotorAV * d2) * d8 + (2.0 * d4 - this.rotorAV * d) * d9)) / 2.0;
        double d11 = (d4 - this.rotorAV * d) * d8 - (d3 + this.rotorAV * d2) * d9;
        double d12 = d2 * d8 - d * d9 - d5;
        if (d10 == 0.0) {
            double d13 = -d12 / d11;
            if (d13 > 0.0) {
                return d13;
            }
            return d7;
        }
        if (d10 < 0.0) {
            d10 = -d10;
            d11 = -d11;
            d12 = -d12;
        }
        if ((d6 = d11 * d11 - 4.0 * d10 * d12) < 0.0) {
            return d7;
        }
        double d14 = (-d11 - (d6 = Math.sqrt(d6))) / (2.0 * d10);
        if (d14 > 0.0) {
            return d14;
        }
        d14 = (-d11 + d6) / (2.0 * d10);
        if (d14 > 0.0) {
            return d14;
        }
        return d7;
    }

    double dt(double d, double d2, double d3, double d4, double d5, int n, double d6) {
        if (Double.isInfinite(d6)) {
            return 0.0;
        }
        return (d6 * d4 + d2) * Math.cos(this.vanePhases[n] + this.rotorAV * d6) - (d6 * d3 + d) * Math.sin(this.vanePhases[n] + this.rotorAV * d6) - d5;
    }

    @Override
    public int collisionCode() {
        return this.cc;
    }

    @Override
    public void collide(Particle2D particle2D, int n) {
        double d;
        double d2;
        double d3;
        if (n < 0) {
            return;
        }
        double d4 = particle2D.x - this.wcx;
        double d5 = particle2D.y - this.wcy;
        double d6 = d4 * d4 + d5 * d5;
        double d7 = Math.sqrt(d6);
        if (!this.onSeg(d7, particle2D.radius)) {
            return;
        }
        int n2 = (int)(20.0 * (d7 - this.minRad) / (this.maxRad - this.minRad));
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= 20) {
            n2 = 19;
        }
        particle2D.logCollision();
        int n3 = n / 2;
        int n4 = n % 2;
        int n5 = 2 * n4 - 1;
        double[] dArray = this.collisionsHist[n4];
        int n6 = n2;
        dArray[n6] = dArray[n6] + 1.0;
        double d8 = this.vaneC[n3];
        double d9 = this.vaneS[n3];
        double d10 = (double)(-n5) * d9;
        double d11 = (double)n5 * d8;
        for (int i = 0; i < 10 && !((d3 = d10 * (d2 = particle2D.vx) + d11 * (d = particle2D.vy)) > 0.0); ++i) {
            double d12 = particle2D.mass;
            double d13 = this.rotorParticleMass;
            double d14 = d12 + d13;
            double d15 = this.thermalVelocity(n4);
            double d16 = (double)n5 * d7 * this.rotorAV;
            double d17 = d15 + d16;
            double d18 = 2.0 * d13 / d14 * (d17 - d3);
            particle2D.changeVelocity(d18 * d10, d18 * d11);
            double d19 = 2.0 * d12 * d13 * (d3 - d17) * (d13 * d17 + d12 * d3) / (d14 * d14);
            double d20 = -(d4 * d8 + d5 * d9) * d12 * d18 * (double)n5;
            double d21 = d19 - d20 * (this.rotorAV + 0.5 * d20 / this.rotorI);
            if (n4 == 0) {
                this.blackThermal += d21;
            } else {
                this.whiteThermal += d21;
            }
            this.rotorAV += d20 / this.rotorI;
            double[] dArray2 = this.momentumHist[n4];
            int n7 = n2;
            dArray2[n7] = dArray2[n7] + d12 * d18;
            double[] dArray3 = this.amHist[n4];
            int n8 = n2;
            dArray3[n8] = dArray3[n8] + d7 * d12 * d18;
        }
    }

    public void collideNonthermal(Particle2D particle2D, int n) {
        if (n < 0) {
            return;
        }
        int n2 = n / 2;
        int n3 = n % 2;
        double d = this.vaneC[n2];
        double d2 = this.vaneS[n2];
        double d3 = particle2D.x - this.wcx;
        double d4 = particle2D.y - this.wcy;
        double d5 = d3 * d3 + d4 * d4;
        double d6 = Math.sqrt(d5);
        double d7 = particle2D.vx;
        double d8 = particle2D.vy;
        if (!this.onSeg(d6, particle2D.radius)) {
            return;
        }
        particle2D.logCollision();
        double d9 = d * d3 + d2 * d4;
        double d10 = d2 * d7 - d * d8;
        double d11 = particle2D.mass;
        double d12 = this.rotorI + d11 * d9 * d9;
        double d13 = 2.0 * (d10 + d9 * this.rotorAV) / d12;
        double d14 = -d9 * d11 * d13;
        double d15 = this.rotorI * d13;
        double d16 = -d2 * d15;
        double d17 = d * d15;
        this.rotorAV += d14;
        particle2D.changeVelocity(d16, d17);
    }

    @Override
    public boolean[][] markWallOnGrid(Particle2Dbin particle2Dbin) {
        int n;
        int n2 = particle2Dbin.nx;
        int n3 = particle2Dbin.ny;
        boolean[][] blArray = new boolean[n2][n3];
        double d = particle2Dbin.x1;
        double d2 = particle2Dbin.x2;
        double d3 = particle2Dbin.y1;
        double d4 = particle2Dbin.y2;
        double d5 = particle2Dbin.xg;
        double d6 = particle2Dbin.yg;
        for (int i = 0; i < n2; ++i) {
            double d7 = d + (double)i * d5;
            for (n = 0; n < n3; ++n) {
                double d8 = d3 + (double)n * d5;
                if (!this.withinOuterCircle(d7, d8) && !this.withinOuterCircle(d7 + d5 / 2.0, d8) && !this.withinOuterCircle(d7 + d5, d8) && !this.withinOuterCircle(d7, d8 + d6 / 2.0) && !this.withinOuterCircle(d7, d8 + d6) && !this.withinOuterCircle(d7 + d5 / 2.0, d8 + d6) && !this.withinOuterCircle(d7 + d5, d8 + d6 / 2.0) && !this.withinOuterCircle(d7 + d5, d8 + d6) || this.withinInnerCircle(d7, d8) && this.withinInnerCircle(d7 + d5, d8) && this.withinInnerCircle(d7, d8 + d6) && this.withinInnerCircle(d7 + d5, d8 + d6)) continue;
                blArray[i][n] = true;
            }
        }
        double d9 = Math.sqrt(d5 * d5 + d6 * d6);
        if (this.diameter < d9 && this.wcx > d && this.wcx < d2 && this.wcy > d3 && this.wcy < d4) {
            int n4 = (int)Math.floor((this.wcx - d) / d5);
            if (n4 >= n2) {
                n4 = n2 - 1;
            } else if (n4 < 0) {
                n4 = 0;
            }
            n = (int)Math.floor((this.wcy - d3) / d6);
            if (n >= n3) {
                n = n3 - 1;
            } else if (n < 0) {
                n = 0;
            }
            blArray[n4][n] = true;
        }
        return blArray;
    }

    @Override
    public void evolve(double d) {
        double d2;
        if (!this.infiniteFriction) {
            this.rotorPhase += this.rotorAV * d;
            this.setVanePhases();
        }
        if (this.whiteThermal - (d2 = d * this.thermalFlux) > this.minTherm) {
            this.blackThermal += d2;
            this.whiteThermal -= d2;
        } else {
            this.blackThermal += this.whiteThermal - this.minTherm;
            this.whiteThermal = this.minTherm;
        }
        if (this.hasFriction && this.rotorAV != 0.0) {
            double d3;
            double d4 = this.kineticEnergy();
            double d5 = d3 = this.infiniteFriction ? Math.abs(this.rotorAV) : this.rotorFriction * d;
            if (this.rotorAV > 0.0) {
                this.rotorAV -= d3;
                if (this.rotorAV < 0.0) {
                    this.rotorAV = 0.0;
                }
                double[] dArray = this.amHist[1];
                dArray[20] = dArray[20] + this.rotorI * d3;
            } else {
                this.rotorAV += d3;
                if (this.rotorAV > 0.0) {
                    this.rotorAV = 0.0;
                }
                double[] dArray = this.amHist[0];
                dArray[20] = dArray[20] + this.rotorI * d3;
            }
            double d6 = this.kineticEnergy();
            double d7 = (d4 - d6) / 2.0;
            this.blackThermal += d7;
            this.whiteThermal += d7;
        }
    }

    @Override
    public void draw(Graphics graphics, Color[] colorArray, int n, int n2, double d) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (int i = 0; i < this.rotorSegCount; ++i) {
            double d2 = this.rotorSegL[i];
            double d3 = this.rotorSegH[i];
            for (int j = 0; j < 2; ++j) {
                graphics.setColor(colorArray[j]);
                double d4 = 3.0 * (double)(2 * j - 1) / d;
                for (int k = 0; k < this.rotorVanes; ++k) {
                    double d5 = this.vaneC[k];
                    double d6 = this.vaneS[k];
                    double d7 = -d6 * d4;
                    double d8 = d5 * d4;
                    double d9 = this.wcx + d5 * d2;
                    double d10 = this.wcy + d6 * d2;
                    double d11 = this.wcx + d5 * d3;
                    double d12 = this.wcy + d6 * d3;
                    double d13 = d9 + d7;
                    double d14 = d10 + d8;
                    double d15 = d11 + d7;
                    double d16 = d12 + d8;
                    nArray[0] = n + (int)(d * d9);
                    nArray2[0] = n2 - (int)(d * d10);
                    nArray[1] = n + (int)(d * d11);
                    nArray2[1] = n2 - (int)(d * d12);
                    nArray[2] = n + (int)(d * d15);
                    nArray2[2] = n2 - (int)(d * d16);
                    nArray[3] = n + (int)(d * d13);
                    nArray2[3] = n2 - (int)(d * d14);
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
        }
    }

    public double kineticEnergy() {
        return 0.5 * this.rotorI * this.rotorAV * this.rotorAV;
    }

    public double angularMomentum() {
        return this.rotorI * this.rotorAV;
    }

    public double blackThermalEnergy() {
        return this.blackThermal;
    }

    public double whiteThermalEnergy() {
        return this.whiteThermal;
    }

    public double thermalVelocity(int n) {
        return Math.sqrt(2.0 * (n == 0 ? this.blackThermal : this.whiteThermal) / (0.5 * this.rotorMass));
    }

    public void setThermalFlux(double d) {
        this.thermalFlux = d;
    }

    public boolean onSeg(double d, double d2) {
        for (int i = 0; i < this.rotorSegCount; ++i) {
            if (!(d > this.rotorSegL[i] - d2) || !(d < this.rotorSegH[i] + d2)) continue;
            return true;
        }
        return false;
    }
}

