/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.Littlewood;

import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;

public class Littlewood
extends Applet
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    final int lowOrder = 6;
    final int highOrder = 36;
    final int defaultOrder = 20;
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    FontMetrics fm = null;
    NumberFormat nf = null;
    final int toolsHeight = 55;
    LittlewoodPanel lp = null;
    Choice orderChoice = null;
    Button resetButton = null;
    Button zoomIn = null;
    Button zoomOut = null;

    @Override
    public void init() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = n * n2;
        this.setBackground(Color.white);
        this.setFont(new Font(this.getFont().getName(), 0, 12));
        this.lp = new LittlewoodPanel(this);
        this.lp.specifySize(n - 10, n2 - 55);
        this.lp.specifyOrder(20);
        this.setLayout(new FlowLayout(0, 5, 5));
        this.add(this.lp);
        this.lp.init();
        this.resetButton = new Button("Reset view");
        this.add(this.resetButton);
        this.resetButton.addActionListener(this);
        this.orderChoice = new Choice();
        for (int i = 6; i <= 36; ++i) {
            this.orderChoice.add("Degree " + i);
        }
        this.add(this.orderChoice);
        this.orderChoice.addItemListener(this);
        this.orderChoice.select(14);
        this.zoomIn = new Button("Zoom \u00d7 2");
        this.add(this.zoomIn);
        this.zoomIn.addActionListener(this);
        this.zoomOut = new Button("Zoom \u00f7 2");
        this.add(this.zoomOut);
        this.zoomOut.addActionListener(this);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        String string;
        String string2;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(aaON);
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics();
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
            this.nf.setMaximumIntegerDigits(1);
            this.nf.setMaximumFractionDigits(5);
        }
        graphics2D.setColor(Color.black);
        int n3 = this.fm.getDescent();
        int n4 = this.fm.getHeight();
        if (this.lp.dragonStatus()) {
            string2 = "Click to return to roots plot.";
            string = "\u201cDragon\u201d for (" + this.nf.format(this.lp.getXJcen()) + ", " + this.nf.format(this.lp.getYJcen()) + "), height is " + this.nf.format(this.lp.getYJheight());
            this.orderChoice.setEnabled(false);
        } else {
            string2 = "Drag to select a new view.  Shift-click for \u201cdragon\u201d.";
            string = "Centre is (" + this.nf.format(this.lp.getXcen()) + ", " + this.nf.format(this.lp.getYcen()) + "), height is " + this.nf.format(this.lp.getYheight());
            this.orderChoice.setEnabled(true);
        }
        int n5 = this.fm.stringWidth(string2);
        int n6 = this.fm.stringWidth(string);
        graphics2D.drawString(string2, n - 5 - n5, n2 - 5 - n3);
        graphics2D.drawString(string, n - 5 - n6, n2 - 5 - n3 - n4);
        super.paint(graphics);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.resetButton) {
            this.lp.defaultView();
        } else if (object == this.zoomIn) {
            this.lp.zoomIn();
        } else if (object == this.zoomOut) {
            this.lp.zoomOut();
        }
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.orderChoice) {
            this.lp.setOrder(6 + this.orderChoice.getSelectedIndex());
        }
    }

    public class LittlewoodPanel
    extends Panel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 1L;
        Littlewood parent = null;
        Dimension size = null;
        Image I = null;
        Image J = null;
        Graphics G;
        Graphics H;
        boolean needPaint = true;
        boolean needDragonPaint = false;
        int paintOffs = 0;
        int needDragonCount;
        final long tStep = 100L;
        final double xcen0 = 0.0;
        final double ycen0 = 0.0;
        final double yheight0 = 1.8;
        double xcen = 0.0;
        double ycen = 0.0;
        double yheight = 1.8;
        double newXcen = 0.0;
        double newYcen = 0.0;
        double newYheight = 1.8;
        boolean isDragon = false;
        double xjcen;
        double yjcen;
        double dragonHeight;
        int N;
        double[] r1;
        double[] cPowerR;
        double[] cPowerI;
        double[][] ga;
        int ncp;
        double r;
        double rsq;
        double hscale;
        boolean flipX;
        boolean flipY;
        boolean invert;
        int[] fPix = null;
        float[] dmag = null;
        boolean amMouseMotionListener = false;
        boolean changeView = false;
        boolean swapView = false;
        boolean validMouseRectangle = false;
        int mouseX1;
        int mouseY1;
        int mouseX2;
        int mouseY2;
        int mouseX3;
        int mouseY3;
        FontMetrics fm = null;
        NumberFormat nf = null;

        LittlewoodPanel(Littlewood littlewood2) {
            this.parent = littlewood2;
        }

        public void init() {
            this.setBackground(Color.white);
            this.setFont(new Font(this.getFont().getName(), 0, 12));
            this.addMouseListener(this);
            this.cPowerR = new double[this.N + 1];
            this.cPowerI = new double[this.N + 1];
            this.r1 = new double[this.N + 1];
            this.ga = new double[this.N + 1][2];
            this.ga[this.N][1] = 0.0;
            this.ga[this.N][0] = 0.0;
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public synchronized void paint(Graphics graphics) {
            int n;
            double d;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            Dimension dimension = this.getSize();
            int n7 = dimension.width;
            int n8 = dimension.height;
            int n9 = n7 * n8;
            if (this.I == null) {
                this.I = this.createImage(n7, n8);
                this.G = this.I.getGraphics();
            }
            if (this.J == null) {
                this.J = this.createImage(n7, n8);
                this.H = this.J.getGraphics();
            }
            if (this.fPix == null) {
                this.fPix = new int[n9];
                this.dmag = new float[n9];
                this.changeView = true;
            }
            if (this.changeView) {
                this.changeView = false;
                for (int i = 0; i < n9; ++i) {
                    this.fPix[i] = -1;
                    this.dmag[i] = -1.0f;
                }
                this.paintOffs = 0;
                this.validMouseRectangle = false;
                this.G.setColor(this.getBackground());
                this.G.fillRect(0, 0, n7, n8);
                this.setView(this.newXcen, this.newYcen, this.newYheight);
                this.parent.repaint();
                this.needPaint = true;
            }
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            d2 = ((double)n7 - 1.0) / 2.0;
            d3 = ((double)n8 - 1.0) / 2.0;
            d4 = this.yheight / ((double)n8 - 1.0);
            boolean bl = this.xcen - d4 * d2 < 0.0 && this.xcen + d4 * d2 > 0.0;
            boolean bl2 = this.ycen - d4 * d3 < 0.0 && this.ycen + d4 * d3 > 0.0;
            int n10 = 0;
            int n11 = 0;
            if (bl) {
                n6 = (int)Math.round(d2 - this.xcen / d4);
                this.xcen = d4 * (d2 - (double)n6);
                n10 = (int)(2.0 * (d2 - this.xcen / d4));
            }
            if (bl2) {
                n6 = (int)Math.round(d3 + this.ycen / d4);
                this.ycen = d4 * ((double)n6 - d3);
                n11 = (int)(2.0 * (d3 + this.ycen / d4));
            }
            if (this.swapView) {
                this.swapView = false;
                this.parent.repaint();
                if (this.dragonStatus()) {
                    this.xjcen = this.xcen + d4 * ((double)this.mouseX1 - d2);
                    this.yjcen = this.ycen - d4 * ((double)this.mouseY1 - d3);
                    if (this.xjcen * this.xjcen + this.yjcen * this.yjcen < 1.0) {
                        this.needDragonPaint = true;
                        this.needDragonCount = 10;
                        float f = this.dmag[n7 * this.mouseY1 + this.mouseX1];
                        if (f < 0.0f) {
                            block1: for (n5 = 1; n5 < 20; ++n5) {
                                for (int i = -1; i <= 1; i += 2) {
                                    for (int j = 0; j < 2; ++j) {
                                        for (n4 = -n5 + 1; n4 <= n5; ++n4) {
                                            n3 = this.mouseX1 + i * (j > 0 ? -n4 : n5);
                                            n2 = this.mouseY1 + i * (j > 0 ? n5 : n4);
                                            if (n3 >= 0 && n3 < n7 && n2 >= 0 && n2 < n8 && (f = this.dmag[n7 * n2 + n3]) > 0.0f) break block1;
                                        }
                                    }
                                }
                            }
                        }
                        this.dragonHeight = f > 0.0f ? this.yheight * (double)f : 0.1 * Math.pow(0.75, this.N - 20);
                    } else {
                        this.setDragonStatus(false);
                    }
                }
            }
            if (this.needPaint) {
                int n12;
                int n13;
                float[] fArray = new float[9];
                long l = System.currentTimeMillis();
                n4 = 1;
                int n14 = 0;
                for (n3 = this.paintOffs; n3 < n9; ++n3) {
                    if (this.fPix[n3] != -1) continue;
                    n14 = n3 / n7;
                    n2 = n3 % n7;
                    if (n2 == 0 && System.currentTimeMillis() - l > 100L) {
                        n4 = 0;
                        break;
                    }
                    n13 = -1;
                    n12 = -1;
                    this.flipX = false;
                    if (bl) {
                        n13 = n10 - n2;
                        if (n13 >= n7 || n13 < 0) {
                            n13 = -1;
                        } else {
                            this.flipX = true;
                        }
                    }
                    this.flipY = false;
                    if (bl2) {
                        n12 = n11 - n14;
                        if (n12 >= n8 || n12 < 0) {
                            n12 = -1;
                        } else {
                            this.flipY = true;
                        }
                    }
                    double d5 = this.xcen + d4 * ((double)n2 - d2);
                    d = d5 * d5;
                    double d6 = this.ycen - d4 * ((double)n14 - d3);
                    double d7 = d6 * d6;
                    double d8 = d + d7;
                    double d9 = d4;
                    boolean bl3 = this.invert = d8 > 1.0;
                    if (this.invert) {
                        d5 /= d8;
                        d6 = -d6 / d8;
                        d9 = d4 / d8;
                        d8 = 1.0 / d8;
                    }
                    float f = 0.0f;
                    n = -16777216;
                    float f2 = 0.0f;
                    float f3 = -1.0f;
                    if (!(d8 < 0.25 || d8 > 4.0 || d8 > 0.6400000000000001 || (f = this.rootsForPixel(d5, d6, d9, fArray)) == 0.0f)) {
                        float f4 = (float)(d9 * d9 * 10.0 * Math.pow(2.0, this.N));
                        f2 = Math.min(1.0f, f / f4) / f;
                        n = new Color(f2 * fArray[0], f2 * fArray[1], f2 * fArray[2]).getRGB();
                        f3 = fArray[7] / f;
                    }
                    this.fPix[n3] = n;
                    this.dmag[n3] = f3;
                    if (this.flipY) {
                        this.fPix[n7 * n12 + n2] = this.fPix[n3];
                        this.dmag[n7 * n12 + n2] = this.dmag[n3];
                    }
                    if (!this.flipX) continue;
                    if (f != 0.0f) {
                        n = new Color(f2 * fArray[3], f2 * fArray[4], f2 * fArray[5]).getRGB();
                        f3 = fArray[8] / f;
                    } else {
                        n = -16777216;
                        f3 = -1.0f;
                    }
                    this.fPix[n7 * n14 + n13] = n;
                    this.dmag[n7 * n14 + n13] = f3;
                    if (!this.flipY) continue;
                    this.fPix[n7 * n12 + n13] = n;
                    this.dmag[n7 * n12 + n13] = f3;
                }
                GraphicsUtils.drawPixDCM((Component)this, (Graphics)this.G, (int[])this.fPix, (int)n7, (int)((n3 - this.paintOffs) / n7), (int)this.paintOffs, (int)n7, (int)0, (int)(this.paintOffs / n7));
                if (bl2) {
                    n13 = this.paintOffs / n7;
                    n12 = n14 - 1;
                    int n15 = n11 - n12;
                    int n16 = n11 - n13;
                    if (n15 < 0) {
                        n15 = 0;
                    }
                    if (n16 >= n8) {
                        n16 = n8 - 1;
                    }
                    if (n16 >= n15) {
                        GraphicsUtils.drawPixDCM((Component)this, (Graphics)this.G, (int[])this.fPix, (int)n7, (int)(n16 - n15 + 1), (int)(n15 * n7), (int)n7, (int)0, (int)n15);
                    }
                }
                if (n4 != 0) {
                    this.needPaint = false;
                    this.paintOffs = 0;
                } else {
                    this.paintOffs = n3;
                    this.repaint();
                }
            }
            if (this.needDragonPaint) {
                if (--this.needDragonCount == 0) {
                    float[][][] fArray = new float[n7][n8][4];
                    double d10 = ((double)n7 - 1.0) / ((double)n8 - 1.0);
                    double d11 = 0.55 * this.dragonHeight * Math.sqrt(1.0 + d10 * d10);
                    this.doDragon(this.xjcen, this.yjcen, fArray, n7, n8, d11);
                    for (n3 = 0; n3 < n7; ++n3) {
                        for (n2 = 0; n2 < n8; ++n2) {
                            float f = fArray[n3][n2][3];
                            this.fPix[n7 * n2 + n3] = new Color(fArray[n3][n2][0] / f, fArray[n3][n2][1] / f, fArray[n3][n2][2] / f).getRGB();
                        }
                    }
                    GraphicsUtils.drawPixDCM((Component)this, (Graphics)this.H, (int[])this.fPix, (int)n7, (int)n8, (int)0, (int)n7, (int)0, (int)0);
                    this.needDragonPaint = false;
                } else {
                    this.H.setColor(Color.black);
                    this.H.fillRect(0, 0, n7, n8);
                    this.H.setColor(Color.white);
                    Graphics2D graphics2D = (Graphics2D)this.H;
                    graphics2D.setRenderingHints(aaON);
                    graphics2D.drawString("Calculating ...", n7 / 2, n8 / 2);
                    this.repaint();
                }
            }
            graphics.drawImage(this.dragonStatus() ? this.J : this.I, 0, 0, null);
            if (this.amMouseMotionListener) {
                int n17 = Math.abs(this.mouseX2 - this.mouseX1);
                n5 = Math.abs(this.mouseY2 - this.mouseY1);
                int n18 = n7 * n5 / n8;
                int n19 = n8 * n17 / n7;
                n4 = Math.min(n17, n18);
                n3 = Math.min(n5, n19);
                this.mouseX3 = this.mouseX2 >= this.mouseX1 ? this.mouseX1 + n4 : this.mouseX1 - n4;
                this.mouseY3 = this.mouseY2 >= this.mouseY1 ? this.mouseY1 + n3 : this.mouseY1 - n3;
                this.validMouseRectangle = Math.abs(this.mouseX1 - this.mouseX3) > 6 && Math.abs(this.mouseY1 - this.mouseY3) > 6;
                graphics.setColor(this.validMouseRectangle ? Color.white : Color.gray);
                graphics.drawLine(this.mouseX1, this.mouseY1, this.mouseX1, this.mouseY3);
                graphics.drawLine(this.mouseX1, this.mouseY3, this.mouseX3, this.mouseY3);
                graphics.drawLine(this.mouseX3, this.mouseY3, this.mouseX3, this.mouseY1);
                graphics.drawLine(this.mouseX3, this.mouseY1, this.mouseX1, this.mouseY1);
                if (this.validMouseRectangle) {
                    double d12 = this.xcen + d4 * ((double)this.mouseX1 - d2);
                    double d13 = this.xcen + d4 * ((double)this.mouseX3 - d2);
                    double d14 = this.ycen - d4 * ((double)this.mouseY1 - d3);
                    d = this.ycen - d4 * ((double)this.mouseY3 - d3);
                    this.newXcen = (d12 + d13) / 2.0;
                    this.newYcen = (d14 + d) / 2.0;
                    this.newYheight = Math.abs(d - d14);
                    if (this.nf == null) {
                        this.nf = NumberFormat.getInstance();
                    }
                    this.nf.setMaximumIntegerDigits(1);
                    this.nf.setMaximumFractionDigits(5);
                    String string = "(" + this.nf.format(d12) + ", " + this.nf.format(d14) + ")";
                    String string2 = "(" + this.nf.format(d13) + ", " + this.nf.format(d) + ")";
                    if (this.fm == null) {
                        this.fm = graphics.getFontMetrics();
                    }
                    int n20 = this.fm.getHeight();
                    int n21 = this.fm.getAscent();
                    int n22 = this.fm.getDescent();
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    n = 0;
                    int n26 = this.fm.stringWidth(string);
                    int n27 = this.fm.stringWidth(string2);
                    if (this.mouseX1 < this.mouseX3) {
                        n23 = this.mouseX1 - n26 - 5;
                        n24 = this.mouseX3 + 5;
                    } else {
                        n23 = this.mouseX1 + 5;
                        n24 = this.mouseX3 - n27 - 5;
                    }
                    if (this.mouseY1 < this.mouseY3) {
                        n25 = this.mouseY1 - n22;
                        n = this.mouseY3 + n21;
                    } else {
                        n25 = this.mouseY1 + n21;
                        n = this.mouseY3 - n22;
                    }
                    if (n23 < 2) {
                        n23 = 2;
                    }
                    if (n24 < 2) {
                        n24 = 2;
                    }
                    if (n23 + n26 + 2 > n7) {
                        n23 = n7 - 2 - n26;
                    }
                    if (n24 + n27 + 2 > n7) {
                        n24 = n7 - 2 - n27;
                    }
                    if (n25 - n21 < 2) {
                        n25 = n21 + 2;
                    }
                    if (n - n21 < 2) {
                        n = n21 + 2;
                    }
                    if (n25 - n21 + n20 + 2 > n8) {
                        n25 = n8 - 2 - n20 + n21;
                    }
                    if (n - n21 + n20 + 2 > n8) {
                        n = n8 - 2 - n20 + n21;
                    }
                    graphics.setColor(Color.gray);
                    graphics.fillRect(n23 - 2, n25 - n21 - 2, n26 + 4, n20 + 4);
                    graphics.fillRect(n24 - 2, n - n21 - 2, n27 + 4, n20 + 4);
                    graphics.setColor(Color.black);
                    graphics.drawString(string, n23, n25);
                    graphics.drawString(string2, n24, n);
                }
            }
        }

        float rootsForPixel(double d, double d2, double d3, float[] fArray) {
            for (int i = 0; i < 9; ++i) {
                fArray[i] = 0.0f;
            }
            this.hscale = d3 / 2.0;
            if (Math.abs(d2) < this.hscale) {
                return this.realRootsForPixel(d, this.hscale, fArray);
            }
            this.r = d3 / Math.sqrt(2.0);
            this.rsq = this.r * this.r;
            double d4 = d * d + d2 * d2;
            double d5 = Math.sqrt(d4);
            this.cPowerR[0] = 1.0;
            this.cPowerI[0] = 0.0;
            this.cPowerR[1] = d;
            this.cPowerI[1] = d2;
            this.ncp = 1;
            double d6 = d5 + this.r;
            double d7 = 1.0 - d6;
            double d8 = d6;
            this.r1[this.N] = 0.0;
            for (int i = this.N - 1; i > 0; --i) {
                this.r1[i] = (1.0 - d8) / d7;
                d8 *= d6;
            }
            d8 = d6;
            double d9 = d5;
            double d10 = this.r;
            double d11 = 0.5 * this.rsq / d5;
            double d12 = 1.0;
            double d13 = 0.0;
            for (int i = 1; i <= this.N; ++i) {
                this.r1[i] = (d8 *= d6) * this.r1[i] + (d13 += d8 - (d9 *= d5) - (d12 += 1.0) * ((d10 *= d5) + (d12 - 1.0) * (d11 *= d5)));
            }
            this.analysePixel(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, 1, fArray, d, d2);
            return fArray[6];
        }

        void analysePixel(double d, double d2, double d3, double d4, double d5, double d6, long l, int n, float[] fArray, double d7, double d8) {
            int n2;
            if (n > this.ncp) {
                for (n2 = this.ncp + 1; n2 <= n; ++n2) {
                    this.cPowerR[n2] = d7 * this.cPowerR[n2 - 1] - d8 * this.cPowerI[n2 - 1];
                    this.cPowerI[n2] = d7 * this.cPowerI[n2 - 1] + d8 * this.cPowerR[n2 - 1];
                }
                this.ncp = n;
            }
            n2 = n == this.N ? 1 : 0;
            double d9 = n;
            double d10 = this.cPowerR[n];
            double d11 = this.cPowerI[n];
            double d12 = this.cPowerR[n - 1];
            double d13 = this.cPowerI[n - 1];
            double d14 = 0.0;
            double d15 = 0.0;
            if (n - 2 >= 0) {
                d14 = this.cPowerR[n - 2];
                d15 = this.cPowerI[n - 2];
            }
            double d16 = d9 * d12;
            double d17 = d9 * d13;
            double d18 = 0.5 * d9 * (d9 - 1.0);
            double d19 = d18 * d14;
            double d20 = d18 * d15;
            for (int i = -1; i <= 2; i += 2) {
                long l2;
                double d21 = d + (double)i * d10;
                double d22 = d2 + (double)i * d11;
                double d23 = d3 + (double)i * d16;
                double d24 = d4 + (double)i * d17;
                double d25 = d5 + (double)i * d19;
                double d26 = d6 + (double)i * d20;
                double d27 = d23 * d23 + d24 * d24;
                double d28 = this.r1[n] + this.r * Math.sqrt(d27) + this.rsq * Math.sqrt(d25 * d25 + d26 * d26);
                if (!(d21 * d21 + d22 * d22 < d28 * d28)) continue;
                long l3 = l2 = i > 0 ? l : l | 1L << 63 - n;
                if (n2 != 0) {
                    double d29 = d23 / d27;
                    double d30 = -d24 / d27;
                    double d31 = d29 * d21 - d30 * d22;
                    double d32 = d29 * d22 + d30 * d21;
                    double d33 = d29 * d25 - d30 * d26;
                    double d34 = d29 * d26 + d30 * d25;
                    double d35 = 1.0 - (d31 * d33 - d32 * d34);
                    double d36 = -(d31 * d34 + d32 * d33);
                    double d37 = d35 * d35 + d36 * d36;
                    double d38 = d35 / d37;
                    double d39 = -d36 / d37;
                    double d40 = d31 * d38 - d32 * d39;
                    double d41 = d31 * d39 + d32 * d38;
                    if (!(Math.abs(d40) < this.hscale) || !(Math.abs(d41) < this.hscale)) continue;
                    if (this.invert) {
                        l2 = this.reverse(l2);
                    }
                    int n3 = Color.HSBtoRGB((float)l2 / 1.014571E19f, 1.0f, 1.0f);
                    fArray[0] = fArray[0] + (float)(n3 >> 16 & 0xFF) / 255.0f;
                    fArray[1] = fArray[1] + (float)(n3 >> 8 & 0xFF) / 255.0f;
                    fArray[2] = fArray[2] + (float)(n3 & 0xFF) / 255.0f;
                    fArray[7] = fArray[7] + (float)Math.sqrt(d27);
                    if (this.flipX) {
                        int n4 = Color.HSBtoRGB((float)(l2 ^ 0x5555555555555555L) / 1.014571E19f, 1.0f, 1.0f);
                        fArray[3] = fArray[3] + (float)(n4 >> 16 & 0xFF) / 255.0f;
                        fArray[4] = fArray[4] + (float)(n4 >> 8 & 0xFF) / 255.0f;
                        fArray[5] = fArray[5] + (float)(n4 & 0xFF) / 255.0f;
                        fArray[8] = fArray[8] + (float)Math.sqrt(d27);
                    }
                    fArray[6] = fArray[6] + 1.0f;
                    continue;
                }
                this.analysePixel(d21, d22, d23, d24, d25, d26, l2, n + 1, fArray, d7, d8);
            }
        }

        float realRootsForPixel(double d, double d2, float[] fArray) {
            double d3 = d - d2;
            double d4 = d + d2;
            this.cPowerR[0] = 1.0;
            this.cPowerI[0] = 1.0;
            this.cPowerR[1] = d3;
            this.cPowerI[1] = d4;
            for (int i = 2; i <= this.N; ++i) {
                this.cPowerR[i] = d3 * this.cPowerR[i - 1];
                this.cPowerI[i] = d4 * this.cPowerI[i - 1];
            }
            double d5 = Math.abs(d3);
            double d6 = Math.abs(d4);
            double d7 = Math.abs(this.cPowerR[this.N]);
            double d8 = Math.abs(this.cPowerI[this.N]);
            double d9 = d5;
            double d10 = d6;
            for (int i = 1; i < this.N; ++i) {
                this.ga[i][0] = d5 / (1.0 - d5) * (d9 - d7);
                this.ga[i][1] = d6 / (1.0 - d6) * (d10 - d8);
                d9 *= d5;
                d10 *= d6;
            }
            this.analysePixelReal(1.0, 1.0, 0L, 1, fArray, d);
            return fArray[6];
        }

        void analysePixelReal(double d, double d2, long l, int n, float[] fArray, double d3) {
            boolean bl = n == this.N;
            double[] dArray = this.ga[n];
            for (int i = -1; i <= 1; i += 2) {
                double d4;
                int n2 = 0;
                int n3 = 0;
                double d5 = d + (double)i * this.cPowerR[n];
                if (d5 > 0.0 && d5 - dArray[0] > 0.0) {
                    ++n2;
                }
                if (d5 < 0.0 && d5 + dArray[0] < 0.0) {
                    ++n3;
                }
                if ((d4 = d2 + (double)i * this.cPowerI[n]) > 0.0 && d4 - dArray[1] > 0.0) {
                    ++n2;
                }
                if (d4 < 0.0 && d4 + dArray[1] < 0.0) {
                    ++n3;
                }
                if (n2 == 1 && n3 == 1) {
                    long l2;
                    float f = 1 << this.N - n;
                    long l3 = l2 = i > 0 ? l : l | 1L << 63 - n;
                    if (this.invert && n < this.N) {
                        for (long j = 0L; j < 1L << this.N - n; ++j) {
                            long l4 = this.reverse(l2 | j << 63 - this.N);
                            int n4 = Color.HSBtoRGB((float)l4 / 1.014571E19f, 1.0f, 1.0f);
                            fArray[0] = fArray[0] + (float)(n4 >> 16 & 0xFF) / 255.0f;
                            fArray[1] = fArray[1] + (float)(n4 >> 8 & 0xFF) / 255.0f;
                            fArray[2] = fArray[2] + (float)(n4 & 0xFF) / 255.0f;
                            if (!this.flipX) continue;
                            int n5 = Color.HSBtoRGB((float)(l4 ^ 0x5555555555555555L) / 1.014571E19f, 1.0f, 1.0f);
                            fArray[3] = fArray[3] + (float)(n5 >> 16 & 0xFF) / 255.0f;
                            fArray[4] = fArray[4] + (float)(n5 >> 8 & 0xFF) / 255.0f;
                            fArray[5] = fArray[5] + (float)(n5 & 0xFF) / 255.0f;
                        }
                    } else {
                        if (this.invert) {
                            l2 = this.reverse(l2);
                        }
                        int n6 = Color.HSBtoRGB((float)l2 / 1.014571E19f, 1.0f, 1.0f);
                        fArray[0] = fArray[0] + f * (float)(n6 >> 16 & 0xFF) / 255.0f;
                        fArray[1] = fArray[1] + f * (float)(n6 >> 8 & 0xFF) / 255.0f;
                        fArray[2] = fArray[2] + f * (float)(n6 & 0xFF) / 255.0f;
                        if (this.flipX) {
                            int n7 = Color.HSBtoRGB((float)(l2 ^ 0x5555555555555555L) / 1.014571E19f, 1.0f, 1.0f);
                            fArray[3] = fArray[3] + f * (float)(n7 >> 16 & 0xFF) / 255.0f;
                            fArray[4] = fArray[4] + f * (float)(n7 >> 8 & 0xFF) / 255.0f;
                            fArray[5] = fArray[5] + f * (float)(n7 & 0xFF) / 255.0f;
                        }
                    }
                    fArray[6] = fArray[6] + f;
                    continue;
                }
                if (n2 == 2 || n3 == 2 || bl) continue;
                this.analysePixelReal(d5, d4, i > 0 ? l : l | 1L << 63 - n, n + 1, fArray, d3);
            }
        }

        private long reverse(long l) {
            long l2 = 0L;
            long l3 = Long.MIN_VALUE;
            long l4 = 1L << 63 - this.N;
            if ((l & l4) != 0L) {
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            for (int i = 0; i <= this.N; ++i) {
                if ((l & l3) != 0L) {
                    l2 |= l4;
                }
                l3 >>>= 1;
                l4 <<= 1;
            }
            return l2;
        }

        @Override
        public synchronized void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public synchronized void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public synchronized void mousePressed(MouseEvent mouseEvent) {
            if (this.needPaint) {
                return;
            }
            if (this.dragonStatus() && !this.swapView) {
                this.setDragonStatus(false);
                this.swapView = true;
                this.repaint();
                return;
            }
            if (mouseEvent.isShiftDown() && !this.swapView) {
                this.mouseX1 = mouseEvent.getX();
                this.mouseY1 = mouseEvent.getY();
                this.setDragonStatus(true);
                this.swapView = true;
                this.repaint();
                return;
            }
            this.makeMouseMotionListener();
            this.mouseX1 = this.mouseX2 = mouseEvent.getX();
            this.mouseY1 = this.mouseY2 = mouseEvent.getY();
        }

        @Override
        public synchronized void mouseReleased(MouseEvent mouseEvent) {
            if (this.needPaint) {
                return;
            }
            if (this.amMouseMotionListener) {
                this.cancelMouseMotionListener();
                this.mouseX2 = mouseEvent.getX();
                this.mouseY2 = mouseEvent.getY();
                if (this.validMouseRectangle) {
                    this.changeView = true;
                }
                this.repaint();
            }
        }

        @Override
        public synchronized void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public synchronized void mouseDragged(MouseEvent mouseEvent) {
            if (this.needPaint) {
                return;
            }
            this.mouseX2 = mouseEvent.getX();
            this.mouseY2 = mouseEvent.getY();
            this.repaint();
        }

        @Override
        public synchronized void mouseMoved(MouseEvent mouseEvent) {
        }

        synchronized void makeMouseMotionListener() {
            if (!this.amMouseMotionListener) {
                this.addMouseMotionListener(this);
                this.amMouseMotionListener = true;
            }
        }

        synchronized void cancelMouseMotionListener() {
            if (this.amMouseMotionListener) {
                this.removeMouseMotionListener(this);
                this.amMouseMotionListener = false;
            }
        }

        synchronized void setView(double d, double d2, double d3) {
            this.xcen = d;
            this.ycen = d2;
            this.yheight = d3;
        }

        public synchronized void defaultView() {
            this.newXcen = 0.0;
            this.newYcen = 0.0;
            this.newYheight = 1.8;
            this.changeView = true;
            this.setDragonStatus(false);
            this.repaint();
        }

        public synchronized void zoomIn() {
            if (this.dragonStatus()) {
                this.dragonHeight /= 2.0;
                this.needDragonPaint = true;
                this.needDragonCount = 10;
                this.repaint();
                this.parent.repaint();
            } else {
                this.newXcen = this.xcen;
                this.newYcen = this.ycen;
                this.newYheight = this.yheight / 2.0;
                this.changeView = true;
                this.repaint();
            }
        }

        public synchronized void zoomOut() {
            if (this.dragonStatus()) {
                this.dragonHeight *= 2.0;
                this.needDragonPaint = true;
                this.needDragonCount = 10;
                this.repaint();
                this.parent.repaint();
            } else {
                this.newXcen = this.xcen;
                this.newYcen = this.ycen;
                this.newYheight = this.yheight * 2.0;
                this.changeView = true;
                this.repaint();
            }
        }

        public synchronized void setOrder(int n) {
            if (n != this.N && !this.dragonStatus()) {
                this.specifyOrder(n);
                this.init();
                this.newXcen = this.xcen;
                this.newYcen = this.ycen;
                this.newYheight = this.yheight;
                this.changeView = true;
                this.repaint();
            }
        }

        synchronized void specifySize(int n, int n2) {
            if (n % 2 == 0) {
                --n;
            }
            if (n2 % 2 == 0) {
                --n2;
            }
            this.size = new Dimension(n, n2);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.size;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.size;
        }

        public synchronized double getXcen() {
            return this.xcen;
        }

        public synchronized double getYcen() {
            return this.ycen;
        }

        public synchronized double getYheight() {
            return this.yheight;
        }

        public synchronized double getXJcen() {
            return this.xjcen;
        }

        public synchronized double getYJcen() {
            return this.yjcen;
        }

        public synchronized double getYJheight() {
            return this.dragonHeight;
        }

        public synchronized void specifyOrder(int n) {
            this.N = n;
        }

        public synchronized boolean dragonStatus() {
            return this.isDragon;
        }

        public synchronized void setDragonStatus(boolean bl) {
            this.isDragon = bl;
        }

        void doDragon(double d, double d2, float[][][] fArray, int n, int n2, double d3) {
            int n3;
            double d4 = d * d + d2 * d2;
            double d5 = Math.sqrt(d4);
            this.cPowerR[0] = 1.0;
            this.cPowerI[0] = 0.0;
            this.cPowerR[1] = d;
            this.cPowerI[1] = d2;
            this.ncp = 1;
            double d6 = 1.0 - d5;
            double d7 = d5;
            this.r1[this.N] = 0.0;
            for (n3 = this.N - 1; n3 > 0; --n3) {
                this.r1[n3] = (1.0 - d7) / d6;
                d7 *= d5;
            }
            d7 = d5;
            for (n3 = 1; n3 <= this.N; ++n3) {
                this.r1[n3] = (d7 *= d5) * this.r1[n3];
            }
            this.doDragon2(1.0, 0.0, 0L, 1, fArray, n, n2, d, d2, d3);
        }

        void doDragon2(double d, double d2, long l, int n, float[][][] fArray, int n2, int n3, double d3, double d4, double d5) {
            int n4;
            if (n > this.ncp) {
                for (n4 = this.ncp + 1; n4 <= n; ++n4) {
                    this.cPowerR[n4] = d3 * this.cPowerR[n4 - 1] - d4 * this.cPowerI[n4 - 1];
                    this.cPowerI[n4] = d3 * this.cPowerI[n4 - 1] + d4 * this.cPowerR[n4 - 1];
                }
                this.ncp = n;
            }
            n4 = n == this.N ? 1 : 0;
            double d6 = this.cPowerR[n];
            double d7 = this.cPowerI[n];
            for (int i = -1; i <= 2; i += 2) {
                long l2;
                double d8 = d + (double)i * d6;
                double d9 = d2 + (double)i * d7;
                if (!(Math.sqrt(d8 * d8 + d9 * d9) - this.r1[n] < d5)) continue;
                long l3 = l2 = i > 0 ? l : l | 1L << 63 - n;
                if (n4 != 0) {
                    double d10 = this.dragonHeight / ((double)n3 - 1.0);
                    for (int j = 1; j <= 1; j += 2) {
                        int n5;
                        int n6 = (int)Math.round(((double)n3 - 1.0) / 2.0 - (double)j * d9 / d10);
                        if (n6 < 0 || n6 >= n3 || (n5 = (int)Math.round(((double)n2 - 1.0) / 2.0 + (double)j * d8 / d10)) < 0 || n5 >= n2) continue;
                        int n7 = Color.HSBtoRGB((float)l2 / 1.014571E19f, 1.0f, 1.0f);
                        float[] fArray2 = fArray[n5][n6];
                        fArray2[0] = fArray2[0] + (float)(n7 >> 16 & 0xFF) / 255.0f;
                        fArray2[1] = fArray2[1] + (float)(n7 >> 8 & 0xFF) / 255.0f;
                        fArray2[2] = fArray2[2] + (float)(n7 & 0xFF) / 255.0f;
                        fArray2[3] = fArray2[3] + 1.0f;
                    }
                    continue;
                }
                this.doDragon2(d8, d9, l2, n + 1, fArray, n2, n3, d3, d4, d5);
            }
        }
    }
}

