/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.NewtonianHoop;

import egan.graphics.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

class HoopState {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    int p;
    double r0;
    double re;
    double omega;
    double es;
    double K;
    double[] x;
    double[] y;
    double[] vx;
    double[] vy;
    double TK;
    double spionp;
    double rs;
    double[] sx;
    double[] sy;
    double[] cs;
    double[] rd;
    boolean sValid;
    double[] ax;
    double[] ay;
    double[] bx;
    double[] by;
    double[] cx;
    double[] cy;
    double[] dx;
    double[] dy;
    boolean aValid;
    double[] VX12;
    double[] VX23;
    double[] VY12;
    double[] VY23;
    double[] VV12;
    double[] VV23;
    int npw;
    int[] pw;
    int ncw;
    int[] cw;
    double cat;
    double catTime;

    double req(double d) {
        return this.TK * this.r0 / (this.TK - d * d * this.r0 * this.r0);
    }

    double reqInitial() {
        return this.re;
    }

    void InitHoopState(int n, double d, double d2) {
        this.p = n;
        this.r0 = d;
        this.K = d2;
        this.x = new double[n];
        this.y = new double[n];
        this.vx = new double[n];
        this.vy = new double[n];
        this.TK = 2.0 * d2 * d2;
        this.spionp = Math.sin(Math.PI / (double)n);
        this.rs = 2.0 * d * this.spionp;
        this.sx = new double[n];
        this.sy = new double[n];
        this.cs = new double[n];
        this.rd = new double[n];
        this.sValid = false;
        this.ax = new double[n];
        this.ay = new double[n];
        this.bx = new double[n];
        this.by = new double[n];
        this.cx = new double[n];
        this.cy = new double[n];
        this.dx = new double[n];
        this.dy = new double[n];
        this.VX12 = new double[n];
        this.VX23 = new double[n];
        this.VY12 = new double[n];
        this.VY23 = new double[n];
        this.VV12 = new double[n];
        this.VV23 = new double[n];
        this.aValid = false;
        this.npw = 0;
        this.pw = new int[n];
        this.ncw = 0;
        this.cw = new int[n];
        this.cat = 0.0;
        this.catTime = 0.0;
    }

    HoopState(int n, double d, double d2, double d3) {
        this.InitHoopState(n, d, d2);
        double d4 = this.re = this.req(d3);
        this.omega = d3;
        this.es = 2.0 * d4 * this.spionp;
        double d5 = d3 * d4;
        for (int i = 0; i < n; ++i) {
            double d6 = Math.PI * 2 * (double)i / (double)n;
            double d7 = Math.sin(d6);
            double d8 = Math.cos(d6);
            this.x[i] = d4 * d8;
            this.y[i] = d4 * d7;
            this.vx[i] = -d5 * d7;
            this.vy[i] = d5 * d8;
        }
    }

    void getSep() {
        if (!this.sValid) {
            double d = 1.0 / this.rs;
            for (int i = 0; i < this.p; ++i) {
                int n = (i + 1) % this.p;
                double d2 = this.sx[i] = this.x[n] - this.x[i];
                double d3 = this.sy[i] = this.y[n] - this.y[i];
                this.cs[i] = Math.sqrt(d2 * d2 + d3 * d3);
                this.rd[i] = d - 1.0 / this.cs[i];
            }
            this.sValid = true;
        }
    }

    double KE() {
        double d = 0.0;
        for (int i = 0; i < this.p; ++i) {
            d += this.vx[i] * this.vx[i] + this.vy[i] * this.vy[i];
        }
        return d / (2.0 * (double)this.p);
    }

    double PE() {
        this.getSep();
        double d = 0.0;
        for (int i = 0; i < this.p; ++i) {
            double d2 = this.cs[i] / this.rs - 1.0;
            d += d2 * d2;
        }
        return this.K * this.K * d / (double)this.p;
    }

    double energy() {
        return this.KE() + this.PE();
    }

    double AM() {
        double d = 0.0;
        for (int i = 0; i < this.p; ++i) {
            d += this.x[i] * this.vy[i] - this.y[i] * this.vx[i];
        }
        return d / (double)this.p;
    }

    void computeAcc() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        double d21;
        double d22;
        double d23;
        double d24;
        double d25;
        double d26;
        int n;
        int n2;
        int n3;
        this.getSep();
        if (this.aValid) {
            return;
        }
        double d27 = this.K * this.K / (this.r0 * this.spionp);
        for (n3 = 0; n3 < this.p; ++n3) {
            n2 = (n3 + this.p - 1) % this.p;
            this.ax[n3] = d27 * (this.rd[n3] * this.sx[n3] - this.rd[n2] * this.sx[n2]);
            this.ay[n3] = d27 * (this.rd[n3] * this.sy[n3] - this.rd[n2] * this.sy[n2]);
        }
        for (n3 = 0; n3 < this.p; ++n3) {
            n2 = (n3 + this.p - 1) % this.p;
            n = (n3 + 1) % this.p;
            d26 = this.sx[n2];
            d25 = this.sy[n2];
            d24 = this.sx[n3];
            d23 = this.sy[n3];
            d22 = this.VX12[n3] = this.vx[n3] - this.vx[n2];
            d21 = this.VX23[n3] = this.vx[n] - this.vx[n3];
            d20 = this.VY12[n3] = this.vy[n3] - this.vy[n2];
            d19 = this.VY23[n3] = this.vy[n] - this.vy[n3];
            d18 = this.cs[n2];
            d17 = this.cs[n3];
            d16 = d18 * d18 * d18;
            d15 = d17 * d17 * d17;
            d14 = this.rd[n2];
            d13 = this.rd[n3];
            d12 = this.VV12[n3] = d22 * d26 + d20 * d25;
            d11 = this.VV23[n3] = d21 * d24 + d19 * d23;
            this.bx[n3] = d27 * (-(d14 * d22) + d13 * d21 - d12 * d26 / d16 + d11 * d24 / d15);
            this.by[n3] = d27 * (-(d14 * d20) + d13 * d19 - d12 * d25 / d16 + d11 * d23 / d15);
        }
        for (n3 = 0; n3 < this.p; ++n3) {
            n2 = (n3 + this.p - 1) % this.p;
            n = (n3 + 1) % this.p;
            d26 = this.sx[n2];
            d25 = this.sy[n2];
            d24 = this.sx[n3];
            d23 = this.sy[n3];
            d22 = this.VX12[n3];
            d21 = this.VX23[n3];
            d20 = this.VY12[n3];
            d19 = this.VY23[n3];
            d18 = this.cs[n2];
            d17 = this.cs[n3];
            d16 = d18 * d18 * d18;
            d15 = d17 * d17 * d17;
            d14 = d16 * d18 * d18;
            d13 = d15 * d17 * d17;
            d12 = this.rd[n2];
            d11 = this.rd[n3];
            d10 = this.VV12[n3];
            d9 = d10 * d10;
            d8 = this.VV23[n3];
            d7 = d8 * d8;
            d6 = this.ax[n3] - this.ax[n2];
            d5 = this.ay[n3] - this.ay[n2];
            d4 = this.ax[n] - this.ax[n3];
            d3 = this.ay[n] - this.ay[n3];
            d2 = d22 * d22 + d20 * d20 + d6 * d26 + d5 * d25;
            d = d21 * d21 + d19 * d19 + d4 * d24 + d3 * d23;
            this.cx[n3] = d27 * (-(d6 * d12) + d4 * d11 - 2.0 * d10 * d22 / d16 + 2.0 * d8 * d21 / d15 - d2 * d26 / d16 + 3.0 * d9 * d26 / d14 + d * d24 / d15 - 3.0 * d7 * d24 / d13);
            this.cy[n3] = d27 * (-(d5 * d12) + d3 * d11 - 2.0 * d10 * d20 / d16 + 2.0 * d8 * d19 / d15 - d2 * d25 / d16 + 3.0 * d9 * d25 / d14 + d * d23 / d15 - 3.0 * d7 * d23 / d13);
        }
        for (n3 = 0; n3 < this.p; ++n3) {
            n2 = (n3 + this.p - 1) % this.p;
            n = (n3 + 1) % this.p;
            d26 = this.sx[n2];
            d25 = this.sy[n2];
            d24 = this.sx[n3];
            d23 = this.sy[n3];
            d22 = this.VX12[n3];
            d21 = this.VX23[n3];
            d20 = this.VY12[n3];
            d19 = this.VY23[n3];
            d18 = this.cs[n2];
            d17 = this.cs[n3];
            d16 = d18 * d18;
            d15 = d17 * d17;
            d14 = d16 * d18;
            d13 = d15 * d17;
            d12 = d14 * d16;
            d11 = d13 * d15;
            d10 = d14 * d14 * d18;
            d9 = d13 * d13 * d17;
            d8 = this.rd[n2];
            d7 = this.rd[n3];
            d6 = this.VV12[n3];
            d5 = d6 * d6;
            d4 = d5 * d6;
            d3 = this.VV23[n3];
            d2 = d3 * d3;
            d = d2 * d3;
            double d28 = this.ax[n3] - this.ax[n2];
            double d29 = this.ay[n3] - this.ay[n2];
            double d30 = this.ax[n] - this.ax[n3];
            double d31 = this.ay[n] - this.ay[n3];
            double d32 = d22 * d22 + d20 * d20 + d28 * d26 + d29 * d25;
            double d33 = d21 * d21 + d19 * d19 + d30 * d24 + d31 * d23;
            double d34 = this.bx[n3] - this.bx[n2];
            double d35 = this.by[n3] - this.by[n2];
            double d36 = this.bx[n] - this.bx[n3];
            double d37 = this.by[n] - this.by[n3];
            this.dx[n3] = d27 * (-(d34 * d8) + d36 * d7 - 3.0 * d28 * d6 / d14 + 3.0 * d30 * d3 / d13 - 3.0 * d32 * d22 / d14 + 9.0 * d5 * d22 / d12 + 3.0 * d33 * d21 / d13 - 9.0 * d2 * d21 / d11 + 9.0 * d32 * d6 * d26 / d12 - 15.0 * d4 * d26 / d10 - d26 * (3.0 * d29 * d20 + 3.0 * d28 * d22 + d35 * d25 + d34 * d26) / d14 - 9.0 * d33 * d3 * d24 / d11 + 15.0 * d * d24 / d9 + d24 * (3.0 * d31 * d19 + 3.0 * d30 * d21 + d37 * d23 + d36 * d24) / d13);
            this.dy[n3] = d27 * (-(d35 * d8) + d37 * d7 - 3.0 * d29 * d6 / d14 + 3.0 * d31 * d3 / d13 - 3.0 * d32 * d20 / d14 + 9.0 * d5 * d20 / d12 + 3.0 * d33 * d19 / d13 - 9.0 * d2 * d19 / d11 + 9.0 * d32 * d6 * d25 / d12 - 15.0 * d4 * d25 / d10 - d25 * (3.0 * d28 * d22 + 3.0 * d29 * d20 + d34 * d26 + d35 * d25) / d14 - 9.0 * d33 * d3 * d23 / d11 + 15.0 * d * d23 / d9 + d23 * (3.0 * d30 * d21 + 3.0 * d31 * d19 + d36 * d24 + d37 * d23) / d13);
        }
        this.aValid = true;
    }

    void advance(double d) {
        this.getSep();
        this.computeAcc();
        for (int i = 0; i < this.p; ++i) {
            int n = i;
            this.x[n] = this.x[n] + d * (this.vx[i] + d * (this.ax[i] / 2.0 + d * (this.bx[i] / 6.0 + d * (this.cx[i] / 24.0 + d * this.dx[i] / 120.0))));
            int n2 = i;
            this.y[n2] = this.y[n2] + d * (this.vy[i] + d * (this.ay[i] / 2.0 + d * (this.by[i] / 6.0 + d * (this.cy[i] / 24.0 + d * this.dy[i] / 120.0))));
            int n3 = i;
            this.vx[n3] = this.vx[n3] + d * (this.ax[i] + d * (this.bx[i] / 2.0 + d * (this.cx[i] / 6.0 + d * this.dx[i] / 24.0)));
            int n4 = i;
            this.vy[n4] = this.vy[n4] + d * (this.ay[i] + d * (this.by[i] / 2.0 + d * (this.cy[i] / 6.0 + d * this.dy[i] / 24.0)));
        }
        this.sValid = false;
        this.aValid = false;
        int[] nArray = this.pw;
        this.pw = this.cw;
        this.npw = this.ncw;
        this.cw = nArray;
        this.ncw = this.identifyCrossings(this.cw);
        this.updateCrossingMovement(d);
    }

    int identifyCrossings(int[] nArray) {
        int n = 0;
        double d = this.re * this.re;
        double d2 = 0.0;
        for (int i = 0; i <= this.p; ++i) {
            int n2 = i % this.p;
            double d3 = this.x[n2] * this.x[n2] + this.y[n2] * this.y[n2] - d;
            if (i > 0 && d3 * d2 < 0.0) {
                nArray[n++] = n2;
            }
            d2 = d3;
        }
        return n;
    }

    void updateCrossingMovement(double d) {
        if (this.ncw != 0 && this.ncw == this.npw) {
            for (int i = 0; i < this.npw; ++i) {
                int n = this.pw[i];
                int n2 = 2 * this.p;
                int n3 = 0;
                for (int j = 0; j < this.ncw; ++j) {
                    int n4 = this.cw[j];
                    int n5 = (this.p + n4 - n) % this.p;
                    int n6 = (this.p + n - n4) % this.p;
                    if (n5 < n2) {
                        n2 = n5;
                        n3 = 1;
                    }
                    if (n6 >= n2) continue;
                    n2 = n6;
                    n3 = -1;
                }
                this.cat += (double)(n3 * n2);
                this.catTime += d;
            }
        }
    }

    double averageWaveSpeed() {
        if (this.catTime == 0.0) {
            return 0.0;
        }
        return this.cat * 2.0 * Math.PI / (double)this.p / this.catTime / this.omega;
    }

    void pulsation(double d) {
        int n = 0;
        while (n < this.p) {
            int n2 = n;
            this.x[n2] = this.x[n2] * d;
            int n3 = n;
            this.y[n3] = this.y[n3] * d;
            int n4 = n;
            this.vx[n4] = this.vx[n4] / d;
            int n5 = n++;
            this.vy[n5] = this.vy[n5] / d;
        }
        this.sValid = false;
        this.aValid = false;
    }

    void statWave(int n, double d) {
        double d2 = this.re * d;
        for (int i = 0; i < this.p; ++i) {
            double d3 = Math.PI * 2 * (double)i / (double)this.p;
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            double d6 = Math.cos((double)n * d3);
            double d7 = Math.sin((double)n * d3);
            double d8 = this.re + d2 * d6;
            double d9 = -(d2 / (double)n) * d7;
            this.x[i] = d8 * d4 - d9 * d5;
            this.y[i] = d8 * d5 + d9 * d4;
            double d10 = -this.omega * (d9 + d2 * (double)n * d7);
            double d11 = this.omega * this.re;
            this.vx[i] = d10 * d4 - d11 * d5;
            this.vy[i] = d10 * d5 + d11 * d4;
        }
        this.sValid = false;
        this.aValid = false;
        this.ncw = this.identifyCrossings(this.cw);
    }

    void generalWave(int n, double d, double d2, double d3) {
        this.generalWave(n, d, d2, d3, d2 * d3);
    }

    void generalWave(int n, double d, double d2, double d3, double d4) {
        double d5 = this.re * d;
        for (int i = 0; i < this.p; ++i) {
            double d6 = Math.PI * 2 * (double)i / (double)this.p;
            double d7 = Math.cos(d6);
            double d8 = Math.sin(d6);
            double d9 = Math.cos((double)n * d6);
            double d10 = Math.sin((double)n * d6);
            double d11 = this.re + d5 * d9;
            double d12 = d5 * d2 * d10;
            this.x[i] = d11 * d7 - d12 * d8;
            this.y[i] = d11 * d8 + d12 * d7;
            double d13 = -this.omega * d5 * d10 * (d2 - d3 * (double)n);
            double d14 = this.omega * (this.re + d5 * d9 * (1.0 - (double)n * d4));
            this.vx[i] = d13 * d7 - d14 * d8;
            this.vy[i] = d13 * d8 + d14 * d7;
        }
        this.sValid = false;
        this.aValid = false;
        this.ncw = this.identifyCrossings(this.cw);
    }

    double tensionChange() {
        double d = 0.0;
        double d2 = this.es / this.rs - 1.0;
        this.getSep();
        for (int i = 0; i < this.p; ++i) {
            double d3 = this.cs[i] / this.rs - 1.0;
            double d4 = Math.abs((d3 - d2) / d2);
            if (!(d4 > d)) continue;
            d = d4;
        }
        return d;
    }

    void draw(Graphics graphics, int n, int n2, double d, Color[] colorArray, double d2) {
        int n3;
        this.getSep();
        double d3 = (double)(n / 2) / d;
        int n4 = n / 2;
        int n5 = 3 * n2 / 7;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(aaON);
        graphics.setColor(colorArray[5]);
        int n6 = (int)(d3 * this.r0);
        int n7 = (int)(d3 * this.re);
        graphics.drawOval(n4 - n6, n5 - n6, 2 * n6, 2 * n6);
        graphics.drawOval(n4 - n7, n5 - n7, 2 * n7, 2 * n7);
        for (n3 = 0; n3 < this.ncw; ++n3) {
            double d4 = d3 * this.x[this.cw[n3]];
            double d5 = d3 * this.y[this.cw[n3]];
            graphics.drawLine(n4 + (int)(0.9 * d4), n5 - (int)(0.9 * d5), n4 + (int)(1.1 * d4), n5 - (int)(1.1 * d5));
        }
        n3 = 0;
        int n8 = 0;
        boolean bl = false;
        for (int i = 0; i < this.p; ++i) {
            int n9 = 0;
            n9 = this.cs[i] > 1.01 * this.es ? 0 : (this.cs[i] > 0.99 * this.es ? 1 : (this.cs[i] > this.rs ? 2 : (this.cs[i] > 0.5 * this.rs ? 3 : 4)));
            graphics.setColor(colorArray[n9]);
            if (i == 0) {
                n3 = n4 + (int)(d3 * this.x[i]);
                n8 = n5 - (int)(d3 * this.y[i]);
            }
            int n10 = (i + 1) % this.p;
            int n11 = n4 + (int)(d3 * this.x[n10]);
            int n12 = n5 - (int)(d3 * this.y[n10]);
            graphics.drawLine(n3, n8, n11, n12);
            if (i % 10 == 0) {
                GraphicsUtils.fillSmallCircle((Graphics)graphics, (int)(n3 - 2), (int)(n8 - 2), (int)5);
            }
            n3 = n11;
            n8 = n12;
        }
    }
}

