/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.NewtonianHoop;

import egan.applets.NewtonianHoop.HoopState;
import egan.graphics.GraphicsUtils;
import egan.maths.Polynomial;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;

public class NewtonianHoop
extends Applet
implements Runnable,
ItemListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    String omegaStr = "\u03c9";
    Image I;
    Graphics G;
    long F = 0L;
    long tStep = 40L;
    long pt;
    private volatile Thread a;
    HoopState hoop;
    double e0;
    double am0;
    double t;
    double K;
    double omega;
    double tinc;
    int p;
    final double r0 = 1.0;
    Font fnt;
    FontMetrics fm;
    int fa;
    int fd;
    int fh;
    Color[] palette = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.blue, new Color(0x999999)};
    Choice vertexChoice;
    Choice kChoice;
    Choice omegaChoice;
    Choice perturbChoice;
    final double kInc = 0.1;
    final double omegaInc = 0.02;
    final int vertexInc = 20;
    final int maxM = 5;
    Button restart;

    @Override
    public void init() {
        int n;
        this.setLayout(new FlowLayout(0));
        this.restart = new Button("RESTART");
        this.add(this.restart);
        this.restart.addActionListener(this);
        this.vertexChoice = new Choice();
        for (int i = 1; i <= 20; ++i) {
            this.vertexChoice.addItem("" + i * 20 + " vertices");
        }
        this.vertexChoice.select(9);
        this.add(this.vertexChoice);
        this.vertexChoice.addItemListener(this);
        this.vertexChoice.setBackground(Color.white);
        double d = 0.0;
        this.kChoice = new Choice();
        for (n = 1; n <= 7; ++n) {
            d = (double)n * 0.1;
            this.kChoice.addItem("K=" + this.SigDig(d, 1));
        }
        this.add(this.kChoice);
        this.kChoice.addItemListener(this);
        this.kChoice.setBackground(Color.white);
        this.omegaChoice = new Choice();
        n = 1;
        while ((double)n * 1.0 * 0.02 < 1.414 * d) {
            this.omegaChoice.addItem(this.omegaStr + "=" + this.SigDig((double)n * 0.02, 3));
            ++n;
        }
        this.maximiseOmega();
        this.add(this.omegaChoice);
        this.omegaChoice.addItemListener(this);
        this.omegaChoice.setBackground(Color.white);
        this.perturbChoice = new Choice();
        this.perturbChoice.addItem("Pulsations");
        for (n = 1; n <= 5; ++n) {
            this.perturbChoice.addItem("Wave, m=" + n + ", c=-1");
        }
        for (n = 1; n <= 3; ++n) {
            for (int i = 1; i <= 5; ++i) {
                this.perturbChoice.addItem("Wave, m=" + i + ", cubic solution " + n);
            }
        }
        this.perturbChoice.select(20);
        this.add(this.perturbChoice);
        this.perturbChoice.addItemListener(this);
        this.perturbChoice.setBackground(Color.white);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setBackground(Color.black);
        Thread thread = Thread.currentThread();
        while (this.a == thread) {
            long l = System.currentTimeMillis();
            NewtonianHoop newtonianHoop = this;
            synchronized (newtonianHoop) {
                if (l - this.pt > this.tStep || l < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public synchronized void update(Graphics graphics) {
        long l = System.currentTimeMillis();
        if (l - this.pt > this.tStep || l < this.pt) {
            this.pt = l;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            if (this.I == null) {
                this.I = this.createImage(n, n2);
                this.G = this.I.getGraphics();
            }
            this.d(this.G, n, n2, this.F);
            graphics.drawImage(this.I, 0, 0, null);
            ++this.F;
            if (this.F % 50L == 1L) {
                System.gc();
            }
            this.restart.repaint();
            this.kChoice.repaint();
            this.omegaChoice.repaint();
            this.perturbChoice.repaint();
        }
    }

    public void d(Graphics graphics, int n, int n2, long l) {
        int n3;
        int n4;
        Object object;
        if (l == 0L) {
            object = GraphicsUtils.getNiceFont((Component)this);
            this.fnt = new Font((String)object, 0, 14);
            this.fm = this.getFontMetrics(this.fnt);
            this.fa = this.fm.getAscent();
            this.fd = this.fm.getDescent();
            this.fh = this.fm.getHeight();
            this.p = (this.vertexChoice.getSelectedIndex() + 1) * 20;
            this.K = (double)(this.kChoice.getSelectedIndex() + 1) * 0.1;
            while (true) {
                this.omega = (double)(this.omegaChoice.getSelectedIndex() + 1) * 0.02;
                if (1.0 * this.omega * this.omega < 2.0 * this.K * this.K) break;
                this.omegaChoice.select(this.omegaChoice.getSelectedIndex() - 1);
                this.omegaChoice.repaint();
            }
            this.tinc = 0.005 / this.K;
            this.hoop = new HoopState(this.p, 1.0, this.K, this.omega);
            double d = 0.025;
            int n5 = this.perturbChoice.getSelectedIndex();
            if (n5 == 0) {
                this.hoop.pulsation(Math.max(0.9, Math.sqrt(1.0 / this.hoop.reqInitial())));
            } else if (n5 >= 1 && n5 <= 5) {
                this.hoop.statWave(n5, d);
            } else {
                n4 = 1 + (n5 - 5 - 1) % 5;
                n3 = n4 * n4;
                double d2 = 2.0 * this.K * this.K / 1.0 / (this.omega * this.omega);
                double d3 = Math.sqrt(d2);
                double[] dArray = new double[]{(double)(n3 - 3) * d2 - 1.0, -((double)(n3 + 1) * d2 + 3.0), -n3, n3};
                Polynomial polynomial = new Polynomial(dArray, 3);
                double d4 = Math.min(-10.0, -2.0 * d3);
                double d5 = Math.max(10.0, 2.0 * d3);
                double[] dArray2 = new double[5];
                int n6 = polynomial.zeroes(dArray2, d4, d5, 1.0E-5);
                int n7 = 1 + (n5 - 5 - 1) / 5;
                double d6 = dArray2[n7];
                double d7 = (2.0 * d6 + 1.0 + d2) / ((double)n4 * (d6 * d6 - d2));
                double d8 = d;
                if ((double)n4 * Math.abs(d7) * d8 > 1.0) {
                    d8 = 0.9 / ((double)n4 * Math.abs(d7));
                }
                this.hoop.generalWave(n4, d8, d7, d6);
            }
            this.e0 = this.hoop.energy();
            this.am0 = this.hoop.AM();
            this.t = 0.0;
        }
        object = (Graphics2D)graphics;
        ((Graphics2D)object).setRenderingHints(aaON);
        graphics.setFont(this.fnt);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n, n2);
        this.hoop.draw(graphics, n, n2, 1.5 * this.hoop.reqInitial(), this.palette, this.t);
        int n8 = n2 - 2 * this.fd;
        int n9 = this.fh + this.fd;
        String[][] stringArrayArray = new String[][]{{"High", "Tension"}, {"Equilibrium", "Tension"}, {"Low", "Tension"}, {"Low", "Pressure"}, {"High", "Pressure"}};
        n4 = n8 - 6 * n9;
        n3 = n4 + n9;
        int n10 = n9;
        for (int i = 0; i < 5; ++i) {
            int n11 = Math.max(this.fm.stringWidth(stringArrayArray[i][0]), this.fm.stringWidth(stringArrayArray[i][1]));
            int n12 = n11 + 6;
            graphics.setColor(this.palette[i]);
            graphics.fillRect(n10, n4 - this.fa - 1, n12, this.fh + 2 + n9);
            graphics.setColor(Color.black);
            graphics.drawString(stringArrayArray[i][0], n10 + 3, n4);
            graphics.drawString(stringArrayArray[i][1], n10 + 3, n3);
            n10 += n12;
        }
        graphics.setColor(Color.white);
        graphics.drawString("Relaxed radius = " + this.SigDig(1.0, 3) + "  Equilibrium radius = " + this.SigDig(this.hoop.reqInitial(), 3), n9, n8 - 7 * n9);
        double d = this.hoop.energy();
        graphics.drawString("Energy / M = " + this.SigDig(d, 6), n9, n8 - 4 * n9);
        double d9 = this.hoop.AM();
        graphics.drawString("Angular momentum / M = " + this.SigDig(d9, 6), n9, n8 - 2 * n9);
        graphics.drawString("Elapsed time = " + this.SigDig(this.t, 2) + "  Average wave speed / " + this.omegaStr + " = " + this.SigDig(this.hoop.averageWaveSpeed(), 4), n9, n8 - n9);
        graphics.drawString("Numerical error in conserved quantities = " + this.SigDig(100.0 * Math.max(Math.abs((d - this.e0) / this.e0), Math.abs((d9 - this.am0) / this.am0)), 2) + "%", n9, n8);
        int n13 = n - 2 * n9;
        int n14 = this.fh + 2;
        int n15 = n8 - 3 * n9 - this.fa - 1;
        graphics.setColor(Color.white);
        graphics.drawRect(n9, n15, n13, n14);
        graphics.fillRect(n9, n15, (int)(this.hoop.KE() / d * (double)n13), n14);
        graphics.setColor(Color.black);
        graphics.drawString(" Kinetic energy", n9, n8 - 3 * n9);
        for (int i = 0; i < 5; ++i) {
            this.hoop.advance(this.tinc);
            this.t += this.tinc;
        }
    }

    public String SigDig(double d, int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        int n2 = d == 0.0 ? -n : (int)Math.floor(Math.log(Math.abs(d)) / Math.log(10.0)) - (n - 1);
        if (n2 < 0) {
            numberFormat.setMinimumFractionDigits(-n2);
            numberFormat.setMaximumFractionDigits(-n2);
        } else {
            numberFormat.setMinimumFractionDigits(0);
            numberFormat.setMaximumFractionDigits(0);
        }
        return numberFormat.format(d);
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.vertexChoice) {
            this.F = 0L;
        } else if (object == this.kChoice) {
            this.F = 0L;
            this.maximiseOmega();
        } else if (object == this.omegaChoice) {
            this.F = 0L;
        } else if (object == this.perturbChoice) {
            this.F = 0L;
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.restart) {
            this.F = 0L;
        }
    }

    void maximiseOmega() {
        int n = 1;
        while ((double)n * 1.0 * 0.02 < 1.414 * (double)(this.kChoice.getSelectedIndex() + 1) * 0.1) {
            this.omegaChoice.select(n - 1);
            ++n;
        }
    }
}

