/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.NullChamber;

import egan.applets.NullChamber.Particle;
import egan.applets.NullChamber.orbitSelector;
import egan.applets.NullChamber.particleGun;
import egan.applets.NullChamber.projectedView;
import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class NullChamber
extends Applet
implements Runnable,
KeyListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    long F = 0L;
    long tStep = 60L;
    long pt = 0L;
    final double chamberTimePerFrame = 1.0;
    final double GS = 8.0;
    final double SJ = 5.0;
    final double RS = 10.0;
    final int gap = 3;
    final int nStonePalette = 5;
    Color[][] stonePalette = new Color[][]{{Color.red, Color.red}, {Color.yellow.darker(), Color.yellow.darker()}, {Color.green, Color.green}, {Color.cyan, Color.cyan}, {Color.magenta, Color.magenta}};
    int currentStone;
    private volatile Thread a;
    projectedView pvRSGS;
    projectedView pvRSSJ;
    projectedView pvGSSJ;
    orbitSelector orbitSel;
    particleGun pGun;
    Checkbox showTrailsCheckbox;
    Button fireParticleButton;
    Button dropParticleButton;
    Button clearButton;
    Vector<Particle> stones;
    String statusString = "";

    @Override
    public void init() {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = Color.white;
        this.setBackground(color);
        Font font = new Font(GraphicsUtils.getNiceFont((Component)this), 0, 12);
        Color color2 = new Color(0xCCCCFF);
        Color color3 = new Color(0x6666FF);
        this.currentStone = 0;
        Color color4 = new Color(0xFF9999);
        Color color5 = new Color(0xFF6666);
        this.pGun = new particleGun();
        this.pGun.setVel(0, 0.03);
        this.pGun.setCoord(2, 3.0);
        this.stones = new Vector(10, 10);
        double d = 36.0 / (double)(n - 12);
        int n3 = (int)Math.floor(10.0 / d);
        int n4 = (int)Math.floor(8.0 / d);
        int n5 = (int)Math.floor(5.0 / d);
        this.pvRSGS = new projectedView(this, 2 * n3, 2 * n4, 10.0, -10.0, -1.0, 8.0, -8.0, -1.0, 1, 0, "rarb", "sharq", "sard", "garm", font, color3, color2, color, color, this.pGun);
        this.pvRSSJ = new projectedView(this, 2 * n3, 2 * n5, 10.0, -10.0, -1.0, 5.0, -5.0, -1.0, 1, 2, "rarb", "sharq", "shomal", "junub", font, color3, color2, color, color, this.pGun);
        this.pvGSSJ = new projectedView(this, 2 * n4, 2 * n5, -8.0, 8.0, 1.0, 5.0, -5.0, -1.0, 0, 2, "garm", "sard", "shomal", "junub", font, color3, color2, color, color, this.pGun);
        this.orbitSel = new orbitSelector(this, 2 * n4, 2 * n4, 0.0, 12.0, 1.0, 1.0, -1.0, -0.2, "", "r/M", "a/M", "", font, color5, color4, color, new Color(0xAAEEEE));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.pvRSGS, gridBagConstraints);
        this.add(this.pvRSGS);
        this.pvRSGS.addKeyListener(this.pvRSGS);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.orbitSel, gridBagConstraints);
        this.add(this.orbitSel);
        this.orbitSel.addKeyListener(this.orbitSel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.pvRSSJ, gridBagConstraints);
        this.add(this.pvRSSJ);
        this.pvRSSJ.addKeyListener(this.pvRSSJ);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.pvGSSJ, gridBagConstraints);
        this.add(this.pvGSSJ);
        this.pvGSSJ.addKeyListener(this.pvGSSJ);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        this.showTrailsCheckbox = new Checkbox("Show trails");
        this.showTrailsCheckbox.setState(true);
        gridBagLayout.setConstraints(this.showTrailsCheckbox, gridBagConstraints);
        this.add(this.showTrailsCheckbox);
        this.fireParticleButton = new Button("Fire stone");
        gridBagLayout.setConstraints(this.fireParticleButton, gridBagConstraints);
        this.add(this.fireParticleButton);
        this.fireParticleButton.addActionListener(this);
        this.dropParticleButton = new Button("Drop stone");
        gridBagLayout.setConstraints(this.dropParticleButton, gridBagConstraints);
        this.add(this.dropParticleButton);
        this.dropParticleButton.addActionListener(this);
        this.clearButton = new Button("Clear all stones");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.clearButton, gridBagConstraints);
        this.add(this.clearButton);
        this.clearButton.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addKeyListener(this);
        Thread thread = Thread.currentThread();
        while (this.a == thread) {
            long l = System.currentTimeMillis();
            NullChamber nullChamber = this;
            synchronized (nullChamber) {
                if (l - this.pt > this.tStep || l < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(this.tStep / 3L);
            }
            catch (Exception exception) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public synchronized void update(Graphics graphics) {
        long l = System.currentTimeMillis();
        if (l - this.pt > this.tStep || l < this.pt) {
            this.pt = l;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            this.pvRSGS.repaint();
            this.pvRSSJ.repaint();
            this.pvGSSJ.repaint();
            this.maybeShowStatus(graphics);
            ++this.F;
        }
    }

    @Override
    public void showStatus(String string) {
        super.showStatus(string);
        this.statusString = string;
    }

    void maybeShowStatus(Graphics graphics) {
        if (this.statusString != "") {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)graphics, (Component)this);
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        Object object = actionEvent.getSource();
        boolean bl2 = object == this.fireParticleButton;
        boolean bl3 = bl = object == this.dropParticleButton;
        if (bl2 || bl) {
            this.fireOrDrop(bl);
        } else if (object == this.clearButton) {
            this.clearAllStones();
        }
    }

    @Override
    public synchronized void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 70) {
            this.fireOrDrop(false);
        } else if (n == 68) {
            this.fireOrDrop(true);
        } else if (n == 67) {
            this.clearAllStones();
        } else if (n == 83) {
            this.toggleShowTrails();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public synchronized void fireOrDrop(boolean bl) {
        Particle particle = null;
        if (bl) {
            double[] dArray = new double[3];
            for (int i = 0; i < 3; ++i) {
                dArray[i] = 0.0;
            }
            particle = new Particle(this.pGun.getCoords(), dArray);
        } else {
            particle = new Particle(this.pGun.getCoords(), this.pGun.getVels());
        }
        particle.setStartTime((double)this.F * 1.0);
        particle.setPalette(this.stonePalette[this.currentStone]);
        this.currentStone = (this.currentStone + 1) % 5;
        this.stones.add(particle);
    }

    public synchronized void clearAllStones() {
        this.stones.clear();
        this.F = 0L;
        this.pvRSGS.clearBackground();
        this.pvRSSJ.clearBackground();
        this.pvGSSJ.clearBackground();
    }

    public synchronized int numberOfStones() {
        return this.stones.size();
    }

    public synchronized void getStoneCoords(int n, double[] dArray) {
        Particle particle = this.stones.elementAt(n);
        double d = (double)this.F * 1.0;
        double d2 = this.orbitSel.Ar();
        double d3 = this.orbitSel.Az();
        double d4 = this.orbitSel.omega();
        particle.updateCoords(d2, d3, d4, d);
        for (int i = 0; i < 3; ++i) {
            dArray[i] = particle.getCurrentCoord(i);
        }
    }

    public synchronized Color[] getStonePalette(int n) {
        Particle particle = this.stones.elementAt(n);
        return particle.getPalette();
    }

    public synchronized boolean showTrails() {
        return this.showTrailsCheckbox.getState();
    }

    public synchronized void toggleShowTrails() {
        this.showTrailsCheckbox.setState(!this.showTrailsCheckbox.getState());
    }
}

