/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.NullChamber;

import egan.applets.NullChamber.NullChamber;
import egan.applets.NullChamber.graphPaperPanel;
import egan.graphics.GraphicsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;

class orbitSelector
extends graphPaperPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    NullChamber parent;
    double rVal;
    double aVal;
    boolean mouseDown;
    int xdir = 1;
    int ydir = 1;

    orbitSelector(NullChamber nullChamber, int n, int n2, double d, double d2, double d3, double d4, double d5, double d6, String string, String string2, String string3, String string4, Font font, Color color, Color color2, Color color3, Color color4) {
        super(n, n2, d, d2, d3, d4, d5, d6, false, string, string2, string3, string4, font, color, color2, color3, color4);
        this.parent = nullChamber;
        this.setRA(8.33, 0.0);
        this.mouseDown = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public synchronized void setRA(double d, double d2) {
        this.rVal = d;
        this.aVal = d2;
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public synchronized void update(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.bg == null) {
            super.prepareBG();
            Graphics graphics2 = this.bg.getGraphics();
            GraphicsUtils.setAA((Graphics)graphics2);
            block0: for (double d = 1.0; d <= 2.9; d += 0.1) {
                float f;
                double d2 = d - 1.0;
                double d3 = 2.0 * (3.0 - 2.0 * d);
                double d4 = 3.0 - d;
                if (d < 1.99) {
                    f = (float)(d2 / 2.0);
                    graphics2.setColor(new Color(f, f, f));
                } else {
                    f = (float)(0.6 + (d - 2.0) / 3.0);
                    graphics2.setColor(new Color(Color.HSBtoRGB(f, 1.0f, 1.0f)));
                }
                int n3 = -1;
                int n4 = -1;
                for (double d5 = 1.0; d5 <= 12.0; d5 += this.xpx) {
                    double d6 = Math.sqrt(d5);
                    double d7 = d2 == 0.0 ? d6 * (3.0 - d5) / 2.0 : d6 * (2.0 * d - Math.sqrt(d4 * (3.0 * d2 * d5 + d3))) / (3.0 * d2);
                    if (d7 < -1.0) {
                        d7 = -1.0;
                    }
                    if (d7 > 1.0) {
                        n3 = -1;
                    }
                    if (!(d7 <= 1.0)) continue;
                    int n5 = this.pixX(d5);
                    int n6 = this.pixY(d7);
                    if (n3 != -1) {
                        graphics2.drawLine(n3, n4, n5, n6);
                    }
                    if (d7 == -1.0) continue block0;
                    n3 = n5;
                    n4 = n6;
                }
            }
        }
        graphics.drawImage(this.bg, 0, 0, null);
        this.drawCross(graphics);
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.mouseDown = true;
        this.okPos(n, n2);
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.mouseDown = false;
        this.okPos(n, n2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.mouseDown = true;
        this.okPos(n, n2);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    void okPos(int n, int n2) {
        double d;
        double d2;
        double d3 = this.parY(n2);
        if (d3 > this.ymax) {
            d3 = this.ymax;
        }
        if (d3 < this.ymin) {
            d3 = this.ymin;
        }
        if ((d2 = this.parX(n)) > this.xmax) {
            d2 = this.xmax;
        }
        if (d2 <= (d = this.minRforA(d3))) {
            d2 = d + this.xpx / 2.0;
        }
        this.rVal = d2;
        this.aVal = d3;
        this.repaint();
        this.parent.clearAllStones();
    }

    @Override
    public synchronized void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this.pixX(this.rVal);
        int n3 = this.pixY(this.aVal);
        if (n == 37 || n == 226) {
            this.okPos(n2 - 1, n3);
        } else if (n == 39 || n == 227) {
            this.okPos(n2 + 1, n3);
        } else if (n == 38 || n == 224) {
            this.okPos(n2, n3 - 1);
        } else if (n == 40 || n == 225) {
            this.okPos(n2, n3 + 1);
        } else {
            this.parent.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    void drawCross(Graphics graphics) {
        int n = this.pixX(this.rVal);
        int n2 = this.pixY(this.aVal);
        GraphicsUtils.setAA((Graphics)graphics);
        graphics.setColor(Color.white);
        if (this.mouseDown) {
            int n3 = n - 10;
            while (n3 + 1 <= n + 10) {
                graphics.drawLine(n3, n2, n3 + 1, n2);
                n3 += 3;
            }
            n3 = n2 - 10;
            while (n3 + 1 <= n2 + 10) {
                graphics.drawLine(n, n3, n, n3 + 1);
                n3 += 3;
            }
        } else {
            graphics.drawLine(n - 10, n2, n + 10, n2);
            graphics.drawLine(n, n2 - 10, n, n2 + 10);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        int n4 = fontMetrics.getAscent();
        int n5 = fontMetrics.getDescent();
        int n6 = n4 + n5;
        int n7 = 3;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(3);
        String string = "r/M=" + decimalFormat.format(this.rVal);
        String string2 = "a/M=" + decimalFormat.format(this.aVal);
        String string3 = "Weight Ratio=" + decimalFormat.format(this.tidalRatio(this.rVal, this.aVal));
        int n8 = Math.max(fontMetrics.stringWidth(string), Math.max(fontMetrics.stringWidth(string2), fontMetrics.stringWidth(string3))) + 2 * n7;
        int n9 = 4 * n7 + 3 * n6;
        if (this.xdir == 1 && n + 2 * n7 + n8 >= this.kgx) {
            this.xdir = -1;
        }
        if (this.xdir == -1 && n - 2 * n7 - n8 < this.jgx) {
            this.xdir = 1;
        }
        if (this.ydir == 1 && n2 + 2 * n7 + n9 >= this.kgy) {
            this.ydir = -1;
        }
        if (this.ydir == -1 && n2 - 2 * n7 - n9 < this.jgy) {
            this.ydir = 1;
        }
        int n10 = this.xdir == 1 ? n + 2 * n7 : n - 2 * n7 - n8;
        int n11 = this.ydir == 1 ? n2 + 2 * n7 : n2 - 2 * n7 - n9;
        graphics.setColor(Color.yellow);
        graphics.fillRect(n10, n11, n8, n9);
        graphics.setColor(new Color(0xCCCC00));
        graphics.drawRect(n10, n11, n8, n9);
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        graphics.drawString(string, n10 + n7, n11 + n7 + n4);
        graphics.drawString(string2, n10 + n7, n11 + 2 * n7 + n4 + n6);
        graphics.drawString(string3, n10 + n7, n11 + 3 * n7 + n4 + 2 * n6);
    }

    double tidalRatio(double d, double d2) {
        double d3 = d2 * d2;
        double d4 = -3.0 * (d3 + (-2.0 + d) * d) / (3.0 * d3 - 4.0 * d2 * Math.sqrt(d) + d * d);
        return d4;
    }

    double minRforA(double d) {
        if (d == -1.0) {
            return 4.0;
        }
        if (d == 0.0) {
            return 3.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        double d2 = Math.atan2(2.0 * d * Math.sqrt(1.0 - d * d), 1.0 - 2.0 * d * d) / 3.0;
        return 2.0 + Math.cos(d2) - Math.sqrt(3.0) * Math.sin(d2);
    }

    synchronized double Ar() {
        double d = this.rVal * (this.rVal - 3.0) + 2.0 * this.aVal * Math.sqrt(this.rVal);
        return 3.0 * (this.rVal * (this.rVal - 2.0) + this.aVal * this.aVal) / (this.rVal * this.rVal * this.rVal * d);
    }

    synchronized double Az() {
        double d = Math.sqrt(this.rVal);
        double d2 = this.rVal * (this.rVal - 3.0) + 2.0 * this.aVal * d;
        return -(this.rVal * this.rVal - 4.0 * this.aVal * d + 3.0 * this.aVal * this.aVal) / (this.rVal * this.rVal * this.rVal * d2);
    }

    synchronized double omega() {
        return Math.sqrt(1.0 / (this.rVal * this.rVal * this.rVal));
    }
}

