/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.QuantumSoccer;

import egan.applets.QuantumSoccer.QuantumSoccer;
import egan.applets.QuantumSoccer.Spectrum;
import egan.graphics.GraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class Field
extends Panel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    static final int nteam = 11;
    static final int keeper = 10;
    static final int nplayers = 22;
    static final int np7 = 29;
    static final int plRad = 6;
    static final int plWidth = 12;
    static final double[] ipx = new double[]{0.45, 0.45, 0.45, 0.45, 0.45, 0.25, 0.25, 0.25, 0.15, 0.15, 0.05};
    static final double[] ipy = new double[]{0.1, 0.35, 0.5, 0.65, 0.9, 0.3, 0.5, 0.7, 0.35, 0.65, 0.5};
    static final int[] pswap = new int[]{15, 14, 13, 12, 11, 18, 17, 16, 20, 19, 21, 4, 3, 2, 1, 0, 7, 6, 5, 9, 8, 10};
    Dimension pd;
    Spectrum spec;
    Image I;
    float t;
    float dt;
    float[] st;
    float[][] xx;
    float[][] yy;
    float thresh;
    float velX = 0.0f;
    float velY = 0.0f;
    float[] px = new float[22];
    float[] py = new float[22];
    float[] vx = new float[22];
    float[] vy = new float[22];
    float[] bx = new float[22];
    float[] by = new float[22];
    float[] bt = new float[22];
    float[][][] pPhases = new float[22][][];
    int psel = -1;
    int gw;
    int gh;
    int gy1;
    int gy2;
    int gx2;
    int score1;
    int score2;
    int resolution;
    int[] vPairs;
    int[][] pPairs = new int[22][];
    float[][] obstacles = new float[29][4];
    boolean ok = false;
    boolean autoRev;
    boolean enabled = true;
    double[][] II;
    double[][] JJ;
    QuantumSoccer parent;
    static final int nphase = 8;
    static final int hphase = 4;
    static final int ephase = 1;
    static final float fphase = 8.0f;
    static final float fphase10 = 80.0f;
    static final float fphase20 = 160.0f;
    static final float ncontours = 6.0f;
    float[][][] Phi;
    int[][] iLower;
    int[] iLeft;
    int[][][] iRight;
    int[][] iC;
    float[] fLower;
    float[][] fLeft;
    float[][] fRight;
    float[] fC;

    Field(Color color, int n, int n2, Spectrum spectrum, QuantumSoccer quantumSoccer) {
        int n3;
        int n4;
        int n5;
        this.setBackground(color);
        this.pd = new Dimension(n, n2);
        this.spec = spectrum;
        this.parent = quantumSoccer;
        int n6 = this.spec.nx;
        int n7 = this.spec.ny;
        this.st = new float[2000];
        for (n5 = 0; n5 < 1000; ++n5) {
            this.st[n5] = (float)Math.sin((double)n5 * 0.0031415926535897933);
            this.st[1000 + n5] = -this.st[n5];
        }
        int n8 = this.st.length;
        float f = (float)n8 / 2.0f;
        float f2 = f / (float)(n - 1);
        float f3 = f / (float)(n2 - 1);
        this.xx = new float[n][n6];
        for (n5 = 0; n5 < n; ++n5) {
            float f4 = f2 * (float)n5;
            for (n4 = 1; n4 <= n6; ++n4) {
                this.xx[n5][n4 - 1] = this.st[(int)((float)n4 * f4) % n8];
            }
        }
        this.yy = new float[n2][n7];
        for (n3 = 0; n3 < n2; ++n3) {
            float f5 = f3 * (float)(n2 - 1 - n3);
            for (n4 = 1; n4 <= n7; ++n4) {
                this.yy[n3][n4 - 1] = this.st[(int)((float)n4 * f5) % n8];
            }
        }
        this.gw = n / 12;
        this.gy1 = (n2 - n2 / 3) / 2;
        this.gy2 = n2 - 1 - this.gy1;
        this.gh = this.gy2 - this.gy1;
        this.gx2 = n - 1 - this.gw;
        for (n3 = 0; n3 < 7; ++n3) {
            n5 = 22 + n3;
            this.obstacles[n5][0] = (n3 < 6 ? n3 % 2 * this.gx2 : n - 1) - 1;
            this.obstacles[n5][1] = this.obstacles[n5][0] + (float)(n3 < 6 ? this.gw : -(n - 1)) + 2.0f;
            this.obstacles[n5][2] = (n3 < 6 ? (n3 < 4 ? this.gy1 : this.gy2) : n2 - 1) - 1;
            this.obstacles[n5][3] = this.obstacles[n5][2] + (float)(n3 < 6 ? (n3 < 2 ? this.gh : 0) : -(n2 - 1)) + 2.0f;
        }
        this.II = new double[n6 + 1][n6 + 1];
        this.JJ = new double[n7 + 1][n7 + 1];
        double d = (double)this.gw / (double)(n - 1);
        double d2 = Math.PI * d;
        for (int i = 1; i <= n6; ++i) {
            double[] dArray = this.II[i];
            for (int j = 1; j <= n6; ++j) {
                if (i == j) {
                    dArray[i] = d - Math.sin((double)(2 * i) * d2) / ((double)(2 * i) * Math.PI);
                    continue;
                }
                dArray[j] = j < i ? this.II[j][i] : 1.0 / (Math.PI * (double)(i * i - j * j)) * ((double)(i + j) * Math.sin((double)(i - j) * d2) - (double)(i - j) * Math.sin((double)(i + j) * d2));
            }
        }
        double d3 = (double)this.gh / (double)(n2 - 1);
        double d4 = Math.PI * d3;
        for (int i = 1; i <= n7; ++i) {
            double[] dArray = this.JJ[i];
            for (int j = 1; j <= n7; ++j) {
                if (i == j) {
                    dArray[i] = d3 - (double)(1 - 2 * (i % 2)) * Math.sin((double)i * d4) / ((double)i * Math.PI);
                    continue;
                }
                dArray[j] = j < i ? this.JJ[j][i] : ((i + j) % 2 == 0 ? 2.0 / (Math.PI * (double)(i * i - j * j)) * ((double)((1 - 2 * (((i - j) / 2 + 1000) % 2)) * (i + j)) * Math.sin((double)(i - j) * d4 / 2.0) - (double)((1 - 2 * ((i + j) / 2 % 2)) * (i - j)) * Math.sin((double)(i + j) * d4 / 2.0)) : 0.0);
            }
        }
        this.spec.setBest(this.II, this.JJ);
        this.reset(true, true);
    }

    public synchronized void reset(boolean bl, boolean bl2) {
        int n;
        for (n = 0; n < 22; ++n) {
            this.vy[n] = 0.0f;
            this.vx[n] = 0.0f;
        }
        this.spec.reset(bl);
        if (bl) {
            for (n = 0; n < 11; ++n) {
                this.px[n] = (float)((double)(this.pd.width - 1) * ipx[n]);
                this.py[n] = (float)((double)(this.pd.height - 1) * ipy[n]);
                int n2 = pswap[n];
                this.px[n2] = (float)(this.pd.width - 1) - this.px[n];
                this.py[n2] = (float)(this.pd.height - 1) - this.py[n];
            }
            this.psel = -1;
        }
        if (bl2) {
            this.score1 = 0;
            this.score2 = 0;
        }
    }

    public synchronized void setPars(int n, float f, boolean bl) {
        if (this.resolution != n) {
            this.resolution = n;
            this.Phi = null;
        }
        this.thresh = f;
        this.autoRev = bl;
    }

    public synchronized void setTime(float f, float f2) {
        this.t = f;
        this.dt = f2;
        this.ok = false;
        this.repaint();
    }

    public synchronized void setVelocities(float f, float f2, int[] nArray) {
        this.velX = f;
        this.velY = f2;
        this.vPairs = nArray;
        if (this.psel >= 0) {
            this.click((int)this.px[this.psel], (int)this.py[this.psel]);
        }
    }

    public synchronized void next(boolean bl, boolean bl2) {
        int n = this.psel;
        for (int i = 0; i < 22; ++i) {
            n = (n + (bl ? 21 : 1)) % 22;
            if (bl2 && this.vx[n] == 0.0f && this.vy[n] == 0.0f) continue;
            this.psel = n;
            break;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pd;
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = 0;
        int n4 = 0;
        float[] fArray = this.st;
        float f = (float)fArray.length / 2.0f;
        int n5 = fArray.length;
        int n6 = n5 / 4;
        int n7 = 5 * n6;
        if (this.I == null) {
            this.I = this.createImage(n, n2);
            this.ok = false;
        }
        if (!this.ok) {
            Spectrum spectrum = this.spec;
            synchronized (spectrum) {
                float f2;
                int n8;
                int n9;
                int n10;
                Object object;
                int n11;
                Graphics graphics2 = this.I.getGraphics();
                GraphicsUtils.setAA((Graphics)graphics2);
                Font font = this.getFont();
                graphics2.setFont(font);
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n12 = fontMetrics.getAscent();
                int n13 = fontMetrics.getDescent();
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, n, n2);
                int n14 = this.resolution;
                int n15 = (n - 1) / n14 * n14;
                int n16 = (n2 - 1) / n14 * n14;
                int n17 = (n - 1 - n15) / 2;
                int n18 = (n2 - 1 - n16) / 2;
                int n19 = 1 + n2 / n14;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int n20 = this.spec.nx;
                int n21 = this.spec.ny;
                boolean[][] blArray = this.spec.s;
                boolean bl = false;
                int n22 = 4 * n14;
                int n23 = n22 + 1;
                int n24 = 4 * n22;
                if (this.Phi == null) {
                    this.Phi = new float[2][n20 + 2][n21 + 1];
                    this.fLeft = new float[2][n19];
                    this.iLeft = new int[n19];
                    this.fLower = new float[n23];
                    this.iLower = new int[2][n23];
                    this.iRight = new int[2][n19][n23];
                    this.fRight = new float[n19][n23];
                    this.iC = new int[3][n24];
                    this.fC = new float[n24];
                }
                int n25 = 0;
                int n26 = 0;
                float[][] fArray2 = this.Phi[0];
                float[][] fArray3 = this.Phi[1];
                float[] fArray4 = this.Phi[0][n20 + 1];
                float[] fArray5 = this.Phi[1][n20 + 1];
                float f5 = 0.0f;
                float[] fArray6 = this.fLeft[0];
                float f6 = 0.0f;
                float[] fArray7 = this.fLeft[1];
                int n27 = 0;
                int[] nArray = this.iLeft;
                int[] nArray2 = this.iLower[0];
                int[][] nArray3 = this.iRight[0];
                int[] nArray4 = this.iLower[1];
                int[][] nArray5 = this.iRight[1];
                float[] fArray8 = this.fLower;
                float[][] fArray9 = this.fRight;
                int[] nArray6 = this.iC[0];
                int[] nArray7 = this.iC[1];
                int[] nArray8 = this.iC[2];
                float[] fArray10 = this.fC;
                int n28 = -1;
                float f7 = 0.0f;
                float f8 = 0.0f;
                float f9 = 0.0f;
                Color[] colorArray = new Color[]{Color.red, Color.black, Color.cyan, Color.black, Color.white, Color.black, Color.blue, Color.black};
                int n29 = 0;
                int n30 = 0;
                int n31 = n20;
                int n32 = n21;
                for (n11 = 1; n11 <= n20; ++n11) {
                    double[] dArray = this.II[n11];
                    float[] fArray11 = this.spec.freq[n11];
                    object = this.spec.amp[n11];
                    float[] fArray12 = fArray2[n11];
                    float[] fArray13 = fArray3[n11];
                    boolean[] blArray2 = blArray[n11];
                    for (n10 = 1; n10 <= n21; ++n10) {
                        if (!blArray2[n10]) continue;
                        if (n11 > n29) {
                            n29 = n11;
                        }
                        if (n10 > n30) {
                            n30 = n10;
                        }
                        if (n11 < n31) {
                            n31 = n11;
                        }
                        if (n10 < n32) {
                            n32 = n10;
                        }
                        float f10 = fArray11[n10];
                        int n33 = (int)(f10 * (float)n5 * this.t) % n5;
                        float f11 = fArray[n33];
                        float f12 = fArray[(n7 - n33) % n5];
                        float[] fArray14 = object[n10];
                        float f13 = fArray14[0];
                        float f14 = fArray14[1];
                        fArray12[n10] = f13 * f12 + f14 * f11;
                        fArray13[n10] = f14 * f12 - f13 * f11;
                        double[] dArray2 = this.JJ[n10];
                        for (n9 = 1; n9 <= n20; ++n9) {
                            float[] fArray15 = this.spec.freq[n9];
                            float[][] fArray16 = this.spec.amp[n9];
                            double d = dArray[n9];
                            boolean[] blArray3 = blArray[n9];
                            for (n8 = 1; n8 <= n21; ++n8) {
                                if (!blArray3[n8]) continue;
                                float[] fArray17 = fArray16[n8];
                                f2 = fArray17[0];
                                float f15 = fArray17[1];
                                float f16 = f10 - fArray15[n8];
                                n33 = (int)((float)n5 * Math.abs(f16) * this.t) % n5;
                                float f17 = (float)(d * dArray2[n8]) * ((f13 * f2 + f14 * f15) * fArray[(n7 - n33) % n5] - (f13 * f15 - f14 * f2) * (float)(f16 < 0.0f ? -1 : 1) * fArray[n33]);
                                f3 += f17;
                                f4 += (float)(1 - 2 * ((n11 - n9 + 1000) % 2)) * f17;
                            }
                        }
                    }
                }
                graphics2.setColor(Color.white);
                graphics2.drawRect(0, this.gy1, this.gw, this.gh);
                graphics2.drawRect(this.gx2, this.gy1, this.gw, this.gh);
                graphics2.setColor(this.getBackground().brighter());
                n3 = (int)((float)(this.gh - 1) * f3 / this.thresh);
                graphics2.fillRect(1, this.gy2 - n3, this.gw - 1, n3);
                n3 = (int)((float)(this.gh - 1) * f4 / this.thresh);
                graphics2.fillRect(this.gx2 + 1, this.gy2 - n3, this.gw - 1, n3);
                this.tryMove(this.dt);
                graphics2.setColor(Color.yellow);
                for (n3 = 0; n3 < 22; ++n3) {
                    int n34 = (int)((double)this.px[n3] + 0.5) - 6;
                    int n35 = (int)((double)this.py[n3] + 0.5) - 6;
                    if (n3 == 11) {
                        graphics2.setColor(Color.magenta);
                    }
                    if (n3 % 11 == 10) {
                        if (n3 == this.psel) {
                            graphics2.fillOval(n34, n35, 12, 12);
                        } else {
                            graphics2.drawOval(n34, n35, 12, 12);
                        }
                    } else if (n3 == this.psel) {
                        graphics2.fillRect(n34, n35, 12, 12);
                    } else {
                        graphics2.drawRect(n34, n35, 12, 12);
                    }
                    if (this.vx[n3] == 0.0f && this.vy[n3] == 0.0f) continue;
                    graphics2.fillRect(n34 + 3, n35 + 3, 6, 6);
                }
                int n36 = 0;
                int n37 = 0;
                for (n3 = n17; n3 < n; n3 += n14) {
                    object = this.xx[n3 - n17];
                    for (n10 = n32; n10 <= n30; ++n10) {
                        fArray4[n10] = 0.0f;
                        fArray5[n10] = 0.0f;
                    }
                    for (n11 = n31; n11 <= n29; ++n11) {
                        float[] fArray18 = object[n11 - 1];
                        float[] fArray19 = fArray2[n11];
                        float[] fArray20 = fArray3[n11];
                        for (n10 = n32; n10 <= n30; ++n10) {
                            int n38 = n10;
                            fArray4[n38] = fArray4[n38] + fArray19[n10] * fArray18;
                            int n39 = n10;
                            fArray5[n39] = fArray5[n39] + fArray20[n10] * fArray18;
                        }
                    }
                    n4 = n18;
                    int n40 = 0;
                    while (n4 < n2) {
                        float f18;
                        float f19;
                        int n41;
                        int n42;
                        boolean bl2;
                        float[] fArray21 = this.yy[n4 - n18];
                        float f20 = 0.0f;
                        float f21 = 0.0f;
                        for (n10 = n32; n10 <= n30; ++n10) {
                            float f22 = fArray21[n10 - 1];
                            f21 += f22 * fArray4[n10];
                            f20 += f22 * fArray5[n10];
                        }
                        float f23 = f21 * f21;
                        float f24 = f20 * f20;
                        float f25 = 6.0f * (f23 + f24);
                        int n43 = (int)f25;
                        boolean bl3 = bl2 = f23 > f24;
                        float f26 = 80.0f + 1.0f * ((bl2 ? f20 / f21 : (f20 == 0.0f ? -1.0f : -f21 / f20)) + (float)((f20 < 0.0f ? -1 : 1) * (bl2 ? (f21 < 0.0f ? 4 : 0) : 2)));
                        float f27 = 160.0f - f26;
                        int n44 = 0;
                        int n45 = 0;
                        int n46 = 0;
                        int[] nArray9 = nArray3[n40];
                        int[] nArray10 = nArray5[n40];
                        float[] fArray22 = fArray9[n40];
                        if (n4 > n18) {
                            float f28;
                            if (n3 > n17) {
                                int n47;
                                n8 = 0;
                                while ((n47 = nArray4[n8]) >= 0) {
                                    nArray6[n46] = nArray2[n8];
                                    nArray7[n46] = n37;
                                    nArray8[n46] = n47;
                                    fArray10[n46++] = fArray8[n8++];
                                }
                                n8 = 0;
                                while ((n47 = nArray10[n8]) >= 0) {
                                    nArray6[n46] = n36;
                                    nArray7[n46] = nArray9[n8];
                                    nArray8[n46] = n47;
                                    fArray10[n46++] = fArray22[n8++];
                                }
                            }
                            if ((n42 = n43) > (n41 = n27)) {
                                n41 = n43;
                                n42 = n27;
                            }
                            f7 = (f6 + f27) % 8.0f;
                            if (f28 > 4.0f) {
                                f7 -= 8.0f;
                            }
                            f19 = 1.0f / (f25 - f5);
                            n8 = n42 + 1;
                            while (n8 <= n41 && n45 < n22) {
                                f18 = f19 * (f25 - (float)n8);
                                nArray6[n46] = n3;
                                nArray7[n46] = nArray9[n45] = n4 - (int)((float)n14 * f18 + 0.5f);
                                nArray8[n46] = nArray10[n45] = n8++;
                                int n48 = n46++;
                                int n49 = n45++;
                                float f29 = f26 + f18 * f7;
                                fArray22[n49] = f29;
                                fArray10[n48] = f29;
                            }
                        }
                        if (n3 > n17) {
                            float f30;
                            int n50;
                            n42 = n43;
                            n41 = nArray[n40];
                            if (n42 > n41) {
                                n50 = n41;
                                n41 = n43;
                                n42 = n50;
                            }
                            f7 = (fArray7[n40] + f27) % 8.0f;
                            if (f30 > 4.0f) {
                                f7 -= 8.0f;
                            }
                            f19 = 1.0f / (f25 - fArray6[n40]);
                            n8 = n42 + 1;
                            while (n8 <= n41 && n44 < n22) {
                                f18 = f19 * (f25 - (float)n8);
                                nArray6[n46] = nArray2[n44] = n3 - (int)((float)n14 * f18 + 0.5f);
                                nArray7[n46] = n4;
                                nArray8[n46] = nArray4[n44] = n8++;
                                int n51 = n46++;
                                int n52 = n44++;
                                float f31 = f26 + f18 * f7;
                                fArray8[n52] = f31;
                                fArray10[n51] = f31;
                            }
                            if (n4 > n18 && n46 >= 2) {
                                block18: for (n50 = 0; n50 < n46 - 1; ++n50) {
                                    if (nArray8[n50] < 0) continue;
                                    for (int i = n50 + 1; i < n46; ++i) {
                                        int n53;
                                        if (nArray8[n50] != nArray8[i]) continue;
                                        int n54 = n50;
                                        f8 = fArray10[n54];
                                        n25 = (int)f8 % 8;
                                        int n55 = i;
                                        f9 = fArray10[n55];
                                        n26 = (int)f9 % 8;
                                        if (n25 != n26) {
                                            float f32;
                                            f7 = (80.0f + f9 - f8) % 8.0f;
                                            if (f32 > 4.0f) {
                                                f7 = 8.0f - f7;
                                                n54 = i;
                                                n55 = n50;
                                                f8 = f9;
                                                n53 = n25;
                                                n25 = n26;
                                                n26 = n53;
                                            }
                                        }
                                        n53 = nArray6[n54];
                                        int n56 = nArray7[n54];
                                        int n57 = nArray6[n55];
                                        int n58 = nArray7[n55];
                                        if (n25 != n26 && f7 != 0.0f) {
                                            int n59 = n57 - n53;
                                            int n60 = n58 - n56;
                                            f2 = 160.0f - f8;
                                            int n61 = n53;
                                            int n62 = n56;
                                            n8 = n25;
                                            while (true) {
                                                n8 = (n8 + 1) % 8;
                                                f18 = ((float)n8 + f2) % 8.0f / f7;
                                                int n63 = n53 + (int)(f18 * (float)n59 + 0.5f);
                                                int n64 = n56 + (int)(f18 * (float)n60 + 0.5f);
                                                if (n28 != n25) {
                                                    n28 = n25;
                                                    graphics2.setColor(colorArray[n28]);
                                                }
                                                graphics2.drawLine(n61, n62, n63, n64);
                                                n61 = n63;
                                                n62 = n64;
                                                if (n8 == n26) break;
                                                n25 = n8;
                                            }
                                            n53 = n61;
                                            n56 = n62;
                                        }
                                        if (n28 != n26) {
                                            n28 = n26;
                                            graphics2.setColor(colorArray[n28]);
                                        }
                                        graphics2.drawLine(n53, n56, n57, n58);
                                        nArray8[i] = -1;
                                        continue block18;
                                    }
                                }
                            }
                        }
                        fArray6[n40] = f5 = f25;
                        nArray[n40] = n27 = n43;
                        fArray7[n40] = f6 = f26;
                        nArray4[n44] = -1;
                        nArray10[n45] = -1;
                        n37 = n4;
                        n4 += n14;
                        ++n40;
                    }
                    n36 = n3;
                }
                if (!this.spec.preview) {
                    if (f3 >= this.thresh) {
                        graphics2.setColor(Color.white);
                        bl = true;
                        graphics2.fillRect(0, this.gy1, this.gw, this.gh);
                        ++this.score1;
                        this.parent.playGoal(1);
                    }
                    if (f4 >= this.thresh) {
                        graphics2.setColor(Color.white);
                        bl = true;
                        graphics2.fillRect(this.gx2, this.gy1, this.gw, this.gh);
                        ++this.score2;
                        this.parent.playGoal(2);
                    }
                    if (bl) {
                        this.reset(true, false);
                    }
                }
                object = new String[]{(float)((int)(f3 * 1000.0f)) / 10.0f + "%", (float)((int)(f4 * 1000.0f)) / 10.0f + "%", "Score " + this.score1, "Score " + this.score2, "time=" + (int)this.t};
                n8 = n12 + n13 + 2;
                for (n3 = 0; n3 < 5; ++n3) {
                    n9 = fontMetrics.stringWidth((String)object[n3]);
                    int n65 = n11 = n3 % 2 == 0 ? 2 : n - 2 - n9;
                    n10 = n3 == 4 ? n12 + 2 : (n3 < 2 ? this.gy1 - n13 - 4 : this.gy2 + n12 + 4);
                    n4 = n10 - n12 - 1;
                    graphics2.setColor(n3 == 4 ? Color.white : Color.black);
                    graphics2.fillRect(n11 - 2, n4, n9 + 3, n8);
                    graphics2.setColor(n3 == 4 ? Color.black : (n3 % 2 == 0 ? Color.magenta : Color.yellow));
                    graphics2.drawRect(n11 - 2, n4, n9 + 3, n8);
                    graphics2.drawString((String)object[n3], n11, n10);
                }
                graphics2.dispose();
                this.ok = true;
                if (!this.spec.ok) {
                    this.spec.repaint();
                }
            }
        }
        graphics.drawImage(this.I, 0, 0, null);
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        if (this.enabled) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.click(n, n2);
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    void click(int n, int n2) {
        int n3;
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        for (n3 = 21; n3 >= 0; --n3) {
            if (!(Math.abs((float)n - this.px[n3]) <= 6.0f) || !(Math.abs((float)n2 - this.py[n3]) <= 6.0f)) continue;
            if (this.vx[n3] != 0.0f || this.vy[n3] != 0.0f) {
                this.spec.setPerturb(this.pPairs[n3], this.pPhases[n3], -1.0f, false);
            }
            this.vx[n3] = this.velX;
            this.vy[n3] = this.velY;
            this.pPairs[n3] = this.vPairs;
            this.bx[n3] = this.px[n3] / (float)(n4 - 1);
            this.by[n3] = this.py[n3] / (float)(n5 - 1);
            this.bt[n3] = this.t;
            this.pPhases[n3] = this.spec.setPhases(this.pPhases[n3], this.vPairs, this.velX, this.velY, this.bx[n3], this.by[n3], this.t);
            this.spec.setPerturb(this.vPairs, this.pPhases[n3], 1.0f, true);
            break;
        }
        this.psel = n3;
    }

    public synchronized void tryMove(float f) {
        float f2;
        int n;
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        float f3 = (float)n2 - 1.0f;
        float f4 = 1.0E10f;
        float[] fArray = new float[22];
        for (n = 0; n < 22; ++n) {
            this.obstacles[n][0] = this.px[n];
            this.obstacles[n][1] = this.px[n];
            this.obstacles[n][2] = this.py[n];
            this.obstacles[n][3] = this.py[n];
            fArray[n] = f;
        }
        for (int i = 0; i < 22; ++i) {
            for (int j = i + 1; j < 29; ++j) {
                float f5;
                float f6;
                float f7;
                float f8;
                float f9;
                int n4 = j - 22;
                if (i == 11 * n4 + 10) continue;
                float f10 = this.vx[i];
                float f11 = -this.vy[i];
                float f12 = n4 >= 0 ? 0.0f : this.vx[j];
                float f13 = n4 >= 0 ? 0.0f : -this.vy[j];
                float f14 = f10 - f12;
                float f15 = f11 - f13;
                if (f14 == 0.0f && f15 == 0.0f) continue;
                float f16 = this.px[i];
                float f17 = this.py[i];
                float[] fArray2 = this.obstacles[j];
                float f18 = (n4 >= 0 ? 1 : 2) * 7;
                float f19 = fArray2[0] - f18;
                float f20 = fArray2[1] + f18;
                float f21 = fArray2[2] - f18;
                float f22 = fArray2[3] + f18;
                if ((double)f14 == 0.0) {
                    if ((f19 - f16) * (f20 - f16) < 0.0f) {
                        f9 = -f4;
                        f8 = f4;
                    } else {
                        f9 = -f4;
                        f8 = -f4;
                    }
                } else {
                    f9 = (f19 - f16) / f14;
                    f8 = (f20 - f16) / f14;
                    if (f9 > f8) {
                        f7 = f9;
                        f9 = f8;
                        f8 = f7;
                    }
                }
                if ((double)f15 == 0.0) {
                    if ((f21 - f17) * (f22 - f17) < 0.0f) {
                        f6 = -f4;
                        f5 = f4;
                    } else {
                        f6 = -f4;
                        f5 = -f4;
                    }
                } else {
                    f6 = (f21 - f17) / f15;
                    f5 = (f22 - f17) / f15;
                    if (f6 > f5) {
                        f7 = f6;
                        f6 = f5;
                        f5 = f7;
                    }
                }
                if (!(n4 < 6 && f6 <= f8 && f9 <= f5 && (double)(f7 = Math.max(f9, f6)) >= 0.0)) {
                    float f23;
                    if (n4 != 6) continue;
                    f7 = Math.min(f8, f5);
                    if (!((double)f23 >= 0.0)) continue;
                }
                f2 = f7 / f3;
                fArray[i] = Math.min(fArray[i], f2);
                if (n4 >= 0) continue;
                fArray[j] = Math.min(fArray[j], f2);
            }
        }
        for (n = 0; n < 22; ++n) {
            if (this.vx[n] == 0.0f && this.vy[n] == 0.0f) continue;
            f2 = fArray[n];
            int n5 = n;
            this.px[n5] = this.px[n5] + this.vx[n] * f3 * f2;
            int n6 = n;
            this.py[n6] = this.py[n6] + -this.vy[n] * f3 * f2;
            if (!(f2 < f)) continue;
            this.spec.setPerturb(this.pPairs[n], this.pPhases[n], -1.0f, !this.autoRev);
            if (this.autoRev) {
                int n7 = n;
                this.vx[n7] = this.vx[n7] * -1.0f;
                int n8 = n;
                this.vy[n8] = this.vy[n8] * -1.0f;
                this.bx[n] = this.px[n] / (float)(n2 - 1);
                this.by[n] = this.py[n] / (float)(n3 - 1);
                this.bt[n] = this.t;
                this.pPhases[n] = this.spec.setPhases(this.pPhases[n], this.pPairs[n], this.vx[n], this.vy[n], this.bx[n], this.by[n], this.bt[n]);
                this.spec.setPerturb(this.pPairs[n], this.pPhases[n], 1.0f, true);
                continue;
            }
            this.vy[n] = 0.0f;
            this.vx[n] = 0.0f;
        }
    }

    @Override
    public synchronized void setEnabled(boolean bl) {
        this.enabled = bl;
        this.spec.setEnabled(bl);
    }
}

