/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.QuantumSoccer;

import egan.applets.QuantumSoccer.Field;
import egan.applets.QuantumSoccer.Spectrum;
import egan.applets.QuantumSoccer.Velocity;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ObjectInputStream;
import java.net.URL;

public class QuantumSoccer
extends Applet
implements Runnable,
ActionListener,
ItemListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    public static final int nx = 10;
    public static final int ny = 5;
    static final int resMin = 2;
    static final int resMax = 12;
    static final int vMax = 9;
    static final float fieldX = 100.0f;
    static final float fieldY = 50.0f;
    Field field;
    Spectrum spectrum;
    Velocity vel;
    Panel pan;
    Choice thresh;
    Choice res;
    Checkbox ar;
    Button restart;
    Button[] demos = new Button[2];
    String[] demoLabels = new String[2];
    int[] threshVals = new int[]{5, 10, 15, 20, 25, 30, 35, 40, 45, 50};
    int mult = 1;
    int[][][] pairs = new int[10][10][];
    short[][] scripts = new short[2][];
    short[] script = null;
    int saveTI;
    int saveVx;
    int saveVy;
    boolean saveAR;
    int adnum = -1;
    int scriptLen;
    int scriptPtr;
    private volatile Thread a;
    static final long tStep0 = 25L;
    float t = 0.0f;
    float maxDt = 0.2f;
    float dt = this.maxDt / 2.0f;
    long pct;
    long tStep = 25L;
    long dtMs = (long)(1000.0f * this.dt);

    @Override
    public void init() {
        int n;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setFont(new Font(this.getFont().getName(), 0, 10));
        this.setLayout(new FlowLayout(1, 4, 4));
        this.vel = new Velocity(this, 9, this.getFont());
        this.add(this.vel);
        this.vel.addMouseListener(this.vel);
        this.vel.addMouseMotionListener(this.vel);
        this.vel.addKeyListener(this);
        this.pan = new Panel();
        this.pan.setLayout(new GridLayout(3, 2, 5, 5));
        this.thresh = new Choice();
        for (n = 0; n < this.threshVals.length; ++n) {
            this.thresh.addItem("Goal at " + this.threshVals[n] + "%");
        }
        this.thresh.select(0);
        this.pan.add(this.thresh);
        this.thresh.addItemListener(this);
        this.res = new Choice();
        for (n = 2; n <= 12; ++n) {
            this.res.addItem(n + " pix");
        }
        this.res.select(6);
        this.pan.add(this.res);
        this.res.addItemListener(this);
        this.ar = new Checkbox("Auto-reverse");
        this.pan.add(this.ar);
        this.ar.addItemListener(this);
        this.restart = new Button("RESTART");
        this.pan.add(this.restart);
        this.restart.addActionListener(this);
        for (n = 0; n < 2; ++n) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new URL(this.getCodeBase(), "egan/applets/QuantumSoccer/Demo" + (n == 0 ? "1" : "2") + ".script").openStream());
                if (objectInputStream != null) {
                    this.scripts[n] = (short[])objectInputStream.readObject();
                    objectInputStream.close();
                    this.demoLabels[n] = new String("Demo (" + this.scripts[n][this.scripts[n].length - 4] + " sec)");
                    this.demos[n] = new Button(this.demoLabels[n]);
                    this.pan.add(this.demos[n]);
                }
                this.demos[n].addActionListener(this);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.add(this.pan);
        this.pan.addKeyListener(this);
        this.validate();
        n = this.getSize().width - 5;
        int n2 = (n - 1) / 2 + 1;
        int n3 = this.getSize().height - 12 - n2 - Math.max(this.vel.getLocation().y + this.vel.getSize().height, this.pan.getLocation().y + this.pan.getSize().height);
        this.spectrum = new Spectrum(new Color(153, 153, 255), n, n3, 10, 5, n, n2);
        this.field = new Field(new Color(0, 204, 0), n, n2, this.spectrum, this);
        this.add(this.field);
        this.add(this.spectrum);
        this.spectrum.addMouseListener(this.spectrum);
        this.spectrum.addMouseMotionListener(this.spectrum);
        this.spectrum.addKeyListener(this);
        this.field.addMouseListener(this.field);
        this.field.addKeyListener(this);
        this.field.setPars(2 + this.res.getSelectedIndex(), (float)this.threshVals[this.thresh.getSelectedIndex()] / 100.0f, this.ar.getState());
    }

    public void playGoal(int n) {
        URL uRL = null;
        try {
            uRL = new URL(this.getCodeBase(), n == 1 ? "egan/applets/QuantumSoccer/goal1.au" : "egan/applets/QuantumSoccer/goal2.au");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL != null) {
            this.play(uRL);
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.serviceControl(object);
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.serviceControl(object);
    }

    void serviceControl(Object object) {
        boolean bl;
        int n;
        for (n = 1; n >= 0 && object != this.demos[n]; --n) {
        }
        boolean bl2 = bl = n >= 0 || object == this.restart && this.script != null;
        if (bl) {
            if (this.script == null) {
                int n2;
                this.script = this.scripts[n];
                this.dtMs = this.script[1];
                this.dt = (float)this.dtMs / 1000.0f;
                this.scriptPtr = 2;
                this.scriptLen = this.script.length;
                this.saveTI = this.thresh.getSelectedIndex();
                this.saveAR = this.ar.getState();
                this.saveVx = this.vel.getV(0);
                this.saveVy = this.vel.getV(1);
                this.ar.setState(true);
                this.ar.setEnabled(false);
                for (n2 = this.threshVals.length - 1; n2 >= 0 && this.script[0] < this.threshVals[n2]; --n2) {
                }
                this.thresh.select(n2);
                this.thresh.setEnabled(false);
                this.vel.setEnabled(false);
                this.field.setEnabled(false);
                for (n2 = 0; n2 < 2; ++n2) {
                    if (this.demos[n2] == null) continue;
                    if (n2 == n) {
                        this.demos[n2].setLabel("HALT DEMO");
                    } else {
                        this.demos[n2].setEnabled(false);
                    }
                    this.demos[n2].repaint();
                }
                this.adnum = n;
            } else {
                this.endScript();
            }
            this.field.reset(true, false);
            this.t = 0.0f;
        }
        if (object == this.res || object == this.thresh || object == this.ar || bl) {
            this.field.setPars(2 + this.res.getSelectedIndex(), (float)this.threshVals[this.thresh.getSelectedIndex()] / 100.0f, this.ar.getState());
            this.ar.repaint();
        }
        if (object == this.restart) {
            this.field.reset(true, true);
            this.vel.setV(0, 0);
            this.setVelocities();
            this.t = 0.0f;
        }
    }

    public synchronized void endScript() {
        if (this.adnum >= 0) {
            this.script = null;
            this.thresh.setEnabled(true);
            this.thresh.select(this.saveTI);
            this.ar.setEnabled(true);
            this.ar.setState(this.saveAR);
            this.vel.setV(this.saveVx, this.saveVy);
            this.vel.setEnabled(true);
            this.setVelocities();
            this.field.setEnabled(true);
            this.field.setPars(2 + this.res.getSelectedIndex(), (float)this.threshVals[this.thresh.getSelectedIndex()] / 100.0f, this.ar.getState());
            for (int i = 0; i < 2; ++i) {
                if (this.demos[i] == null) continue;
                this.demos[i].setLabel(this.demoLabels[i]);
                this.demos[i].setEnabled(true);
                this.demos[i].repaint();
            }
            this.ar.repaint();
            this.adnum = -1;
            this.dt = this.maxDt / 2.0f;
            this.dtMs = (long)(1000.0f * this.dt);
        }
    }

    @Override
    public synchronized void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this.adnum < 0) {
            int n2;
            boolean bl = keyEvent.isShiftDown();
            boolean bl2 = keyEvent.isControlDown();
            boolean bl3 = false;
            int n3 = bl2 || bl ? 1 : 0;
            int[] nArray = new int[]{this.vel.getV(0), this.vel.getV(1)};
            if (n >= 48 && n <= 57 && Math.abs(n2 = (n - 48) * this.mult) <= 9 || n >= 96 && n <= 105 && Math.abs(n2 = (n - 96) * this.mult) <= 9 || n == 82 && (n2 = -nArray[n3]) <= 9 || (n == 38 || n == 224) && (n2 = nArray[n3] + 1) <= 9 || (n == 40 || n == 225) && (n2 = nArray[n3] - 1) >= -9) {
                bl3 = true;
                nArray[n3] = n2;
            } else if (n == 66) {
                bl3 = true;
                nArray[0] = nArray[0] * -1;
                nArray[1] = nArray[1] * -1;
            } else if (n == 90) {
                bl3 = true;
                nArray[1] = 0;
                nArray[0] = 0;
            } else if (n == 72) {
                this.field.reset(false, false);
            } else if (n == 39 || n == 227) {
                this.field.next(false, bl);
            } else if (n == 37 || n == 226) {
                this.field.next(true, bl);
            }
            int n4 = this.mult = n == 45 || n == 523 ? -1 : 1;
            if (bl3) {
                this.vel.setV(nArray[0], nArray[1]);
                this.setVelocities();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setVelocities() {
        int n = this.vel.getV(0);
        int n2 = this.vel.getV(1);
        this.field.setVelocities((float)n / 100.0f, (float)n2 / 100.0f, this.getPairs(n, n2));
    }

    public synchronized int[] getPairs(int n, int n2) {
        int n3;
        int n4 = Math.abs(n);
        if (this.pairs[n4][n3 = Math.abs(n2)] == null) {
            this.pairs[n4][n3] = this.spectrum.setPairs((float)n4 / 100.0f, (float)n3 / 50.0f);
        }
        return this.pairs[n4][n3];
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
    }

    @Override
    public void stop() {
        this.a = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addKeyListener(this);
        this.pct = System.currentTimeMillis();
        Thread thread = Thread.currentThread();
        while (this.a == thread) {
            Field field = this.field;
            synchronized (field) {
                if (this.field.ok) {
                    long l = System.currentTimeMillis();
                    long l2 = l - this.pct;
                    if (this.script != null) {
                        if (this.scriptPtr == this.scriptLen && this.t - (float)this.script[this.scriptLen - 4] > 2.0f) {
                            this.endScript();
                        } else {
                            while (this.scriptPtr < this.scriptLen && Math.abs(this.t - (float)this.script[this.scriptPtr]) < this.dt / 10.0f) {
                                ++this.scriptPtr;
                                this.field.t = this.t;
                                this.vel.setV(this.script[this.scriptPtr++], this.script[this.scriptPtr++]);
                                this.field.psel = this.script[this.scriptPtr++];
                                this.setVelocities();
                            }
                        }
                        this.field.psel = -1;
                    } else {
                        this.dt = (float)l2 / 1000.0f;
                        if (this.dt > this.maxDt) {
                            this.dt = (float)((int)(this.t / this.maxDt) + 1) * this.maxDt - this.t;
                        }
                    }
                    this.tStep += this.dtMs - l2;
                    if (this.tStep < 1L) {
                        this.tStep = 1L;
                    }
                    this.spectrum.perturb(this.dt);
                    this.t += this.dt;
                    this.field.setTime(this.t, this.dt);
                    this.pct = l;
                }
            }
            try {
                Thread.sleep(this.tStep);
            }
            catch (Exception exception) {}
        }
    }
}

