/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.QuantumSoccer;

import egan.graphics.GraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class Spectrum
extends Panel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    Dimension pd;
    Image I;
    Image bg;
    int nx;
    int ny;
    boolean ok = false;
    boolean bgOK = false;
    boolean preview = false;
    boolean enabled = true;
    int prevX;
    int prevY;
    float[][][][] gAmp;
    float[][][] amp;
    boolean[][][] gS;
    boolean[][] s;
    float[][] freq;
    float[] cosP = new float[100];
    float[] sinP = new float[100];
    int hspan = 0;
    int vspan;
    int boxH;
    int boxV;
    int boxR;
    int fh;
    int numLinked = 0;
    int[] linkedStates = new int[100];
    short[][][][] pairIndex;
    int[] previewLinks;

    Spectrum(Color color, int n, int n2, int n3, int n4, int n5, int n6) {
        this.setBackground(color);
        this.pd = new Dimension(n, n2);
        this.nx = n3;
        this.ny = n4;
        int n7 = n3 + 1;
        int n8 = n4 + 1;
        this.gAmp = new float[3][n7][n8][2];
        this.gS = new boolean[3][n7][n8];
        this.freq = new float[n7][n8];
        this.pairIndex = new short[n3][n4][n3][n4];
        float f = (n5 - 1) * (n5 - 1);
        float f2 = (n6 - 1) * (n6 - 1);
        float f3 = 2.5f * (1.0f / f + 1.0f / f2);
        for (int i = 1; i <= this.nx; ++i) {
            for (int j = 1; j <= this.ny; ++j) {
                this.freq[i][j] = (float)Math.round(100.0f * ((float)(i * i) / f + (float)(j * j) / f2) / 8.0f / f3) / 100.0f;
            }
        }
        this.amp = this.gAmp[0];
        this.s = this.gS[0];
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pd;
    }

    public synchronized void reset(boolean bl) {
        this.numLinked = 0;
        this.pairIndex = new short[this.nx][this.ny][this.nx][this.ny];
        if (bl) {
            if (this.preview) {
                this.mouseReleased(null);
            }
            for (int i = 1; i <= this.nx; ++i) {
                for (int j = 1; j <= this.ny; ++j) {
                    this.amp[i][j][1] = 0.0f;
                    this.amp[i][j][0] = 0.0f;
                    this.s[i][j] = false;
                }
            }
            this.amp[1][2][0] = -0.707f;
            this.s[1][2] = true;
            this.amp[2][1][0] = 0.707f;
            this.s[2][1] = true;
        }
        this.ok = false;
        this.bgOK = false;
        this.repaint();
    }

    public synchronized void setPreviewLinks(int[] nArray) {
        this.previewLinks = nArray;
        this.ok = false;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public synchronized void update(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5 = this.getSize().width;
        int n6 = this.getSize().height;
        if (this.bg == null) {
            this.bg = this.createImage(n5, n6);
            this.bgOK = false;
        }
        if (!this.bgOK) {
            Object object2;
            object = this.getFont();
            if (this.hspan == 0) {
                object2 = this.getFontMetrics((Font)object);
                this.fh = ((FontMetrics)object2).getAscent() + 1;
                this.hspan = n5 / this.nx;
                this.vspan = n6 / this.ny;
                this.boxH = this.hspan - 4;
                this.boxV = this.vspan - this.fh - 4;
                this.boxR = Math.min(this.boxH / 2 - 1, this.boxV / 2 - 1);
            }
            object2 = this.bg.getGraphics();
            GraphicsUtils.setAA((Graphics)object2);
            ((Graphics)object2).setColor(this.getBackground());
            ((Graphics)object2).fillRect(0, 0, n5, n6);
            ((Graphics)object2).setFont((Font)object);
            ((Graphics)object2).setColor(Color.gray);
            this.showLinkages((Graphics)object2, this.linkedStates, this.numLinked);
            n4 = 4;
            n3 = 1;
            while (n3 <= this.nx) {
                n2 = 2;
                n = 1;
                while (n <= this.ny) {
                    ((Graphics)object2).setColor(Color.lightGray);
                    ((Graphics)object2).drawRect(n4, n2, this.boxH - 1, this.boxV);
                    ((Graphics)object2).setColor(Color.yellow);
                    ((Graphics)object2).drawString("" + (int)(1000.0f * this.freq[n3][n]), n4 + 4, n2 + this.boxV + this.fh);
                    ++n;
                    n2 += this.vspan;
                }
                ++n3;
                n4 += this.hspan;
            }
            ((Graphics)object2).dispose();
            this.bgOK = true;
        }
        if (this.I == null) {
            this.I = this.createImage(n5, n6);
            this.ok = false;
        }
        if (!this.ok) {
            object = this.I.getGraphics();
            ((Graphics)object).drawImage(this.bg, 0, 0, null);
            GraphicsUtils.setAA((Graphics)object);
            int n7 = 4;
            n4 = 1;
            while (n4 <= this.nx) {
                n3 = n7 + this.boxH / 2;
                n2 = 2;
                n = 1;
                while (n <= this.ny) {
                    if (this.s[n4][n]) {
                        int n8 = n2 + this.boxV / 2;
                        float f = this.amp[n4][n][0];
                        float f2 = this.amp[n4][n][1];
                        float f3 = (float)Math.sqrt(f * f + f2 * f2);
                        ((Graphics)object).setColor(Math.abs(f) > Math.abs(f2) ? (f < 0.0f ? Color.red : Color.blue) : (f2 < 0.0f ? Color.white : Color.cyan));
                        ((Graphics)object).fillRect(n7 + 1, n2 + 1, (int)(f3 * (float)(this.boxH - 2)), this.boxV - 1);
                        ((Graphics)object).setColor(Color.black);
                        ((Graphics)object).drawRect(n7, n2, this.boxH - 1, this.boxV);
                        ((Graphics)object).drawLine(n3, n8, n3 + (int)(f * (float)this.boxR / f3), n8 - (int)(f2 * (float)this.boxR / f3));
                        ((Graphics)object).drawOval(n3 - this.boxR, n8 - this.boxR, 2 * this.boxR, 2 * this.boxR);
                    }
                    ++n;
                    n2 += this.vspan;
                }
                ++n4;
                n7 += this.hspan;
            }
            if (this.previewLinks != null) {
                ((Graphics)object).setColor(new Color(0x990000));
                this.showLinkages((Graphics)object, this.previewLinks, this.previewLinks.length);
            }
            ((Graphics)object).dispose();
            this.ok = true;
        }
        graphics.drawImage(this.I, 0, 0, null);
    }

    public void showLinkages(Graphics graphics, int[] nArray, int n) {
        int n2;
        int n3 = 4 + this.boxH / 2;
        int n4 = 2 + this.boxV / 2;
        int n5 = 0;
        while (n5 < n && (n2 = nArray[n5++]) != 0) {
            int n6 = ((n2 & 0x3F) - 1) * this.hspan + n3;
            int n7 = ((n2 >> 6 & 0x3F) - 1) * this.vspan + n4;
            int n8 = ((n2 >> 12 & 0x3F) - 1) * this.hspan + n3;
            int n9 = ((n2 >> 18 & 0x3F) - 1) * this.vspan + n4;
            graphics.drawLine(n6, n7, n8, n9);
            graphics.fillRect(n6 - 2, n7 - 2, 5, 5);
            graphics.fillRect(n8 - 2, n9 - 2, 5, 5);
        }
    }

    public synchronized int[] setPairs(float f, float f2) {
        int[] nArray = new int[50];
        int n = 0;
        float f3 = f / 2.0f;
        float f4 = f2 / 2.0f;
        for (int i = 1; i <= this.nx; ++i) {
            for (int j = 1; j <= this.ny; ++j) {
                float f5 = this.freq[i][j];
                for (int k = 1; k <= this.nx; ++k) {
                    for (int i2 = 1; i2 <= this.ny; ++i2) {
                        float f6;
                        float f7 = this.freq[k][i2] - f5;
                        if (!(f6 > 0.0f)) continue;
                        boolean bl = true;
                        for (int i3 = -1; bl && i3 <= 1; i3 += 2) {
                            for (int i4 = -1; bl && i4 <= 1; i4 += 2) {
                                for (int i5 = -1; bl && i5 <= 1; i5 += 2) {
                                    for (int i6 = -1; bl && i6 <= 1; i6 += 2) {
                                        if (!(Math.abs(f7 - (float)i6 * (f3 * (float)(k + i3 * i) + (float)i4 * f4 * (float)(i2 + i5 * j))) < 0.001f)) continue;
                                        if (n + 1 >= nArray.length) {
                                            int[] nArray2 = nArray;
                                            nArray = new int[n + 50];
                                            System.arraycopy(nArray2, 0, nArray, 0, n);
                                        }
                                        nArray[n++] = i + (j << 6) + (k << 12) + (i2 << 18) + (i3 + 1 << 23) + (i4 + 1 << 24) + (i5 + 1 << 25) + (i6 + 1 << 26);
                                        bl = false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        nArray[n] = 0;
        return nArray;
    }

    public synchronized float[][] setPhases(float[][] fArray, int[] nArray, float f, float f2, float f3, float f4, float f5) {
        int n;
        if (f == 0.0f && f2 == 0.0f) {
            return fArray;
        }
        int n2 = nArray.length;
        float[][] fArray2 = fArray == null || fArray.length < n2 ? new float[n2][2] : fArray;
        int n3 = 1;
        int n4 = 1;
        if (f < 0.0f) {
            n3 = -1;
            if (f2 > 0.0f) {
                n4 = -1;
            }
        } else if (f2 < 0.0f) {
            n4 = -1;
        }
        float f6 = f3 - f * f5;
        float f7 = 1.0f - f4 - f2 * 2.0f * f5;
        for (int i = 0; i < n2 && (n = nArray[i]) != 0; ++i) {
            int n5 = n & 0x3F;
            int n6 = n >> 6 & 0x3F;
            int n7 = n >> 12 & 0x3F;
            int n8 = n >> 18 & 0x3F;
            int n9 = (n >> 23 & 2) - 1;
            int n10 = n4 * ((n >> 24 & 2) - 1);
            int n11 = (n >> 25 & 2) - 1;
            int n12 = n3 * ((n >> 26 & 2) - 1);
            double d = (double)(-n12) * Math.PI * (double)(f6 * (float)(n7 + n9 * n5) + (float)n10 * f7 * (float)(n8 + n11 * n6));
            float f8 = n9 * n11;
            fArray2[i][0] = f8 * (float)Math.cos(d);
            fArray2[i][1] = f8 * (float)Math.sin(d);
        }
        return fArray2;
    }

    public synchronized void setPerturb(int[] nArray, float[][] fArray, float f, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (nArray == null || fArray == null) {
            return;
        }
        int n8 = nArray.length;
        for (n7 = 0; n7 < n8 && (n6 = nArray[n7]) != 0; ++n7) {
            n5 = (n6 & 0x3F) - 1;
            n4 = (n6 >> 6 & 0x3F) - 1;
            n3 = (n6 >> 12 & 0x3F) - 1;
            n2 = (n6 >> 18 & 0x3F) - 1;
            n = this.pairIndex[n5][n4][n3][n2] - 1;
            if (n == -1) {
                n = this.numLinked;
            }
            if (n >= this.linkedStates.length) {
                int[] nArray2 = this.linkedStates;
                float[] fArray2 = this.cosP;
                float[] fArray3 = this.sinP;
                this.linkedStates = new int[n + 100];
                this.cosP = new float[n + 100];
                this.sinP = new float[n + 100];
                System.arraycopy(nArray2, 0, this.linkedStates, 0, this.numLinked);
                System.arraycopy(fArray2, 0, this.cosP, 0, this.numLinked);
                System.arraycopy(fArray3, 0, this.sinP, 0, this.numLinked);
            }
            if (n == this.numLinked) {
                this.sinP[n] = 0.0f;
                this.cosP[n] = 0.0f;
                this.linkedStates[n] = n6;
                ++this.numLinked;
                this.pairIndex[n5][n4][n3][n2] = (short)this.numLinked;
            }
            int n9 = n;
            this.cosP[n9] = this.cosP[n9] + f * fArray[n7][0];
            int n10 = n;
            this.sinP[n10] = this.sinP[n10] + f * fArray[n7][1];
        }
        if (bl) {
            n7 = 0;
            for (n = 0; n < this.numLinked; ++n) {
                n6 = this.linkedStates[n];
                n5 = (n6 & 0x3F) - 1;
                n4 = (n6 >> 6 & 0x3F) - 1;
                n3 = (n6 >> 12 & 0x3F) - 1;
                n2 = (n6 >> 18 & 0x3F) - 1;
                if (Math.abs(this.cosP[n]) > 1.0E-4f || Math.abs(this.sinP[n]) > 1.0E-4f) {
                    if (n7 != n) {
                        this.linkedStates[n7] = n6;
                        this.cosP[n7] = this.cosP[n];
                        this.sinP[n7] = this.sinP[n];
                        this.pairIndex[n5][n4][n3][n2] = (short)(n7 + 1);
                    }
                    ++n7;
                    continue;
                }
                this.pairIndex[n5][n4][n3][n2] = 0;
            }
            this.numLinked = n7;
        }
        this.ok = false;
        this.bgOK = false;
    }

    public synchronized void perturb(float f) {
        if (this.linkedStates != null && this.numLinked != 0 && !this.preview) {
            float f2;
            int n;
            int n2;
            float f3 = 0.03f * f;
            for (int i = 0; i < this.numLinked; ++i) {
                n2 = this.linkedStates[i];
                int n3 = n2 & 0x3F;
                int n4 = n2 >> 6 & 0x3F;
                n = n2 >> 12 & 0x3F;
                int n5 = n2 >> 18 & 0x3F;
                if (!this.s[n3][n4] && !this.s[n][n5]) continue;
                f2 = f3 * this.cosP[i];
                float f4 = f3 * this.sinP[i];
                float[] fArray = this.amp[n3][n4];
                float[] fArray2 = this.amp[n][n5];
                float f5 = fArray[0];
                float f6 = fArray[1];
                float f7 = fArray2[0];
                float f8 = fArray2[1];
                fArray2[0] = fArray2[0] + (f2 * f6 + f4 * f5);
                fArray2[1] = fArray2[1] + (f4 * f6 - f2 * f5);
                fArray[0] = fArray[0] + (f2 * f8 - f4 * f7);
                fArray[1] = fArray[1] + (-f4 * f8 - f2 * f7);
            }
            float f9 = 0.0f;
            for (n2 = 1; n2 <= this.nx; ++n2) {
                float[][] fArray = this.amp[n2];
                boolean[] blArray = this.s[n2];
                for (n = 1; n <= this.ny; ++n) {
                    float[] fArray3 = fArray[n];
                    f2 = fArray3[0] * fArray3[0] + fArray3[1] * fArray3[1];
                    blArray[n] = f2 > 1.0000001E-6f;
                    if (!blArray[n]) continue;
                    f9 += f2;
                }
            }
            f9 = (float)Math.sqrt(f9);
            for (n2 = 1; n2 <= this.nx; ++n2) {
                float[][] fArray = this.amp[n2];
                boolean[] blArray = this.s[n2];
                for (n = 1; n <= this.ny; ++n) {
                    if (!blArray[n]) continue;
                    float[] fArray4 = fArray[n];
                    fArray4[0] = fArray4[0] / f9;
                    float[] fArray5 = fArray[n];
                    fArray5[1] = fArray5[1] / f9;
                }
            }
            this.ok = false;
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.enabled) {
            if (this.preview) {
                this.mouseReleased(mouseEvent);
            }
            if (mouseEvent.isShiftDown()) {
                this.amp = this.gAmp[1];
                this.s = this.gS[1];
                this.prevX = 0;
                this.preview = true;
            } else {
                int n3 = n - 4;
                int n4 = n2 - 2;
                int n5 = n3 / this.hspan;
                int n6 = n4 / this.vspan;
                int n7 = n3 % this.hspan;
                int n8 = n4 % this.vspan;
                if (n3 >= 0 && n5 < this.nx && n4 >= 0 && n6 < this.ny && n7 <= this.boxH && n8 <= this.boxV) {
                    this.amp = this.gAmp[2];
                    this.s = this.gS[2];
                    this.amp[++n5][++n6][0] = 1.0f;
                    this.s[n5][n6] = true;
                    this.prevX = n5;
                    this.prevY = n6;
                    this.preview = true;
                }
            }
            this.ok = false;
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (this.enabled && this.preview) {
            if (this.prevX > 0) {
                this.amp[this.prevX][this.prevY][0] = 0.0f;
                this.s[this.prevX][this.prevY] = false;
            }
            this.amp = this.gAmp[0];
            this.s = this.gS[0];
            this.preview = false;
            this.ok = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mousePressed(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public synchronized void setBest(double[][] dArray, double[][] dArray2) {
        double[] dArray3 = this.ev(dArray);
        double[] dArray4 = this.ev(dArray2);
        for (int i = 1; i <= this.nx; ++i) {
            for (int j = 1; j <= this.ny; ++j) {
                float f;
                float[] fArray = this.gAmp[1][i][j];
                fArray[0] = (float)(dArray3[i] * dArray4[j]);
                this.gS[1][i][j] = Math.abs(f) > 0.001f;
                fArray[1] = 0.0f;
            }
        }
    }

    double[] ev(double[][] dArray) {
        int n;
        int n2 = dArray.length - 1;
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        double d = 0.0;
        double d2 = (float)Math.sqrt(1.0 / (double)n2);
        for (n = 1; n <= n2; ++n) {
            dArray2[n] = d2;
        }
        for (int i = 0; i < 2000; ++i) {
            for (n = 1; n <= n2; ++n) {
                dArray3[n] = 0.0;
                for (int j = 1; j <= n2; ++j) {
                    int n3 = n;
                    dArray3[n3] = dArray3[n3] + dArray[n][j] * dArray2[j];
                }
            }
            double[] dArray4 = dArray3;
            dArray3 = dArray2;
            dArray2 = dArray4;
            d2 = 0.0;
            for (n = 1; n <= n2; ++n) {
                d2 += dArray2[n] * dArray2[n];
            }
            d2 = Math.sqrt(d2);
            d = 0.0;
            for (n = 1; n <= n2; ++n) {
                int n4 = n;
                dArray2[n4] = dArray2[n4] / d2;
                d = Math.max(d, Math.abs(dArray2[n] - dArray3[n]));
            }
            if (d < 1.0E-8) break;
        }
        return dArray2;
    }
}

