/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.QuantumSoccer;

import egan.applets.QuantumSoccer.QuantumSoccer;
import egan.graphics.GraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class Velocity
extends Panel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    static final int gridInc = 4;
    QuantumSoccer parent;
    Dimension pd;
    int vMax;
    int[] xy;
    int xc;
    int yc;
    int gw;
    int gMax;
    Image I;
    Image[] bg = new Image[2];
    boolean frozen = false;
    boolean enabled = true;

    Velocity(QuantumSoccer quantumSoccer, int n, Font font) {
        this.parent = quantumSoccer;
        this.vMax = n;
        this.gw = 8 * (n + 2);
        this.xc = this.yc = this.gw / 2;
        this.pd = new Dimension(this.gw + (font == null ? 55 : this.getFontMetrics(font).stringWidth("vx=" + -n) + 15), this.gw);
        this.xy = new int[2];
        this.gMax = 4 * n;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pd;
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public synchronized void update(Graphics graphics) {
        int n;
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        if (this.I == null) {
            this.I = this.createImage(n2, n3);
        }
        Graphics graphics2 = this.I.getGraphics();
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, n2, n3);
        GraphicsUtils.setAA((Graphics)graphics2);
        int n4 = n = this.enabled ? 0 : 1;
        if (this.bg[n] == null) {
            this.bg[n] = this.createImage(this.gw, this.gw);
            Graphics graphics3 = this.bg[n].getGraphics();
            graphics3.setColor(Color.white);
            graphics3.fillRect(0, 0, this.gw, this.gw);
            Color color = new Color(n == 0 ? 0xCCCCFF : 0xCCCCCC);
            Color color2 = new Color(n == 0 ? 0x9999FF : 0x999999);
            Color color3 = new Color(n == 0 ? 0x6666FF : 0x666666);
            for (int i = -this.vMax; i <= this.vMax; ++i) {
                graphics3.setColor(i % 5 == 0 ? (i == 0 ? color3 : color2) : color);
                graphics3.drawLine(this.xc - 4 * i, this.yc - 4 * this.vMax, this.xc - 4 * i, this.yc + 4 * this.vMax);
                graphics3.drawLine(this.xc - 4 * this.vMax, this.yc - 4 * i, this.xc + 4 * this.vMax, this.yc - 4 * i);
            }
        }
        graphics2.drawImage(this.bg[n], 0, 0, null);
        graphics2.setColor(new Color(0x990000));
        int n5 = this.xc + 4 * this.xy[0];
        int n6 = this.yc - 4 * this.xy[1];
        int n7 = this.xc + 3 * this.xy[0];
        int n8 = this.yc - 3 * this.xy[1];
        if (this.xy[0] != 0 || this.xy[1] != 0) {
            graphics2.drawLine(this.xc, this.yc, n5, n6);
            graphics2.drawLine(n5, n6, n7 + this.xy[1], n8 + this.xy[0]);
            graphics2.drawLine(n5, n6, n7 - this.xy[1], n8 - this.xy[0]);
        } else {
            graphics2.fillRect(this.xc - 1, this.yc - 1, 3, 3);
        }
        graphics2.setColor(this.enabled ? Color.black : Color.gray);
        graphics2.drawString("vx=" + this.xy[0], this.gw + 3, n3 / 3);
        graphics2.drawString("vy=" + this.xy[1], this.gw + 3, 2 * n3 / 3);
        graphics.drawImage(this.I, 0, 0, null);
    }

    public synchronized int getV(int n) {
        return this.xy[n];
    }

    public synchronized void setV(int n, int n2) {
        int n3 = n < -this.vMax ? -this.vMax : (this.xy[0] = n > this.vMax ? this.vMax : n);
        this.xy[1] = n2 < -this.vMax ? -this.vMax : (n2 > this.vMax ? this.vMax : n2);
        this.repaint();
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n - this.xc;
        int n4 = this.yc - n2;
        if (this.enabled && (mouseEvent == null || n3 >= -this.gMax && n3 <= this.gMax && n4 >= -this.gMax && n4 <= this.gMax)) {
            if (!this.frozen) {
                this.parent.stop();
                this.frozen = true;
            }
            int n5 = (int)Math.round((double)n3 / 4.0);
            int n6 = (int)Math.round((double)n4 / 4.0);
            this.setV(n5, n6);
            this.parent.spectrum.setPreviewLinks(this.parent.getPairs(this.xy[0], this.xy[1]));
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (this.enabled) {
            if (this.frozen) {
                this.parent.start();
                this.frozen = false;
            }
            this.parent.setVelocities();
            this.parent.spectrum.setPreviewLinks(null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mousePressed(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void setEnabled(boolean bl) {
        this.enabled = bl;
        this.repaint();
    }
}

