/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Patch;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class QuasiMusic
extends JApplet
implements MetaEventListener {
    private static final long serialVersionUID = 1L;
    static boolean getSoundbank = false;
    static boolean forVideo = false;
    static boolean currentlyMakingVideo = false;
    final Color selCol = Color.yellow;
    final Color playCol = Color.green;
    final int defaultDim = 7;
    final int defaultScale = 6;
    final int defaultChannels = 16;
    final long defaultSeed = 23456789L;
    final int minDim = 4;
    final int maxDim = 12;
    final int minScale = 1;
    final int maxScale = 12;
    final long defaultTimeStep = 100L;
    final long videoTimeStep = 100L;
    final int keyTranspose = 24;
    final int numOctaves = 6;
    final int numNotes = 72;
    final int[] whiteIDs = new int[]{0, 2, 4, 5, 7, 9, 11};
    final int[] cMinorIDs = new int[]{0, 2, 3, 5, 7, 8, 10};
    final int middleC = 60;
    final int middleBflat = 58;
    final int middleCsharp = 61;
    final int BANK_SELECT = 0;
    final int END_OF_TRACK = 47;
    final int REVERB = 91;
    final int TEXT = 1;
    final int defaultVelocity = 64;
    final int defaultPressure = 64;
    final int defaultReverb = 64;
    final int defaultBend = 8192;
    final int ticksPerBeat = 10;
    final long tilePadding = 1000L;
    final int tickDenom = 500;
    final String flat = "\u266d";
    final String sharp = "\u266f";
    final String[] octave = new String[]{"C", "C\u266f", "D", "D\u266f", "E", "F", "F\u266f", "G", "G\u266f", "A", "A\u266f", "B"};
    final String secMsg = "When running QuasiMusic as an applet,\nextra Java permissions are needed in\norder to load or save files.\nTo load/save files, it's better to\ndownload the application version of QuasiMusic.";
    TilePanel tilePanel = null;
    TileControls tileControls = null;
    boolean isAnApplet = false;
    TitledBorder titledBorder = null;
    static QuasiMusic currentQuasiMusic = null;
    MidiSynth midiSynth = null;

    public QuasiMusic() {
        this.setLayout(new BorderLayout());
        this.midiSynth = new MidiSynth(this);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.titledBorder = new TitledBorder(new EtchedBorder(new Color(100, 100, 127), new Color(50, 50, 64)), " Untitled ", 2, 2);
        EmptyBorder eb = new EmptyBorder(2, 2, 2, 2);
        CompoundBorder cb = new CompoundBorder(eb, this.titledBorder);
        p.setBorder(new CompoundBorder(cb, eb));
        JPanel pp = new JPanel(new BorderLayout());
        pp.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.tilePanel = new TilePanel(this, 7, 6, 4, 12, 1, 12, forVideo ? 100L : 100L, 16, 0);
        pp.add(this.tilePanel);
        p.add(pp);
        this.tilePanel.prepareDemos();
        this.tileControls = new TileControls(this, this.tilePanel, 7, 6, 4, 12, 1, 12, 16, this.tilePanel.getDemoToolTips());
        p.add(this.tileControls);
        p.add(this.midiSynth);
        this.add(p);
        this.isAnApplet = false;
    }

    @Override
    public void stop() {
        if (this.midiSynth != null) {
            this.midiSynth.close();
        }
    }

    @Override
    public void init() {
        this.isAnApplet = true;
        this.tileControls.forbidIO();
    }

    public boolean runningAsApplet() {
        return this.isAnApplet;
    }

    public static void main(String[] args) {
        int h;
        int w;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("video")) {
                forVideo = true;
            }
            if (!args[i].equals("soundbank")) continue;
            getSoundbank = true;
        }
        if (forVideo) {
            w = 1330;
            h = 1150;
        } else {
            w = 900;
            h = 800;
        }
        currentQuasiMusic = new QuasiMusic();
        JFrame f = new JFrame("QuasiMusic");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add("Center", currentQuasiMusic);
        f.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        f.setLocation(screenSize.width / 2 - w / 2, screenSize.height / 2 - h / 2);
        f.setSize(w, h);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (currentQuasiMusic != null) {
                    currentQuasiMusic.stop();
                }
            }
        }));
        f.setVisible(true);
    }

    public static void showErrorMessage(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error", 0);
    }

    public void setTitle(String t) {
        this.titledBorder.setTitle(" " + t + " ");
    }

    private Sequence makeEmptySequence() {
        try {
            return new Sequence(0.0f, 10);
        }
        catch (Exception ex) {
            QuasiMusic.showErrorMessage("There were problems creating a MIDI sequence:\n" + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    public long ticksFromMillis(long millis, Sequence s) {
        return millis * (long)s.getResolution() / 500L;
    }

    public long millisFromTicks(long ticks, Sequence s) {
        return ticks * 500L / (long)s.getResolution();
    }

    @Override
    public void meta(MetaMessage message) {
        int type = message.getType();
        if (type == 47) {
            this.tilePanel.donePlaying();
        } else if (type == 1) {
            this.tilePanel.textMessage(message.getData());
        }
    }

    public void setChannel(int ci) {
        this.midiSynth.setChannel(ci);
        this.tilePanel.setChannel(ci);
    }

    public class MidiSynth
    extends JPanel {
        private static final long serialVersionUID = 1L;
        final int ON = 0;
        final int OFF = 1;
        Sequencer sequencer;
        Sequence sequence;
        Synthesizer synthesizer;
        Soundbank soundbank;
        Instrument[] validInstruments = null;
        boolean[] loadedInstruments;
        int[][] bpi = null;
        int unknownInstrument;
        int nValidInstruments = 0;
        ChannelData[] channels;
        ChannelData cc;
        JSlider veloS;
        JSlider presS;
        JSlider bendS;
        JSlider revbS;
        Vector<Key> keys = new Vector();
        JTable table;
        Piano piano;
        boolean record;
        Track track;
        long startTime;
        long lastNoteOff;
        int lastNote;
        int recNoteCount;
        Controls controls;
        int maxVoices;
        int nRows = 8;
        int nCols;
        QuasiMusic parent;

        public MidiSynth(QuasiMusic parent) {
            this.open();
            this.parent = parent;
            this.setLayout(new BorderLayout());
            this.setMaximumSize(forVideo ? new Dimension(1280, 100) : new Dimension(900, 400));
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, forVideo ? 0 : 1));
            p.setBorder(new EmptyBorder(2, 2, 2, 2));
            JPanel pp = new JPanel(new BorderLayout());
            pp.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.piano = new Piano();
            pp.add(this.piano);
            p.add(pp);
            this.controls = new Controls();
            p.add(this.controls);
            p.add(new InstrumentsTable());
            this.add(p);
            ListSelectionModel lsm = this.table.getSelectionModel();
            lsm.setSelectionInterval(0, 0);
            lsm = this.table.getColumnModel().getSelectionModel();
            lsm.setSelectionInterval(0, 0);
        }

        public void open() {
            boolean customSoundbank;
            try {
                if (this.synthesizer == null && (this.synthesizer = MidiSystem.getSynthesizer()) == null) {
                    QuasiMusic.showErrorMessage("Unable to access MIDI synthesizer");
                    return;
                }
                this.synthesizer.open();
                this.sequencer = MidiSystem.getSequencer(false);
                this.sequencer.open();
                this.sequencer.getTransmitter().setReceiver(this.synthesizer.getReceiver());
                this.sequence = QuasiMusic.this.makeEmptySequence();
                this.maxVoices = this.synthesizer.getMaxPolyphony();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems opening the MIDI resources:\n" + ex.getMessage());
                ex.printStackTrace();
                return;
            }
            this.soundbank = null;
            if (getSoundbank) {
                this.soundbank = this.manuallySelectSoundbank();
            }
            if (this.soundbank == null) {
                customSoundbank = false;
                this.soundbank = this.synthesizer.getDefaultSoundbank();
            } else {
                customSoundbank = true;
            }
            if (this.soundbank == null) {
                QuasiMusic.showErrorMessage("You have no Java soundbank installed.\nYou will need to download and install one\nfrom http://java.sun.com/products/java-media/sound/soundbanks.html\nin order to use this applet.");
            } else {
                if (getSoundbank) {
                    this.describeSoundbank(this.soundbank);
                }
                int nBanks = 8;
                this.unknownInstrument = 128 * nBanks;
                this.validInstruments = new Instrument[this.unknownInstrument];
                this.loadedInstruments = new boolean[this.unknownInstrument];
                this.nValidInstruments = 0;
                this.bpi = new int[nBanks][128];
                for (int bank = 0; bank < nBanks; ++bank) {
                    for (int program = 0; program < 128; ++program) {
                        Instrument instr = this.soundbank.getInstrument(new Patch(bank, program));
                        if (instr == null) {
                            this.bpi[bank][program] = this.unknownInstrument;
                            continue;
                        }
                        this.bpi[bank][program] = this.nValidInstruments;
                        this.validInstruments[this.nValidInstruments++] = instr;
                    }
                }
                this.synthesizer.loadInstrument(this.validInstruments[0]);
                this.loadedInstruments[0] = true;
            }
            MidiChannel[] midiChannels = this.synthesizer.getChannels();
            this.channels = new ChannelData[midiChannels.length];
            for (int i = 0; i < this.channels.length; ++i) {
                if (midiChannels[i] == null) continue;
                this.channels[i] = new ChannelData(midiChannels[i], i);
            }
            this.cc = this.channels[0];
        }

        public void close() {
            if (this.synthesizer != null) {
                this.synthesizer.close();
            }
            if (this.sequencer != null) {
                this.sequencer.close();
            }
            this.sequencer = null;
            this.synthesizer = null;
            this.validInstruments = null;
            this.channels = null;
        }

        public synchronized void setChannel(int ci) {
            this.cc = this.channels[ci];
            this.cc.setComponentStates();
        }

        public int instrumentNumber(int bank, int program) {
            if (bank >= this.bpi.length) {
                return this.unknownInstrument;
            }
            return this.bpi[bank][program];
        }

        public String instrumentName(int bank, int program) {
            int instrNum = this.instrumentNumber(bank, program);
            if (instrNum == this.unknownInstrument) {
                return "Unknown instrument";
            }
            return this.validInstruments[instrNum].getName();
        }

        public String describeTrack(Track tr, Sequence sequence, boolean showInstruments, boolean showNotes, boolean showTime) {
            StringBuffer sb = new StringBuffer(128);
            StringBuffer nb = new StringBuffer(128);
            int n = tr.size();
            boolean[] seen = new boolean[this.unknownInstrument + 1];
            long prevTick = -1L;
            boolean sNotes = showNotes;
            boolean sInstruments = showInstruments;
            byte bank = 0;
            for (int ee = 0; ee < n; ++ee) {
                MidiEvent event = tr.get(ee);
                MidiMessage msg = event.getMessage();
                int status = msg.getStatus();
                int type = status & 0xF0;
                if (type == 176 && sInstruments && msg.getMessage()[1] == 0) {
                    bank = msg.getMessage()[2];
                    continue;
                }
                if (type == 192 && sInstruments) {
                    byte program = msg.getMessage()[1];
                    int instr = this.instrumentNumber(bank, program);
                    if (seen[instr]) continue;
                    seen[instr] = true;
                    if (sb.length() > 40) {
                        sb.append(", etc.");
                        sInstruments = false;
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.instrumentName(bank, program));
                    while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                        sb.setLength(sb.length() - 1);
                    }
                    continue;
                }
                if (type != 144 || !sNotes) continue;
                int note = ((ShortMessage)msg).getData1();
                int posN = note - 60 + 1200;
                String noteName = QuasiMusic.this.octave[posN % 12] + (posN / 12 - 96);
                long tick = event.getTick();
                if (nb.length() > 40) {
                    nb.append(" etc.");
                    sNotes = false;
                    continue;
                }
                if (nb.length() > 0) {
                    if (tick == prevTick) {
                        nb.append("-");
                    } else {
                        nb.append(" ");
                    }
                }
                prevTick = tick;
                nb.append(noteName);
            }
            if (showNotes) {
                sb.append(" ");
                sb.append(nb);
            }
            if (showTime) {
                sb.append(" (" + (QuasiMusic.this.millisFromTicks(tr.ticks(), sequence) - 1000L) + " ms)");
            }
            return sb.toString();
        }

        public void allSoundOff() {
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i].channel.allSoundOff();
            }
        }

        public void createShortEvent(int type, int data1, int data2, long m) {
            ShortMessage message = new ShortMessage();
            try {
                long millis = 0L;
                if (this.startTime < 0L) {
                    this.startTime = System.currentTimeMillis();
                } else {
                    millis = System.currentTimeMillis() - this.startTime;
                }
                if (m != -1L) {
                    millis = m;
                }
                if (type == 128) {
                    this.lastNoteOff = millis;
                    this.lastNote = data1;
                }
                long tick = QuasiMusic.this.ticksFromMillis(millis, this.sequence);
                if (type == 192 || type == 208) {
                    message.setMessage(type + this.cc.num, data1, 0);
                } else {
                    message.setMessage(type + this.cc.num, data1, data2);
                }
                MidiEvent event = new MidiEvent(message, tick);
                this.track.add(event);
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems creating a MIDI message:\n" + ex.getMessage());
                ex.printStackTrace();
            }
        }

        public void noteOnEvent(int note, boolean needDetails) {
            if (needDetails) {
                this.createShortEvent(176, 0, this.cc.getBank(), -1L);
                this.createShortEvent(192, this.cc.getProgram(), 0, -1L);
                this.createShortEvent(208, this.cc.pressure, 0, -1L);
                this.createShortEvent(176, 91, this.cc.reverb, -1L);
                int lo7 = this.cc.bend & 0x7F;
                int hi7 = this.cc.bend >> 7 & 0x7F;
                this.createShortEvent(224, lo7, hi7, -1L);
            }
            this.createShortEvent(144, note, this.cc.velocity, -1L);
        }

        public void noteOffEvent(int note) {
            this.createShortEvent(128, note, this.cc.velocity, -1L);
        }

        public void startRecording() {
            this.record = true;
            this.track = this.sequence.createTrack();
            this.startTime = -1L;
            this.lastNoteOff = 0L;
            this.recNoteCount = 0;
        }

        public Sequence getRecording() {
            this.record = false;
            if (this.recNoteCount == 0) {
                this.sequence.deleteTrack(this.track);
                this.track = null;
                return null;
            }
            this.createShortEvent(128, this.lastNote, this.cc.velocity, this.lastNoteOff + 1000L);
            Sequence s = this.sequence;
            this.sequence = QuasiMusic.this.makeEmptySequence();
            return s;
        }

        public void playBack(Sequence s) {
            if (s == null) {
                return;
            }
            try {
                if (!this.sequencer.isOpen()) {
                    this.sequencer.open();
                }
                if (this.sequencer.isRunning()) {
                    this.sequencer.stop();
                }
                this.synthesizer.loadInstruments(this.soundbank, s.getPatchList());
                this.sequencer.setSequence(s);
                this.sequencer.setTickPosition(0L);
                this.sequencer.addMetaEventListener(this.parent);
                this.sequencer.start();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems playing a MIDI sequence:\n" + ex.getMessage());
                ex.printStackTrace();
            }
        }

        public void stopPlayBack() {
            this.sequencer.stop();
            this.allSoundOff();
        }

        public boolean startPlayingMIDI(File midiIn) {
            if (midiIn == null) {
                return false;
            }
            try {
                Sequence s = MidiSystem.getSequence(midiIn);
                if (!this.sequencer.isOpen()) {
                    this.sequencer.open();
                }
                if (this.sequencer.isRunning()) {
                    this.sequencer.stop();
                }
                this.synthesizer.loadInstruments(this.soundbank, s.getPatchList());
                this.sequencer.setSequence(s);
                this.sequencer.start();
                return true;
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems playing the MIDI file:\n" + ex.getMessage());
                ex.printStackTrace();
                return false;
            }
        }

        private Soundbank manuallySelectSoundbank() {
            try {
                File file = new File(System.getProperty("user.dir"));
                JFileChooser fc = new JFileChooser(file);
                fc.setDialogTitle("Choose soundbank (cancel for default)");
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().endsWith(".sf2") || f.getName().endsWith(".SF2") || f.getName().endsWith(".dls") || f.getName().endsWith(".DLS");
                    }

                    @Override
                    public String getDescription() {
                        return "Files *.sf2, *.dls";
                    }
                });
                if (fc.showOpenDialog(null) == 0) {
                    File sf = fc.getSelectedFile();
                    return MidiSystem.getSoundbank(sf);
                }
            }
            catch (SecurityException ex) {
                QuasiMusic.showErrorMessage("When running QuasiMusic as an applet,\nextra Java permissions are needed in\norder to load or save files.\nTo load/save files, it's better to\ndownload the application version of QuasiMusic.");
                ex.printStackTrace();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems reading the soundbank file:\n" + ex.getMessage());
                ex.printStackTrace();
            }
            return null;
        }

        private void describeSoundbank(Soundbank sb) {
            System.out.println("Soundbank description: " + sb.getDescription());
            System.out.println("Soundbank name: " + sb.getName());
            System.out.println("Soundbank vendor: " + sb.getVendor());
            System.out.println("Soundbank version: " + sb.getVersion());
            Instrument[] instr = sb.getInstruments();
            for (int i = 0; i < instr.length; ++i) {
                Patch p = instr[i].getPatch();
                System.out.println(instr[i].getName() + " [bank: " + p.getBank() + ", program: " + p.getProgram() + "]");
            }
        }

        class Controls
        extends JPanel
        implements ChangeListener {
            private static final long serialVersionUID = 1L;
            public JButton recordB;
            JMenu menu;
            int fileNum = 0;

            public Controls() {
                this.setLayout(new BoxLayout(this, 1));
                this.setBorder(new EmptyBorder(2, 2, 2, 2));
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 0));
                MidiSynth.this.veloS = this.createSlider("Velocity", p, 64);
                MidiSynth.this.presS = this.createSlider("Pressure", p, 64);
                MidiSynth.this.revbS = this.createSlider("Reverb", p, 64);
                MidiSynth.this.bendS = this.create14BitSlider("Pitch Bend", p, 8192);
                p.add(Box.createHorizontalStrut(10));
                this.add(p);
            }

            private JSlider createSlider(String name, JPanel p, int def) {
                JSlider slider = new JSlider(0, 0, 127, def);
                slider.addChangeListener(this);
                TitledBorder tb = new TitledBorder(new EtchedBorder());
                tb.setTitle(" " + name + " = " + def + " ");
                slider.setBorder(tb);
                p.add(slider);
                p.add(Box.createHorizontalStrut(5));
                return slider;
            }

            private JSlider create14BitSlider(String name, JPanel p, int def) {
                JSlider slider = new JSlider(0, 0, 16383, def);
                slider.addChangeListener(this);
                TitledBorder tb = new TitledBorder(new EtchedBorder());
                tb.setTitle(" " + name + " = " + def + " ");
                slider.setBorder(tb);
                p.add(slider);
                p.add(Box.createHorizontalStrut(5));
                return slider;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                int value = slider.getValue();
                TitledBorder tb = (TitledBorder)slider.getBorder();
                String s = tb.getTitle();
                tb.setTitle(s.substring(0, s.indexOf(61) + 2) + String.valueOf(value) + " ");
                if (slider == MidiSynth.this.veloS) {
                    MidiSynth.this.cc.velocity = value;
                } else if (slider == MidiSynth.this.presS) {
                    MidiSynth.this.cc.pressure = value;
                    MidiSynth.this.cc.channel.setChannelPressure(MidiSynth.this.cc.pressure);
                } else if (slider == MidiSynth.this.bendS) {
                    MidiSynth.this.cc.bend = value;
                    MidiSynth.this.cc.channel.setPitchBend(MidiSynth.this.cc.bend);
                } else if (slider == MidiSynth.this.revbS) {
                    MidiSynth.this.cc.reverb = value;
                    MidiSynth.this.cc.channel.controlChange(91, MidiSynth.this.cc.reverb);
                }
                slider.repaint();
            }
        }

        class InstrumentsTable
        extends JPanel {
            private static final long serialVersionUID = 1L;
            private String[] names0 = new String[]{"Piano", "Chromatic Perc.", "Organ", "Guitar", "Bass", "Strings", "Ensemble", "Brass", "Reed", "Pipe", "Synth Lead", "Synth Pad", "Synth Effects", "Ethnic", "Percussive", "Sound Effects"};
            private String[] names;

            public InstrumentsTable() {
                int i;
                MidiSynth.this.nCols = (MidiSynth.this.nValidInstruments + MidiSynth.this.nRows - 1) / MidiSynth.this.nRows;
                this.names = new String[MidiSynth.this.nCols];
                int snames = 0;
                if (this.names.length >= this.names0.length) {
                    for (i = 0; i < this.names0.length; ++i) {
                        this.names[i] = this.names0[i];
                    }
                    snames = this.names0.length;
                }
                for (i = snames; i < MidiSynth.this.nCols; ++i) {
                    this.names[i] = "EXTRAS " + (i - snames + 1);
                }
                this.setLayout(new BorderLayout());
                AbstractTableModel dataModel = new AbstractTableModel(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public int getColumnCount() {
                        return MidiSynth.this.nCols;
                    }

                    @Override
                    public int getRowCount() {
                        return MidiSynth.this.nRows;
                    }

                    @Override
                    public Object getValueAt(int r, int c) {
                        int indx = c * MidiSynth.this.nRows + r;
                        if (indx >= MidiSynth.this.nValidInstruments) {
                            return "";
                        }
                        if (MidiSynth.this.validInstruments != null) {
                            return MidiSynth.this.validInstruments[indx].getName();
                        }
                        return Integer.toString(indx);
                    }

                    @Override
                    public String getColumnName(int c) {
                        return InstrumentsTable.this.names[c];
                    }

                    public Class getColumnClass(int c) {
                        return this.getValueAt(0, c).getClass();
                    }

                    @Override
                    public boolean isCellEditable(int r, int c) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object obj, int r, int c) {
                    }
                };
                MidiSynth.this.table = new JTable(dataModel){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                        Component c = super.prepareRenderer(renderer, row, col);
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            int inum = MidiSynth.this.nRows * col + row;
                            if (inum < MidiSynth.this.nValidInstruments) {
                                Patch p = MidiSynth.this.validInstruments[inum].getPatch();
                                int bank = p.getBank();
                                jc.setToolTipText("MIDI bank " + bank + ", program " + p.getProgram());
                                if (!this.isCellSelected(row, col)) {
                                    if (bank == 0) {
                                        jc.setForeground(Color.black);
                                    } else if (bank == 1) {
                                        jc.setForeground(Color.green.darker());
                                    } else if (bank == 2) {
                                        jc.setForeground(Color.red.darker());
                                    } else {
                                        jc.setForeground(Color.blue.darker());
                                    }
                                }
                            }
                        }
                        return c;
                    }
                };
                MidiSynth.this.table.setSelectionMode(0);
                ListSelectionModel lsm = MidiSynth.this.table.getSelectionModel();
                lsm.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        int row = MidiSynth.this.table.getSelectedRow();
                        int col = MidiSynth.this.table.getSelectedColumn();
                        if (row < 0 || col < 0) {
                            return;
                        }
                        int indx = col * MidiSynth.this.nRows + row;
                        if (indx >= MidiSynth.this.nValidInstruments) {
                            row = (MidiSynth.this.nValidInstruments - 1) % MidiSynth.this.nRows;
                            ((ListSelectionModel)e.getSource()).setSelectionInterval(row, row);
                            return;
                        }
                        MidiSynth.this.cc.row = row;
                    }
                });
                lsm = MidiSynth.this.table.getColumnModel().getSelectionModel();
                lsm.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        int row = MidiSynth.this.table.getSelectedRow();
                        int col = MidiSynth.this.table.getSelectedColumn();
                        if (row < 0 || col < 0) {
                            return;
                        }
                        int indx = col * MidiSynth.this.nRows + row;
                        if (indx >= MidiSynth.this.nValidInstruments) {
                            col = MidiSynth.this.nCols - 2;
                            ((ListSelectionModel)e.getSource()).setSelectionInterval(col, col);
                            return;
                        }
                        MidiSynth.this.cc.col = col;
                    }
                });
                MidiSynth.this.table.setPreferredScrollableViewportSize(new Dimension(MidiSynth.this.nCols * 110, 200));
                MidiSynth.this.table.setCellSelectionEnabled(true);
                MidiSynth.this.table.setColumnSelectionAllowed(true);
                for (int i2 = 0; i2 < MidiSynth.this.nCols; ++i2) {
                    TableColumn column = MidiSynth.this.table.getColumn(this.names[i2]);
                    column.setPreferredWidth(110);
                }
                MidiSynth.this.table.setAutoResizeMode(0);
                JScrollPane sp = new JScrollPane(MidiSynth.this.table);
                sp.setVerticalScrollBarPolicy(21);
                sp.setHorizontalScrollBarPolicy(32);
                this.add(sp);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(884, 170);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(884, 170);
            }
        }

        class ChannelData {
            MidiChannel channel;
            int velocity;
            int pressure;
            int bend;
            int reverb;
            int row;
            int col;
            int inum;
            int num;

            public ChannelData(MidiChannel channel, int num) {
                this.channel = channel;
                this.num = num;
                this.velocity = 64;
                this.pressure = 64;
                this.bend = 8192;
                this.reverb = 64;
                this.inum = -1;
                this.row = 0;
                this.col = 0;
                this.ensureProgram();
                channel.setChannelPressure(this.pressure);
                channel.setPitchBend(this.bend);
                channel.controlChange(91, this.reverb);
            }

            public void setComponentStates() {
                MidiSynth.this.table.setRowSelectionInterval(this.row, this.row);
                MidiSynth.this.table.setColumnSelectionInterval(this.col, this.col);
                JSlider[] slider = new JSlider[]{MidiSynth.this.veloS, MidiSynth.this.presS, MidiSynth.this.bendS, MidiSynth.this.revbS};
                int[] v = new int[]{this.velocity, this.pressure, this.bend, this.reverb};
                for (int i = 0; i < slider.length; ++i) {
                    TitledBorder tb = (TitledBorder)slider[i].getBorder();
                    String s = tb.getTitle();
                    tb.setTitle(s.substring(0, s.indexOf(61) + 2) + String.valueOf(v[i]) + " ");
                    slider[i].setValue(v[i]);
                    slider[i].repaint();
                }
            }

            public int validInstrumentNumber() {
                return this.col * MidiSynth.this.nRows + this.row;
            }

            public void ensureProgram() {
                if (MidiSynth.this.validInstruments != null) {
                    int inumRC;
                    this.inum = inumRC = this.validInstrumentNumber();
                    Instrument instr = MidiSynth.this.validInstruments[this.inum];
                    if (!MidiSynth.this.loadedInstruments[this.inum]) {
                        MidiSynth.this.synthesizer.loadInstrument(instr);
                        MidiSynth.this.loadedInstruments[this.inum] = true;
                    }
                    Patch p = instr.getPatch();
                    this.channel.programChange(p.getBank(), p.getProgram());
                }
            }

            public int getBank() {
                int inumRC = this.validInstrumentNumber();
                return MidiSynth.this.validInstruments[inumRC].getPatch().getBank();
            }

            public int getProgram() {
                int inumRC = this.validInstrumentNumber();
                return MidiSynth.this.validInstruments[inumRC].getPatch().getProgram();
            }
        }

        class Piano
        extends JPanel
        implements MouseListener {
            private static final long serialVersionUID = 1L;
            int numChords = 10;
            int ch = 10;
            int cw = 30;
            int kw = forVideo ? 6 : 20;
            int kh = this.numChords * this.ch;
            int bkw = this.kw / 2;
            int hbkw = this.bkw / 2;
            int bkh = this.kh / 2;
            int xChord = 42 * this.kw;
            Vector<Key> blackKeys = new Vector();
            Vector<Key> whiteKeys = new Vector();
            Vector<Key> chordKeys = new Vector();
            Key prevKey;
            int selectedChord = -1;
            int[] keyCentres = new int[72];

            public Piano() {
                int i;
                this.setLayout(new BorderLayout());
                this.setPreferredSize(new Dimension(this.xChord + this.cw, this.kh + 1));
                int x = 0;
                for (i = 0; i < 6; ++i) {
                    int j = 0;
                    while (j < 7) {
                        int keyIndex = i * 12 + QuasiMusic.this.whiteIDs[j];
                        int keyNum = keyIndex + 24;
                        this.keyCentres[keyIndex] = x + this.bkw;
                        this.whiteKeys.add(new Key(x, 0, this.kw, this.kh, keyNum));
                        ++j;
                        x += this.kw;
                    }
                }
                i = 0;
                x = 0;
                while (i < 6) {
                    int keyIndex = i * 12;
                    int keyNum = keyIndex + 24;
                    this.blackKeys.add(new Key((x += this.kw) - this.hbkw, 0, this.bkw, this.bkh, keyNum + 1));
                    this.keyCentres[keyIndex + 1] = x;
                    this.blackKeys.add(new Key((x += this.kw) - this.hbkw, 0, this.bkw, this.bkh, keyNum + 3));
                    this.keyCentres[keyIndex + 3] = x;
                    x += this.kw;
                    this.blackKeys.add(new Key((x += this.kw) - this.hbkw, 0, this.bkw, this.bkh, keyNum + 6));
                    this.keyCentres[keyIndex + 6] = x;
                    this.blackKeys.add(new Key((x += this.kw) - this.hbkw, 0, this.bkw, this.bkh, keyNum + 8));
                    this.keyCentres[keyIndex + 8] = x;
                    this.blackKeys.add(new Key((x += this.kw) - this.hbkw, 0, this.bkw, this.bkh, keyNum + 10));
                    this.keyCentres[keyIndex + 10] = x;
                    ++i;
                    x += this.kw;
                }
                i = 0;
                int y = 0;
                while (i < this.numChords) {
                    this.chordKeys.add(new ChordKey(this.xChord, y, this.cw, this.ch, i, new Color(Color.HSBtoRGB((float)i / (0.5f + (float)this.numChords), 1.0f, 0.6f + 0.2f * (float)(i % 2)))));
                    ++i;
                    y += this.ch;
                }
                MidiSynth.this.keys.addAll(this.blackKeys);
                MidiSynth.this.keys.addAll(this.whiteKeys);
                MidiSynth.this.keys.addAll(this.chordKeys);
                this.addMouseListener(this);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Key key = this.getKey(e.getPoint());
                if (key != null) {
                    if (key.isChord() && (e.getModifiersEx() & 0x40) != 0) {
                        int cnum = key.kNum;
                        this.selectedChord = this.selectedChord == cnum ? -1 : cnum;
                        this.repaint();
                    } else {
                        key.on();
                        this.prevKey = key;
                        if (this.selectedChord >= 0 && !key.isChord()) {
                            this.chordKeys.get(this.selectedChord).toggleNote(key.kNum);
                        }
                        this.repaint();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.prevKey != null) {
                    this.prevKey.off();
                    this.repaint();
                    this.prevKey = null;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.prevKey != null) {
                    this.prevKey.off();
                    this.repaint();
                    this.prevKey = null;
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            public Key getKey(Point point) {
                for (int i = 0; i < MidiSynth.this.keys.size(); ++i) {
                    if (!MidiSynth.this.keys.get(i).contains(point)) continue;
                    return MidiSynth.this.keys.get(i);
                }
                return null;
            }

            @Override
            public void paint(Graphics g) {
                Key key;
                int i;
                Graphics2D g2 = (Graphics2D)g;
                Dimension d = this.getSize();
                g2.setBackground(this.getBackground());
                g2.clearRect(0, 0, d.width, d.height);
                g2.setColor(Color.white);
                g2.fillRect(0, 0, 42 * this.kw, this.kh);
                for (i = 0; i < this.whiteKeys.size(); ++i) {
                    key = this.whiteKeys.get(i);
                    if (key.isNoteOn()) {
                        g2.setColor(QuasiMusic.this.playCol);
                        g2.fill(key);
                    }
                    g2.setColor(Color.black);
                    g2.draw(key);
                }
                for (i = 0; i < this.blackKeys.size(); ++i) {
                    key = this.blackKeys.get(i);
                    if (key.isNoteOn()) {
                        g2.setColor(QuasiMusic.this.playCol);
                        g2.fill(key);
                        g2.setColor(Color.black);
                        g2.draw(key);
                        continue;
                    }
                    g2.setColor(Color.black);
                    g2.fill(key);
                }
                for (i = 0; i < this.chordKeys.size(); ++i) {
                    key = (ChordKey)this.chordKeys.get(i);
                    Color c = key.isNoteOn() ? QuasiMusic.this.playCol : (i == this.selectedChord ? QuasiMusic.this.selCol : ((ChordKey)key).col);
                    g2.setColor(c);
                    g2.fill(key);
                    g2.setColor(Color.black);
                    g2.draw(key);
                    for (int j = 0; j < 72; ++j) {
                        if (!((ChordKey)key).noteSet[j]) continue;
                        g2.setColor(c);
                        g2.fillRect(this.keyCentres[j] - this.hbkw, i * this.ch, this.bkw, this.ch);
                        g2.setColor(Color.black);
                        g2.drawRect(this.keyCentres[j] - this.hbkw, i * this.ch, this.bkw, this.ch);
                    }
                }
            }
        }

        class ChordKey
        extends Key {
            private static final long serialVersionUID = 1L;
            boolean[] noteSet;
            int noteCount;
            Color col;

            public ChordKey(int x, int y, int width, int height, int num, Color col) {
                super(x, y, width, height, num);
                this.noteSet = new boolean[72];
                this.col = col;
                this.noteCount = 0;
            }

            @Override
            public void on() {
                this.setNoteState(0);
                boolean needDetails = true;
                MidiSynth.this.cc.ensureProgram();
                for (int k = 0; k < 72; ++k) {
                    if (!this.noteSet[k]) continue;
                    int note = 24 + k;
                    MidiSynth.this.cc.channel.noteOn(note, MidiSynth.this.cc.velocity);
                    if (!MidiSynth.this.record) continue;
                    MidiSynth.this.noteOnEvent(note, needDetails);
                    ++MidiSynth.this.recNoteCount;
                    needDetails = false;
                }
            }

            @Override
            public void off() {
                this.setNoteState(1);
                for (int k = 0; k < 72; ++k) {
                    if (!this.noteSet[k]) continue;
                    int note = 24 + k;
                    MidiSynth.this.cc.channel.noteOff(note, MidiSynth.this.cc.velocity);
                    if (!MidiSynth.this.record) continue;
                    MidiSynth.this.noteOffEvent(note);
                }
            }

            @Override
            public void toggleNote(int note) {
                int indx = note - 24;
                if (this.noteSet[indx]) {
                    --this.noteCount;
                    this.noteSet[indx] = false;
                } else if (this.noteCount < MidiSynth.this.maxVoices) {
                    ++this.noteCount;
                    this.noteSet[indx] = true;
                }
            }

            @Override
            public boolean isChord() {
                return true;
            }
        }

        class Key
        extends Rectangle {
            private static final long serialVersionUID = 1L;
            int noteState;
            int kNum;

            public Key(int x, int y, int width, int height, int num) {
                super(x, y, width, height);
                this.noteState = 1;
                this.kNum = num;
            }

            public boolean isNoteOn() {
                return this.noteState == 0;
            }

            public void on() {
                this.setNoteState(0);
                MidiSynth.this.cc.ensureProgram();
                MidiSynth.this.cc.channel.noteOn(this.kNum, MidiSynth.this.cc.velocity);
                if (MidiSynth.this.record) {
                    MidiSynth.this.noteOnEvent(this.kNum, true);
                    ++MidiSynth.this.recNoteCount;
                }
            }

            public void off() {
                this.setNoteState(1);
                MidiSynth.this.cc.channel.noteOff(this.kNum, MidiSynth.this.cc.velocity);
                if (MidiSynth.this.record) {
                    MidiSynth.this.noteOffEvent(this.kNum);
                }
            }

            public void setNoteState(int state) {
                this.noteState = state;
            }

            public void toggleNote(int note) {
            }

            public boolean isChord() {
                return false;
            }
        }
    }

    class TileControls
    extends JPanel
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = 1L;
        JComboBox<String> latticeChoice = null;
        JComboBox<String> latticeSizeChoice = null;
        JComboBox<String> channelChoice = null;
        JButton rewindButton = null;
        JButton randomButton = null;
        JButton playButton = null;
        JCheckBox solo = null;
        JButton clearChannelButton = null;
        JButton copyButton = null;
        JButton pasteButton = null;
        JButton imposeButton = null;
        JButton clearAllButton = null;
        JButton saveButton = null;
        JButton saveAsButton = null;
        JButton loadButton = null;
        JButton recordButton = null;
        JButton playMIDIButton = null;
        JButton importMIDIButton = null;
        JButton[] loadDemos = null;
        QuasiMusic parent = null;
        int dim;
        int scaleNumber;
        int channelNumber;
        int minDim;
        int maxDim;
        int minScale;
        int maxScale;
        int nChannels;
        boolean playState;
        boolean soloState;
        boolean recordState;
        boolean playMIDIState;
        boolean allowIO;
        boolean notesInClipboard;
        boolean canImportMIDI;
        int loadedDemo = -1;
        int nDemos;
        TilePanel tilePanel = null;

        public TileControls(QuasiMusic parent, TilePanel tilePanel, int dim, int scaleNumber, int minDim, int maxDim, int minScale, int maxScale, int nChannels, String[] demoToolTips) {
            int i;
            this.parent = parent;
            this.tilePanel = tilePanel;
            this.dim = dim;
            this.scaleNumber = scaleNumber;
            this.channelNumber = 0;
            this.minDim = minDim;
            this.maxDim = maxDim;
            this.minScale = minScale;
            this.maxScale = maxScale;
            this.nChannels = nChannels;
            this.allowIO = true;
            this.nDemos = demoToolTips.length;
            this.loadDemos = new JButton[this.nDemos];
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            JPanel p = new JPanel();
            p.setBorder(new EmptyBorder(1, 1, 1, 1));
            p.setLayout(new BoxLayout(p, 1));
            this.latticeChoice = new JComboBox();
            for (i = minDim; i <= maxDim; ++i) {
                this.latticeChoice.addItem("Lattice Z^" + String.valueOf(i));
            }
            this.latticeChoice.addItemListener(this);
            this.latticeChoice.setSelectedIndex(dim - minDim);
            this.latticeChoice.setAlignmentX(0.0f);
            p.add(this.latticeChoice);
            this.latticeSizeChoice = new JComboBox();
            for (i = minScale; i <= maxScale; ++i) {
                this.latticeSizeChoice.addItem("Lattice size " + String.valueOf(i));
            }
            this.latticeSizeChoice.addItemListener(this);
            this.latticeSizeChoice.setSelectedIndex(scaleNumber - minScale);
            this.latticeSizeChoice.setAlignmentX(0.0f);
            p.add(this.latticeSizeChoice);
            this.channelChoice = new JComboBox();
            for (i = 1; i <= nChannels; ++i) {
                this.channelChoice.addItem("Channel " + String.valueOf(i));
            }
            this.channelChoice.addItemListener(this);
            this.channelChoice.setSelectedIndex(0);
            this.channelChoice.setAlignmentX(0.0f);
            p.add(this.channelChoice);
            JPanel pp = new JPanel();
            pp.setBorder(new EmptyBorder(1, 1, 1, 1));
            pp.setLayout(new BoxLayout(pp, 0));
            pp.setAlignmentX(0.0f);
            this.rewindButton = this.createButton("Rewind", pp);
            this.randomButton = this.createButton("Randomise", pp);
            p.add(pp);
            this.add(p);
            p = new JPanel();
            p.setBorder(new EmptyBorder(1, 1, 1, 1));
            p.setLayout(new BoxLayout(p, 1));
            pp = new JPanel();
            pp.setBorder(new EmptyBorder(1, 1, 1, 1));
            pp.setLayout(new BoxLayout(pp, 0));
            pp.setAlignmentX(0.0f);
            this.playButton = this.createButton("Play", pp);
            this.playState = false;
            this.solo = new JCheckBox("Solo", false);
            this.solo.addActionListener(this);
            this.soloState = false;
            pp.add(this.solo);
            p.add(pp);
            this.recordButton = this.createButton(forVideo ? "Record VIDEO" : "Record MIDI file", p);
            this.recordState = false;
            this.playMIDIButton = this.createButton("Play MIDI file", p);
            this.playMIDIState = false;
            this.importMIDIButton = this.createButton("Import MIDI", p);
            this.importMIDIButton.setEnabled(false);
            this.canImportMIDI = false;
            this.add(p);
            p = new JPanel();
            p.setBorder(new EmptyBorder(1, 1, 1, 1));
            p.setLayout(new BoxLayout(p, 1));
            this.clearChannelButton = this.createButton("Clear this chn", p);
            this.copyButton = this.createButton("Copy chn notes", p);
            this.pasteButton = this.createButton("Paste chn notes", p);
            this.notesInClipboard = false;
            this.pasteButton.setEnabled(false);
            this.imposeButton = this.createButton("Impose instrmnt", p);
            this.add(p);
            p = new JPanel();
            p.setBorder(new EmptyBorder(1, 1, 1, 1));
            p.setLayout(new BoxLayout(p, 1));
            this.clearAllButton = this.createButton("Clear all", p);
            this.saveButton = this.createButton("Save tile notes", p);
            this.saveAsButton = this.createButton("Save as ...", p);
            this.loadButton = this.createButton("Load tile notes", p);
            this.add(p);
            JPanel q = new JPanel();
            q.setBorder(new TitledBorder(new EtchedBorder(new Color(100, 100, 127), new Color(50, 50, 64)), " Load demo ", 2, 2));
            q.setLayout(new BoxLayout(q, 0));
            p = null;
            for (i = 0; i < this.nDemos; ++i) {
                if (i % 3 == 0) {
                    if (p != null) {
                        q.add(p);
                    }
                    p = new JPanel();
                    p.setLayout(new BoxLayout(p, 1));
                }
                this.loadDemos[i] = this.createButton(i + 1 + "   ", p);
                this.loadDemos[i].setToolTipText(demoToolTips[i]);
            }
            if (p != null) {
                q.add(p);
            }
            this.add(q);
        }

        private JButton createButton(String name, JPanel p) {
            JButton b = new JButton(name);
            b.addActionListener(this);
            b.setAlignmentX(0.0f);
            p.add(b);
            return b;
        }

        public void forbidIO() {
            this.loadButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.saveAsButton.setEnabled(false);
            this.recordButton.setEnabled(false);
            this.playMIDIButton.setEnabled(false);
            this.importMIDIButton.setEnabled(false);
            this.allowIO = false;
        }

        public void importMIDIenable(boolean e) {
            if (this.allowIO) {
                this.importMIDIButton.setEnabled(e);
            }
            this.canImportMIDI = e;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JComboBox combo = null;
            combo = (JComboBox)e.getSource();
            int i = combo.getSelectedIndex();
            int newDim = this.dim;
            int newScale = this.scaleNumber;
            int newChannel = this.channelNumber;
            if (combo == this.latticeChoice) {
                newDim = this.minDim + i;
            } else if (combo == this.latticeSizeChoice) {
                newScale = this.minScale + i;
            } else if (combo == this.channelChoice) {
                newChannel = i;
                this.parent.setChannel(i);
            }
            if (this.tilePanel != null) {
                if (newDim != this.dim || newScale != this.scaleNumber) {
                    this.dim = newDim;
                    this.scaleNumber = newScale;
                    this.channelNumber = newChannel;
                    this.tilePanel.setup(this.dim, this.scaleNumber);
                    this.setScale(newScale);
                } else if (newChannel != this.channelNumber) {
                    this.channelNumber = newChannel;
                    this.tilePanel.needNewK();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int newLoadedDemo;
            block6: {
                JButton button;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                block11: {
                                                    block10: {
                                                        block9: {
                                                            block8: {
                                                                block7: {
                                                                    block5: {
                                                                        if (e.getSource() == this.solo) {
                                                                            this.soloState = this.solo.isSelected();
                                                                            return;
                                                                        }
                                                                        button = (JButton)e.getSource();
                                                                        newLoadedDemo = this.loadedDemo;
                                                                        if (button != this.rewindButton) break block5;
                                                                        this.tilePanel.setup(this.dim, this.scaleNumber);
                                                                        break block6;
                                                                    }
                                                                    if (button != this.randomButton) break block7;
                                                                    boolean shiftedClick = (e.getModifiers() & 1) != 0;
                                                                    this.tilePanel.randomise(shiftedClick ? -1L : 1L);
                                                                    this.tilePanel.setup(this.dim, this.scaleNumber);
                                                                    break block6;
                                                                }
                                                                if (button != this.playButton) break block8;
                                                                this.playState = !this.playState;
                                                                this.playButton.setText(this.playState ? "Stop" : "Play");
                                                                this.enableControls(!this.playState, this.playButton);
                                                                this.tilePanel.setScrolling(this.playState);
                                                                break block6;
                                                            }
                                                            if (button != this.recordButton) break block9;
                                                            if (!this.allowIO) break block6;
                                                            this.recordState = !this.recordState;
                                                            this.recordButton.setText(this.recordState ? "Stop recording" : "Record MIDI file");
                                                            this.enableControls(!this.recordState, this.recordButton);
                                                            this.tilePanel.setRecordingMIDI(this.recordState);
                                                            break block6;
                                                        }
                                                        if (button != this.playMIDIButton) break block10;
                                                        if (!this.allowIO) break block6;
                                                        this.playMIDIState = !this.playMIDIState;
                                                        this.playMIDIButton.setText(this.playMIDIState ? "Stop playing" : "Play MIDI file");
                                                        this.enableControls(!this.playMIDIState, this.playMIDIButton);
                                                        this.tilePanel.setPlayingMIDI(this.playMIDIState);
                                                        break block6;
                                                    }
                                                    if (button != this.importMIDIButton) break block11;
                                                    if (!this.allowIO) break block6;
                                                    this.tilePanel.importMIDI();
                                                    newLoadedDemo = -1;
                                                    break block6;
                                                }
                                                if (button != this.clearChannelButton) break block12;
                                                this.tilePanel.clearChannel(this.channelNumber);
                                                newLoadedDemo = -1;
                                                break block6;
                                            }
                                            if (button != this.clearAllButton) break block13;
                                            this.tilePanel.clearAllTiles();
                                            newLoadedDemo = -1;
                                            break block6;
                                        }
                                        if (button != this.copyButton) break block14;
                                        this.tilePanel.copyChannelNotes(this.channelNumber);
                                        this.notesInClipboard = true;
                                        this.pasteButton.setEnabled(true);
                                        break block6;
                                    }
                                    if (button != this.pasteButton) break block15;
                                    this.tilePanel.pasteChannelNotes(this.channelNumber);
                                    newLoadedDemo = -1;
                                    break block6;
                                }
                                if (button != this.imposeButton) break block16;
                                this.tilePanel.imposeInstrument(this.channelNumber);
                                newLoadedDemo = -1;
                                break block6;
                            }
                            if (button != this.saveAsButton) break block17;
                            if (!this.allowIO) break block6;
                            this.tilePanel.saveAs();
                            break block6;
                        }
                        if (button != this.saveButton) break block18;
                        if (!this.allowIO) break block6;
                        this.tilePanel.save();
                        break block6;
                    }
                    if (button != this.loadButton) break block19;
                    if (!this.allowIO) break block6;
                    this.tilePanel.loadAllTiles();
                    newLoadedDemo = -1;
                    break block6;
                }
                for (int i = 0; i < this.nDemos; ++i) {
                    if (button != this.loadDemos[i]) continue;
                    this.tilePanel.loadDemo(i);
                    newLoadedDemo = i;
                    break;
                }
            }
            if (newLoadedDemo != this.loadedDemo) {
                if (this.loadedDemo >= 0) {
                    this.loadDemos[this.loadedDemo].setText(this.loadedDemo + 1 + "   ");
                }
                if (newLoadedDemo >= 0) {
                    this.loadDemos[newLoadedDemo].setText(newLoadedDemo + 1 + " \u2022");
                }
                this.loadedDemo = newLoadedDemo;
            }
        }

        private synchronized void enableControls(boolean e, JButton b) {
            this.channelChoice.setEnabled(e);
            this.latticeChoice.setEnabled(e);
            this.latticeSizeChoice.setEnabled(e);
            this.clearChannelButton.setEnabled(e);
            this.clearAllButton.setEnabled(e);
            this.copyButton.setEnabled(e);
            this.pasteButton.setEnabled(e && this.notesInClipboard);
            this.imposeButton.setEnabled(e);
            this.rewindButton.setEnabled(e);
            this.randomButton.setEnabled(e);
            this.solo.setEnabled(e);
            for (int i = 0; i < this.nDemos; ++i) {
                this.loadDemos[i].setEnabled(e);
            }
            if (b != this.playButton) {
                this.playButton.setEnabled(e);
            }
            if (this.allowIO) {
                this.loadButton.setEnabled(e);
                this.saveButton.setEnabled(e);
                this.saveAsButton.setEnabled(e);
                this.importMIDIButton.setEnabled(e && this.canImportMIDI);
                if (b != this.recordButton) {
                    this.recordButton.setEnabled(e);
                }
                if (b != this.playMIDIButton) {
                    this.playMIDIButton.setEnabled(e);
                }
            }
        }

        public synchronized void setScale(int scaleNumber) {
            this.scaleNumber = scaleNumber;
            this.latticeSizeChoice.setSelectedIndex(scaleNumber - this.minScale);
            this.latticeSizeChoice.repaint();
        }

        public synchronized void donePlayingMIDI() {
            if (this.playMIDIState) {
                this.playMIDIState = false;
                this.playMIDIButton.setText("Play MIDI file");
                this.enableControls(true, this.playMIDIButton);
            }
        }

        public boolean isSolo() {
            return this.soloState;
        }
    }

    public class TilePanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 1L;
        QuasiMusic parent = null;
        IndexColorModel cm1;
        IndexColorModel cm2;
        WritableRaster raster;
        DataBufferByte dataBuffer;
        byte[] r1;
        byte[] g1;
        byte[] b1;
        byte[] r2;
        byte[] g2;
        byte[] b2;
        byte[] r3;
        byte[] g3;
        byte[] b3;
        byte[] r4;
        byte[] g4;
        byte[] b4;
        Color[][] tileCols;
        Color[][] tileColsDarker;
        Color[][] tileColsBrighter;
        int[] edt;
        int[] fdt;
        int ntc;
        int ngs;
        long timeStep;
        int nChannels;
        int currentChannelIndex;
        boolean scrolling = false;
        boolean solo = false;
        boolean recordingMIDI = false;
        boolean playingMIDI = false;
        boolean needSequence = false;
        BufferedInputStream midiIn = null;
        BufferedImage J = null;
        BufferedImage K = null;
        Graphics H;
        int[][] defaultSamplePoints = null;
        int[][] currentSamplePoints = null;
        int selectedSamplePoint = -1;
        int Jw;
        int Jh;
        int take = 0;
        int latestHC;
        int latestTake;
        long lowY = 0L;
        long latestYoffs;
        long greatestYcue;
        short nFlashTiles;
        short iFlashTiles;
        float[][] flashTilesX = null;
        float[][] flashTilesY = null;
        short[] tilesToFlash = null;
        short[] flashCount = null;
        short[] flashIndex = null;
        short nToFlash;
        Color[] flashTileCols = null;
        byte[] frameMessage = "F".getBytes();
        byte[] flashOnMessage = new byte[]{"f".getBytes()[0], 0, 0, 0};
        byte[] flashOffMessage = new byte[]{"g".getBytes()[0], 0, 0, 0};
        double inc;
        int dim;
        int scaleNumber;
        double scaleFactor;
        double halfScaleFactor;
        int minDim;
        int maxDim;
        int minScale;
        int maxScale;
        double[] Gx;
        double[] Gy;
        double[] Gd;
        double[][] Dets;
        int[][] left;
        int[][] top;
        int[][] right;
        double marg;
        long rseed1;
        long rseed2;
        Sequence[][][] tileNotes;
        Sequence[][] clipboard;
        int selectedLowDim = -1;
        int selectedHighDim = -1;
        int playingLowDim = -1;
        int playingHighDim = -1;
        Point pressedPoint = null;
        String playingDescr = null;
        Rectangle playingDescrR;
        boolean shiftedClick = false;
        boolean pristine = true;
        File lastSavedQMF = null;
        File lastReadQMF = null;
        File lastSavedMIDI = null;
        File lastReadMIDI = null;
        final BasicStroke str = new BasicStroke(0.5f, 0, 2);
        final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath rhomb = new GeneralPath(0, 5);
        final int DEMO_SCALE_CHROMATIC = 0;
        final int DEMO_SCALE_C_MAJOR = 1;
        final int DEMO_SCALE_B_FLAT_MAJOR = 2;
        final int[] majorTonics = new int[]{60, 58};
        final int DEMO_SCALE_C_MINOR = 3;
        final int DEMO_SCALE_C_SHARP_MINOR = 4;
        final int[] minorTonics = new int[]{60, 61};
        final int DEMO_SCALE_C_MAJOR_TRIADS = 5;
        final int DEMO_SCALE_B_FLAT_MAJOR_TRIADS = 6;
        final int DEMO_SCALE_C_MAJOR_ASCENTS = 7;
        final int DEMO_SCALE_B_FLAT_MAJOR_ASCENTS = 8;
        final int DEMO_SCALE_C_MAJOR_DESCENTS = 9;
        final int DEMO_SCALE_B_FLAT_MAJOR_DESCENTS = 10;
        final int nScales = 11;
        final String[] scaleNames = new String[]{"Chromatic notes", "C major notes", "B\u266d major notes", "C minor notes", "C\u266f minor notes", "C major triads", "B\u266d major triads", "C major ascents", "B\u266d major ascents", "C major descents", "B\u266d major descents"};
        int[][][][] scaleSet = null;
        final int nDemos = 9;
        int[][][] demoInstruments = null;
        long[] demoKeystrikes = null;
        long[] demoNoteTiming = null;
        int[] demoScales = null;
        int[] demoDims = null;
        String[] demoToolTips = null;
        int[] activeChannels;
        int nActive;
        long frameNumber;
        BufferedImage V;
        Graphics VG;
        long lastLowY;
        Sequence rmSeq = null;
        Track rmTrack = null;
        long MIDIstartTime;
        long MIDIstopTime;
        Vector<Cue> cues = null;
        Sequence currentSeq = null;
        Sequence nextSeq = null;
        Track currentTrack = null;
        Track nextTrack = null;

        public TilePanel(QuasiMusic parent, int dim, int scaleNumber, int minDim, int maxDim, int minScale, int maxScale, long timeStep, int nChannels, int ci) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.r1 = new byte[256];
            this.g1 = new byte[256];
            this.b1 = new byte[256];
            this.r2 = new byte[256];
            this.g2 = new byte[256];
            this.b2 = new byte[256];
            this.r3 = new byte[256];
            this.g3 = new byte[256];
            this.b3 = new byte[256];
            this.r4 = new byte[256];
            this.g4 = new byte[256];
            this.b4 = new byte[256];
            this.rseed1 = 23456789L;
            this.rseed2 = 23456789L;
            this.timeStep = timeStep;
            this.parent = parent;
            this.minDim = minDim;
            this.maxDim = maxDim;
            this.minScale = minScale;
            this.maxScale = maxScale;
            this.nChannels = nChannels;
            this.currentChannelIndex = ci;
            int ndim = maxDim - minDim + 1;
            int nscale = maxScale - minScale + 1;
            this.tileNotes = new Sequence[nChannels][maxDim][maxDim];
            this.clipboard = new Sequence[maxDim][maxDim];
            this.pristine = true;
            this.setup(dim, scaleNumber);
        }

        public void setChannel(int ci) {
            this.currentChannelIndex = ci;
        }

        public void setScale(int scaleNumber) {
            this.scaleNumber = scaleNumber;
            this.scaleFactor = scaleNumber;
            this.halfScaleFactor = 0.5 * this.scaleFactor;
        }

        public void clearAllTiles() {
            int i;
            if (!this.okToWipe()) {
                return;
            }
            for (i = 0; i < this.nChannels; ++i) {
                for (int j = 0; j < this.maxDim; ++j) {
                    for (int k = 0; k < this.maxDim; ++k) {
                        this.tileNotes[i][j][k] = null;
                    }
                }
            }
            this.pristine = true;
            this.setSavedAs(null);
            for (i = 0; i < this.nChannels; ++i) {
                this.currentSamplePoints[i][0] = this.defaultSamplePoints[i][0];
                this.currentSamplePoints[i][1] = this.defaultSamplePoints[i][1];
            }
            this.needNewK();
        }

        public void clearChannel(int chn) {
            for (int j = 0; j < this.maxDim; ++j) {
                for (int k = 0; k < this.maxDim; ++k) {
                    this.tileNotes[chn][j][k] = null;
                }
            }
            this.pristine = false;
            this.needNewK();
        }

        public void copyChannelNotes(int chn) {
            for (int j = 0; j < this.maxDim; ++j) {
                for (int k = 0; k < this.maxDim; ++k) {
                    this.clipboard[j][k] = this.cloneSequence(this.tileNotes[chn][j][k], 0);
                }
            }
        }

        public void pasteChannelNotes(int chn) {
            for (int j = 0; j < this.maxDim; ++j) {
                for (int k = 0; k < this.maxDim; ++k) {
                    this.tileNotes[chn][j][k] = this.cloneSequence(this.clipboard[j][k], chn);
                }
            }
            this.pristine = false;
            this.needNewK();
        }

        private Sequence cloneSequence(Sequence s, int newChn) {
            if (s == null) {
                return null;
            }
            Sequence cseq = QuasiMusic.this.makeEmptySequence();
            Track ctr = cseq.createTrack();
            try {
                Track tr = s.getTracks()[0];
                if (tr != null) {
                    int n = tr.size() - 1;
                    for (int ee = 0; ee < n; ++ee) {
                        MidiEvent tileEvent = tr.get(ee);
                        MidiEvent event = new MidiEvent(this.cloneChange(tileEvent.getMessage(), newChn, -1), tileEvent.getTick());
                        ctr.add(event);
                    }
                }
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems creating a MIDI sequence:\n" + ex.getMessage());
                ex.printStackTrace();
            }
            return cseq;
        }

        public void imposeInstrument(int chn) {
            int bank = QuasiMusic.this.midiSynth.cc.getBank();
            int program = QuasiMusic.this.midiSynth.cc.getProgram();
            for (int j = 0; j < this.maxDim; ++j) {
                for (int k = 0; k < this.maxDim; ++k) {
                    this.tileNotes[chn][j][k] = this.imposeInstrument(this.tileNotes[chn][j][k], bank, program);
                }
            }
            this.pristine = false;
        }

        private Sequence imposeInstrument(Sequence s, int bank, int program) {
            if (s == null) {
                return null;
            }
            Sequence cseq = QuasiMusic.this.makeEmptySequence();
            Track ctr = cseq.createTrack();
            Track tr = s.getTracks()[0];
            if (tr != null) {
                try {
                    int n = tr.size() - 1;
                    for (int ee = 0; ee < n; ++ee) {
                        ShortMessage nsm;
                        MidiEvent tileEvent = tr.get(ee);
                        MidiEvent event = null;
                        MidiMessage msg = tileEvent.getMessage();
                        int status = msg.getStatus();
                        int type = status & 0xF0;
                        if (type == 176 && msg.getMessage()[1] == 0) {
                            nsm = new ShortMessage();
                            nsm.setMessage(status, 0, bank);
                            event = new MidiEvent(nsm, tileEvent.getTick());
                        } else if (type == 192) {
                            nsm = new ShortMessage();
                            nsm.setMessage(status, program, 0);
                            event = new MidiEvent(nsm, tileEvent.getTick());
                        } else {
                            event = new MidiEvent((MidiMessage)tileEvent.getMessage().clone(), tileEvent.getTick());
                        }
                        ctr.add(event);
                    }
                }
                catch (Exception ex) {
                    QuasiMusic.showErrorMessage("There were problems creating a MIDI message:\n" + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            return cseq;
        }

        public void loadAllTiles() {
            if (!this.okToWipe()) {
                return;
            }
            try {
                File file = this.lastReadQMF != null ? this.lastReadQMF.getParentFile() : (this.lastSavedQMF != null ? this.lastSavedQMF.getParentFile() : (this.lastReadMIDI != null ? this.lastReadMIDI.getParentFile() : (this.lastSavedMIDI != null ? this.lastSavedMIDI.getParentFile() : new File(System.getProperty("user.dir")))));
                JFileChooser fc = new JFileChooser(file);
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().endsWith(".qmf") || f.getName().endsWith(".QMF");
                    }

                    @Override
                    public String getDescription() {
                        return "Files *.qmf saved by QuasiMusic";
                    }
                });
                if (fc.showOpenDialog(null) == 0) {
                    int i;
                    File sf = fc.getSelectedFile();
                    DataInputStream fos = new DataInputStream(new FileInputStream(sf));
                    this.lastReadQMF = sf;
                    for (i = 0; i < this.nChannels; ++i) {
                        for (int j = 0; j < this.maxDim; ++j) {
                            for (int k = 0; k < this.maxDim; ++k) {
                                int n = fos.readInt();
                                if (n == 0) {
                                    this.tileNotes[i][j][k] = null;
                                    continue;
                                }
                                Sequence s = QuasiMusic.this.makeEmptySequence();
                                Track t = s.createTrack();
                                for (int ee = 0; ee < n; ++ee) {
                                    int msgLen = fos.readInt();
                                    byte[] msgData = new byte[msgLen];
                                    fos.readFully(msgData, 0, msgLen);
                                    long tick = fos.readLong();
                                    ShortMessage message = new ShortMessage();
                                    byte data0 = msgData[0];
                                    byte data1 = msgData[1];
                                    byte data2 = 0;
                                    if (msgLen == 3) {
                                        data2 = msgData[2];
                                    }
                                    message.setMessage(data0, data1, data2);
                                    MidiEvent event = new MidiEvent(message, tick);
                                    t.add(event);
                                }
                                this.tileNotes[i][j][k] = s;
                            }
                        }
                    }
                    for (i = 0; i < this.nChannels; ++i) {
                        try {
                            int x = fos.readInt();
                            int y = fos.readInt();
                            this.currentSamplePoints[i][0] = x;
                            this.currentSamplePoints[i][1] = y;
                            continue;
                        }
                        catch (EOFException ex) {
                            break;
                        }
                    }
                    fos.close();
                    this.pristine = true;
                    this.setSavedAs(sf);
                }
            }
            catch (SecurityException ex) {
                QuasiMusic.showErrorMessage("When running QuasiMusic as an applet,\nextra Java permissions are needed in\norder to load or save files.\nTo load/save files, it's better to\ndownload the application version of QuasiMusic.");
                ex.printStackTrace();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems reading the file:\n" + ex.getMessage());
                ex.printStackTrace();
            }
            this.K = null;
            this.repaint();
        }

        public boolean startPlayingMIDI() {
            try {
                File file = this.lastReadMIDI != null ? this.lastReadMIDI.getParentFile() : (this.lastSavedMIDI != null ? this.lastSavedMIDI.getParentFile() : (this.lastReadQMF != null ? this.lastReadQMF.getParentFile() : (this.lastSavedQMF != null ? this.lastSavedQMF.getParentFile() : new File(System.getProperty("user.dir")))));
                JFileChooser fc = new JFileChooser(file);
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().endsWith(".mid") || f.getName().endsWith(".MID") || f.getName().endsWith(".midi") || f.getName().endsWith(".midi");
                    }

                    @Override
                    public String getDescription() {
                        return "Files *.mid, *.midi";
                    }
                });
                if (fc.showOpenDialog(null) == 0) {
                    File sf;
                    this.lastReadMIDI = sf = fc.getSelectedFile();
                    return this.parent.midiSynth.startPlayingMIDI(sf);
                }
            }
            catch (SecurityException ex) {
                QuasiMusic.showErrorMessage("When running QuasiMusic as an applet,\nextra Java permissions are needed in\norder to load or save files.\nTo load/save files, it's better to\ndownload the application version of QuasiMusic.");
                ex.printStackTrace();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems with the MIDI file:\n" + ex.getMessage());
                ex.printStackTrace();
            }
            return false;
        }

        public void importMIDI() {
            int reply;
            if (this.selectedLowDim < 0) {
                return;
            }
            Sequence ms = this.parent.midiSynth.getRecording();
            if (ms != null && (reply = JOptionPane.showConfirmDialog(null, "Importing a MIDI file into this tile will throw out\nthe notes you've just played.\nAre you sure you want to do this?", "Changes will be lost", 2)) != 0) {
                this.tileNotes[this.currentChannelIndex][this.selectedLowDim][this.selectedHighDim] = ms;
                this.pristine = false;
                this.noSelection();
                this.needNewK();
                return;
            }
            this.tileNotes[this.currentChannelIndex][this.selectedLowDim][this.selectedHighDim] = null;
            try {
                File file = this.lastReadMIDI != null ? this.lastReadMIDI.getParentFile() : (this.lastSavedMIDI != null ? this.lastSavedMIDI.getParentFile() : (this.lastReadQMF != null ? this.lastReadQMF.getParentFile() : (this.lastSavedQMF != null ? this.lastSavedQMF.getParentFile() : new File(System.getProperty("user.dir")))));
                JFileChooser fc = new JFileChooser(file);
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().endsWith(".mid") || f.getName().endsWith(".MID") || f.getName().endsWith(".midi") || f.getName().endsWith(".midi");
                    }

                    @Override
                    public String getDescription() {
                        return "Files *.mid, *.midi";
                    }
                });
                if (fc.showOpenDialog(null) == 0) {
                    File sf = fc.getSelectedFile();
                    Sequence impS = MidiSystem.getSequence(sf);
                    this.lastReadMIDI = sf;
                    Sequence splitS = this.splitSequence(impS, this.currentChannelIndex);
                    if (splitS != null) {
                        int i;
                        Track[] splitTracks = splitS.getTracks();
                        int ntr = splitTracks.length;
                        int nopt = ntr + 1;
                        Object[] options = new String[nopt];
                        boolean j = false;
                        for (int i2 = 0; i2 < ntr; ++i2) {
                            options[i2] = "" + (i2 + 1) + ". " + this.parent.midiSynth.describeTrack(splitTracks[i2], splitS, true, false, true);
                        }
                        options[ntr] = "Cancel - use none";
                        Object selectedValue = JOptionPane.showInputDialog(null, "Choose the music you want to import into tile", "Music found in MIDI file", 1, null, options, options[0]);
                        int iopt = nopt - 1;
                        for (i = 0; i < nopt; ++i) {
                            if (selectedValue != options[i]) continue;
                            iopt = i;
                            break;
                        }
                        if (iopt < ntr) {
                            for (i = 0; i < ntr; ++i) {
                                if (i == iopt) continue;
                                splitS.deleteTrack(splitTracks[i]);
                            }
                            this.tileNotes[this.currentChannelIndex][this.selectedLowDim][this.selectedHighDim] = splitS;
                        }
                    }
                }
            }
            catch (SecurityException ex) {
                QuasiMusic.showErrorMessage("When running QuasiMusic as an applet,\nextra Java permissions are needed in\norder to load or save files.\nTo load/save files, it's better to\ndownload the application version of QuasiMusic.");
                ex.printStackTrace();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems with the MIDI file:\n" + ex.getMessage());
                ex.printStackTrace();
            }
            this.noSelection();
            this.pristine = false;
            this.needNewK();
        }

        private Sequence splitSequence(Sequence impSeq, int newChn) throws InvalidMidiDataException {
            Sequence result = QuasiMusic.this.makeEmptySequence();
            Track[] impTracks = impSeq.getTracks();
            int ntracks = impTracks.length;
            Track[] newTracks = new Track[this.nChannels + 1];
            MidiEvent[] lastNoteOff = new MidiEvent[this.nChannels + 1];
            int all = this.nChannels;
            long[] maxTicks = new long[this.nChannels + 1];
            for (int tn = 0; tn < ntracks; ++tn) {
                MidiMessage[][] lastDetails = new MidiMessage[5][this.nChannels];
                for (int i = 0; i < this.nChannels; ++i) {
                    ShortMessage sm = new ShortMessage();
                    sm.setMessage(176 + newChn, 0, 0);
                    lastDetails[0][i] = sm;
                    sm = new ShortMessage();
                    sm.setMessage(192 + newChn, 0, 0);
                    lastDetails[1][i] = sm;
                    sm = new ShortMessage();
                    sm.setMessage(208 + newChn, 64, 0);
                    lastDetails[2][i] = sm;
                    sm = new ShortMessage();
                    sm.setMessage(224 + newChn, 0, 64);
                    lastDetails[3][i] = sm;
                    sm = new ShortMessage();
                    sm.setMessage(176 + newChn, 91, 64);
                    lastDetails[4][i] = sm;
                }
                Track tr = impTracks[tn];
                int n = tr.size();
                for (int ee = 0; ee < n; ++ee) {
                    int c;
                    int k;
                    MidiEvent oldEvent = tr.get(ee);
                    MidiMessage msg = oldEvent.getMessage();
                    long oldTick = oldEvent.getTick();
                    long newTick = QuasiMusic.this.ticksFromMillis(QuasiMusic.this.millisFromTicks(oldTick, impSeq), result);
                    int status = msg.getStatus();
                    int chn = status & 0xF;
                    int type = status & 0xF0;
                    byte control = msg.getMessage()[1];
                    int indx = (type - 176) / 16;
                    if (indx == 0 && (control == 0 || control == 91) || indx > 0 && indx < 4) {
                        if (indx == 0 && control == 91) {
                            indx = 4;
                        }
                        lastDetails[indx][chn] = msg;
                        continue;
                    }
                    if (type == 144 && msg.getMessage()[2] != 0) {
                        for (k = 0; k < 2; ++k) {
                            int n2 = c = k == 0 ? all : chn;
                            if (newTracks[c] == null) {
                                newTracks[c] = result.createTrack();
                            }
                            for (int i = 0; i < 5; ++i) {
                                newTracks[c].add(new MidiEvent(this.cloneChange(lastDetails[i][chn], newChn, -1), newTick));
                            }
                            newTracks[c].add(new MidiEvent(this.cloneChange(msg, newChn, -1), newTick));
                        }
                        continue;
                    }
                    if (type != 128 && (type != 144 || msg.getMessage()[2] != 0)) continue;
                    for (k = 0; k < 2; ++k) {
                        int n3 = c = k == 0 ? all : chn;
                        if (newTracks[c] == null) {
                            newTracks[c] = result.createTrack();
                        }
                        MidiEvent offEvent = new MidiEvent(this.cloneChange(msg, newChn, 128), newTick);
                        newTracks[c].add(offEvent);
                        if (newTick <= maxTicks[c]) continue;
                        lastNoteOff[c] = offEvent;
                        maxTicks[c] = newTick;
                    }
                }
            }
            for (int chn = 0; chn <= this.nChannels; ++chn) {
                if (newTracks[chn] == null) continue;
                newTracks[chn].add(new MidiEvent(this.cloneChange(lastNoteOff[chn].getMessage(), newChn, 128), lastNoteOff[chn].getTick() + QuasiMusic.this.ticksFromMillis(1000L, result)));
            }
            if (result.getTracks().length == 2) {
                result.deleteTrack(result.getTracks()[1]);
            }
            return result;
        }

        private ShortMessage cloneChange(MidiMessage msg, int newChn, int newType) throws InvalidMidiDataException {
            ShortMessage sm = new ShortMessage();
            ShortMessage old = (ShortMessage)msg;
            int type = newType > 0 ? newType : old.getStatus() & 0xF0;
            sm.setMessage(type + newChn, old.getData1(), old.getData2());
            return sm;
        }

        private void noSelection() {
            this.selectedLowDim = -1;
            this.selectedHighDim = -1;
            if (this.parent.tileControls != null) {
                this.parent.tileControls.importMIDIenable(false);
            }
        }

        private void setSelection(int eD, int fD) {
            this.selectedLowDim = eD;
            this.selectedHighDim = fD;
            if (this.parent.tileControls != null) {
                this.parent.tileControls.importMIDIenable(true);
            }
        }

        public void save() {
            if (this.lastSavedQMF == null) {
                this.saveAs();
            } else {
                this.saveTilesToFile(this.lastSavedQMF);
            }
        }

        public void saveAs() {
            try {
                File file = this.lastSavedQMF != null ? this.lastSavedQMF.getParentFile() : (this.lastReadQMF != null ? this.lastReadQMF.getParentFile() : (this.lastReadMIDI != null ? this.lastReadMIDI.getParentFile() : (this.lastSavedMIDI != null ? this.lastSavedMIDI.getParentFile() : new File(System.getProperty("user.dir")))));
                JFileChooser fc = new JFileChooser(file);
                if (this.lastSavedQMF != null) {
                    fc.setSelectedFile(this.lastSavedQMF);
                }
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "Save as .qmf file";
                    }
                });
                while (fc.showSaveDialog(null) == 0) {
                    int reply;
                    File sf = fc.getSelectedFile();
                    String sfpath = sf.getPath();
                    if (!sfpath.endsWith(".qmf") && !sfpath.endsWith(".QMF")) {
                        sf = new File(sfpath + ".qmf");
                    }
                    if (sf.exists() && (reply = JOptionPane.showConfirmDialog(null, "The file " + sf.getName() + " already exists\n" + "Are you sure you want to overwrite it?", "File exists", 2)) != 0) continue;
                    this.saveTilesToFile(sf);
                    break;
                }
            }
            catch (SecurityException ex) {
                QuasiMusic.showErrorMessage("When running QuasiMusic as an applet,\nextra Java permissions are needed in\norder to load or save files.\nTo load/save files, it's better to\ndownload the application version of QuasiMusic.");
                ex.printStackTrace();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems writing the file:\n" + ex.getMessage());
                ex.printStackTrace();
            }
        }

        public void saveTilesToFile(File sf) {
            try {
                int i;
                DataOutputStream fos = new DataOutputStream(new FileOutputStream(sf));
                for (i = 0; i < this.nChannels; ++i) {
                    for (int j = 0; j < this.maxDim; ++j) {
                        for (int k = 0; k < this.maxDim; ++k) {
                            int n;
                            Track tr;
                            Sequence ts = this.tileNotes[i][j][k];
                            boolean didWrite = false;
                            if (ts != null && (tr = ts.getTracks()[0]) != null && (n = tr.size() - 1) != 0) {
                                fos.writeInt(n);
                                didWrite = true;
                                for (int ee = 0; ee < n; ++ee) {
                                    MidiEvent tileEvent = tr.get(ee);
                                    MidiMessage msg = tileEvent.getMessage();
                                    int msgLen = msg.getLength();
                                    byte[] msgData = msg.getMessage();
                                    fos.writeInt(msgLen);
                                    fos.write(msgData, 0, msgLen);
                                    long tick = tileEvent.getTick();
                                    fos.writeLong(tick);
                                }
                            }
                            if (didWrite) continue;
                            fos.writeInt(0);
                        }
                    }
                }
                for (i = 0; i < this.nChannels; ++i) {
                    fos.writeInt(this.currentSamplePoints[i][0]);
                    fos.writeInt(this.currentSamplePoints[i][1]);
                }
                fos.close();
                this.pristine = true;
                this.setSavedAs(sf);
            }
            catch (SecurityException ex) {
                QuasiMusic.showErrorMessage("When running QuasiMusic as an applet,\nextra Java permissions are needed in\norder to load or save files.\nTo load/save files, it's better to\ndownload the application version of QuasiMusic.");
                ex.printStackTrace();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems writing the file:\n" + ex.getMessage());
                ex.printStackTrace();
            }
        }

        public void saveMidiAs() {
            this.MIDIstopTime = System.currentTimeMillis();
            try {
                File file = this.lastSavedMIDI != null ? this.lastSavedMIDI.getParentFile() : (this.lastReadMIDI != null ? this.lastReadMIDI.getParentFile() : (this.lastSavedQMF != null ? this.lastSavedQMF.getParentFile() : (this.lastReadQMF != null ? this.lastReadQMF.getParentFile() : new File(System.getProperty("user.dir")))));
                JFileChooser fc = new JFileChooser(file);
                if (this.lastSavedQMF != null) {
                    String sfp = this.lastSavedQMF.getPath();
                    String suggestion = sfp.endsWith(".qmf") || sfp.endsWith(".QMF") ? sfp.substring(0, sfp.length() - 4) + ".mid" : sfp + ".mid";
                    fc.setSelectedFile(new File(suggestion));
                }
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "Save as .mid file";
                    }
                });
                while (fc.showSaveDialog(null) == 0) {
                    int reply;
                    File sf = fc.getSelectedFile();
                    String sfpath = sf.getPath();
                    if (!sfpath.endsWith(".mid") && !sfpath.endsWith(".MID")) {
                        sf = new File(sfpath + ".mid");
                    }
                    if (sf.exists() && (reply = JOptionPane.showConfirmDialog(null, "The file " + sf.getName() + " already exists\n" + "Are you sure you want to overwrite it?", "File exists", 2)) != 0) continue;
                    this.saveMidiFile(sf, this.filterTrack(this.rmSeq, this.MIDIstopTime - this.MIDIstartTime));
                    this.lastSavedMIDI = sf;
                    break;
                }
            }
            catch (SecurityException ex) {
                QuasiMusic.showErrorMessage("When running QuasiMusic as an applet,\nextra Java permissions are needed in\norder to load or save files.\nTo load/save files, it's better to\ndownload the application version of QuasiMusic.");
                ex.printStackTrace();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems writing the file:\n" + ex.getMessage());
                ex.printStackTrace();
            }
        }

        public void saveMidiFile(File file, Sequence sequence) {
            try {
                int[] fileTypes = MidiSystem.getMidiFileTypes(sequence);
                if (fileTypes.length == 0) {
                    QuasiMusic.showErrorMessage("Sorry, your MIDI system can't write MIDI files");
                } else if (MidiSystem.write(sequence, fileTypes[0], file) == -1) {
                    throw new IOException("");
                }
            }
            catch (SecurityException ex) {
                QuasiMusic.showErrorMessage("When running QuasiMusic as an applet,\nextra Java permissions are needed in\norder to load or save files.\nTo load/save files, it's better to\ndownload the application version of QuasiMusic.");
                ex.printStackTrace();
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems writing the MIDI file\n" + ex.getMessage());
                ex.printStackTrace();
            }
        }

        public void demoEvent(Track t, Sequence s, int chn, long millis, int type, int data1, int data2) {
            ShortMessage message = new ShortMessage();
            try {
                long tick = QuasiMusic.this.ticksFromMillis(millis, s);
                if (type == 192 || type == 208) {
                    message.setMessage(type + chn, data1, 0);
                } else {
                    message.setMessage(type + chn, data1, data2);
                }
                MidiEvent event = new MidiEvent(message, tick);
                t.add(event);
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems loading the demo:\n" + ex.getMessage());
                ex.printStackTrace();
            }
        }

        public void demoNoteOnEvent(Track t, Sequence s, int chn, long millis, int note, boolean needDetails, int instrument, int velocity, int pressure, int reverb, int bend) {
            if (needDetails) {
                this.demoEvent(t, s, chn, millis, 176, 0, 0);
                this.demoEvent(t, s, chn, millis, 192, instrument, 0);
                this.demoEvent(t, s, chn, millis, 208, pressure, 0);
                this.demoEvent(t, s, chn, millis, 176, 91, reverb);
                int lo7 = bend & 0x7F;
                int hi7 = bend >> 7 & 0x7F;
                this.demoEvent(t, s, chn, millis, 224, lo7, hi7);
            }
            this.demoEvent(t, s, chn, millis, 144, note, velocity);
        }

        public void demoNoteOffEvent(Track t, Sequence s, int chn, long millis, int note, int velocity) {
            this.demoEvent(t, s, chn, millis, 128, note, velocity);
        }

        public void prepareDemos() {
            this.scaleSet = new int[11][][][];
            boolean[] heptatonic = new boolean[12];
            for (int i = 0; i < 7; ++i) {
                heptatonic[QuasiMusic.this.whiteIDs[i]] = true;
            }
            boolean[] minor = new boolean[12];
            for (int i = 0; i < 7; ++i) {
                minor[QuasiMusic.this.cMinorIDs[i]] = true;
            }
            this.scaleSet[0] = new int[128][1][1];
            int[][][] chromatic = this.scaleSet[0];
            for (int k = 0; k < 128; ++k) {
                chromatic[k][0][0] = k;
            }
            int nMajor = this.majorTonics.length;
            for (int i = 0; i < nMajor; ++i) {
                int[][][] scale = null;
                int tonic = this.majorTonics[i];
                for (int j = 0; j < 2; ++j) {
                    int count = 0;
                    for (int k = 0; k < 128; ++k) {
                        if (!heptatonic[(k - tonic + 1200) % 12]) continue;
                        if (scale != null) {
                            scale[count][0][0] = k;
                        }
                        ++count;
                    }
                    if (scale != null) continue;
                    scale = new int[count][1][1];
                }
                this.scaleSet[1 + i] = scale;
            }
            int nMinor = this.minorTonics.length;
            for (int i = 0; i < nMinor; ++i) {
                int[][][] scale = null;
                int tonic = this.minorTonics[i];
                for (int j = 0; j < 2; ++j) {
                    int count = 0;
                    for (int k = 0; k < 128; ++k) {
                        if (!minor[(k - tonic + 1200) % 12]) continue;
                        if (scale != null) {
                            scale[count][0][0] = k;
                        }
                        ++count;
                    }
                    if (scale != null) continue;
                    scale = new int[count][1][1];
                }
                this.scaleSet[3 + i] = scale;
            }
            int nMajorTriads = this.majorTonics.length;
            for (int i = 0; i < nMajorTriads; ++i) {
                int[][][] scale = null;
                int tonic = this.majorTonics[i];
                for (int j = 0; j < 2; ++j) {
                    int count = 0;
                    int k = 0;
                    while (k + 7 < 128) {
                        if (heptatonic[(k - tonic + 1200) % 12] && heptatonic[(k + 4 - tonic + 1200) % 12] && heptatonic[(k + 7 - tonic + 1200) % 12]) {
                            if (scale != null) {
                                scale[count][0][0] = k;
                                scale[count][0][1] = k + 4;
                                scale[count][0][2] = k + 7;
                            }
                            ++count;
                        }
                        ++k;
                    }
                    if (scale != null) continue;
                    scale = new int[count][1][3];
                }
                this.scaleSet[5 + i] = scale;
            }
            for (int da = 0; da < 2; ++da) {
                int nMajorAscents = this.majorTonics.length;
                for (int i = 0; i < nMajorAscents; ++i) {
                    int[][][] scale = new int[21][2][1];
                    int tonic = this.majorTonics[i];
                    int count = 0;
                    for (int eD = 0; eD < 7; ++eD) {
                        for (int fD = eD + 1; fD < 7; ++fD) {
                            scale[count][da][0] = tonic + QuasiMusic.this.whiteIDs[eD];
                            scale[count][1 - da][0] = tonic + QuasiMusic.this.whiteIDs[fD];
                            ++count;
                        }
                    }
                    this.scaleSet[7 + da * nMajorAscents + i] = scale;
                }
            }
            this.demoInstruments = new int[9][][];
            this.demoKeystrikes = new long[9];
            this.demoNoteTiming = new long[9];
            this.demoScales = new int[9];
            this.demoDims = new int[9];
            this.demoToolTips = new String[9];
            for (int demoNumber = 0; demoNumber < 9; ++demoNumber) {
                int i;
                int[] ins1;
                Object ins = null;
                long keyStrike = 200L;
                long noteTiming = 250L;
                int scale = 1;
                int dd = 0;
                String instrTip = null;
                if (demoNumber == 0) {
                    int[] ins0 = new int[]{9, 13, 112, 116, 115};
                    ins1 = new int[]{0, 3, 6, 10, 15};
                    ins = new int[2][];
                    ins[0] = ins0;
                    ins[1] = ins1;
                    scale = 2;
                } else if (demoNumber == 1) {
                    ins = new int[2][8];
                    for (i = 0; i < 8; ++i) {
                        ins[0][i] = 56 + i;
                        ins[1][i] = i;
                    }
                    instrTip = "All 8 brass";
                } else if (demoNumber == 2) {
                    ins = new int[2][16];
                    for (i = 0; i < 16; ++i) {
                        ins[0][i] = 8 * i;
                        ins[1][i] = i == 9 ? 10 : (i == 10 ? 9 : i);
                    }
                    instrTip = "First of all 16 groups (but ch 10 percuss instead of Synth Lead)";
                } else if (demoNumber == 3) {
                    int[] ins0 = new int[]{46};
                    ins1 = new int[]{0};
                    ins = new int[2][];
                    ins[0] = ins0;
                    ins[1] = ins1;
                    scale = 3;
                } else if (demoNumber == 4) {
                    int[] ins0 = new int[]{13, 112};
                    ins1 = new int[]{0, 1};
                    ins = new int[2][];
                    ins[0] = ins0;
                    ins[1] = ins1;
                    scale = 7;
                } else if (demoNumber == 5) {
                    int[] ins0 = new int[]{13, 112};
                    ins1 = new int[]{0, 1};
                    ins = new int[2][];
                    ins[0] = ins0;
                    ins[1] = ins1;
                    scale = 9;
                } else if (demoNumber == 6) {
                    ins = new int[2][14];
                    int chn = 0;
                    for (int i2 = 0; i2 < 14; ++i2) {
                        ins[0][i2] = i2 < 8 ? 40 + i2 : 56 + (i2 - 8);
                        if (chn == 9) {
                            // empty if block
                        }
                        int n = ++chn;
                        ++chn;
                        ins[1][i2] = n;
                    }
                    scale = 4;
                    keyStrike = 300L;
                    instrTip = "All 8 strings and 6 brass";
                } else if (demoNumber == 7) {
                    ins = new int[2][8];
                    for (i = 0; i < 8; ++i) {
                        ins[0][i] = i < 4 ? 64 + i : 72 + (i - 4);
                        ins[1][i] = i;
                    }
                    scale = 2;
                    instrTip = "First 4 reed and first 4 pipe";
                } else if (demoNumber == 8) {
                    ins = new int[2][8];
                    for (i = 0; i < 8; ++i) {
                        ins[0][i] = i < 4 ? i : 48 + (i - 4);
                        ins[1][i] = i;
                    }
                    scale = 5;
                    instrTip = "First 4 piano and first 4 ensemble";
                }
                this.demoInstruments[demoNumber] = ins;
                this.demoKeystrikes[demoNumber] = keyStrike;
                this.demoNoteTiming[demoNumber] = noteTiming;
                this.demoScales[demoNumber] = scale;
                this.demoDims[demoNumber] = dd;
                int nchn = ins[0].length;
                StringBuffer sb = new StringBuffer(512);
                if (instrTip == null) {
                    for (int i3 = 0; i3 < nchn; ++i3) {
                        sb.append(this.parent.midiSynth.instrumentName(0, ins[0][i3]));
                        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                            sb.setLength(sb.length() - 1);
                        }
                        if (i3 == nchn - 1) continue;
                        sb.append(", ");
                    }
                } else {
                    sb.append(instrTip);
                }
                sb.append(" - " + this.scaleNames[scale]);
                this.demoToolTips[demoNumber] = sb.toString();
            }
        }

        public String[] getDemoToolTips() {
            return this.demoToolTips;
        }

        public void loadDemo(int demoNumber) {
            if (!this.okToWipe()) {
                return;
            }
            for (int i = 0; i < this.nChannels; ++i) {
                for (int j = 0; j < this.maxDim; ++j) {
                    for (int k = 0; k < this.maxDim; ++k) {
                        this.tileNotes[i][j][k] = null;
                    }
                }
            }
            this.rseed1 = this.rseed2 = 23456789L * (long)demoNumber;
            this.setup(this.dim, this.scaleNumber);
            int velocity = 64;
            int pressure = 64;
            int reverb = 64;
            int bend = 8192;
            int baseNoteIndex = 0;
            int[] ins = this.demoInstruments[demoNumber][0];
            int[] chns = this.demoInstruments[demoNumber][1];
            long keyStrike = this.demoKeystrikes[demoNumber];
            long noteTiming = this.demoNoteTiming[demoNumber];
            int[][][] scale = this.scaleSet[this.demoScales[demoNumber]];
            int dd = this.demoDims[demoNumber];
            if (dd == 0) {
                dd = this.dim;
            }
            if (ins != null) {
                baseNoteIndex = scale.length / 2 - dd * (dd - 1) / 4;
                for (int ci = 0; ci < ins.length; ++ci) {
                    int chn = chns[ci];
                    int noteIndex = baseNoteIndex;
                    for (int eD = 0; eD < dd; ++eD) {
                        for (int fD = eD + 1; fD < dd; ++fD) {
                            if (noteIndex >= 0 && noteIndex < scale.length) {
                                Track t;
                                Sequence s;
                                try {
                                    Sequence sequence = QuasiMusic.this.makeEmptySequence();
                                    this.tileNotes[chn][eD][fD] = sequence;
                                    s = sequence;
                                    t = s.createTrack();
                                }
                                catch (Exception ex) {
                                    QuasiMusic.showErrorMessage("There were problems loading the demo:\n" + ex.getMessage());
                                    ex.printStackTrace();
                                    return;
                                }
                                int[][] cseq = scale[noteIndex];
                                int nseq = cseq.length;
                                int[] chord = null;
                                long noteStart = 0L;
                                for (int z = 0; z < nseq; ++z) {
                                    int c;
                                    noteStart = (long)z * noteTiming;
                                    chord = cseq[z];
                                    int nc = chord.length;
                                    for (c = 0; c < nc; ++c) {
                                        this.demoNoteOnEvent(t, s, chn, noteStart, chord[c], true, ins[ci], velocity, pressure, reverb, bend);
                                    }
                                    for (c = 0; c < nc; ++c) {
                                        this.demoNoteOffEvent(t, s, chn, noteStart + keyStrike, chord[c], velocity);
                                    }
                                }
                                this.demoNoteOffEvent(t, s, chn, noteStart + keyStrike + 1000L, chord[0], velocity);
                            }
                            ++noteIndex;
                        }
                    }
                }
            }
            this.K = null;
            this.repaint();
            this.pristine = true;
            this.setSavedAs(null);
            QuasiMusic.this.setTitle("Demo " + (demoNumber + 1));
        }

        public boolean okToWipe() {
            if (this.pristine) {
                return true;
            }
            int reply = JOptionPane.showConfirmDialog(null, "If you proceed you will lose the changes you've made.\nAre you sure you want to do this?", "Changes will be lost", 2);
            return reply == 0;
        }

        @Override
        public void paint(Graphics g) {
            this.update(g);
        }

        @Override
        public synchronized void update(Graphics g) {
            if (currentlyMakingVideo) {
                if (this.frameNumber == 0L) {
                    this.renderToFile();
                }
            } else {
                this.render(g);
            }
        }

        private void renderToFile() {
            this.render(this.VG);
            String imageFormat = "png";
            ++this.frameNumber;
            String fn = "0000000000" + this.frameNumber;
            String fnm = fn.substring(fn.length() - 8) + "." + imageFormat;
            try {
                ImageIO.write((RenderedImage)this.V, imageFormat, new File("QuasiMusic" + fnm));
            }
            catch (IOException e) {
                System.out.println("Error writing video frame " + fnm);
            }
            System.out.println("Wrote video frame " + fnm);
            if (this.lowY >= this.lastLowY) {
                System.out.println("Done");
                currentlyMakingVideo = false;
                this.setScrolling(false);
            }
        }

        private void render(Graphics g) {
            int w = 2 * (this.getSize().width / 2);
            int h = 2 * (this.getSize().height / 2);
            boolean needPlayBack = false;
            if (forVideo) {
                w = 1280;
                h = 720;
                this.setSize(new Dimension(w, h));
            }
            int offH = 2 * h;
            int halfOH = offH / 2;
            if (this.flashTilesX == null) {
                this.nFlashTiles = (short)(this.nChannels * h / 4);
                this.iFlashTiles = 0;
                this.flashTilesX = new float[this.nFlashTiles][4];
                this.flashTilesY = new float[this.nFlashTiles][4];
                this.tilesToFlash = new short[this.nFlashTiles];
                this.flashCount = new short[this.nFlashTiles];
                this.flashIndex = new short[this.nFlashTiles];
                this.flashTileCols = new Color[this.nFlashTiles];
                this.nToFlash = 0;
            }
            if (this.J == null || this.Jw != w || this.Jh != offH) {
                this.raster = this.cm1.createCompatibleWritableRaster(w, offH);
                this.dataBuffer = (DataBufferByte)this.raster.getDataBuffer();
                this.J = new BufferedImage(this.cm1, this.raster, false, null);
                this.H = this.J.getGraphics();
                this.Jw = w;
                this.Jh = offH;
                this.d(this.H, w, 0, offH, this.lowY + (long)halfOH);
                this.take = 0;
            } else if (this.take + h >= offH) {
                this.lowY += (long)this.take;
                this.H.copyArea(0, this.take, w, offH - this.take, 0, -this.take);
                this.d(this.H, w, offH - this.take, offH, this.lowY + (long)((2 * offH - this.take) / 2));
                this.take = 0;
            } else if (this.take < 0) {
                this.lowY += (long)this.take;
                this.H.copyArea(0, 0, w, offH + this.take, 0, -this.take);
                this.d(this.H, w, 0, -this.take, this.lowY + (long)(-this.take / 2));
                this.take = 0;
            }
            if (this.needSequence) {
                if (this.nToFlash > 0) {
                    for (int i = 0; i < this.nToFlash; ++i) {
                        short tileNum = this.tilesToFlash[i];
                        if (i < 0) continue;
                        this.flashCount[i] = 0;
                    }
                    this.nToFlash = 0;
                }
                this.d(this.H, w, this.take, offH, this.lowY + (long)((this.take + offH) / 2));
                this.needSequence = false;
                needPlayBack = true;
            }
            if (this.defaultSamplePoints == null) {
                this.createDefaultSamplePoints(h);
            }
            if (this.K == null) {
                boolean contrast = this.scrolling || this.playingLowDim >= 0;
                int nt = this.ngs;
                for (int eD = 0; eD < this.dim; ++eD) {
                    for (int fD = eD + 1; fD < this.dim; ++fD) {
                        boolean someTileNotes;
                        if (this.scrolling) {
                            someTileNotes = false;
                            for (int i = 0; i < this.nChannels; ++i) {
                                if (this.tileNotes[i][eD][fD] == null) continue;
                                someTileNotes = true;
                                break;
                            }
                        } else {
                            boolean bl = someTileNotes = this.tileNotes[this.currentChannelIndex][eD][fD] != null;
                        }
                        if (this.playingLowDim == eD && this.playingHighDim == fD) {
                            this.r2[nt] = this.r3[nt];
                            this.g2[nt] = this.g3[nt];
                            this.b2[nt] = this.b3[nt];
                        } else if (this.selectedLowDim == eD && this.selectedHighDim == fD) {
                            this.r2[nt] = (byte)QuasiMusic.this.selCol.getRed();
                            this.g2[nt] = (byte)QuasiMusic.this.selCol.getGreen();
                            this.b2[nt] = (byte)QuasiMusic.this.selCol.getBlue();
                        } else if (someTileNotes) {
                            if (contrast) {
                                this.r2[nt] = this.r4[nt];
                                this.g2[nt] = this.g4[nt];
                                this.b2[nt] = this.b4[nt];
                            } else {
                                this.r2[nt] = this.r1[nt];
                                this.g2[nt] = this.g1[nt];
                                this.b2[nt] = this.b1[nt];
                            }
                        } else {
                            this.b2[nt] = -1;
                            this.g2[nt] = -1;
                            this.r2[nt] = -1;
                        }
                        ++nt;
                    }
                }
                this.cm2 = new IndexColorModel(8, 256, this.r2, this.g2, this.b2);
                this.K = new BufferedImage(this.cm2, this.raster, false, null);
            }
            g.drawImage(this.K, 0, -this.take, null);
            this.latestTake = this.take;
            if (this.scrolling) {
                this.drawCues(g);
                this.take += 2;
            }
            this.drawSamplePoints(g, h);
            if (this.playingLowDim >= 0 && this.pressedPoint != null && this.playingDescr != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(Color.black);
                g2.fill(this.playingDescrR);
                g2.setPaint(Color.white);
                g2.drawString(this.playingDescr, this.pressedPoint.x, this.pressedPoint.y - this.latestTake);
            }
            if (needPlayBack) {
                Sequence s = this.prepareSequence();
                if (currentlyMakingVideo) {
                    this.videoPlayback(s);
                } else {
                    this.parent.midiSynth.playBack(s);
                }
            }
        }

        public synchronized void setScrolling(boolean scrolling) {
            this.scrolling = scrolling;
            this.solo = this.parent.tileControls.isSolo();
            if (scrolling) {
                if (this.selectedLowDim >= 0) {
                    this.tileClick();
                }
                this.playingLowDim = -1;
                this.selectedSamplePoint = -1;
                this.assembleActiveChannels();
                this.cues = new Vector(1000);
                this.currentSeq = null;
                this.nextSeq = null;
                this.needSequence = true;
            } else {
                this.parent.midiSynth.stopPlayBack();
            }
            this.K = null;
            this.repaint();
        }

        private void assembleActiveChannels() {
            this.activeChannels = new int[this.nChannels];
            this.nActive = 0;
            for (int j = 0; j < this.nChannels; ++j) {
                if (this.solo && j != this.currentChannelIndex) continue;
                boolean someTileNotes = false;
                block1: for (int eD = 0; eD < this.dim; ++eD) {
                    for (int fD = eD + 1; fD < this.dim; ++fD) {
                        if (this.tileNotes[j][eD][fD] == null) continue;
                        someTileNotes = true;
                        continue block1;
                    }
                }
                if (!someTileNotes) continue;
                this.activeChannels[this.nActive++] = j;
            }
            if (this.nActive > 1) {
                for (int lo = 0; lo < this.nActive - 1; ++lo) {
                    int m = lo;
                    for (int i = lo + 1; i < this.nActive; ++i) {
                        if (this.currentSamplePoints[this.activeChannels[i]][0] >= this.currentSamplePoints[this.activeChannels[m]][0]) continue;
                        m = i;
                    }
                    if (m == lo) continue;
                    int tmp = this.activeChannels[m];
                    this.activeChannels[m] = this.activeChannels[lo];
                    this.activeChannels[lo] = tmp;
                }
            }
        }

        public synchronized void donePlaying() {
            if (this.scrolling) {
                Sequence s = this.prepareSequence();
                if (currentlyMakingVideo) {
                    this.videoPlayback(s);
                } else {
                    this.parent.midiSynth.playBack(s);
                }
            } else if (this.playingMIDI) {
                this.donePlayingMIDI();
                this.parent.tileControls.donePlayingMIDI();
            } else {
                this.playingLowDim = -1;
                this.playingHighDim = -1;
                this.K = null;
                this.repaint();
            }
        }

        public synchronized void textMessage(byte[] txt) {
            if (txt[0] == this.frameMessage[0]) {
                if (currentlyMakingVideo) {
                    System.out.println("Got frame message");
                    this.renderToFile();
                } else {
                    this.repaint();
                }
            } else {
                short tileNumber;
                boolean off;
                boolean on = txt[0] == this.flashOnMessage[0];
                boolean bl = off = txt[0] == this.flashOffMessage[0];
                if (on) {
                    short s = tileNumber = this.getShort(txt);
                    short s2 = this.flashCount[s];
                    this.flashCount[s] = (short)(s2 + 1);
                    if (s2 == 0) {
                        boolean done = false;
                        for (int i = 0; i < this.nToFlash; ++i) {
                            if (this.tilesToFlash[i] != -1) continue;
                            this.tilesToFlash[i] = tileNumber;
                            this.flashIndex[tileNumber] = (short)i;
                            done = true;
                            break;
                        }
                        if (!done) {
                            if (this.nToFlash < this.nFlashTiles) {
                                this.tilesToFlash[this.nToFlash] = tileNumber;
                                this.flashIndex[tileNumber] = this.nToFlash;
                                this.nToFlash = (short)(this.nToFlash + 1);
                            } else {
                                this.flashIndex[tileNumber] = -1;
                            }
                        }
                    }
                }
                if (off) {
                    short fi;
                    short s = tileNumber = this.getShort(txt);
                    this.flashCount[s] = (short)(this.flashCount[s] - 1);
                    if (this.flashCount[s] <= 0 && (fi = this.flashIndex[tileNumber]) >= 0) {
                        this.flashIndex[tileNumber] = -1;
                        this.tilesToFlash[fi] = -1;
                        if (fi == this.nToFlash - 1) {
                            this.nToFlash = (short)(this.nToFlash - 1);
                        }
                    }
                }
            }
        }

        private void donePlayingMIDI() {
            this.playingMIDI = false;
            if (this.midiIn != null) {
                try {
                    this.midiIn.close();
                }
                catch (Exception ex) {
                    QuasiMusic.showErrorMessage("There were problems with the MIDI file:\n" + ex.getMessage());
                    ex.printStackTrace();
                }
                this.midiIn = null;
            }
        }

        public synchronized void setRecordingMIDI(boolean recordingMIDI) {
            this.recordingMIDI = recordingMIDI;
            if (recordingMIDI) {
                this.prepareMIDIrec();
                if (forVideo) {
                    this.prepareToMakeVideo();
                }
                this.setScrolling(true);
            } else {
                this.setScrolling(false);
                this.saveMidiAs();
                if (forVideo) {
                    this.finishMakingVideo();
                }
            }
        }

        void prepareToMakeVideo() {
        }

        void finishMakingVideo() {
            this.lastLowY = this.lowY;
            this.setup(this.dim, this.scaleNumber);
            this.V = new BufferedImage(1280, 720, 1);
            this.VG = this.V.getGraphics();
            this.frameNumber = 0L;
            currentlyMakingVideo = true;
            this.setScrolling(true);
        }

        void videoPlayback(Sequence s) {
            Track tr = s.getTracks()[0];
            if (tr != null) {
                int n = tr.size();
                for (int ee = 0; ee < n; ++ee) {
                    MidiEvent event = tr.get(ee);
                    MidiMessage msg = event.getMessage();
                    int status = msg.getStatus();
                    if (status != 255) continue;
                    MetaMessage message = (MetaMessage)msg;
                    int type = message.getType();
                    if (type == 47) {
                        System.out.println("Got EOT");
                        this.donePlaying();
                        continue;
                    }
                    if (type != 1) continue;
                    this.textMessage(message.getData());
                }
            }
        }

        public synchronized void setPlayingMIDI(boolean playingMIDI) {
            this.playingMIDI = playingMIDI;
            if (playingMIDI) {
                if (!this.startPlayingMIDI()) {
                    playingMIDI = false;
                    this.parent.tileControls.donePlayingMIDI();
                }
            } else {
                this.parent.midiSynth.stopPlayBack();
                this.donePlayingMIDI();
            }
        }

        public void prepareMIDIrec() {
            this.rmSeq = QuasiMusic.this.makeEmptySequence();
            this.rmTrack = this.rmSeq.createTrack();
            this.MIDIstartTime = System.currentTimeMillis();
        }

        public void appendSequence(Sequence s) {
            Track tr = s.getTracks()[0];
            if (tr != null) {
                long ticks = this.rmTrack.ticks();
                int n = tr.size() - 1;
                for (int ee = 0; ee < n; ++ee) {
                    MidiEvent tileEvent = tr.get(ee);
                    MidiEvent event = new MidiEvent((MidiMessage)tileEvent.getMessage().clone(), tileEvent.getTick() + ticks);
                    this.rmTrack.add(event);
                }
            }
        }

        private void createDefaultSamplePoints(int h) {
            this.defaultSamplePoints = new int[this.nChannels][2];
            this.currentSamplePoints = new int[this.nChannels][2];
            int dx = this.Jw / this.nChannels;
            int hdx = dx / 2;
            for (int j = 0; j < this.nChannels; ++j) {
                int n = hdx + j * dx;
                this.currentSamplePoints[j][0] = n;
                this.defaultSamplePoints[j][0] = n;
                int n2 = h / 2;
                this.currentSamplePoints[j][1] = n2;
                this.defaultSamplePoints[j][1] = n2;
            }
        }

        private Sequence prepareSequence() {
            long maxTick;
            long maxPix;
            if (this.currentSeq == null) {
                this.currentSeq = QuasiMusic.this.makeEmptySequence();
                this.currentTrack = this.currentSeq.createTrack();
            }
            if (this.nextSeq == null) {
                this.nextSeq = QuasiMusic.this.makeEmptySequence();
                this.nextTrack = this.nextSeq.createTrack();
            }
            long ymin = this.Jh;
            for (int i = 0; i < this.nChannels; ++i) {
                long ym = this.greatestYcue - (this.lowY + (long)this.take + (long)this.currentSamplePoints[i][1]);
                if (ym >= ymin) continue;
                ymin = ym;
            }
            long tf = this.timeStep * (long)this.currentSeq.getResolution();
            long currentMaxTick = ymin * tf / 500L / 2L;
            Vector<Cue> newCues = new Vector<Cue>(1000);
            int nc = this.cues.size();
            long[] flashTicksOn = new long[nc];
            long[] flashTicksOff = new long[nc];
            short[] flashTiles = new short[nc];
            int nFlash = 0;
            for (int i = 0; i < nc; ++i) {
                Cue c = this.cues.get(i);
                if (c == null) continue;
                newCues.add(c);
                if (c.usedForMusic) continue;
                int chn = c.chn;
                int eD = c.eD;
                int fD = c.fD;
                long y0 = (long)Math.round(c.y) - (this.lowY + (long)this.take) - (long)this.currentSamplePoints[chn][1];
                if (y0 > ymin) continue;
                c.usedForMusic = true;
                Sequence ts = this.tileNotes[chn][eD][fD];
                if (ts == null || y0 < 0L) continue;
                long tick = y0 * tf / 500L / 2L;
                Track tr = ts.getTracks()[0];
                if (tr == null) continue;
                flashTicksOn[nFlash] = tick;
                flashTicksOff[nFlash] = tick + tr.ticks();
                flashTiles[nFlash++] = c.tileNumber;
                int n = tr.size() - 2;
                for (int ee = 0; ee < n; ++ee) {
                    Track tdest;
                    MidiEvent tileEvent = tr.get(ee);
                    long evTick = tileEvent.getTick() + tick;
                    if (evTick > currentMaxTick) {
                        evTick -= currentMaxTick;
                        tdest = this.nextTrack;
                    } else {
                        tdest = this.currentTrack;
                    }
                    MidiEvent event = new MidiEvent((MidiMessage)tileEvent.getMessage().clone(), evTick);
                    tdest.add(event);
                }
            }
            if (this.recordingMIDI) {
                this.appendSequence(this.currentSeq);
            }
            if ((maxPix = (maxTick = this.currentTrack.ticks()) * 2L * 500L / tf) == 0L) {
                maxPix = 2L;
            }
            if (maxPix % 2L == 1L) {
                ++maxPix;
            }
            try {
                long tick;
                int i = 2;
                while ((long)i <= maxPix && (tick = (long)i * tf / 500L / 2L) <= currentMaxTick) {
                    MetaMessage message = new MetaMessage();
                    message.setMessage(1, this.frameMessage, 1);
                    this.currentTrack.add(new MidiEvent(message, tick));
                    i += 2;
                }
                for (i = 0; i < nFlash; ++i) {
                    Track tdest;
                    long evTick = flashTicksOn[i];
                    if (evTick > currentMaxTick) {
                        evTick -= currentMaxTick;
                        tdest = this.nextTrack;
                    } else {
                        tdest = this.currentTrack;
                    }
                    MetaMessage message = new MetaMessage();
                    this.setToShort(flashTiles[i], this.flashOnMessage);
                    message.setMessage(1, this.flashOnMessage, 4);
                    tdest.add(new MidiEvent(message, evTick));
                    evTick = flashTicksOff[i];
                    if (evTick > currentMaxTick) {
                        evTick -= currentMaxTick;
                        tdest = this.nextTrack;
                    } else {
                        tdest = this.currentTrack;
                    }
                    message = new MetaMessage();
                    this.setToShort(flashTiles[i], this.flashOffMessage);
                    message.setMessage(1, this.flashOffMessage, 4);
                    tdest.add(new MidiEvent(message, evTick));
                }
            }
            catch (Exception ex) {
                QuasiMusic.showErrorMessage("There were problems creating a MIDI message:\n" + ex.getMessage());
                ex.printStackTrace();
            }
            this.cues = newCues;
            Sequence s = this.currentSeq;
            this.currentSeq = this.nextSeq;
            this.currentTrack = this.nextTrack;
            this.nextSeq = null;
            return this.filterTrack(s, -1L);
        }

        private void setToShort(short value, byte[] target) {
            target[1] = (byte)(value & 0x7F);
            target[2] = (byte)(value >> 7 & 0x7F);
            target[3] = (byte)(value >> 14 & 0x7F);
        }

        private short getShort(byte[] msg) {
            return (short)(msg[1] | msg[2] << 7 | msg[3] << 14);
        }

        private Sequence filterTrack(Sequence s, long timeLimitMillisecs) {
            if (s == null) {
                return null;
            }
            Track tr = s.getTracks()[0];
            if (tr == null) {
                return null;
            }
            byte[][] lastSimilar = new byte[80][];
            boolean[][] notePlaying = new boolean[16][128];
            int npc = 0;
            Sequence sequence = QuasiMusic.this.makeEmptySequence();
            Track track = sequence.createTrack();
            long timeLimitTicks = -1L;
            if (timeLimitMillisecs > 0L) {
                timeLimitTicks = QuasiMusic.this.ticksFromMillis(timeLimitMillisecs, sequence);
            }
            int n = tr.size();
            for (int ee = 0; ee < n; ++ee) {
                MidiEvent event = tr.get(ee);
                MidiMessage msg = event.getMessage();
                int status = msg.getStatus();
                int type = status & 0xF0;
                if (status == 255 && ((MetaMessage)msg).getType() == 47) continue;
                int indx = (status & 0xFF) - 176;
                if (indx >= 0 && indx < 64) {
                    byte control;
                    byte[] b0 = lastSimilar[indx];
                    byte[] b1 = msg.getMessage();
                    if (type == 176 && (control = b1[1]) == 91) {
                        indx += 64;
                    }
                    if (b0 == null) {
                        lastSimilar[indx] = b1;
                    } else {
                        int len = msg.getLength();
                        boolean same = true;
                        for (int i = 0; i < len; ++i) {
                            if (b0[i] == b1[i]) continue;
                            same = false;
                            break;
                        }
                        if (same) continue;
                        lastSimilar[indx] = b1;
                    }
                } else {
                    byte note;
                    int chn = status & 0xF;
                    if (type == 144) {
                        byte note2 = msg.getMessage()[1];
                        if (!notePlaying[chn][note2]) {
                            notePlaying[chn][note2] = true;
                            ++npc;
                        }
                    } else if (type == 128 && notePlaying[chn][note = msg.getMessage()[1]]) {
                        notePlaying[chn][note] = false;
                        --npc;
                    }
                }
                track.add(event);
                if (timeLimitTicks > 0L && npc == 0 && event.getTick() >= timeLimitTicks) break;
            }
            return sequence;
        }

        private void drawCues(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.addRenderingHints(this.aaON);
            g2.setStroke(this.str);
            for (int i = 0; i < this.nToFlash; ++i) {
                short tileNum = this.tilesToFlash[i];
                if (tileNum < 0) continue;
                float[] xp = this.flashTilesX[tileNum];
                float[] yp = this.flashTilesY[tileNum];
                this.rhomb.reset();
                for (int m = 0; m < 4; ++m) {
                    if (m == 0) {
                        this.rhomb.moveTo(xp[m], yp[m] - (float)(this.lowY + (long)this.take));
                        continue;
                    }
                    this.rhomb.lineTo(xp[m], yp[m] - (float)(this.lowY + (long)this.take));
                }
                this.rhomb.closePath();
                g2.setPaint(this.flashTileCols[tileNum]);
                g2.fill(this.rhomb);
                g2.setPaint(Color.black);
                g2.draw(this.rhomb);
            }
            g.setColor(Color.white);
            int n = this.cues.size();
            for (int i = 0; i < n; ++i) {
                Cue c = this.cues.get(i);
                if (c == null) continue;
                int x = c.x;
                float y0 = c.y - (float)(this.lowY + (long)this.take);
                int y = (int)y0;
                g.fillRect(x - 2, y - 1, 5, 2);
                if (y >= -2 || !c.usedForMusic) continue;
                this.cues.set(i, null);
            }
        }

        private void drawSamplePoints(Graphics g, int h) {
            int ndisp = this.scrolling ? this.nActive : this.nChannels;
            for (int k = 0; k < ndisp; ++k) {
                int i = this.scrolling ? this.activeChannels[k] : k;
                boolean sp = i == this.selectedSamplePoint;
                int x = this.currentSamplePoints[i][0];
                int y = this.currentSamplePoints[i][1];
                if (sp) {
                    Font f = this.getFont();
                    FontMetrics fm = this.getFontMetrics(f);
                    String str = "Channel " + (i + 1) + " (" + x + "," + (h / 2 - y) + ")";
                    Rectangle r = fm.getStringBounds(str, this.H).getBounds();
                    int xs = 7;
                    int ys = this.getHeight() - 7 - fm.getDescent();
                    r.translate(xs, ys);
                    r.grow(5, 5);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setPaint(Color.black);
                    g2.fill(r);
                    g2.setPaint(Color.white);
                    g2.drawString(str, xs, ys);
                }
                g.setColor(Color.black);
                g.setXORMode(sp ? Color.yellow : Color.red);
                g.fillRect(x - 3, y - 3, 7, 7);
                g.setPaintMode();
                g.setColor(Color.black);
                g.drawRect(x - 3, y - 3, 7, 7);
            }
        }

        public synchronized void randomise(long factor) {
            this.rseed1 += factor * 9753124680L;
        }

        public synchronized void setup(int dim, int scaleNumber) {
            int eD;
            int fD;
            Random ran1 = new Random(this.rseed1);
            Random ran2 = new Random(this.rseed2);
            this.dim = dim;
            this.setScale(scaleNumber);
            this.J = null;
            this.K = null;
            this.flashTilesX = null;
            this.Gx = new double[dim];
            this.Gy = new double[dim];
            this.Gd = new double[dim];
            double phase = 6.0 * ran1.nextDouble();
            double sA = Math.PI / (double)dim;
            double hA = sA / 2.0;
            double theta = (double)(dim % 2 + 1) * sA;
            double norm = Math.sqrt(2.0 / (double)dim);
            for (int k = 0; k < dim; ++k) {
                double xg = norm * Math.cos(phase + theta * (double)k);
                double yg = norm * Math.sin(phase + theta * (double)k);
                this.Gx[k] = xg;
                this.Gy[k] = yg;
                this.Gd[k] = ran1.nextDouble();
            }
            float cfac = ran2.nextFloat();
            float bfac = 0.75f;
            this.marg = this.halfScaleFactor * norm / Math.sin(hA);
            this.Dets = new double[dim][dim];
            this.tileCols = new Color[dim][dim];
            this.tileColsDarker = new Color[dim][dim];
            this.tileColsBrighter = new Color[dim][dim];
            this.left = new int[dim][dim];
            this.top = new int[dim][dim];
            this.right = new int[dim][dim];
            for (fD = 0; fD < dim; ++fD) {
                for (eD = 0; eD < dim; ++eD) {
                    double xf = this.Gx[fD];
                    double yf = this.Gy[fD];
                    double xe = this.Gx[eD];
                    double ye = this.Gy[eD];
                    float t = (float)(Math.acos((xf * xe + yf * ye) / Math.sqrt((xf * xf + yf * yf) * (xe * xe + ye * ye))) / Math.PI);
                    float tsef = 2.0f * Math.min(t, 1.0f - t);
                    float toef = (float)Math.abs((Math.atan2(xf, yf) + Math.atan2(xe, ye)) / (Math.PI * 2));
                    this.Dets[fD][eD] = ye * xf - xe * yf;
                    this.tileCols[eD][fD] = new Color(Color.HSBtoRGB((cfac + tsef) % 1.0f, 1.0f, bfac * toef + (1.0f - bfac)));
                    this.tileColsDarker[eD][fD] = new Color(Color.HSBtoRGB((cfac + tsef) % 1.0f, 1.0f, 0.5f * (bfac * toef + (1.0f - bfac))));
                    this.tileColsBrighter[eD][fD] = new Color(Color.HSBtoRGB((cfac + tsef) % 1.0f, 1.0f, 1.0f));
                    this.right[eD][fD] = -1;
                    this.top[eD][fD] = -1;
                    this.left[eD][fD] = -1;
                }
            }
            this.ntc = dim * (dim - 1) / 2;
            this.ngs = 256 - this.ntc;
            this.edt = new int[this.ntc];
            this.fdt = new int[this.ntc];
            int nt = 0;
            for (eD = 0; eD < dim; ++eD) {
                fD = eD + 1;
                while (fD < dim) {
                    this.edt[nt] = eD;
                    this.fdt[nt++] = fD++;
                }
            }
            for (int i = 0; i < 256; ++i) {
                int red;
                int green;
                int blue;
                if (i < this.ngs) {
                    float bri = (float)i / (float)this.ngs;
                    green = blue = new Color(bri, bri, bri).getRed();
                    red = blue;
                    this.r2[i] = (byte)red;
                    this.g2[i] = (byte)green;
                    this.b2[i] = (byte)blue;
                } else {
                    int j = i - this.ngs;
                    Color c = this.tileCols[this.edt[j]][this.fdt[j]];
                    red = c.getRed();
                    green = c.getGreen();
                    blue = c.getBlue();
                    c = this.tileColsBrighter[this.edt[j]][this.fdt[j]];
                    int red2 = c.getRed();
                    int green2 = c.getGreen();
                    int blue2 = c.getBlue();
                    this.r3[i] = (byte)red2;
                    this.g3[i] = (byte)green2;
                    this.b3[i] = (byte)blue2;
                    c = this.tileColsDarker[this.edt[j]][this.fdt[j]];
                    red2 = c.getRed();
                    green2 = c.getGreen();
                    blue2 = c.getBlue();
                    this.r4[i] = (byte)red2;
                    this.g4[i] = (byte)green2;
                    this.b4[i] = (byte)blue2;
                }
                this.r1[i] = (byte)red;
                this.g1[i] = (byte)green;
                this.b1[i] = (byte)blue;
            }
            this.cm1 = new IndexColorModel(8, 256, this.r1, this.g1, this.b1);
            double span0 = 50.0 / Math.sqrt(dim);
            this.inc = span0 / 300.0;
            this.lowY = 0L;
            this.take = 0;
            this.noSelection();
            this.playingHighDim = -1;
            this.playingLowDim = -1;
            this.repaint();
        }

        public synchronized void needNewK() {
            this.K = null;
            this.repaint();
        }

        public void d(Graphics g, int w, int y1, int y2, long yoffs) {
            boolean doGraphics = g != null;
            int wc = w / 2;
            int h2 = (y2 - y1) / 2;
            int hc = y1 + h2;
            float yy = 0.0f;
            Graphics2D g2 = null;
            if (doGraphics) {
                g.setColor(Color.black);
                g.fillRect(0, y1, w, y2 - y1);
                g2 = (Graphics2D)g;
                g2.setStroke(this.str);
                this.latestHC = hc;
                this.latestYoffs = yoffs;
            }
            float[] xp = new float[4];
            float[] yp = new float[4];
            double[] gx = this.Gx;
            double[] gy = this.Gy;
            double[] gd = this.Gd;
            double[][] dets = this.Dets;
            double xm1 = (double)wc * this.inc + this.marg;
            double xm0 = -xm1;
            double ym1 = (double)(yoffs + (long)h2) * this.inc + this.marg;
            double ym0 = (double)(yoffs - (long)h2) * this.inc - this.marg;
            double[] xm = new double[]{xm0, xm1};
            double[] ym = new double[]{ym0, ym1};
            double[] xep = new double[2];
            double[] yep = new double[2];
            for (int eD = 0; eD < this.dim; ++eD) {
                int k;
                double xe = gx[eD];
                double ye = gy[eD];
                double de = gd[eD] + this.halfScaleFactor;
                int lc = Integer.MAX_VALUE;
                int uc = Integer.MIN_VALUE;
                for (int j = 0; j < 2; ++j) {
                    for (int i = 0; i < 2; ++i) {
                        k = (int)Math.ceil((xe * xm[i] + ye * ym[j] + de) / this.scaleFactor);
                        if (k < lc) {
                            lc = k;
                        }
                        if (--k <= uc) continue;
                        uc = k;
                    }
                }
                for (int eV = lc; eV <= uc; ++eV) {
                    double y;
                    double x;
                    double ae = this.scaleFactor * (double)eV - de;
                    int nn = 0;
                    for (int ii = 0; ii < 2 && nn < 2; ++ii) {
                        x = xm[ii];
                        y = (ae - xe * x) / ye;
                        if (y >= ym0 && y <= ym1) {
                            xep[nn] = x;
                            yep[nn++] = y;
                            if (nn == 2) break;
                        }
                        if (!((x = (ae - ye * (y = ym[ii])) / xe) >= xm0) || !(x <= xm1)) continue;
                        xep[nn] = x;
                        yep[nn++] = y;
                    }
                    double xep0 = xep[0];
                    double xep1 = xep[1];
                    double yep0 = yep[0];
                    double yep1 = yep[1];
                    for (int fD = eD + 1; fD < this.dim; ++fD) {
                        double xf = gx[fD];
                        double xfae = xf * ae;
                        double yf = gy[fD];
                        double yfae = yf * ae;
                        double df = gd[fD] + this.halfScaleFactor;
                        double dd = dets[eD][fD];
                        Color col = this.tileCols[eD][fD];
                        int lc0 = (int)Math.ceil((xf * xep0 + yf * yep0 + df) / this.scaleFactor);
                        int uc0 = (int)Math.floor((xf * xep1 + yf * yep1 + df) / this.scaleFactor);
                        if (uc0 < lc0) {
                            k = lc0;
                            lc0 = uc0 + 1;
                            uc0 = k - 1;
                        }
                        for (int fV = lc0; fV <= uc0; ++fV) {
                            int m;
                            double af = this.scaleFactor * (double)fV - df;
                            x = (yfae - ye * af) / dd;
                            y = (xe * af - xfae) / dd;
                            double xs = 0.0;
                            double ys = 0.0;
                            for (m = 0; m < this.dim; ++m) {
                                if (m == eD || m == fD) continue;
                                double gxm = gx[m];
                                double gym = gy[m];
                                double gdm = gd[m];
                                double z = this.scaleFactor * Math.floor((gxm * x + gym * y + gdm) / this.scaleFactor + 0.5) - gdm;
                                xs += z * gxm;
                                ys += z * gym;
                            }
                            for (m = 0; m < 4; ++m) {
                                double ee = ae + this.scaleFactor * (0.5 - (double)(m / 2));
                                double ff = af + this.scaleFactor * (0.5 - (double)((m + 1) % 4 / 2));
                                double xa = xs + ee * xe + ff * xf;
                                double ya = ys + ee * ye + ff * yf;
                                xp[m] = (float)((double)wc + xa / this.inc);
                                yp[m] = (float)((double)hc + ya / this.inc - (double)yoffs);
                                if (m != 0) continue;
                                yy = (float)ya;
                            }
                            if (doGraphics) {
                                this.drawTile(g2, xp, yp, col, eD, fD, y1, y2);
                                continue;
                            }
                            this.identifyPoint(xp, yp, eD, fD);
                        }
                    }
                }
            }
            if (this.scrolling && doGraphics) {
                this.greatestYcue = this.lowY + (long)y2 - 1L;
            }
        }

        public void drawTile(Graphics2D g2, float[] xp, float[] yp, Color col, int eD, int fD, int y1, int y2) {
            this.rhomb.reset();
            for (int m = 0; m < 4; ++m) {
                if (m == 0) {
                    this.rhomb.moveTo(xp[m], yp[m]);
                    continue;
                }
                this.rhomb.lineTo(xp[m], yp[m]);
            }
            this.rhomb.closePath();
            g2.setPaint(col);
            g2.fill(this.rhomb);
            g2.setPaint(Color.black);
            g2.draw(this.rhomb);
            if (this.left[eD][fD] < 0) {
                float xmin = xp[0];
                float xmax = xp[0];
                this.right[eD][fD] = 0;
                this.left[eD][fD] = 0;
                for (int m = 1; m < 4; ++m) {
                    if (xp[m] < xmin) {
                        xmin = xp[m];
                        this.left[eD][fD] = m;
                        continue;
                    }
                    if (!(xp[m] > xmax)) continue;
                    xmax = xp[m];
                    this.right[eD][fD] = m;
                }
                int t1 = (this.left[eD][fD] + 1) % 4;
                int t2 = (this.right[eD][fD] + 1) % 4;
                int n = this.top[eD][fD] = yp[t1] < yp[t2] ? t1 : t2;
            }
            if (this.scrolling) {
                int j;
                int ix;
                float x;
                int lft = this.left[eD][fD];
                int rght = this.right[eD][fD];
                int tp = this.top[eD][fD];
                float xmin = xp[lft];
                float xmax = xp[rght];
                float xcen = xp[tp];
                float ycen = yp[tp];
                boolean usedTile = false;
                for (int k = 0; k < this.nActive && !((x = (float)(ix = this.currentSamplePoints[j = this.activeChannels[k]][0]) + 0.5f) > xmax); ++k) {
                    int s;
                    float mu;
                    float y;
                    if (!(x > xmin) || this.tileNotes[j][eD][fD] == null || !((y = (mu = (xcen - x) / (xcen - xp[s = x < xcen ? lft : rght])) * yp[s] + (1.0f - mu) * ycen) > (float)y1) || !(y <= (float)y2)) continue;
                    this.cues.add(new Cue(ix, (float)this.lowY + y, j, eD, fD, this.iFlashTiles));
                    usedTile = true;
                }
                if (usedTile) {
                    this.flashTileCols[this.iFlashTiles] = this.tileColsBrighter[eD][fD];
                    for (int m = 0; m < 4; ++m) {
                        this.flashTilesX[this.iFlashTiles][m] = xp[m];
                        this.flashTilesY[this.iFlashTiles][m] = (float)this.lowY + yp[m];
                    }
                    this.iFlashTiles = (short)(this.iFlashTiles + 1);
                    if (this.iFlashTiles == this.nFlashTiles) {
                        this.iFlashTiles = 0;
                    }
                }
            }
        }

        public void identifyPoint(float[] xp, float[] yp, int eD, int fD) {
            this.rhomb.reset();
            for (int m = 0; m < 4; ++m) {
                if (m == 0) {
                    this.rhomb.moveTo(xp[m], yp[m]);
                    continue;
                }
                this.rhomb.lineTo(xp[m], yp[m]);
            }
            this.rhomb.closePath();
            if (this.pressedPoint != null && this.rhomb.contains(this.pressedPoint)) {
                if (this.shiftedClick) {
                    if (this.selectedLowDim == eD && this.selectedHighDim == fD) {
                        this.noSelection();
                        this.tileNotes[this.currentChannelIndex][eD][fD] = this.parent.midiSynth.getRecording();
                        this.pristine = false;
                        this.K = null;
                    } else {
                        if (this.selectedLowDim >= 0) {
                            this.tileNotes[this.currentChannelIndex][this.selectedLowDim][this.selectedHighDim] = this.parent.midiSynth.getRecording();
                            this.pristine = false;
                        }
                        this.setSelection(eD, fD);
                        this.tileNotes[this.currentChannelIndex][eD][fD] = null;
                        this.pristine = false;
                        this.parent.midiSynth.startRecording();
                        this.K = null;
                    }
                } else {
                    Sequence s = this.tileNotes[this.currentChannelIndex][eD][fD];
                    if (s != null) {
                        this.parent.midiSynth.playBack(s);
                        this.playingLowDim = eD;
                        this.playingHighDim = fD;
                        this.K = null;
                        this.playingDescr = this.parent.midiSynth.describeTrack(s.getTracks()[0], s, true, true, false);
                        Font f = this.getFont();
                        FontMetrics fm = this.getFontMetrics(f);
                        this.playingDescrR = fm.getStringBounds(this.playingDescr, this.H).getBounds();
                        this.playingDescrR.translate(this.pressedPoint.x, this.pressedPoint.y - this.latestTake);
                        this.playingDescrR.grow(5, 5);
                    }
                }
                this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.scrolling) {
                Point p = e.getPoint();
                int x = p.x;
                int y = p.y;
                this.selectedSamplePoint = -1;
                for (int i = 0; i < this.nChannels; ++i) {
                    int sx = this.currentSamplePoints[i][0];
                    int sy = this.currentSamplePoints[i][1];
                    if (x < sx - 3 || x > sx + 3 || y < sy - 3 || y > sy + 3) continue;
                    this.selectedSamplePoint = i;
                    this.repaint();
                    return;
                }
                this.shiftedClick = (e.getModifiersEx() & 0x40) != 0;
                this.pressedPoint = new Point(e.getPoint());
                this.pressedPoint.translate(0, this.latestTake);
                this.tileClick();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.scrolling && this.selectedSamplePoint >= 0) {
                Point p = e.getPoint();
                int x = p.x;
                int y = p.y;
                int w = 2 * (this.getSize().width / 2);
                int h = 2 * (this.getSize().height / 2);
                if (x < 0) {
                    x = 0;
                }
                if (x >= w) {
                    x = w - 1;
                }
                if (y < 0) {
                    y = 0;
                }
                if (y >= h) {
                    y = h - 1;
                }
                this.currentSamplePoints[this.selectedSamplePoint][0] = x;
                this.currentSamplePoints[this.selectedSamplePoint][1] = y;
                this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void tileClick() {
            if (this.pressedPoint != null) {
                int y = this.pressedPoint.y;
                int y1 = y - 5;
                int y2 = y + 5;
                this.d(null, 2 * (this.getSize().width / 2), y1, y2, this.latestYoffs + (long)(y - this.latestHC));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.scrolling && this.selectedSamplePoint >= 0) {
                this.selectedSamplePoint = -1;
                this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        public void setSavedAs(File f) {
            this.lastSavedQMF = f;
            if (this.lastSavedQMF == null) {
                this.parent.setTitle("Untitled");
            } else {
                this.parent.setTitle(f.getName());
            }
            this.parent.repaint();
        }

        class Cue {
            public int x;
            public float y;
            public int chn;
            public int eD;
            public int fD;
            public boolean usedForMusic;
            short tileNumber;

            public Cue(int x, float y, int chn, int eD, int fD, short tileNumber) {
                this.x = x;
                this.y = y;
                this.chn = chn;
                this.eD = eD;
                this.fD = fD;
                this.tileNumber = tileNumber;
                this.usedForMusic = false;
            }
        }
    }
}

