/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.SpinNet;

import egan.applets.SpinNet.EdgeData;
import egan.applets.SpinNet.NodeData;
import egan.geometry.GraphEdge;
import egan.geometry.GraphNode;
import egan.geometry.GraphNodeLink;
import egan.graphics.GraphicsUtils;
import egan.maths.LinearSystem;
import egan.maths.Tensor;
import egan.physics.AngularMomentum;
import java.applet.Applet;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;

public class SpinNet
extends Applet
implements Runnable,
MouseListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    Image I;
    Image bg;
    Graphics G;
    Graphics gg;
    long F = 0L;
    long tStep = 120L;
    long pt;
    boolean done = false;
    private volatile Thread a;
    Random ran;
    final double[][] vp = new double[][]{{0.707, 0.707, 0.0}, {0.407939, -0.407939, -0.815878}};
    final double xproj = Math.sqrt(this.vp[0][0] * this.vp[0][0] + this.vp[0][1] * this.vp[0][1]);
    final double yproj = Math.sqrt(this.vp[1][0] * this.vp[1][0] + this.vp[1][1] * this.vp[1][1]);
    final double ringRad = 0.5;
    double scale;
    String[] topList = new String[]{"Planar loop", "Planar 2-node", "Planar grid", "Planar ring", "Tetrahedron", "Cube"};
    static final int LOOP = 0;
    static final int TWO_NODE = 1;
    static final int GRID = 2;
    static final int RING = 3;
    static final int TETRAHEDRON = 4;
    static final int CUBE = 5;
    static final int[] maxSpins = new int[]{10, 10, 10, 6, 6, 4};
    Choice topChoice;
    int topology = 0;
    int nNodes;
    int nEdges;
    GraphNode[] nodes;
    GraphEdge[] edges;
    int minSpin;
    boolean allDiagonal;
    int[][] pushHolonomy;
    int nMainTensors;
    Tensor[] allTensors;
    int[][][] indexPairs;
    int nip;
    int[] cutList;
    int nCuts;
    int[] cutDims;
    int calcsDone;
    int calcsNeeded;
    int plotCount;
    double[] ampR;
    double[] ampI;
    double xscaleP;
    double xscaleA;
    String statusString = "";

    @Override
    public void init() {
        this.setFont(new Font(this.getFont().getName(), 0, 10));
        this.topChoice = new Choice();
        for (int i = 0; i < this.topList.length; ++i) {
            this.topChoice.addItem(this.topList[i]);
        }
        this.topChoice.select(this.topology);
        this.add(this.topChoice);
        this.topChoice.addItemListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thread = Thread.currentThread();
        while (this.a == thread) {
            long l = System.currentTimeMillis();
            SpinNet spinNet = this;
            synchronized (spinNet) {
                if (l - this.pt > this.tStep || l < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(this.done ? 500L : 50L);
            }
            catch (Exception exception) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public synchronized void update(Graphics graphics) {
        long l = System.currentTimeMillis();
        if (l - this.pt > this.tStep || l < this.pt) {
            this.pt = l;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            if (this.I == null) {
                this.I = this.createImage(n, n2);
                this.G = this.I.getGraphics();
            }
            GraphicsUtils.setAA((Graphics)this.G);
            this.d(this.G, n, n2, this.F);
            graphics.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(graphics);
            ++this.F;
        }
    }

    public void d(Graphics graphics, int n, int n2, long l) {
        int n3;
        double[] dArray;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n / 2;
        int n9 = n2 / 2;
        int n10 = this.topChoice.getLocation().y + this.topChoice.getSize().height;
        int n11 = n / 3;
        int n12 = n - n11;
        int n13 = n2 - n10;
        int n14 = n11 + n12 / 2;
        int n15 = n10 + n13 / 2;
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n16 = fontMetrics.getAscent();
        int n17 = fontMetrics.getDescent();
        int n18 = n16 + 10;
        Graphics graphics2 = this.gg;
        if (l == 0L) {
            int n19;
            int n20;
            int n21;
            this.ran = new Random();
            this.bg = this.createImage(n, n2);
            graphics2 = this.gg = this.bg.getGraphics();
            GraphicsUtils.setAA((Graphics)graphics2);
            graphics2.setColor(Color.white);
            graphics2.fillRect(0, 0, n, n2);
            n7 = 0;
            if (this.topology == 0) {
                this.nNodes = 1;
                n7 = 1;
            } else if (this.topology == 1) {
                this.nNodes = 2;
            } else if (this.topology == 2) {
                this.nNodes = 8;
            } else if (this.topology == 3) {
                this.nNodes = 10;
            } else if (this.topology == 4) {
                this.nNodes = 4;
            } else if (this.topology == 5) {
                this.nNodes = 8;
            }
            this.nEdges = ((this.nNodes - n7) * 3 + n7 * 2) / 2;
            System.gc();
            this.nodes = new GraphNode[this.nNodes];
            this.edges = new GraphEdge[this.nEdges];
            this.allTensors = new Tensor[this.nNodes + this.nEdges + 2];
            this.cutList = new int[this.nEdges];
            for (n6 = 0; n6 < this.nEdges; ++n6) {
                this.cutList[n6] = -1;
            }
            this.ampR = new double[51];
            this.ampI = new double[51];
            this.pushHolonomy = null;
            n6 = 0;
            this.nCuts = 0;
            n5 = 0;
            if (this.topology == 0 || this.topology == 1 || this.topology == 3 || this.topology == 4) {
                int n22;
                n5 = this.topology != 4 ? 1 : 0;
                int n23 = n5 != 0 ? this.nNodes : 3;
                double d = Math.PI * 2 / (double)n23;
                for (n22 = 0; n22 < n23; ++n22) {
                    double d2 = (double)n22 * d + (this.topology == 4 ? 0.1 : 0.0);
                    double[] dArray2 = new double[]{0.5 * Math.cos(d2), 0.5 * Math.sin(d2), 0.0};
                    this.nodes[n22] = new GraphNode(dArray2, (Object)new NodeData(n22), false);
                }
                for (n22 = 0; n22 < n23; ++n22) {
                    this.edges[n6++] = new GraphEdge(this.nodes[n22], this.nodes[(n22 + 1) % n23], (Object)new EdgeData());
                }
                if (this.topology == 1) {
                    this.edges[n6++] = new GraphEdge(this.nodes[0], this.nodes[this.nNodes / 2], (Object)new EdgeData());
                } else if (this.topology == 3) {
                    for (n22 = 1; n22 < this.nNodes; n22 += 2) {
                        this.edges[n6++] = new GraphEdge(this.nodes[n22], this.nodes[(n22 + 3) % this.nNodes], (Object)new EdgeData());
                    }
                    this.nCuts = 2;
                    this.cutList[0] = 0;
                    this.cutList[n6 - 1] = 1;
                    int[][] nArrayArray = new int[][]{{10, 1}, {4, 1}, {12, 1}, {8, 1}, {14, 1}, {2, 1}, {11, 1}, {6, 1}, {13, 1}};
                    this.pushHolonomy = nArrayArray;
                } else if (this.topology == 4) {
                    double[] dArray3 = new double[]{0.0, 0.0, 0.707};
                    this.nodes[3] = new GraphNode(dArray3, (Object)new NodeData(3), false);
                    for (int i = 0; i < 3; ++i) {
                        this.edges[n6++] = new GraphEdge(this.nodes[i == 0 ? i : 3], this.nodes[i == 0 ? 3 : i], (Object)new EdgeData());
                    }
                    this.nCuts = 2;
                    this.cutList[0] = 0;
                    this.cutList[1] = 1;
                    int[][] nArrayArray = new int[][]{{3, 1}};
                    this.pushHolonomy = nArrayArray;
                }
            } else if (this.topology == 2) {
                double d = 0.5;
                double d3 = d / 4.0;
                for (int i = 0; i < 2; ++i) {
                    for (n21 = 0; n21 < 2; ++n21) {
                        for (int j = 0; j < 2; ++j) {
                            n20 = 2 * n21 + 4 * j;
                            int n24 = n20 + 1;
                            int n25 = 2 * (n21 + 1) + 4 * j;
                            n19 = n25 + 1;
                            int n26 = 2 * n21 + 4 * (j + 1);
                            n4 = n26 + 1;
                            if (i == 0) {
                                double d4 = ((double)(n21 - 1) + 0.5) * d;
                                double d5 = ((double)(j - 1) + 0.5) * d;
                                double[] dArray4 = new double[]{d4 - d3, d5 - d3, 0.0};
                                dArray = new double[]{d4 + d3, d5 + d3, 0.0};
                                this.nodes[n20] = new GraphNode(dArray4, (Object)new NodeData(n20), false);
                                this.nodes[n24] = new GraphNode(dArray, (Object)new NodeData(n24), false);
                                continue;
                            }
                            if (i != 1) continue;
                            this.edges[n6++] = new GraphEdge(this.nodes[n20], this.nodes[n24], (Object)new EdgeData());
                            if (n21 == 0 && j % 2 == 0) {
                                this.edges[n6++] = new GraphEdge(this.nodes[n20], this.nodes[n26], (Object)new EdgeData());
                            }
                            if (j == 0 && n21 % 2 == 0) {
                                this.edges[n6++] = new GraphEdge(this.nodes[n25], this.nodes[n20], (Object)new EdgeData());
                            }
                            if (n21 == 1) {
                                if (j % 2 == 0) {
                                    this.edges[n6++] = new GraphEdge(this.nodes[n24], this.nodes[n4], (Object)new EdgeData());
                                }
                            } else {
                                this.edges[n6++] = new GraphEdge(this.nodes[n24], this.nodes[n25], (Object)new EdgeData());
                            }
                            if (j == 1) {
                                if (n21 % 2 != 0) continue;
                                this.edges[n6++] = new GraphEdge(this.nodes[n19], this.nodes[n24], (Object)new EdgeData());
                                continue;
                            }
                            this.edges[n6++] = new GraphEdge(this.nodes[n24], this.nodes[n26], (Object)new EdgeData());
                        }
                    }
                }
            } else if (this.topology == 5) {
                int n27;
                for (n27 = 0; n27 < 8; ++n27) {
                    double[] dArray5 = new double[3];
                    for (int i = 0; i < 3; ++i) {
                        dArray5[i] = 0.5 * (double)((n27 & 1 << i) != 0 ? -1 : 1);
                    }
                    double d = 0.1;
                    double d6 = Math.cos(d);
                    double d7 = Math.sin(d);
                    double d8 = d6 * dArray5[0] - d7 * dArray5[1];
                    double d9 = -d7 * dArray5[0] + d6 * dArray5[1];
                    dArray5[0] = d8;
                    dArray5[1] = d9;
                    dArray5[2] = dArray5[2] + 0.5;
                    this.nodes[n27] = new GraphNode(dArray5, (Object)new NodeData(n27), false);
                }
                for (n27 = 0; n27 < 8; ++n27) {
                    for (int i = n27 + 1; i < 8; ++i) {
                        int n28 = n27 ^ i;
                        int n29 = -1;
                        int n30 = -1;
                        if (n28 == 1 || n28 == 2) {
                            n21 = (n27 & 4) >> 2;
                            if ((i & n28) != 0) {
                                n21 = 1 - n21;
                            }
                            if (n21 == 0) {
                                n29 = n27;
                                n30 = i;
                            } else {
                                n29 = i;
                                n30 = n27;
                            }
                        } else if (n28 == 4) {
                            n21 = i & 1;
                            if (n21 == 0) {
                                n29 = n27;
                                n30 = i;
                            } else {
                                n29 = i;
                                n30 = n27;
                            }
                        }
                        if (n29 < 0) continue;
                        this.edges[n6++] = new GraphEdge(this.nodes[n29], this.nodes[n30], (Object)new EdgeData());
                    }
                }
                this.nCuts = 2;
                this.cutList[0] = 0;
                this.cutList[5] = 1;
                int[][] nArrayArray = new int[][]{{2, 0}, {4, 1}, {6, 0}, {7, 1}};
                this.pushHolonomy = nArrayArray;
            }
            double d = 0.0;
            this.scale = n5 != 0 ? 0.45 / (0.5 * Math.max(this.xproj / (double)n12, this.yproj / (double)n13)) : 1.0;
            n3 = n5 != 0 ? 1 : 2;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < this.nNodes; ++j) {
                    double[] dArray6 = this.nodes[j].coords;
                    int[] nArray = new int[2];
                    for (n20 = 0; n20 < 2; ++n20) {
                        double d10 = 0.0;
                        for (n19 = 0; n19 < 3; ++n19) {
                            d10 += this.vp[n20][n19] * dArray6[n19];
                        }
                        nArray[n20] = (n20 == 0 ? n14 : n15) + (int)(this.scale * d10);
                        d = Math.max(d, Math.abs(d10 / (double)(n20 == 0 ? n12 : n13)));
                    }
                    ((NodeData)this.nodes[j].extra).screenXY = nArray;
                }
                if (i == n3 - 1) continue;
                this.scale = 0.45 / d;
            }
        }
        if (l == 1L) {
            int n31;
            int n32;
            GraphNode graphNode;
            n7 = 1;
            n6 = maxSpins[this.topology];
            block16: while (true) {
                int n33;
                if (this.topology != 5) {
                    while ((n7 = 1 + (int)(this.ran.nextDouble() * (double)(n6 - 1))) == this.minSpin) {
                    }
                }
                for (n5 = 0; n5 < this.nEdges; ++n5) {
                    ((EdgeData)this.edges[n5].extra).twoJ = 0;
                }
                do {
                    GraphNodeLink graphNodeLink;
                    GraphNode graphNode2;
                    for (n5 = 0; n5 < this.nEdges; ++n5) {
                        ((EdgeData)this.edges[n5].extra).loopSpin = 0;
                    }
                    graphNode = graphNode2 = this.nodes[(int)(this.ran.nextDouble() * (double)this.nNodes)];
                    do {
                        graphNodeLink = graphNode.link((int)(this.ran.nextDouble() * (double)graphNode.valence));
                        GraphEdge graphEdge = graphNodeLink.edge;
                        ((EdgeData)graphEdge.extra).loopSpin += graphNodeLink.startEdge;
                    } while ((graphNode = graphNodeLink.edgeLink.node) != graphNode2);
                    n33 = 0;
                    for (n3 = 0; n3 < this.nEdges; ++n3) {
                        EdgeData edgeData = (EdgeData)this.edges[n3].extra;
                        int n34 = edgeData.twoJ += Math.abs(edgeData.loopSpin);
                        if (n34 > n6) continue block16;
                        if (n34 >= n7) continue;
                        ++n33;
                    }
                } while (n33 != 0);
                break;
            }
            this.minSpin = n7;
            for (n5 = 0; n5 < this.nEdges; ++n5) {
                double d;
                graphNode = this.edges[n5];
                GraphNodeLink graphNodeLink = graphNode.link1;
                GraphNodeLink graphNodeLink2 = graphNode.link2;
                EdgeData edgeData = (EdgeData)graphNode.extra;
                double[] dArray7 = new double[]{0.0, 0.0, 1.0, 0.0};
                if (this.topology == 0) {
                    d = 1.5707963267948966;
                } else if (this.topology == 1 && n5 < 2) {
                    d = 0.7853981633974483;
                } else {
                    int n35;
                    GraphNode graphNode3 = graphNodeLink.node;
                    GraphNode graphNode4 = graphNodeLink2.node;
                    double[] dArray8 = graphNode3.coords;
                    double[] dArray9 = graphNode4.coords;
                    dArray7 = new double[4];
                    for (int i = 0; i < 3; ++i) {
                        n4 = (i + 1) % 3;
                        n35 = (i + 2) % 3;
                        dArray7[i] = dArray8[n4] * dArray9[n35] - dArray9[n4] * dArray8[n35];
                    }
                    double d11 = 0.0;
                    for (n35 = 0; n35 < 3; ++n35) {
                        d11 += dArray7[n35] * dArray7[n35];
                    }
                    d = Math.sqrt(d11);
                    if (d != 0.0) {
                        n35 = 0;
                        while (n35 < 3) {
                            int n36 = n35++;
                            dArray7[n36] = dArray7[n36] / d;
                        }
                    }
                }
                dArray7[3] = d;
                edgeData.axes = new double[1][];
                edgeData.axes[0] = dArray7;
            }
            if (this.pushHolonomy != null) {
                n5 = this.pushHolonomy.length;
                for (int i = 0; i < n5; ++i) {
                    int n37 = this.pushHolonomy[i][0];
                    int n38 = this.pushHolonomy[i][1];
                    GraphEdge graphEdge = this.edges[n37];
                    GraphNodeLink graphNodeLink = graphEdge.link1;
                    GraphNodeLink graphNodeLink3 = graphEdge.link2;
                    EdgeData edgeData = (EdgeData)graphEdge.extra;
                    double[][] dArray10 = edgeData.axes;
                    int n39 = dArray10.length;
                    GraphNodeLink graphNodeLink4 = n38 == 0 ? graphNodeLink : graphNodeLink3;
                    for (int j = 0; j < 2; ++j) {
                        int n40;
                        boolean bl;
                        GraphNodeLink graphNodeLink5 = j == 0 ? graphNodeLink4.prev : graphNodeLink4.next;
                        EdgeData edgeData2 = (EdgeData)graphNodeLink5.edge.extra;
                        double[][] dArray11 = edgeData2.axes;
                        n32 = dArray11.length;
                        edgeData2.axes = new double[n39 + n32][];
                        int n41 = 0;
                        if (graphNodeLink5.startEdge == -1) {
                            bl = n38 == 1;
                            for (n40 = 0; n40 < n32; ++n40) {
                                var46_196[n41++] = dArray11[n40];
                            }
                        } else {
                            bl = n38 == 0;
                        }
                        for (n40 = 0; n40 < n39; ++n40) {
                            int n42 = bl ? n39 - 1 - n40 : n40;
                            int n43 = n41++;
                            double[] dArray12 = new double[4];
                            var46_196[n43] = dArray12;
                            double[] dArray13 = dArray12;
                            for (int k = 0; k < 4; ++k) {
                                dArray13[k] = dArray10[n42][k];
                            }
                            if (!bl) continue;
                            dArray13[3] = dArray13[3] * -1.0;
                        }
                        if (graphNodeLink5.startEdge != 1) continue;
                        for (n40 = 0; n40 < n32; ++n40) {
                            var46_196[n41++] = dArray11[n40];
                        }
                    }
                    edgeData.axes = new double[0][];
                }
            }
            this.nMainTensors = this.nNodes;
            this.allDiagonal = true;
            for (n5 = 0; n5 < this.nEdges; ++n5) {
                double[][] dArrayArray;
                double d = 1.0E-8;
                GraphEdge graphEdge = this.edges[n5];
                GraphNodeLink graphNodeLink = graphEdge.link1;
                GraphNodeLink graphNodeLink6 = graphEdge.link2;
                EdgeData edgeData = (EdgeData)graphEdge.extra;
                double[][] dArray14 = edgeData.axes;
                int n44 = dArray14.length;
                int n45 = 0;
                for (int i = 1; i < n44; ++i) {
                    boolean bl = true;
                    for (int j = 0; j < 3 && bl; ++j) {
                        if (!(Math.abs(dArray14[i][j] - dArray14[n45][j]) > d)) continue;
                        bl = false;
                    }
                    if (bl) {
                        double[] dArray15 = dArray14[n45];
                        dArray15[3] = dArray15[3] + dArray14[i][3];
                        continue;
                    }
                    if (Math.abs(dArray14[n45][3]) > d) {
                        ++n45;
                    }
                    dArray14[n45] = dArray14[i];
                }
                if (n45 < n44 && Math.abs(dArray14[n45][3]) > d) {
                    ++n45;
                }
                edgeData.axes = new double[n45][];
                System.arraycopy(dArray14, 0, dArrayArray, 0, n45);
                edgeData.identity = n45 == 0;
                boolean bl = edgeData.diagonal = edgeData.identity || n45 == 1 && Math.abs(dArrayArray[0][0]) < d && Math.abs(dArrayArray[0][1]) < d;
                if (!edgeData.identity) {
                    ++this.nMainTensors;
                }
                if (edgeData.diagonal) continue;
                this.allDiagonal = false;
            }
            for (n5 = 0; n5 < this.nNodes; ++n5) {
                int n46;
                int n47;
                GraphNode graphNode5 = this.nodes[n5];
                graphNode5.numberRing();
                NodeData nodeData = (NodeData)graphNode5.extra;
                int n48 = graphNode5.valence;
                int[] nArray = new int[n48];
                int[] nArray2 = new int[n48];
                int[] nArray3 = new int[n48];
                int n49 = 0;
                GraphNodeLink graphNodeLink = graphNode5.firstLink;
                for (int i = 0; i < n48; ++i) {
                    nArray[i] = ((EdgeData)graphNodeLink.edge.extra).twoJ;
                    nArray2[i] = nArray[i] + 1;
                    nArray3[i] = graphNodeLink.startEdge;
                    n49 += nArray3[i];
                    graphNodeLink = graphNodeLink.next;
                }
                if (n48 == 2) {
                    double[][] dArrayArray = new double[][]{{1.0, -1.0, 0.0}};
                    n47 = nArray2[0];
                    double[] dArray16 = new double[n47];
                    for (n46 = 0; n46 < n47; ++n46) {
                        dArray16[n46] = 1.0;
                    }
                    nodeData.intertwiner = new Tensor((Object)dArray16, 2, nArray2, false, 1, null, new LinearSystem((double[][])dArrayArray, 2, 1));
                } else if (n48 == 3) {
                    int[] nArray4 = new int[3];
                    n47 = 0;
                    int n50 = 0;
                    for (n46 = 0; n46 < 3; ++n46) {
                        if (nArray3[n46] == n49) {
                            nArray4[n47++] = n46;
                            continue;
                        }
                        nArray4[2] = n46;
                        n50 = n46;
                    }
                    n46 = nArray[nArray4[0]];
                    int n51 = nArray[nArray4[1]];
                    int n52 = nArray[nArray4[2]];
                    n32 = nodeData.j1j2j3 = (n46 << 16) + (n51 << 8) + n52;
                    double[][] dArray17 = null;
                    for (int i = 0; i < n5; ++i) {
                        NodeData nodeData2 = (NodeData)this.nodes[i].extra;
                        if (nodeData2.j1j2j3 != n32) continue;
                        dArray17 = (double[][])nodeData2.intertwiner.components;
                        break;
                    }
                    if (dArray17 == null) {
                        dArray17 = AngularMomentum.ClebschGordan((int)n46, (int)n51, (int)n52);
                    }
                    double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0, (double)(n46 + n51 - n52) / 2.0}};
                    dArrayArray[0][nArray4[0]] = 1.0;
                    dArrayArray[0][nArray4[1]] = 1.0;
                    dArrayArray[0][nArray4[2]] = -1.0;
                    nodeData.intertwiner = new Tensor((Object)dArray17, 3, nArray2, false, 2, nArray4, new LinearSystem((double[][])dArrayArray, 3, 1));
                }
                this.allTensors[n5] = nodeData.intertwiner;
            }
            this.nip = 0;
            this.indexPairs = new int[2 * this.nEdges + this.nCuts][2][2];
            n5 = 0;
            for (n31 = 0; n31 < this.nEdges; ++n31) {
                GraphEdge graphEdge = this.edges[n31];
                EdgeData edgeData = (EdgeData)graphEdge.extra;
                GraphNodeLink graphNodeLink = graphEdge.link1;
                GraphNodeLink graphNodeLink7 = graphEdge.link2;
                GraphNode graphNode6 = graphNodeLink.node;
                GraphNode graphNode7 = graphNodeLink7.node;
                int[][] nArray = this.indexPairs[this.nip++];
                nArray[0][0] = ((NodeData)graphNode6.extra).nodeNumber;
                nArray[0][1] = graphNodeLink.ringNumber;
                if (this.cutList[n31] >= 0) {
                    nArray[1][0] = this.nMainTensors;
                    nArray[1][1] = this.cutList[n31];
                    nArray = this.indexPairs[this.nip++];
                    nArray[0][0] = this.nMainTensors + 1;
                    nArray[0][1] = this.cutList[n31];
                }
                if (!edgeData.identity) {
                    int n53 = edgeData.twoJ + 1;
                    int[] nArray5 = new int[]{n53, n53};
                    double[][][] dArray18 = new double[n53][n53][2];
                    if (edgeData.diagonal) {
                        double[][] dArrayArray = new double[][]{{1.0, -1.0, 0.0}};
                        edgeData.holonomy = new Tensor((Object)dArray18, 2, nArray5, true, 2, null, new LinearSystem((double[][])dArrayArray, 2, 1));
                    } else {
                        edgeData.holonomy = new Tensor((Object)dArray18, 2, nArray5, true);
                    }
                    edgeData.holonomyComponents = dArray18;
                    this.allTensors[this.nNodes + n5] = edgeData.holonomy;
                    nArray[1][0] = this.nNodes + n5;
                    nArray[1][1] = 0;
                    nArray = this.indexPairs[this.nip++];
                    nArray[0][0] = this.nNodes + n5;
                    nArray[0][1] = 1;
                    ++n5;
                }
                nArray[1][0] = ((NodeData)graphNode7.extra).nodeNumber;
                nArray[1][1] = graphNodeLink7.ringNumber;
            }
            if (this.nCuts > 0) {
                this.cutDims = new int[this.nCuts];
                for (n31 = 0; n31 < this.nEdges; ++n31) {
                    if (this.cutList[n31] < 0) continue;
                    this.cutDims[this.cutList[n31]] = ((EdgeData)this.edges[n31].extra).twoJ + 1;
                }
            }
            this.calcsNeeded = this.allDiagonal ? 26 : 51;
            this.calcsDone = 0;
            this.plotCount = 0;
        }
        if (l == 0L || l == 1L) {
            graphics2.setFont(font);
            graphics2.setColor(Color.black);
            int[] nArray = new int[4];
            int[] nArray6 = new int[4];
            int n54 = n5 = this.topology == 0 || this.topology == 1 ? 1 : 0;
            if (l == 0L) {
                int n55;
                for (n55 = 0; n55 < this.nNodes; ++n55) {
                    NodeData nodeData = (NodeData)this.nodes[n55].extra;
                    graphics2.fillOval(nodeData.screenXY[0] - 3, nodeData.screenXY[1] - 3, 7, 7);
                }
                if (n5 != 0) {
                    n55 = (int)(0.5 * this.xproj * this.scale);
                    int n56 = (int)(0.5 * this.yproj * this.scale);
                    graphics2.drawOval(n14 - n55, n15 - n56, 2 * n55, 2 * n56);
                }
            }
            for (int i = 0; i < this.nEdges; ++i) {
                int n57;
                double d;
                GraphEdge graphEdge = this.edges[i];
                NodeData nodeData = (NodeData)graphEdge.link1.node.extra;
                NodeData nodeData3 = (NodeData)graphEdge.link2.node.extra;
                int n58 = nodeData.screenXY[0];
                int n59 = nodeData.screenXY[1];
                int n60 = nodeData3.screenXY[0];
                int n61 = nodeData3.screenXY[1];
                double d12 = (n58 + n60) / 2;
                double d13 = (n59 + n61) / 2;
                double d14 = n60 - n58;
                double d15 = n61 - n59;
                if (this.topology == 0) {
                    d = -0.5 * this.scale;
                    d12 = n14 + (int)(d * this.vp[0][0]);
                    d13 = n15 + (int)(d * this.vp[1][0]);
                    d14 = -this.vp[0][1];
                    d15 = -this.vp[1][1];
                } else if (this.topology == 1 && i != 2) {
                    d = 0.5 * this.scale * (double)(1 - 2 * i);
                    d12 = n14 + (int)(d * this.vp[0][1]);
                    d13 = n15 + (int)(d * this.vp[1][1]);
                }
                d = Math.sqrt(d14 * d14 + d15 * d15);
                double d16 = 0.0;
                double d17 = 0.0;
                for (double d18 = 4.0; d18 < 6.0; d18 += 0.25) {
                    d16 = d18 * d14 / d;
                    d17 = d18 * d15 / d;
                    for (n57 = 0; n57 < 3; ++n57) {
                        nArray[n57] = (int)Math.round(d12 + (n57 < 2 ? (double)(2 * n57 - 1) * d17 - d16 : d16));
                        nArray6[n57] = (int)Math.round(d13 + (n57 < 2 ? (double)(1 - 2 * n57) * d16 - d17 : d17));
                    }
                    n57 = nArray[1] - nArray[0];
                    int n62 = nArray6[1] - nArray6[0];
                    if (n57 * n57 + n62 * n62 >= 100) break;
                }
                if (l == 0L) {
                    if (n5 == 0 || i == 2) {
                        graphics2.drawLine(n58, n59, nArray[2], nArray6[2]);
                        graphics2.drawLine(n60, n61, nArray[2], nArray6[2]);
                    }
                    graphics2.fillPolygon(nArray, nArray6, 3);
                }
                if (l != 1L) continue;
                int n63 = ((EdgeData)graphEdge.extra).twoJ;
                String string = n63 % 2 == 0 ? "" + n63 / 2 : n63 + "/2";
                n57 = fontMetrics.stringWidth(string);
                double d19 = Double.MAX_VALUE;
                for (int j = -1; j <= 1; j += 2) {
                    for (int k = -1; k <= 1; k += 2) {
                        double d20 = -d15 * (double)j * (double)n57 + d14 * (double)k * (double)n16;
                        d19 = Math.min(d20, d19);
                    }
                }
                double d21 = -0.55 * d19 / (d * d);
                int n64 = (int)Math.round(d12 - (d17 + d21 * d15));
                int n65 = (int)Math.round(d13 + (d16 + d21 * d14));
                graphics2.setColor(Color.white);
                graphics2.fillRect(n64 - n57 / 2, n65 - n16 / 2, n57, n16);
                graphics2.setColor(Color.black);
                graphics2.drawString(string, n64 - n57 / 2, n65 + n16 / 2);
            }
        }
        if (l > 1L && this.calcsDone < this.calcsNeeded) {
            long l2 = System.currentTimeMillis();
            for (n5 = this.calcsDone; n5 < this.calcsNeeded; ++n5) {
                Object object;
                Object object2;
                double d = (double)n5 / 50.0;
                double d22 = 1.0 - d;
                double d23 = d * 5.0 + d22 * -5.0;
                for (int i = 0; i < this.nEdges; ++i) {
                    GraphEdge graphEdge = this.edges[i];
                    EdgeData edgeData = (EdgeData)graphEdge.extra;
                    if (edgeData.identity) continue;
                    object2 = edgeData.axes;
                    int n66 = ((double[][])object2).length;
                    double[] dArray19 = object2[0];
                    double d24 = d23 * dArray19[3];
                    if (n66 > 1) {
                        double[] dArray20 = SpinNet.rotToQuaternion(dArray19, d24);
                        for (int j = 1; j < n66; ++j) {
                            dArray = object2[j];
                            double[] dArray21 = SpinNet.rotToQuaternion(dArray, d23 * dArray[3]);
                            dArray20 = SpinNet.qMult(dArray20, dArray21);
                        }
                        dArray19 = SpinNet.quaternionToRot(dArray20);
                        d24 = dArray19[3];
                    }
                    AngularMomentum.spinJ((double[][][])edgeData.holonomyComponents, (int)edgeData.twoJ, (double)d24, (double)dArray19[0], (double)dArray19[1], (double)dArray19[2]);
                }
                double d25 = 0.0;
                double d26 = 0.0;
                if (this.nCuts == 0) {
                    object = Tensor.stagedContraction((Tensor[])this.allTensors, (int)this.nMainTensors, (int[][][])this.indexPairs, (int)this.nip, (int)0);
                    object2 = object.complexPair(null);
                    d25 = (double)object2[0];
                    d26 = (double)object2[1];
                } else {
                    int n67;
                    object = new int[this.nCuts];
                    block52: do {
                        Tensor tensor = Tensor.basisTensor((int)this.nCuts, (int[])this.cutDims, (int[])object);
                        this.allTensors[this.nMainTensors + 1] = tensor;
                        this.allTensors[this.nMainTensors] = tensor;
                        object2 = Tensor.stagedContraction((Tensor[])this.allTensors, (int)(this.nMainTensors + 2), (int[][][])this.indexPairs, (int)this.nip, (int)this.nMainTensors);
                        double[] dArray22 = object2.complexPair(null);
                        d25 += dArray22[0];
                        d26 += dArray22[1];
                        n67 = 0;
                        while (n67 < this.nCuts) {
                            int n68 = n67;
                            object[n68] = object[n68] + 1;
                            if (object[n68] != this.cutDims[n67]) continue block52;
                            object[n67++] = 0;
                        }
                    } while (n67 != this.nCuts);
                }
                this.ampR[n5] = d25;
                this.ampI[n5] = d26;
                if (this.allDiagonal) {
                    this.ampR[50 - n5] = d25;
                    this.ampI[50 - n5] = d26;
                }
                ++this.calcsDone;
                long l3 = System.currentTimeMillis();
                if (l3 >= l2 && l3 - l2 <= 500L) {
                    continue;
                }
                break;
            }
        } else if (l > 2L && this.calcsDone == this.calcsNeeded && this.plotCount < 51) {
            int n69 = n11 / 15;
            int n70 = n11 / 2 - n69;
            n5 = n69 + n70;
            int n71 = n18 + 10;
            int n72 = n2 - n71;
            int n73 = n72 - n71;
            double d = (double)n73 / 50.0;
            for (int i = 0; i < 5 && this.plotCount < 51; ++i) {
                int n74;
                if (this.plotCount == 0) {
                    double d27 = 0.0;
                    for (int j = 0; j < 51; ++j) {
                        d27 = Math.max(Math.max(Math.abs(this.ampR[j]), Math.abs(this.ampI[j])), d27);
                    }
                    this.xscaleA = 0.8 * (double)n70 / d27;
                    graphics2.setColor(Color.black);
                    graphics2.drawLine(n5, n71, n5, n72);
                    String string = "Amplitude vs curvature";
                    graphics2.drawString(string, Math.max(5, n5 - fontMetrics.stringWidth(string) / 2), n18);
                    for (int j = -5; j <= 5; ++j) {
                        n74 = n71 + (int)((double)n73 * (0.5 + 0.5 * (double)j / 5.0));
                        graphics2.drawLine(n5 - 5, n74, n5 + 5, n74);
                        String string2 = "" + j;
                        int n75 = fontMetrics.stringWidth(string2);
                        graphics2.drawString(string2, n5 - 10 - n75, n74 + n16 / 2);
                    }
                    ++this.plotCount;
                }
                n74 = n71 + (int)(d * (double)(this.plotCount - 1));
                int n76 = n71 + (int)(d * (double)this.plotCount);
                graphics2.setColor(new Color(0x339933));
                int n77 = n5 + (int)(this.xscaleA * this.ampR[this.plotCount - 1]);
                int n78 = n5 + (int)(this.xscaleA * this.ampR[this.plotCount]);
                graphics2.drawLine(n77, n74, n78, n76);
                graphics2.setColor(Color.red);
                n77 = n5 + (int)(this.xscaleA * this.ampI[this.plotCount - 1]);
                n78 = n5 + (int)(this.xscaleA * this.ampI[this.plotCount]);
                graphics2.drawLine(n77, n74, n78, n76);
                ++this.plotCount;
            }
            if (this.plotCount == 51) {
                this.done = true;
            }
        }
        graphics.drawImage(this.bg, 0, 0, null);
        graphics.setColor(Color.black);
        if (l == 0L) {
            graphics.drawString("Assigning spins to edges", 10, n18);
        } else if (this.plotCount == 0) {
            int n79 = 10;
            int n80 = n16 + n17;
            n5 = n18;
            int n81 = n5 + n80;
            int n82 = 3 * n16 / 2;
            int n83 = n11 - 2 * n79;
            int n84 = n81 + n80;
            graphics.drawString("Evaluating for 51 curvatures", n79, n5);
            graphics.drawString("(Click to give up and try different spins)", n79, n81);
            graphics.setColor(Color.black);
            graphics.fillRect(n79, n84, n83, n82);
            int n85 = (int)((double)this.calcsDone / (double)this.calcsNeeded * (double)n83);
            for (int i = 1; i <= 4; ++i) {
                graphics.setColor(new Color(0x333333 * i));
                int n86 = (i - 1) * n82 / 8;
                int n87 = i - 1;
                graphics.fillRect(n79 + n87, n84 + n86, n85 - 2 * n87, n82 - 2 * n86);
            }
            graphics.setColor(Color.black);
            graphics.drawRect(n79, n84, n83, n82);
        }
    }

    @Override
    public void showStatus(String string) {
        super.showStatus(string);
        this.statusString = string;
    }

    void maybeShowStatus(Graphics graphics) {
        if (this.statusString != "") {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)graphics, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
        this.showStatus("Click to redraw with different spins");
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.F = 0L;
        this.done = false;
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        int n;
        if (itemEvent.getSource() == this.topChoice && (n = this.topChoice.getSelectedIndex()) != this.topology) {
            this.topology = n;
            this.mousePressed(null);
        }
    }

    public static double[] rotToQuaternion(double[] dArray, double d) {
        double d2 = d / 2.0;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double[] dArray2 = new double[]{d3, d4 * dArray[0], d4 * dArray[1], d4 * dArray[2]};
        return dArray2;
    }

    public static double[] quaternionToRot(double[] dArray) {
        double d = Math.acos(dArray[0]);
        double d2 = Math.sin(d);
        if (d2 == 0.0) {
            return new double[4];
        }
        double[] dArray2 = new double[]{dArray[1] / d2, dArray[2] / d2, dArray[3] / d2, 2.0 * d};
        return dArray2;
    }

    public static double[] qMult(double[] dArray, double[] dArray2) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray2[0];
        double d6 = dArray2[1];
        double d7 = dArray2[2];
        double d8 = dArray2[3];
        double[] dArray3 = new double[]{d * d5 - d2 * d6 - d3 * d7 - d4 * d8, d2 * d5 + d * d6 - d4 * d7 + d3 * d8, d3 * d5 + d4 * d6 + d * d7 - d2 * d8, d4 * d5 - d3 * d6 + d2 * d7 + d * d8};
        return dArray3;
    }
}

