/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.Wormholes;

import egan.applets.Wormholes.dRay;
import egan.applets.Wormholes.dVec;
import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Wormholes
extends Applet
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    Image I;
    Graphics G;
    Dimension Z;
    dRay red1 = new dRay(0.3, 0.0, 0.0, 1.0);
    dRay red2 = new dRay(0.7, 0.0, 0.0, 1.0);
    dRay blue1 = new dRay(0.2, 0.0, 0.0, 1.0);
    dRay blue2 = new dRay(0.8, 0.0, 0.0, 1.0);
    dRay redSim1;
    dRay redSim2;
    dRay blueSim1;
    dRay blueSim2;
    boolean mdown = false;
    static final double mfrac = 0.9;
    static final double lomarg = 0.04999999999999999;
    static final double himarg = 0.95;
    double xa;
    double xb;
    double ta;
    double tb;
    double xmin;
    double xmax;
    double tmin;
    double tmax;
    Dimension ps;
    dRay sbl;
    dVec h;
    static final int nwave = 33;
    static final int hwave = 16;
    double wamp;
    int iwper;
    int twn;
    int[] wpack = new int[33];
    int[] totalWave;
    String statusString = "";

    @Override
    public void init() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.ps = this.getSize();
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        double d = (double)this.ps.height / (double)this.ps.width;
        this.xmin = -0.05;
        this.xmax = 1.05;
        this.tmax = d * this.xmax / 2.0;
        this.tmin = -this.tmax;
        this.xb = 0.9 * (double)this.ps.width / (this.xmax - this.xmin);
        this.xa = 0.04999999999999999 * (double)this.ps.width - this.xb * this.xmin;
        this.tb = -this.xb;
        this.ta = 0.95 * (double)this.ps.height - this.tb * this.tmin;
        this.wamp = (double)this.ps.width / 40.0;
        this.iwper = 2;
        for (int i = 0; i < 33; ++i) {
            this.wpack[i] = (int)(this.wamp * Math.sin((double)i * 0.19634954084936207));
        }
        this.twn = this.ps.height / 2;
        this.totalWave = new int[this.twn];
    }

    Point calcPoint(double d, double d2) {
        return new Point((int)(this.xa + this.xb * d), (int)(this.ta + this.tb * d2));
    }

    dVec find(int n, int n2) {
        return new dVec(((double)n - this.xa) / this.xb, ((double)n2 - this.ta) / this.tb);
    }

    void drawRay(Graphics graphics, dRay dRay2, dVec dVec2, double d) {
        if (dRay2.hitBounds(this.xmin, this.xmax, this.tmin, this.tmax, dVec2, d) != 1.0E10) {
            Point point = this.calcPoint(dRay2.sx, dRay2.sy);
            Point point2 = this.calcPoint(dVec2.x, dVec2.y);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    void drawBothRays(Graphics graphics, dRay dRay2) {
        this.drawRay(graphics, dRay2, new dVec(), 1.0E10);
        this.drawRay(graphics, new dRay(dRay2.sx, dRay2.sy, -dRay2.vx, -dRay2.vy), new dVec(), 1.0E10);
    }

    boolean outOfBounds(dVec dVec2) {
        return dVec2.x < this.xmin || dVec2.x > this.xmax || dVec2.y < this.tmin || dVec2.y > this.tmax;
    }

    void drawDashed(Graphics graphics, dRay dRay2, dVec dVec2, double d) {
        if (dRay2.hitBounds(this.xmin, this.xmax, this.tmin, this.tmax, dVec2, d) != 1.0E10) {
            Point point = this.calcPoint(dRay2.sx, dRay2.sy);
            Point point2 = this.calcPoint(dVec2.x, dVec2.y);
            int n = (int)(Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y)) / 5.0);
            if (n % 2 == 0) {
                ++n;
            }
            double d2 = n;
            for (int i = 0; i < n; i += 2) {
                double d3 = (double)i / d2;
                double d4 = (double)(i + 1) / d2;
                int n2 = (int)Math.round(d3 * (double)point2.x + (1.0 - d3) * (double)point.x);
                int n3 = (int)Math.round(d3 * (double)point2.y + (1.0 - d3) * (double)point.y);
                int n4 = (int)Math.round(d4 * (double)point2.x + (1.0 - d4) * (double)point.x);
                int n5 = (int)Math.round(d4 * (double)point2.y + (1.0 - d4) * (double)point.y);
                graphics.drawLine(n2, n3, n4, n5);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.I == null || dimension.width != this.Z.width || dimension.height != this.Z.height) {
            this.Z = dimension;
            this.I = this.createImage(this.Z.width, this.Z.height);
            this.G = this.I.getGraphics();
            this.spacetime(this.G);
        }
        graphics.drawImage(this.I, 0, 0, null);
        this.maybeShowStatus(graphics);
        if (this.sbl != null) {
            Point point = this.calcPoint(this.h.x, this.h.y);
            graphics.fillRect(point.x - 5, point.y - 5, 10, 10);
        }
    }

    public void spacetime(Graphics graphics) {
        int n;
        int n2;
        dVec dVec2 = new dVec();
        GraphicsUtils.setAA((Graphics)graphics);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.ps.width, this.ps.height);
        this.redSim1 = new dRay(this.red1.sx, this.red1.sy, this.red1.vy, this.red1.vx);
        this.redSim2 = new dRay(this.red2.sx, this.red2.sy, -this.red2.vy, -this.red2.vx);
        this.blueSim1 = new dRay(this.blue1.sx, this.blue1.sy, this.blue1.vy, this.blue1.vx);
        this.blueSim2 = new dRay(this.blue2.sx, this.blue2.sy, -this.blue2.vy, -this.blue2.vx);
        graphics.setColor(Color.red);
        this.drawBothRays(graphics, this.red1);
        this.drawBothRays(graphics, this.red2);
        graphics.setColor(Color.blue);
        this.drawBothRays(graphics, this.blue1);
        this.drawBothRays(graphics, this.blue2);
        graphics.setColor(Color.magenta);
        dRay dRay2 = new dRay((this.red1.sx + this.blue1.sx) / 2.0, 0.0, 1.0, 1.0);
        dRay dRay3 = null;
        dRay dRay4 = null;
        dRay dRay5 = null;
        dVec dVec3 = new dVec();
        dVec dVec4 = new dVec();
        int n3 = 0;
        Point point = null;
        for (n2 = 0; n2 < this.twn; ++n2) {
            this.totalWave[n2] = 0;
        }
        n2 = this.twn - 1;
        int n4 = 0;
        while (n3++ < 25) {
            double d;
            double d2 = 1.0E10;
            dRay4 = null;
            if (dRay5 != this.blue1 && (d = dRay2.intersect(this.blue1, dVec3)) > 0.0 && d < d2) {
                dRay3 = this.blueSim1;
                dRay4 = this.blue2;
                d2 = d;
                dVec3.dup(dVec4);
            }
            if (dRay5 != this.blue2 && (d = dRay2.intersect(this.blue2, dVec3)) > 0.0 && d < d2) {
                dRay3 = this.blueSim2;
                dRay4 = this.blue1;
                d2 = d;
                dVec3.dup(dVec4);
            }
            if (dRay5 != this.red1 && (d = dRay2.intersect(this.red1, dVec3)) > 0.0 && d < d2) {
                dRay3 = this.redSim1;
                dRay4 = this.red2;
                d2 = d;
                dVec3.dup(dVec4);
            }
            if (dRay5 != this.red2 && (d = dRay2.intersect(this.red2, dVec3)) > 0.0 && d < d2) {
                dRay3 = this.redSim2;
                dRay4 = this.red1;
                d2 = d;
                dVec3.dup(dVec4);
            }
            dVec4.dup(dVec3);
            this.drawRay(graphics, dRay2, dVec4, d2);
            if (dRay4 == null || this.outOfBounds(dVec3)) break;
            dRay2.sx = dVec3.x;
            dRay2.sy = dVec3.y;
            dRay2.vx = dRay3.vx;
            dRay2.vy = dRay3.vy;
            if (dRay4 == this.red2) {
                point = this.calcPoint(dRay2.sx, dRay2.sy);
                for (n = 0; n < 33; ++n) {
                    int n5 = (point.y + this.iwper * (n - 16)) / 2;
                    if (n5 < 0 || n5 >= this.twn) continue;
                    int n6 = n5;
                    this.totalWave[n6] = this.totalWave[n6] + this.wpack[n];
                    if (n5 < n2) {
                        n2 = n5;
                    }
                    if (n5 <= n4) continue;
                    n4 = n5;
                }
            }
            if ((d2 = dRay2.intersect(dRay4, dVec4)) == 1.0E10) break;
            dVec4.dup(dVec3);
            this.drawDashed(graphics, dRay2, dVec4, d2);
            if (this.outOfBounds(dVec3)) break;
            dRay2.sx = dVec3.x;
            dRay2.sy = dVec3.y;
            dRay2.vx = 1.0;
            dRay2.vy = 1.0;
            dRay2.normalise();
            dRay5 = dRay4;
        }
        if (n4 > n2) {
            for (n = n2; n <= n4; ++n) {
                if (this.totalWave[n] == 0) continue;
                graphics.drawLine(point.x + this.totalWave[n], 2 * n, point.x, 2 * n);
            }
        }
        n = this.getFontMetrics(this.getFont()).getHeight();
        String string = "Relative velocity of wormholes is " + Long.toString(Math.round(this.blue1.vx / this.blue1.vy * 100.0)) + "% of lightspeed";
        graphics.setColor(this.getForeground());
        graphics.drawString(string, 10, 5 + n);
    }

    @Override
    public void showStatus(String string) {
        super.showStatus(string);
        this.statusString = string;
        this.repaint();
    }

    void maybeShowStatus(Graphics graphics) {
        if (this.statusString != "") {
            GraphicsUtils.showStatus((String)this.statusString, (Graphics)graphics, (Component)this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
        this.showStatus("Click on blue worldline to change velocity");
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.mdown = true;
        dVec dVec2 = this.find(n, n2);
        this.sbl = null;
        if (Math.abs(this.blue1.distance(dVec2)) < 0.1) {
            this.sbl = this.blue1;
        } else if (Math.abs(this.blue2.distance(dVec2)) < 0.1) {
            this.sbl = this.blue2;
        }
        if (this.sbl != null) {
            this.h = this.sbl.proj(dVec2);
            this.repaint();
            this.showStatus("Drag handle to tilt worldline");
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        this.mdown = false;
        this.sbl = null;
        this.repaint();
        this.showStatus("Click on blue worldline to change velocity");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.mdown = true;
        if (this.sbl != null) {
            dVec dVec2 = this.find(n, n2);
            if (Math.abs(dVec2.y) > 0.01) {
                dVec dVec3 = new dVec((dVec2.x - this.sbl.sx) / (dVec2.y - this.sbl.sy), 1.0);
                if (Math.abs(dVec3.x) <= 0.6 && !dVec3.parallel(this.blue1.dir())) {
                    this.blue1.vx = dVec3.x;
                    this.blue2.vx = dVec3.x;
                    this.blue1.vy = dVec3.y;
                    this.blue2.vy = dVec3.y;
                    this.blue1.normalise();
                    this.blue2.normalise();
                    this.h = dVec2;
                    this.spacetime(this.G);
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

