/*
 * Decompiled with CFR 0.152.
 */
package egan.applets.Wormholes;

import egan.applets.Wormholes.dVec;

class dRay {
    public double sx;
    public double sy;
    public double vx;
    public double vy;
    public static final double NO_INTERSECTION = 1.0E10;

    dRay(double d, double d2, double d3, double d4) {
        this.sx = d;
        this.sy = d2;
        this.vx = d3;
        this.vy = d4;
        this.normalise();
    }

    dRay(dVec dVec2, dVec dVec3) {
        this.sx = dVec2.x;
        this.sy = dVec2.y;
        this.vx = dVec3.x;
        this.vy = dVec3.y;
        this.normalise();
    }

    public void normalise() {
        double d = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
        if (d != 0.0) {
            this.vx /= d;
            this.vy /= d;
        }
    }

    public dVec dir() {
        return new dVec(this.vx, this.vy);
    }

    public double intersect(dRay dRay2, dVec dVec2) {
        double d = -this.vx * dRay2.vy + this.vy * dRay2.vx;
        double d2 = dRay2.vx * (dRay2.sy - this.sy) - dRay2.vy * (dRay2.sx - this.sx);
        if (d != 0.0) {
            dVec2.x = this.sx + (d2 /= d) * this.vx;
            dVec2.y = this.sy + d2 * this.vy;
        } else {
            d2 = 1.0E10;
        }
        return d2;
    }

    public double distance(dVec dVec2) {
        return this.dir().perp().dot(new dVec(dVec2.x - this.sx, dVec2.y - this.sy));
    }

    public dVec proj(dVec dVec2) {
        dVec dVec3 = new dVec();
        this.intersect(new dRay(dVec2, this.dir().perp()), dVec3);
        return dVec3;
    }

    public double hitBounds(double d, double d2, double d3, double d4, dVec dVec2, double d5) {
        dVec dVec3 = new dVec();
        double d6 = this.intersect(new dRay(d, d3, 1.0, 0.0), dVec3);
        if (d6 > 0.0 && d6 < d5) {
            d5 = d6;
            dVec3.dup(dVec2);
        }
        if ((d6 = this.intersect(new dRay(d2, d4, 1.0, 0.0), dVec3)) > 0.0 && d6 < d5) {
            d5 = d6;
            dVec3.dup(dVec2);
        }
        if ((d6 = this.intersect(new dRay(d, d3, 0.0, 1.0), dVec3)) > 0.0 && d6 < d5) {
            d5 = d6;
            dVec3.dup(dVec2);
        }
        if ((d6 = this.intersect(new dRay(d2, d4, 0.0, 1.0), dVec3)) > 0.0 && d6 < d5) {
            d5 = d6;
            dVec3.dup(dVec2);
        }
        return d5;
    }
}

