/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.BgTiler;
import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public abstract class A2
extends Applet
implements Runnable,
MouseListener {
    String statusString = "";
    boolean mouseIN = false;
    int nframes = this.setNFrames(18);
    double frameA;
    double frameHA;
    private volatile Thread a;
    static final long tStep = 100L;
    int p = -1;
    int q;
    long F = 0L;
    long pt = 0L;
    boolean D = true;
    boolean canRedraw = true;
    Image[] I;
    BgTiler bgt = null;

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt > 100L || t < this.pt) {
            this.pt = t;
            int f = (int)(this.F++ % (long)this.nframes);
            if (this.F % 100L == 1L) {
                System.gc();
            }
            if (this.I == null) {
                this.I = new Image[this.nframes];
            }
            if (this.D) {
                boolean C;
                int w = this.getSize().width;
                int h = this.getSize().height;
                if (this.p < 0) {
                    this.p = (int)((double)w * Math.random());
                    this.q = (int)((double)h * Math.random());
                }
                if (this.bgt == null) {
                    this.bgt = new BgTiler(this, w, h);
                }
                if (C = this.I[f] == null) {
                    this.I[f] = this.createImage(w, h);
                }
                Graphics k = this.I[f].getGraphics();
                boolean tiled = false;
                if (C) {
                    tiled = this.bgt.tile(k);
                }
                this.D = this.d(k, w, h, this.p, this.q, f, C, tiled, 0, 1);
                k.dispose();
            }
            g.drawImage(this.I[f], 0, 0, null);
            if (this.mouseIN) {
                this.mouseEntered(null);
            }
            if (this.statusString.length() != 0) {
                GraphicsUtils.showStatus(this.statusString, g, this);
            }
        }
    }

    public abstract boolean d(Graphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            A2 a2 = this;
            synchronized (a2) {
                if (t - this.pt > 100L || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(55L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        if (this.canRedraw) {
            this.showStatus("Click to redraw");
        }
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        if (this.canRedraw) {
            this.showStatus("");
        }
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.mouseIN = true;
        if (this.canRedraw) {
            this.p = e.getX();
            this.q = e.getY();
            this.F = 0L;
            this.D = true;
            this.I = null;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public synchronized int setNFrames(int nf) {
        this.nframes = nf;
        this.frameA = Math.PI * 2 / (double)nf;
        this.frameHA = this.frameA / 2.0;
        return nf;
    }
}

