/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Incandescence
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    final int nCurves = 300;
    final int nFrames = 10;
    final int stepsPerFrame = 2;
    final int nSteps = 20;
    final int NC = 24;
    final double omega = 1.0;
    final double omsq = 1.0;
    final double om2 = 2.0;
    final double A = 3.56;
    final double freqsq = 0.43999999999999995;
    final double OMSQ = Math.abs(0.43999999999999995);
    final double OM = Math.sqrt(this.OMSQ);
    final double OM3 = this.OM * this.OMSQ;
    boolean mouseIN = false;
    private volatile Thread a;
    Image I;
    Image B;
    Graphics G;
    Graphics BG;
    long F = 0L;
    Color[][] palette;
    double[] x0;
    double[] y0;
    double[] vx;
    double[] vy;
    double[][] xp;
    double[][] yp;
    boolean[] haveCurve;
    int[] nData;
    boolean[] onScreen;
    int[] offScreen;
    int currentData;
    String statusString = "";

    @Override
    public synchronized void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            try {
                Thread.sleep(20L);
                this.repaint(20L);
                this.wait();
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        int i;
        int w = this.getSize().width;
        int h = this.getSize().height;
        double ymax = (double)w / (double)h;
        int h2 = h / 2;
        int w2 = w / 2;
        double xa = h2;
        if (this.F == 0L) {
            this.I = this.createImage(w, h);
            this.G = this.I.getGraphics();
            this.B = this.createImage(w, h);
            this.BG = this.B.getGraphics();
            this.BG.setColor(Color.white);
            this.BG.fillRect(0, 0, w, h);
            this.palette = new Color[300][20];
            for (i = 0; i < 300; ++i) {
                float hue = (float)i / 299.0f;
                for (int j = 0; j < 20; ++j) {
                    float sat = (float)j / 19.0f;
                    this.palette[i][j] = new Color(Color.HSBtoRGB(hue, 0.15f + 0.85f * sat, 1.0f));
                }
            }
            this.currentData = 0;
            this.x0 = new double[300];
            this.y0 = new double[300];
            this.vx = new double[300];
            this.vy = new double[300];
            this.nData = new int[300];
            this.offScreen = new int[300];
            this.haveCurve = new boolean[300];
            this.onScreen = new boolean[300];
            this.xp = new double[300][20];
            this.yp = new double[300][20];
        }
        for (int q = 0; q < 6; ++q) {
            int n = -1;
            int i2 = 0;
            while (i2 + 3 < 300) {
                if (!(this.haveCurve[i2] || this.haveCurve[i2 + 1] || this.haveCurve[i2 + 2] || this.haveCurve[i2 + 3])) {
                    n = i2;
                    break;
                }
                i2 += 4;
            }
            if (n < 0) continue;
            for (int delta = 0; delta < 4; ++delta) {
                int nc = n + delta;
                if (delta == 0) {
                    this.x0[nc] = 2.0 * ((double)nc / 299.0 - 0.5);
                    this.y0[nc] = 2.0 * (Math.random() - 0.5) * ymax;
                    this.vx[nc] = 2.0 * (Math.random() - 0.5);
                    this.vy[nc] = 2.0 * (Math.random() - 0.5);
                } else {
                    this.x0[nc] = this.x0[n];
                    this.y0[nc] = this.y0[n];
                    if (delta == 1) {
                        this.vx[nc] = -this.vy[n];
                        this.vy[nc] = this.vx[n];
                    } else if (delta == 2) {
                        this.vx[nc] = -this.vx[n];
                        this.vy[nc] = -this.vy[n];
                    } else if (delta == 3) {
                        this.vx[nc] = this.vy[n];
                        this.vy[nc] = -this.vx[n];
                    }
                }
                this.haveCurve[nc] = true;
                this.nData[nc] = 0;
                this.offScreen[nc] = 0;
            }
        }
        for (i = 0; i < 300; ++i) {
            if (!this.haveCurve[i]) continue;
            double xi = this.x0[i];
            double yi = this.y0[i];
            double vxi = this.vx[i];
            double vyi = this.vy[i];
            double c1 = 3.56 * xi + 2.0 * vyi;
            double c2 = 3.56 * (vyi + 2.0 * xi);
            for (int j = 0; j < 2; ++j) {
                int k = (this.currentData + j) % 20;
                double t = (double)(this.nData[i] + j) / 20.0;
                double omt = this.OM * t;
                double sin = Math.sin(omt);
                double cosm1 = Math.cos(omt) - 1.0;
                this.xp[i][k] = xi + (this.OM * vxi * sin - c1 * cosm1) / this.OMSQ;
                this.yp[i][k] = yi + (2.0 * vxi * cosm1 - c2 * t) / this.OMSQ + 2.0 * c1 * sin / this.OM3;
            }
            int n = i;
            this.nData[n] = this.nData[n] + 2;
        }
        this.currentData = (this.currentData + 2) % 20;
        Graphics BH = this.BG;
        Graphics H = this.G;
        H.drawImage(this.B, 0, 0, null);
        for (i = 0; i < 300; ++i) {
            this.onScreen[i] = false;
        }
        for (int k = 0; k < 19; ++k) {
            int l = (this.currentData + k) % 20;
            int m = (this.currentData + k + 1) % 20;
            for (int i3 = 0; i3 < 300; ++i3) {
                if (!this.haveCurve[i3] || this.nData[i3] + k < 20) continue;
                int x1 = w2 - (int)(xa * this.yp[i3][l]);
                int x2 = w2 - (int)(xa * this.yp[i3][m]);
                int y1 = h2 - (int)(xa * this.xp[i3][l]);
                int y2 = h2 - (int)(xa * this.xp[i3][m]);
                if ((x1 < 0 || x1 >= w || y1 < 0 || y1 >= h) && (x2 < 0 || x2 >= w || y2 < 0 || y2 >= h)) continue;
                this.onScreen[i3] = true;
                H.setColor(this.palette[i3][k]);
                H.drawLine(x1, y1, x2, y2);
                if (k == 18) {
                    GraphicsUtils.fillSmallCircle(H, x2 - 2, y2 - 2, 5);
                }
                if (k >= 2) continue;
                BH.setColor(this.palette[i3][k]);
                BH.drawLine(x1, y1, x2, y2);
            }
        }
        for (i = 0; i < 300; ++i) {
            if (this.onScreen[i]) continue;
            int n = i;
            int n2 = this.offScreen[n];
            this.offScreen[n] = n2 + 1;
            if (n2 <= 2) continue;
            this.haveCurve[i] = false;
        }
        ++this.F;
        g.drawImage(this.I, 0, 0, null);
        this.maybeShowStatus(g);
        this.notify();
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus(this.statusString, g, this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

