/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.BgTiler;
import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.util.Random;

public class Lattice
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath rhomb = new GeneralPath(0, 5);
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    Image I;
    Graphics o;
    BgTiler bgt = null;
    Random r = new Random();
    boolean mouseIN = false;
    int idim = -1;
    int dim;
    int[] dimList = new int[]{4, 8, 24};
    String[] txtList = new String[]{"D4", "E8", "Leech"};
    double[][] rotation;
    int npts = 0;
    double[][] points;
    int[] basisNumber;
    int nzc;
    int[][] nzl;
    int[] colours;
    double radius;
    double rsq;
    int[] GolayOffsets = new int[]{0, 0, 1, 760, 3336, 3336, 4095};
    int[][] GolayCodeCList = null;
    int[] GolayCodeBinary = null;
    int[] GolayWeights = null;
    double[][] sphereC;
    int nbases;
    double[][][] basis;
    double[][][] cob;
    Color[][] palette;
    int ncols;
    int nshades = 5;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Lattice lattice = this;
            synchronized (lattice) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            int i;
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                int k;
                int rdim;
                int d2;
                int d1;
                int oi;
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                this.idim = this.idim < 0 ? (int)(this.r.nextDouble() * (double)(this.dimList.length - 1)) : (this.idim + 1) % this.dimList.length;
                this.dim = this.dimList[this.idim];
                if (this.dim == 4) {
                    this.rsq = 0.5;
                    this.points = new double[13][8];
                    this.colours = new int[13];
                    this.nbases = 1;
                    this.basisNumber = new int[13];
                    this.nzc = 2;
                    this.nzl = new int[13][2];
                    this.ncols = 4;
                    this.npts = 1;
                    for (oi = 1; oi <= 3; ++oi) {
                        for (int swap = 0; swap <= 1; ++swap) {
                            for (int sign = -1; sign <= 1; sign += 2) {
                                if (swap == 0) {
                                    d1 = 0;
                                    d2 = oi;
                                } else {
                                    d1 = oi == 1 ? 2 : 1;
                                    d2 = oi == 3 ? 2 : 3;
                                }
                                this.points[this.npts][d1] = 1.0;
                                this.points[this.npts][d2] = sign;
                                this.basisNumber[this.npts] = 0;
                                this.nzl[this.npts][0] = d1;
                                this.nzl[this.npts][1] = d2;
                                this.colours[this.npts] = oi;
                                ++this.npts;
                            }
                        }
                    }
                }
                if (this.dim == 8) {
                    int j;
                    int i2;
                    int sign;
                    this.rsq = 2.0;
                    this.points = new double[121][8];
                    this.colours = new int[121];
                    this.nbases = 3;
                    this.basisNumber = new int[121];
                    this.cob = new double[2][8][8];
                    this.nzc = 2;
                    this.nzl = new int[121][2];
                    this.ncols = 16;
                    this.npts = 1;
                    for (oi = 1; oi <= 3; ++oi) {
                        for (sign = 1; sign >= -1; sign -= 2) {
                            for (int shift = 0; shift <= 4; shift += 4) {
                                for (int swap = 0; swap <= 1; ++swap) {
                                    int d22;
                                    int d12;
                                    if (swap == 0) {
                                        d12 = 0;
                                        d22 = oi;
                                    } else {
                                        d12 = oi == 1 ? 2 : 1;
                                        d22 = oi == 3 ? 2 : 3;
                                    }
                                    this.points[this.npts][shift + d12] = 2.0;
                                    this.points[this.npts][shift + d22] = sign * 2;
                                    this.basisNumber[this.npts] = 0;
                                    this.nzl[this.npts][0] = shift + d12;
                                    this.nzl[this.npts][1] = shift + d22;
                                    this.colours[this.npts] = oi;
                                    ++this.npts;
                                }
                            }
                        }
                    }
                    for (oi = 4; oi <= 7; ++oi) {
                        for (sign = 1; sign >= -1; sign -= 2) {
                            int d13 = 0;
                            while (d13 < 4) {
                                int d23 = 4 + (d13 + oi - 4) % 4;
                                this.points[this.npts][d13] = 2.0;
                                this.points[this.npts][d23] = sign * 2;
                                this.basisNumber[this.npts] = 0;
                                this.nzl[this.npts][0] = d13++;
                                this.nzl[this.npts][1] = d23;
                                this.colours[this.npts] = oi;
                                ++this.npts;
                            }
                        }
                    }
                    for (i2 = 0; i2 < 8; ++i2) {
                        for (j = 0; j < 8; ++j) {
                            this.cob[0][i2][j] = (i2 + j) % 2 == 0 ? (i2 == j ? -0.5 : 0.5) : 0.0;
                        }
                    }
                    for (i2 = 0; i2 < 8; ++i2) {
                        for (j = 0; j < 8; ++j) {
                            this.cob[1][i2][j] = (i2 + j) % 2 == 0 ? (i2 == 0 || i2 == 7 || j / 2 == 0 || j / 2 == 1 + (i2 - 1) / 2 ? 0.5 : -0.5) : 0.0;
                        }
                    }
                    for (oi = 8; oi <= 15; ++oi) {
                        int bn = 1 + (oi - 8) % 2;
                        int offset = 1 + 16 * ((oi - 8) / 2);
                        for (int i3 = 0; i3 < 8; ++i3) {
                            this.points[this.npts] = this.points[offset + i3];
                            this.basisNumber[this.npts] = bn;
                            this.nzl[this.npts] = this.nzl[offset + i3];
                            this.colours[this.npts] = oi;
                            ++this.npts;
                        }
                    }
                }
                if (this.dim == 24) {
                    this.rsq = 8.0;
                    this.nbases = 1;
                    this.points = null;
                    this.colours = null;
                    this.ncols = 4;
                    this.npts = 2048;
                    if (this.GolayCodeCList == null) {
                        int i4;
                        int[] GolayBasis = new int[]{16519169, 12165122, 15941636, 15114248, 13459472, 10403872, 3641408, 7024768, 5665024, 2945536, 5886976, 8648704};
                        int[] gOffsets = new int[7];
                        for (i4 = 0; i4 < 7; ++i4) {
                            gOffsets[i4] = this.GolayOffsets[i4];
                        }
                        this.GolayCodeCList = new int[4096][];
                        this.GolayCodeBinary = new int[4096];
                        this.GolayWeights = new int[4096];
                        for (i4 = 0; i4 < 4096; ++i4) {
                            int c = 0;
                            for (int j = 0; j < 12; ++j) {
                                if ((i4 & 1 << j) == 0) continue;
                                c ^= GolayBasis[j];
                            }
                            int[] gcl = new int[24];
                            int weight = 0;
                            for (int j = 0; j < 24; ++j) {
                                if ((c & 1 << j) == 0) continue;
                                gcl[weight++] = j;
                            }
                            int n = weight / 4;
                            gOffsets[n] = gOffsets[n] + 1;
                            this.GolayWeights[offs] = weight;
                            this.GolayCodeBinary[offs] = c;
                            this.GolayCodeCList[offs] = gcl;
                        }
                    }
                }
                this.radius = Math.sqrt(this.rsq);
                this.sphereC = new double[2 * this.npts - 1][5];
                this.palette = GraphicsUtils.randomPalette(this.ncols, this.nshades, 0);
                this.basis = new double[this.nbases][3][this.dim];
                for (i = 0; i < 3; ++i) {
                    this.basis[0][i][i] = 1.0;
                }
                if (this.dim == 24) {
                    int i5;
                    rdim = 8;
                    double nf = 1.0 / Math.sqrt(32.0);
                    double[][] orthoSet = new double[rdim][24];
                    for (i5 = 0; i5 < 3; ++i5) {
                        orthoSet[i5][i5] = 1.0;
                    }
                    for (i5 = 3; i5 < (rdim + 3) / 2; ++i5) {
                        int gi = 1 + (int)(4095.0 * this.r.nextDouble());
                        int gw = this.GolayWeights[gi];
                        int[] gc = this.GolayCodeCList[gi];
                        double[] v = orthoSet[i5];
                        for (k = 0; k < 24; ++k) {
                            v[k] = 1.0;
                        }
                        for (k = 0; k < gw; ++k) {
                            v[gc[k]] = -1.0;
                        }
                        v[gc[(int)(this.r.nextDouble() * (double)gw)]] = 3.0;
                    }
                    for (i5 = (rdim + 3) / 2; i5 < rdim; ++i5) {
                        int gi = 1 + (int)(759.0 * this.r.nextDouble());
                        int[] gc = this.GolayCodeCList[gi];
                        double[] v = orthoSet[i5];
                        int sc = 0;
                        for (k = 0; k < 7; ++k) {
                            if (this.r.nextDouble() < 0.5) {
                                ++sc;
                                v[gc[k]] = -2.0;
                                continue;
                            }
                            v[gc[k]] = 2.0;
                        }
                        v[gc[7]] = sc % 2 == 1 ? -2.0 : 2.0;
                    }
                    for (i5 = 3; i5 < rdim; ++i5) {
                        for (int j = 0; j < i5; ++j) {
                            double dp = Utils.dot(orthoSet[i5], orthoSet[j]);
                            for (int k2 = 0; k2 < 24; ++k2) {
                                double[] dArray = orthoSet[i5];
                                int n = k2;
                                dArray[n] = dArray[n] - dp * orthoSet[j][k2];
                            }
                        }
                        Utils.normalise(orthoSet[i5]);
                    }
                    double[][] prevR = null;
                    double[][] newR = null;
                    for (int d14 = 0; d14 < rdim - 1; ++d14) {
                        for (int d24 = d14 + 1; d24 < rdim; ++d24) {
                            double angle = 0.025 * (2.0 + this.r.nextDouble()) / Math.sqrt(rdim);
                            double ca = Math.cos(angle) - 1.0;
                            double sa = Math.sin(angle);
                            double[][] rm = new double[this.dim][this.dim];
                            double[] v1 = orthoSet[d14];
                            double[] v2 = orthoSet[d24];
                            for (int i6 = 0; i6 < this.dim; ++i6) {
                                for (int j = 0; j < this.dim; ++j) {
                                    rm[i6][j] = (i6 == j ? 1.0 : 0.0) + ca * (v1[i6] * v1[j] + v2[i6] * v2[j]) + sa * (v2[i6] * v1[j] - v1[i6] * v2[j]);
                                }
                            }
                            if (prevR == null) {
                                prevR = rm;
                                continue;
                            }
                            if (newR == null) {
                                newR = new double[this.dim][this.dim];
                            }
                            for (int j = 0; j < this.dim; ++j) {
                                for (int k3 = 0; k3 < this.dim; ++k3) {
                                    double s = 0.0;
                                    for (int l = 0; l < this.dim; ++l) {
                                        s += prevR[j][l] * rm[l][k3];
                                    }
                                    newR[j][k3] = s;
                                }
                            }
                            double[][] tmp = prevR;
                            prevR = newR;
                            newR = tmp;
                        }
                    }
                    this.rotation = prevR;
                } else {
                    rdim = this.dim;
                    double[][] prevR = null;
                    double[][] newR = null;
                    for (d1 = 0; d1 < rdim - 1; ++d1) {
                        for (d2 = d1 + 1; d2 < rdim; ++d2) {
                            int j;
                            double angle = 0.025 * (2.0 + this.r.nextDouble()) / Math.sqrt(rdim);
                            double[][] rm = new double[this.dim][this.dim];
                            for (j = 0; j < this.dim; ++j) {
                                rm[j][j] = 1.0;
                            }
                            double d = Math.cos(angle);
                            rm[d2][d2] = d;
                            rm[d1][d1] = d;
                            double d3 = Math.sin(angle);
                            rm[d1][d2] = d3;
                            rm[d2][d1] = -d3;
                            if (prevR == null) {
                                prevR = rm;
                                continue;
                            }
                            if (newR == null) {
                                newR = new double[this.dim][this.dim];
                            }
                            for (j = 0; j < this.dim; ++j) {
                                for (k = 0; k < this.dim; ++k) {
                                    double s = 0.0;
                                    for (int l = 0; l < this.dim; ++l) {
                                        s += prevR[j][l] * rm[l][k];
                                    }
                                    newR[j][k] = s;
                                }
                            }
                            double[][] tmp = prevR;
                            prevR = newR;
                            newR = tmp;
                        }
                    }
                    this.rotation = prevR;
                }
            }
            if (this.bgt == null) {
                this.bgt = new BgTiler(this, w, h);
            }
            this.d(this.o, w, h, this.bgt.tile(this.o));
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
            for (i = 0; i < 3; ++i) {
                Utils.transform(this.rotation, this.basis[0][i]);
            }
            for (i = 1; i < this.nbases; ++i) {
                int i0 = i - 1;
                for (int j = 0; j < 3; ++j) {
                    Utils.transform(this.cob[i0], this.basis[0][j], this.basis[i][j]);
                }
            }
        }
    }

    public void d(Graphics g, int w, int h, boolean TB) {
        int i;
        int col;
        boolean Leech;
        int nspheres = 0;
        int wc = w / 2;
        int hc = h / 2;
        int isize = Math.min(wc, hc) - 4;
        int n = this.dim;
        int[] nzli = null;
        double scale = (double)isize / (3.0 * this.radius);
        double dsq0 = -3.0 * this.rsq;
        double[] pnt = null;
        double[][] bi = null;
        boolean bl = Leech = this.dim == 24;
        if (!TB) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(aaON);
        g2.setStroke(str);
        if (Leech) {
            int[] classCount = new int[]{1, 48576, 552, 49152};
            int[] weights = new int[]{8, 12, 16, 24};
            int[] c3weightCount = new int[]{6072, 30912, 12144, 24};
            double[][] c1eight = new double[3][8];
            double[] cdp = new double[3];
            int iw = 0;
            int weight = 0;
            int woffs = 0;
            pnt = new double[24];
            nzli = new int[24];
            bi = this.basis[0];
            int wt = -1;
            for (int iclass = 0; iclass < 4; ++iclass) {
                for (int ic = 0; ic < classCount[iclass]; ++ic) {
                    double sj;
                    int j;
                    int i1;
                    double[] s = this.sphereC[nspheres];
                    double dsq = dsq0;
                    if (iclass == 0) {
                        dsq = this.rsq;
                        s[2] = 0.0;
                        s[1] = 0.0;
                        s[0] = 0.0;
                    } else if (iclass == 1) {
                        int i0 = 1 + ic / 64;
                        i1 = 2 * (ic % 64);
                        if (i1 == 0) {
                            nzli = this.GolayCodeCList[i0];
                            double sumsqmax = 0.0;
                            for (j = 0; j < 3; ++j) {
                                double[] c1j = c1eight[j];
                                double[] bj = bi[j];
                                double dp = 0.0;
                                double labs = 1.0E8;
                                double sumabs = 0.0;
                                int cs = 0;
                                for (int k = 0; k < 8; ++k) {
                                    double abs;
                                    double bb = 2.0 * bj[nzli[k]];
                                    if (bb < 0.0) {
                                        abs = -bb;
                                        ++cs;
                                    } else {
                                        abs = bb;
                                    }
                                    if (abs < labs) {
                                        labs = abs;
                                    }
                                    sumabs += abs;
                                    c1j[k] = 2.0 * bb;
                                    dp += bb;
                                }
                                cdp[j] = dp;
                                if (cs % 2 == 1) {
                                    sumabs -= 2.0 * labs;
                                }
                                sumsqmax += sumabs * sumabs;
                            }
                            if (sumsqmax + dsq0 < 0.0) {
                                ic += 63;
                                continue;
                            }
                        }
                        int k = 1;
                        int i2 = i1 + 2;
                        while ((i2 & 1 << k) == 0) {
                            ++k;
                        }
                        boolean neg1 = (i1 & 2) == 0;
                        boolean neg2 = (i2 & 1 << k + 1) == 0;
                        for (int j2 = 0; j2 < 3; ++j2) {
                            double[] c1j = c1eight[j2];
                            double c1j0 = c1j[0];
                            double c1jk = c1j[k];
                            s[j2] = sj = cdp[j2];
                            dsq += sj * sj;
                            sj = neg1 ? (sj -= c1j0) : (sj += c1j0);
                            sj = neg2 ? (sj -= c1jk) : (sj += c1jk);
                            cdp[j2] = sj;
                        }
                    } else if (iclass == 2) {
                        int d1 = ic / 23;
                        int d2 = (d1 + 1 + ic % 23) % 24;
                        double pm4 = d1 < d2 ? 4.0 : -4.0;
                        for (j = 0; j < 3; ++j) {
                            double[] bj = bi[j];
                            s[j] = sj = pm4 * bj[d1] + 4.0 * bj[d2];
                            dsq += sj * sj;
                        }
                    } else if (iclass == 3) {
                        if (wt < 0 || iw == c3weightCount[wt]) {
                            iw = 0;
                            weight = weights[++wt];
                            woffs = this.GolayOffsets[weight / 4];
                        }
                        int i0 = iw / weight;
                        i1 = iw % weight;
                        if (i1 == 0) {
                            int c = this.GolayCodeBinary[woffs + i0];
                            nzli = this.GolayCodeCList[woffs + i0];
                            for (int j3 = 0; j3 < 24; ++j3) {
                                pnt[j3] = (c & 1 << j3) != 0 ? -1.0 : 1.0;
                            }
                            double sumsqmax = 0.0;
                            for (int j4 = 0; j4 < 3; ++j4) {
                                double[] bj = bi[j4];
                                double min = 1.0E8;
                                double max = -1.0E8;
                                double dp = 0.0;
                                for (int k = 0; k < 24; ++k) {
                                    double bjk = bj[k];
                                    if (pnt[k] == 1.0) {
                                        dp += bjk;
                                        continue;
                                    }
                                    dp -= bjk;
                                    if (bjk < min) {
                                        min = bjk;
                                    }
                                    if (!(bjk > max)) continue;
                                    max = bjk;
                                }
                                cdp[j4] = dp;
                                double c3max = Math.max(Math.abs(dp + 4.0 * min), Math.abs(dp + 4.0 * max));
                                sumsqmax += c3max * c3max;
                            }
                            if (sumsqmax + dsq0 < 0.0) {
                                iw += weight;
                                ic += weight - 1;
                                continue;
                            }
                        }
                        for (int j5 = 0; j5 < 3; ++j5) {
                            s[j5] = sj = cdp[j5] + 4.0 * bi[j5][nzli[i1]];
                            dsq += sj * sj;
                        }
                        ++iw;
                    }
                    col = iclass;
                    if (!(dsq >= 0.0)) continue;
                    s[3] = Math.sqrt(dsq);
                    s[4] = col;
                    ++nspheres;
                    if (iclass == 0) continue;
                    double[] t = this.sphereC[nspheres++];
                    t[0] = -s[0];
                    t[1] = -s[1];
                    t[2] = -s[2];
                    t[3] = s[3];
                    t[4] = s[4];
                }
            }
        } else {
            int ntadCount = 0;
            for (i = 0; i < this.npts; ++i) {
                if (i % n == 1) {
                    ntadCount = 0;
                }
                if (ntadCount == 3) {
                    if ((i += n - (i - 1) % n) == this.npts) break;
                    ntadCount = 0;
                }
                pnt = this.points[i];
                col = this.colours[i];
                bi = this.basis[this.basisNumber[i]];
                nzli = this.nzl[i];
                double[] s = this.sphereC[nspheres];
                double dsq = dsq0;
                for (int j = 0; j < 3; ++j) {
                    int l = nzli[0];
                    double[] bj = bi[j];
                    double sj = bj[l] * pnt[l];
                    for (int k = 1; k < this.nzc; ++k) {
                        l = nzli[k];
                        sj += bj[l] * pnt[l];
                    }
                    dsq += sj * sj;
                    s[j] = sj;
                }
                if (i == 0) {
                    dsq = this.rsq;
                }
                if (!(dsq >= 0.0)) continue;
                ++ntadCount;
                s[3] = Math.sqrt(dsq);
                s[4] = col;
                ++nspheres;
                if (i == 0) continue;
                double[] t = this.sphereC[nspheres++];
                t[0] = -s[0];
                t[1] = -s[1];
                t[2] = -s[2];
                t[3] = s[3];
                t[4] = s[4];
            }
        }
        if (nspheres > 0) {
            Utils.qs(2, this.sphereC, 0, nspheres - 1);
        }
        double denom = Math.sqrt(2.0625);
        double rx = 1.0 / denom;
        double ry = 1.0 / denom;
        double rz = -0.25 / denom;
        for (i = 0; i < nspheres; ++i) {
            int irad = (int)(scale * this.sphereC[i][3]);
            int cx = wc + (int)(scale * this.sphereC[i][0]);
            int cy = hc + (int)(scale * this.sphereC[i][1]);
            int c = (int)this.sphereC[i][4];
            g.setColor(this.palette[c][1]);
            g.fillOval(cx - irad - 1, cy - irad - 1, 2 * irad + 3, 2 * irad + 3);
            g.setColor(this.palette[c][2]);
            g.fillOval(cx - irad, cy - irad, 2 * irad + 1, 2 * irad + 1);
            for (int ix = 0; ix <= irad; ++ix) {
                double x = (double)ix / (double)irad;
                int pcol = -1;
                int py = 0;
                for (int iy = 0; iy <= irad; ++iy) {
                    double y = (double)iy / (double)irad;
                    double zsq = 1.0 - x * x - y * y;
                    col = -1;
                    if (zsq >= 0.0) {
                        double z = Math.sqrt(zsq);
                        double dp = 2.0 * x * z * rx + 2.0 * y * z * ry + (2.0 * z * z - 1.0) * rz;
                        if (dp > 0.98) {
                            col = 4;
                        } else if (dp > 0.9) {
                            col = 3;
                        }
                    }
                    if (col == pcol) continue;
                    if (pcol >= 0) {
                        g.setColor(this.palette[c][pcol]);
                        g.drawLine(cx - ix, cy - py, cx - ix, cy - (iy - 1));
                    }
                    py = iy;
                    pcol = col;
                }
            }
        }
        if (this.F == 0L && this.mouseIN) {
            this.mouseEntered(null);
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus(this.statusString, g, this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        if (this.idim >= 0) {
            this.showStatus(this.txtList[this.idim] + " lattice packing; click for next");
        }
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

