/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class Night
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    boolean mouseIN = false;
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    Image I;
    Graphics o;
    static final int EYECOLS = 3;
    static final int nEyes = 2;
    static final double eyeLid = 0.7;
    static final double eyeAR = 2.0;
    static final double irisZ = 0.9;
    static final double irisR = Math.sqrt(0.18999999999999995);
    static final double cornerZ = Math.sqrt(0.51);
    static final double eyeLidY = 0.35;
    static final double maxAngle = Math.atan2(0.35, Math.sqrt(0.8775000000000001) - cornerZ);
    int ew;
    int eh;
    int[] ex;
    int[] ey;
    byte[] ePix;
    byte iris1;
    byte iris2;
    byte iris3;
    byte pupil;
    byte white;
    byte transparent;
    double[][] rotation = new double[3][3];
    long blink;
    float[][] f;
    float[][] dA;
    float[][] dC;
    static final int NGREYS = 128;
    static final int NSHIFT = 2;
    static final int N2 = 15;
    int NPLANES;
    Random ran;
    MemoryImageSource mis;
    Image im;
    byte[] cPix;
    byte sky;
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Night night = this;
            synchronized (night) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt >= this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                this.I = this.createImage(w, h);
                this.o = this.I.getGraphics();
                byte[] palette = new byte[393];
                int bstep = 2;
                int ci3 = 0;
                for (int ci = 0; ci < 128; ++ci) {
                    int n = ci3++;
                    int n2 = ci3++;
                    int n3 = ci3++;
                    byte by = (byte)(bstep * ci);
                    palette[n3] = by;
                    palette[n2] = by;
                    palette[n] = by;
                }
                palette[ci3++] = 0;
                palette[ci3++] = 0;
                palette[ci3++] = 102;
                palette[ci3++] = 0;
                palette[ci3++] = -103;
                palette[ci3++] = 102;
                palette[ci3++] = 0;
                palette[ci3++] = 0;
                palette[ci3++] = -1;
                IndexColorModel icm = new IndexColorModel(8, 131, palette, 0, false, -1);
                this.iris1 = (byte)-128;
                this.iris2 = (byte)-127;
                this.iris3 = (byte)-126;
                this.transparent = (byte)-125;
                this.pupil = 0;
                this.white = (byte)127;
                this.sky = 0;
                this.ew = (int)(0.3 * (double)w);
                this.eh = (int)((double)this.ew / 2.0);
                this.ePix = new byte[this.ew * this.eh];
                this.ex = new int[2];
                this.ey = new int[2];
                for (int ee = 0; ee < 2; ++ee) {
                    this.ex[ee] = (w - this.ew) / 2 + (int)(((double)ee - 0.5) * (double)w / 2.0);
                    this.ey[ee] = (h - this.eh) / 2;
                }
                this.blink = 0L;
                this.cPix = new byte[w * h];
                this.mis = new MemoryImageSource(w, h, (ColorModel)icm, this.cPix, 0, w);
                this.mis.setAnimated(true);
                this.im = this.createImage(this.mis);
                this.NPLANES = h / 2 * 15;
                this.f = new float[this.NPLANES][4];
                this.dA = new float[h][w];
                this.dC = new float[h][w];
                this.ran = new Random();
            }
            this.d(this.o, w, h, this.ran);
            g.drawImage(this.I, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h, Random r) {
        int delta;
        int k2;
        int k1;
        if (Math.random() < 0.01) {
            this.blink = this.F;
        }
        double openPhase = (double)(this.F - this.blink) * 0.1;
        double openAngle = Math.min(openPhase, maxAngle);
        double sinOpen = Math.sin(openAngle);
        double cosOpen = Math.cos(openAngle);
        double pupilPhase = (double)this.F * 0.15;
        double pupilZ = 0.99 + 0.01 * (Math.cos(pupilPhase) - 1.0);
        double pupilR = Math.sqrt(1.0 - pupilZ * pupilZ);
        double midIris = (pupilR + irisR) / 2.0;
        double iSpan = 0.45 * (pupilR - irisR);
        double gazePhase = (double)this.F * 0.1;
        double[] xyz = new double[3];
        double[] rc = new double[3];
        double[] axis = new double[]{0.0, 1.0, 0.0};
        Utils.setRotation(this.rotation, 0.25 * Math.sin(gazePhase), axis, 1.0);
        double[] hl = new double[]{-0.17197, 0.1719, 0.97};
        int exc = this.ew / 2;
        int eyc = this.eh / 2;
        double eScale = 0.7 / (double)(exc - 1);
        double ex0 = -0.7;
        double ey0 = ex0 / 2.0;
        for (int ix = 0; ix < this.ew; ++ix) {
            double x = xyz[0] = ex0 + (double)ix * eScale;
            double xsq = x * x;
            for (int iy = 0; iy < this.eh; ++iy) {
                byte col;
                xyz[1] = ey0 + (double)iy * eScale;
                double y = xyz[1];
                double ycos = y * cosOpen;
                xyz[2] = Math.sqrt(1.0 - xsq - y * y);
                double z = xyz[2];
                double zsin = (z - cornerZ) * sinOpen;
                if (ycos + zsin > 0.0 && -ycos + zsin > 0.0) {
                    if (x * hl[0] + y * hl[1] + z * hl[2] > 0.998) {
                        col = this.white;
                    } else {
                        for (int i = 0; i < 3; ++i) {
                            double sum = 0.0;
                            double[] ri = this.rotation[i];
                            for (int j = 0; j < 3; ++j) {
                                sum += ri[j] * xyz[j];
                            }
                            rc[i] = sum;
                        }
                        double rx = rc[0];
                        double ry = rc[1];
                        double rz = rc[2];
                        if (rz > pupilZ) {
                            col = this.pupil;
                        } else if (rz > 0.9) {
                            double theta = 20.0 * Math.atan2(rx, ry);
                            double ct = Math.cos(theta);
                            double rR = Math.sqrt(1.0 - rz * rz);
                            double dr = Math.abs(rR - (midIris + iSpan * ct));
                            col = dr < 0.05 ? this.iris1 : (dr < 0.15 ? this.iris2 : this.iris3);
                        } else {
                            col = this.white;
                        }
                    }
                } else {
                    col = this.transparent;
                }
                this.ePix[iy * this.ew + ix] = col;
            }
        }
        boolean i0 = false;
        int xc = w / 2;
        int yc = h / 2;
        float scale = 2.0f / (float)(h - 5);
        float d1 = 3.0f * ((float)Math.sqrt(this.NPLANES) / 2.0f);
        float d0 = -d1;
        float dspan = d1 - d0;
        boolean init = this.F == 0L;
        float cb0 = 0.1f;
        float cb1 = 0.9f;
        float pcb0 = cb0 * 128.0f;
        float thresh = cb1 * 128.0f;
        float pcbD = thresh - pcb0 - 1.0E-5f;
        float pcbB = -pcbD / 0.75f;
        float pcbA = pcb0 - pcbB;
        float rowStart = pcbA + 0.5f * pcbB;
        if (init) {
            k1 = 0;
            k2 = this.NPLANES;
        } else {
            k1 = (int)(this.F * 15L % (long)this.NPLANES);
            k2 = k1 + 15;
        }
        long shift = 2L * this.F;
        long mishift = shift * (long)(h - 1);
        int n = delta = init ? 1 : -1;
        while (delta <= 1) {
            float b;
            float a;
            int i;
            float[] fk;
            int k;
            boolean adding = delta == 1;
            boolean removing = !adding;
            float dfactor = (float)delta * (pcbB / dspan);
            if (adding) {
                for (k = k1; k < k2; ++k) {
                    float ascale;
                    fk = this.f[k];
                    for (i = 0; i < 4; ++i) {
                        fk[i] = 3.0f * (r.nextFloat() - 0.5f);
                    }
                    a = fk[0];
                    b = fk[1];
                    fk[0] = ascale = scale * a;
                    fk[1] = scale * b;
                    fk[2] = -(a * (fk[2] + scale * (float)xc) + b * (fk[3] + scale * (float)((long)yc - shift)));
                    fk[3] = Math.abs(1.0f / ascale);
                }
            }
            int wj = 0;
            for (int j = 0; j < h; ++j) {
                boolean refresh;
                boolean bl = refresh = j < 2;
                if (refresh && removing) continue;
                int j1 = (int)(((long)j + mishift) % (long)h);
                long js = (long)j - shift;
                float[] dAj = this.dA[j1];
                float[] dCj = this.dC[j1];
                int K1 = k1;
                int K2 = k2;
                if (init || refresh) {
                    for (i = 0; i < w; ++i) {
                        dCj[i] = 0.0f;
                        dAj[i] = 0.0f;
                    }
                    dCj[0] = rowStart;
                    K1 = 0;
                    K2 = this.NPLANES;
                }
                for (k = K1; k < K2; ++k) {
                    int ihi;
                    fk = this.f[k];
                    b = fk[1];
                    float c = fk[2];
                    float bjc = b * (float)js + c;
                    a = fk[0];
                    float bjca = -bjc / a;
                    float sep = fk[3];
                    int ilo = (int)(bjca - sep);
                    if (ilo >= w || (ihi = (int)(bjca + sep)) < 0) continue;
                    if (ilo < 0) {
                        ilo = 0;
                    }
                    int n2 = ilo;
                    dAj[n2] = dAj[n2] + (a *= dfactor);
                    int n3 = ilo;
                    dCj[n3] = dCj[n3] + (bjc *= dfactor);
                    if (ihi >= w) continue;
                    int n4 = ihi;
                    dAj[n4] = dAj[n4] - a;
                    int n5 = ihi;
                    dCj[n5] = dCj[n5] - bjc;
                }
                if (!adding) continue;
                float CC = 0.0f;
                float AA = 0.0f;
                for (i = 0; i < w; ++i) {
                    float f;
                    int n6 = wj++;
                    float lightness = (AA += dAj[i]) * (float)i + (CC += dCj[i]);
                    this.cPix[n6] = f > thresh ? this.sky : (byte)lightness;
                }
            }
            delta += 2;
        }
        for (int ee = 0; ee < 2; ++ee) {
            int xx = this.ex[ee];
            int yy = this.ey[ee];
            for (int ii = 0; ii < this.ew; ++ii) {
                for (int jj = 0; jj < this.eh; ++jj) {
                    byte ce = this.ePix[jj * this.ew + ii];
                    if (ce == this.transparent) continue;
                    int i1 = (yy + jj) * w + xx + ii;
                    byte cc = this.cPix[i1];
                    if (cc == this.sky) {
                        this.cPix[i1] = ce;
                        continue;
                    }
                    if (ce != this.white) continue;
                    this.cPix[i1] = (byte)(cc + 8);
                }
            }
        }
        this.mis.newPixels();
        g.drawImage(this.im, 0, 0, null);
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus(this.statusString, g, this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

