/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.FractalMoon;
import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class Oceanic
extends Applet
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    boolean mouseIN = false;
    final int NFAULTS = 5000;
    final int MIN_FAULTS = 1000;
    final int LAND_INC = 50;
    final int NCLOUDS = 1200;
    final int CLOUD_CHANGE = 5;
    final int NSTARS = 1500;
    final int NHOURS = 240;
    final int NDAYS = 48000;
    final int nOS = 4;
    final int nOS2 = 16;
    final int sRad = 2;
    final int sRad2 = 4;
    final double tilt = 0.2;
    final double obsZ = 4.0;
    final double hPhase = Math.asin(4.0 * Math.sqrt(0.0611764705882353)) - 2.617993877991494;
    long F = 0L;
    long pt = 0L;
    long tStep = 100L;
    private volatile Thread a;
    int[][] stars = new int[2][1500];
    double[][] cloudFaults = new double[1201][5];
    FractalMoon land;
    FractalMoon clouds;
    MemoryImageSource mis;
    Image im;
    byte[] landPix;
    byte[] finalPix;
    int[] iPix;
    Random landR;
    Random cloudR = new Random();
    int nclouds;
    int nfaults;
    int[][] palettes = new int[4][];
    int[][] cols = new int[216][3];
    String statusString = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Oceanic oceanic = this;
            synchronized (oceanic) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt > this.tStep || t < this.pt) {
            boolean firstShow;
            int i;
            int j;
            int k;
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            int overW = 4 * w;
            int overH = 4 * h;
            double hA = this.hPhase + Math.PI * 2 * (double)(this.F % 240L) / 240.0;
            double dA = Math.PI * 2 * (double)(this.F % 48000L) / 48000.0;
            if (this.F == 0L) {
                this.nclouds = 0;
                this.nfaults = 0;
                this.landR = new Random(7306890088886266585L);
                int[][] cints = new int[][]{{0, 0xFFFFFF, 0xFFFF00}, {0x6666FF, 0x6666FF, 0x6666FF, 0x333333, 0x333333, 0x333333, 0x663333, 0x663333, 0x663333, 0x663333, 0x663333, 0x666633, 0x666633, 0x666633, 0x999966, 0x999966, 0x999966, 0x999966, 0x999966, 0x999966, 0xFFFF33}, {0x2222EE, 0x2222EE, 0x2222EE, 52224, 39168, 39168, 26112, 0x333366, 0xCC3366, 0xFFFF33}, null};
                int nTransp = 20;
                int nWhite = 64;
                int nGreys = 64;
                int nPreGrey = nTransp + nWhite;
                int nCloudPalette = nPreGrey + nGreys;
                cints[3] = new int[nCloudPalette];
                int[] cloudsInts = cints[3];
                for (k = 0; k < nCloudPalette; ++k) {
                    if (k < nTransp) {
                        cloudsInts[k] = -1;
                        continue;
                    }
                    if (k < nPreGrey) {
                        cloudsInts[k] = 0xFFFFFF;
                        continue;
                    }
                    int lev = 255 - (k - nPreGrey);
                    cloudsInts[k] = lev << 16 | lev << 8 | lev;
                }
                int ncols = 0;
                for (j = 0; j < 4; ++j) {
                    int l = cints[j].length;
                    this.palettes[j] = new int[l];
                    for (k = 0; k < l; ++k) {
                        int col = cints[j][k];
                        if (col < 0) {
                            this.palettes[j][k] = 216;
                            continue;
                        }
                        int red = col >> 16 & 0xFF;
                        int green = col >> 8 & 0xFF;
                        int blue = col & 0xFF;
                        for (i = 0; i < ncols && (red != this.cols[i][0] || green != this.cols[i][1] || blue != this.cols[i][2]); ++i) {
                        }
                        this.palettes[j][k] = i;
                        if (i != ncols) continue;
                        this.cols[i][0] = red;
                        this.cols[i][1] = green;
                        this.cols[i][2] = blue;
                        ++ncols;
                    }
                }
                this.finalPix = new byte[overW * overH];
                this.landPix = new byte[overW * overH];
                this.iPix = new int[w * h];
                this.mis = new MemoryImageSource(w, h, ColorModel.getRGBdefault(), this.iPix, 0, w);
                this.mis.setAnimated(true);
                this.im = this.createImage(this.mis);
                this.land = new FractalMoon(overH, 0, 0, null);
                this.clouds = new FractalMoon(overH, 0, 0, null);
            }
            Random lRan = this.landR;
            Random cRan = this.cloudR;
            boolean showPlanet = this.nfaults >= 1000;
            boolean bl = firstShow = this.nfaults == 1000;
            if (this.nfaults < 5000) {
                boolean donePlanet;
                double[][] landFaults = new double[50][5];
                for (k = 0; k < 50; ++k) {
                    FractalMoon.randomFault(lRan, landFaults[k]);
                }
                this.land.addFaults(landFaults, 0, 50, 1);
                this.nfaults += 50;
                boolean bl2 = donePlanet = this.nfaults == 5000;
                if (showPlanet) {
                    this.d(null, this.landPix, null, overW, overH, this.nfaults, this.land.height, this.land.dh, this.palettes[donePlanet ? 2 : 1], -1.0, -1.0, null, false);
                }
                if (donePlanet) {
                    this.land = null;
                }
            }
            int k1 = (int)(this.F % 240L) * 5;
            if (this.nclouds == 1200) {
                this.clouds.addFaults(this.cloudFaults, k1, 5, -1);
            }
            for (k = 0; k < 5; ++k) {
                FractalMoon.randomFault(cRan, this.cloudFaults[k1 + k]);
            }
            this.clouds.addFaults(this.cloudFaults, k1, 5, 1);
            if (this.nclouds < 1200) {
                this.nclouds += 5;
            }
            if (this.F > 0L) {
                this.clouds.addFaults(this.cloudFaults, 1200, 1, -1);
            }
            double[] fk = this.cloudFaults[1200];
            fk[0] = -Math.cos(hA);
            fk[1] = 0.2 * Math.cos(dA);
            fk[2] = -Math.sin(hA);
            fk[3] = -1000.0;
            FractalMoon.computeFault(fk);
            this.clouds.addFaults(this.cloudFaults, 1200, 1, 1);
            if (showPlanet) {
                this.d(this.landPix, this.finalPix, cRan, overW, overH, 1200, this.clouds.height, this.clouds.dh, this.palettes[3], hA, dA, this.stars, firstShow);
            }
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    int red = 0;
                    int green = 0;
                    int blue = 0;
                    for (int ii = 0; ii < 4; ++ii) {
                        for (int jj = 0; jj < 4; ++jj) {
                            byte pi = this.finalPix[overW * (4 * j + jj) + 4 * i + ii];
                            int[] cp = this.cols[pi];
                            red += cp[0];
                            green += cp[1];
                            blue += cp[2];
                        }
                    }
                    this.iPix[w * j + i] = 0xFF000000 | (red /= 16) << 16 | (green /= 16) << 8 | (blue /= 16);
                }
            }
            this.mis.newPixels();
            g.drawImage(this.im, 0, 0, null);
            this.maybeShowStatus(g);
            ++this.F;
        }
    }

    public void d(byte[] bgPix, byte[] finalPix, Random r, int w, int h, int nf, short[] height, short[] dh, int[] palette, double hA, double dA, int[][] stars, boolean initStars) {
        int k;
        int i;
        int j;
        int sy;
        double scale = 2.0 / (double)(h - 1);
        double loZsq = 0.0625;
        int w2 = w / 2;
        int h2 = h / 2;
        int wh2 = w2 - h2;
        double cos = Math.cos(hA);
        double sin = Math.sin(hA);
        double cosD = 0.2 * Math.cos(dA);
        boolean cosNeg = cos < 0.0;
        boolean sinNeg = sin < 0.0;
        int black = 0;
        int white = 1;
        int yellow = 2;
        int transparent = 216;
        int bgColour = bgPix == null ? black : transparent;
        double rSun = 0.05;
        double dSun = 0.0;
        double dSunX = 0.0;
        double dSunY = 0.0;
        double tSunX = 0.0;
        double tSunY = 0.0;
        int sunP = (int)(rSun / scale);
        int sunP2 = sunP * sunP;
        int bigSunP = 5 * sunP;
        int bigSunP2 = bigSunP * bigSunP;
        double rbigSunP2 = 1.0 / (double)bigSunP2;
        boolean visSun = false;
        boolean closeSun = false;
        int sx = sy = -w;
        if (stars != null && sin > 0.0) {
            double d;
            dSunX = -4.0 / sin * cos;
            sx = w2 + (int)(dSunX / scale);
            dSunY = 4.0 / sin * cosD;
            sy = h2 + (int)(dSunY / scale);
            dSun = Math.sqrt(dSunX * dSunX + dSunY * dSunY);
            closeSun = d <= 1.0 + rSun;
            visSun = sx > -bigSunP && sx < w + bigSunP && sy > -bigSunP && sy < h + bigSunP && dSun >= 1.0 - 1.5 * rSun;
            double sfac = (0.01 + (dSun - 1.0) * (dSun - 1.0)) / ((double)(sunP2 * sunP) * dSun);
            tSunX = sfac * dSunX;
            tSunY = sfac * dSunY;
        }
        double rowStart = -nf / 2;
        double spanH = 0.75 * Math.sqrt(nf);
        double pfactor = ((double)palette.length - 1.0E-4) / spanH;
        int n = 0;
        for (j = 0; j < h; ++j) {
            double y = scale * (double)(j - h2);
            double R2 = 1.0 - y * y - loZsq;
            int hj = h * j;
            double hrow = (double)height[j] + rowStart;
            i = 0;
            while (i < w) {
                int ll;
                int col;
                double x = scale * (double)(i - w2);
                if (R2 < x * x) {
                    col = bgColour;
                    if (visSun) {
                        k = i - sx;
                        int l = j - sy;
                        ll = k * k + l * l;
                        if (ll < sunP2) {
                            col = white;
                        } else if (ll < bigSunP2 || closeSun) {
                            double d;
                            double hfac = (double)ll * (closeSun ? Math.abs((double)k * tSunX + (double)l * tSunY) : rbigSunP2);
                            if (!(d > 1.0) && hfac < r.nextDouble()) {
                                col = yellow;
                            }
                        }
                    }
                } else {
                    col = hrow < rowStart ? black : palette[(int)(pfactor * (hrow < 0.0 ? 0.0 : (hrow > spanH ? spanH : hrow)))];
                }
                finalPix[n] = col == transparent ? bgPix[n] : (byte)col;
                ll = i - wh2;
                if (ll >= 0 && ll < h) {
                    hrow += (double)dh[hj + ll];
                }
                ++i;
                ++n;
            }
        }
        if (stars != null) {
            double screenAngle = 2.0 * Math.atan(scale * (double)w2 / 4.0);
            int twoPI = (int)((double)w * (Math.PI * 2) / screenAngle);
            int shift = (int)((hA + dA) / screenAngle * (double)w);
            int iprad2 = (int)((1.0 - loZsq) / (scale * scale));
            for (k = 0; k < 1500; ++k) {
                if (initStars) {
                    stars[0][k] = (int)((double)twoPI * r.nextDouble());
                    stars[1][k] = (int)((double)h * r.nextDouble());
                }
                i = (stars[0][k] + shift) % twoPI;
                j = stars[1][k];
                for (int iS = -2; iS <= 2; ++iS) {
                    for (int jS = -2; jS <= 2; ++jS) {
                        int jj;
                        int ii;
                        if (iS * iS + jS * jS > 4) continue;
                        int starI = i + iS;
                        int starJ = j + jS;
                        if (starI < 0 || starI >= w || starJ < 0 || starJ >= h || (ii = starI - w2) * ii + (jj = j - h2) * jj <= iprad2) continue;
                        finalPix[w * starJ + starI] = (byte)white;
                    }
                }
            }
        }
    }

    @Override
    public void showStatus(String s) {
        super.showStatus(s);
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            GraphicsUtils.showStatus(this.statusString, g, this);
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("Click to redraw");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this.F = 0L;
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

