/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.graphics.GraphicsUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class Schild
extends A2 {
    private static final long serialVersionUID = 1L;
    Image stars;
    final double[] vp = new double[]{4.0, 0.0, 4.5};
    final double[][] sxyz = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}, {-1.0, 0.0, 0.0}};
    final double xLo = -18.0;
    final double xHi = -2.0;
    final double xClose = -6.0;
    final double xCen = -10.0;
    final double zPerturb = 0.5;
    double[][] ijk = new double[][]{{-1.5, 0.866025, 0.0}, {-1.5, -0.866025, 0.0}, {-1.0, 0.0, 1.41421}};
    int[][] tetraVertexNos = new int[][]{{0, 1, 2, 4}, {6, 3, 7, 5}, {5, 4, 6, 2}, {6, 5, 2, 3}, {1, 2, 4, 5}, {1, 2, 5, 3}};
    int[][] faces = new int[][]{{3, 2, 1}, {3, 0, 2}, {3, 1, 0}, {0, 1, 2}};
    double[][][] tetras = new double[6][5][3];
    int[][][] net = new int[6][4][3];
    static final int NO_LINK = 2000;
    short[][][] tetraList = new short[2000][][];
    double[][][] vertexList = new double[2000][][];
    double[][] zList = new double[2000][5];
    short[][] sx;
    short[][] sy;
    short[] sc = new short[2];
    short[] drawList;
    boolean[] drawn;
    static final byte allFaces = 0;
    static final byte someFaces = 1;
    static final byte noFaces = 2;
    byte[] drawTet = new byte[2000];
    int ntet;
    private double[] dp = new double[3];

    @Override
    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        if (C) {
            int t;
            double[][] vm;
            int s;
            int l;
            int j;
            int m;
            int i;
            int xc = w / 2;
            int yc = h / 3;
            double[] tvec = new double[3];
            double[][] atom = null;
            double[] e1 = new double[3];
            double[] e2 = new double[3];
            if (f == 0) {
                int n;
                int k;
                this.canRedraw = false;
                this.stars = this.createImage(w, h);
                Graphics G = this.stars.getGraphics();
                G.setColor(Color.black);
                G.fillRect(0, 0, w, h);
                int[][][] starRGB = new int[w][h / 2][];
                int ts = 15 * w;
                double[] radii = new double[]{4.1, 3.7, 3.3, 2.2, 1.7, 1.2, 0.1};
                int[] counts = new int[]{w / 300, w / 300, w / 300, w / 60, w / 15, 2 * w / 3, ts};
                int cc = 0;
                for (i = 0; i < ts; ++i) {
                    double bri;
                    int n2;
                    double xx = Math.random() * (double)w;
                    double yy = Math.random() * (double)h / 2.0;
                    float sat = (float)(0.25 * Math.random());
                    do {
                        int n3 = cc++;
                        n2 = counts[n3];
                        counts[n3] = n2 - 1;
                    } while (n2 < 0);
                    double r = radii[cc];
                    double d = bri = r > 0.5 ? 1.0 : Math.random();
                    if (r > 0.5 && r < 3.0 && Math.random() < 0.5) {
                        double area = Math.PI * r * r;
                        double bfac = area < 1.0 ? 1.0 / area : 1.0;
                        GraphicsUtils.uniformDisk(starRGB, xx, yy, r, (float)Math.random(), sat, (float)(bfac * bri), 4);
                        continue;
                    }
                    GraphicsUtils.gaussianDisk(starRGB, xx, yy, 2.0 * r, (float)Math.random(), sat, (float)bri);
                }
                for (int ix = 0; ix < w; ++ix) {
                    for (int jy = 0; jy < h / 2; ++jy) {
                        int[] col = starRGB[ix][jy];
                        if (col == null) continue;
                        G.setColor(new Color(Math.min(255, col[0]), Math.min(255, col[1]), Math.min(255, col[2])));
                        G.drawLine(ix, jy, ix, jy);
                    }
                }
                double tcxMin = Double.POSITIVE_INFINITY;
                double tcxMax = Double.NEGATIVE_INFINITY;
                for (i = 0; i < 6; ++i) {
                    double[][] tt = this.tetras[i];
                    int[] tvn = this.tetraVertexNos[i];
                    for (m = 0; m < 3; ++m) {
                        double cen = 0.0;
                        for (j = 0; j < 4; ++j) {
                            double vjm = 0.0;
                            for (l = 0; l < 3; ++l) {
                                if ((tvn[j] & 1 << l) == 0) continue;
                                vjm += this.ijk[l][m];
                            }
                            tt[j][m] = vjm;
                            cen += vjm;
                        }
                        cen /= 4.0;
                        for (j = 0; j < 4; ++j) {
                            tt[j][m] = 0.75 * tt[j][m] + 0.25 * cen;
                        }
                        tt[4][m] = cen;
                        if (m != 0) continue;
                        tcxMin = Math.min(tcxMin, cen);
                        tcxMax = Math.max(tcxMax, cen);
                    }
                }
                int[][][] fmap = new int[6][4][4];
                for (i = 0; i < 6; ++i) {
                    for (j = 0; j < 4; ++j) {
                        for (m = 0; m < 4; ++m) {
                            l = 0;
                            for (k = 0; k < 3; ++k) {
                                l |= 1 << (this.tetraVertexNos[i][this.faces[j][k]] ^ 1 << m - 1);
                            }
                            fmap[i][j][m] = l;
                        }
                    }
                }
                for (i = 0; i < 6; ++i) {
                    for (j = 0; j < 4; ++j) {
                        int[] nn = this.net[i][j];
                        for (int i1 = 0; i1 < 6; ++i1) {
                            if (i1 == i) continue;
                            for (int j1 = 0; j1 < 4; ++j1) {
                                for (m = 0; m < 4; ++m) {
                                    if (fmap[i][j][0] != fmap[i1][j1][m]) continue;
                                    nn[0] = i1;
                                    nn[1] = (fmap[i1][j1][m] > fmap[i1][j1][0] ? 1 : -1) * m;
                                    nn[2] = j1;
                                }
                            }
                        }
                    }
                }
                int iHalf = 20;
                int jHalf = 20;
                int kHalf = 2;
                int iRange = 41;
                int jRange = 41;
                int kRange = 4;
                short[][][][] tnum = new short[41][41][4][6];
                for (i = 0; i < 41; ++i) {
                    for (j = 0; j < 41; ++j) {
                        for (k = 0; k < 4; ++k) {
                            for (n = 0; n < 6; ++n) {
                                tnum[i][j][k][n] = 2000;
                            }
                        }
                    }
                }
                double[] pc = new double[3];
                this.ntet = 0;
                for (j = 0; j < 41; ++j) {
                    for (k = 0; k < 4; ++k) {
                        double xx = (double)(j - 20) * this.ijk[1][0] + (double)(k - 2) * this.ijk[2][0];
                        double xx1 = (-18.0 - tcxMax - xx) / this.ijk[0][0];
                        double xx2 = (-2.0 - tcxMin - xx) / this.ijk[0][0];
                        double xxa = Math.min(xx1, xx2);
                        double xxb = Math.max(xx1, xx2);
                        int iLo = Math.max(0, 20 + (int)Math.floor(xxa));
                        int iHi = Math.min(40, 20 + (int)Math.ceil(xxb));
                        for (i = iLo; i <= iHi; ++i) {
                            for (m = 0; m < 3; ++m) {
                                tvec[m] = (double)(i - 20) * this.ijk[0][m] + (double)(j - 20) * this.ijk[1][m] + (double)(k - 2) * this.ijk[2][m];
                            }
                            for (n = 0; n < 6; ++n) {
                                double x = this.tetras[n][4][0] + tvec[0];
                                if (!(x > -18.0) || !(x < -2.0) || k != 3 && !(x > -6.0)) continue;
                                boolean someOnScreen = false;
                                block27: for (int vi = 0; vi < 4; ++vi) {
                                    for (m = 0; m < 3; ++m) {
                                        pc[m] = this.tetras[n][vi][m] + tvec[m];
                                    }
                                    for (int zp = 0; zp < 2; ++zp) {
                                        pc[2] = zp == 0 ? pc[2] + 0.5 : pc[2] - 1.0;
                                        this.screenCoords(pc, this.sc, xc, yc);
                                        if (this.sc[0] < 0 || this.sc[0] >= w || this.sc[1] < 0 || this.sc[1] >= h) continue;
                                        someOnScreen = true;
                                        break block27;
                                    }
                                }
                                if (!someOnScreen) continue;
                                short[][] temp = new short[][]{{(short)i, 0, 0}, {(short)j, 0, 0}, {(short)k, 0, 0}, {(short)n, 0, 0}};
                                this.tetraList[this.ntet] = temp;
                                tnum[i][j][k][n] = (short)this.ntet;
                                this.drawTet[this.ntet] = k <= 1 ? 2 : (x + 0.75 > -2.0 && n > 2 ? 1 : 0);
                                this.vertexList[this.ntet] = new double[this.drawTet[this.ntet] == 1 ? 9 : 5][3];
                                for (l = 0; l < 5; ++l) {
                                    for (m = 0; m < 2; ++m) {
                                        this.vertexList[this.ntet][l][m] = this.tetras[n][l][m] + tvec[m];
                                    }
                                    this.zList[this.ntet][l] = this.tetras[n][l][2] + tvec[2];
                                }
                                ++this.ntet;
                            }
                        }
                    }
                }
                for (m = 0; m < this.ntet; ++m) {
                    int[] tL = new int[3];
                    for (s = 0; s < 3; ++s) {
                        tL[s] = this.tetraList[m][s][0];
                    }
                    n = this.tetraList[m][3][0];
                    for (l = 0; l < 4; ++l) {
                        short[] tml = this.tetraList[m][l];
                        int[] nn = this.net[n][l];
                        int offs = nn[1];
                        int[] li = new int[3];
                        for (s = 0; s < 3; ++s) {
                            li[s] = tL[s] + (1 + s == Math.abs(offs) ? (offs < 0 ? -1 : 1) : 0);
                        }
                        i = li[0];
                        j = li[1];
                        k = li[2];
                        tml[0] = i < 0 || i >= 41 || j < 0 || j >= 41 || k < 0 || k >= 4 ? 2000 : tnum[i][j][k][nn[0]];
                        tml[1] = (short)nn[2];
                    }
                }
                this.sx = new short[this.ntet][];
                this.sy = new short[this.ntet][];
                this.drawList = new short[this.ntet];
                this.drawn = new boolean[this.ntet];
            }
            for (m = 0; m < this.ntet; ++m) {
                vm = this.vertexList[m];
                for (l = 0; l < 5; ++l) {
                    double[] vml = vm[l];
                    double x = vml[0];
                    double y = vml[1];
                    double r = Math.sqrt((x - -10.0) * (x - -10.0) + y * y);
                    vml[2] = this.zList[m][l] + 0.5 * Math.sin(Math.PI * 2 * r / 4.0 - this.frameA * (double)f);
                }
            }
            for (m = 0; m < this.ntet; ++m) {
                vm = this.vertexList[m];
                double[] tetCen = vm[4];
                for (l = 0; l < 4; ++l) {
                    int[] fl = this.faces[l];
                    double[] V0 = vm[fl[0]];
                    double[] V1 = vm[fl[1]];
                    double[] V2 = vm[fl[2]];
                    short[] tml = this.tetraList[m][l];
                    for (t = 0; t < 3; ++t) {
                        e1[t] = V1[t] - V0[t];
                        e2[t] = V2[t] - V0[t];
                    }
                    double[] norm = new double[]{e1[1] * e2[2] - e1[2] * e2[1], e1[2] * e2[0] - e1[0] * e2[2], e1[0] * e2[1] - e1[1] * e2[0]};
                    double nd = 0.0;
                    for (t = 0; t < 3; ++t) {
                        nd += norm[t] * (V0[t] - this.vp[t]);
                    }
                    tml[2] = (short)(nd < 0.0 ? -1 : 1);
                    if (this.drawTet[m] != 1 || (s = tml[0]) == 2000) continue;
                    double nd2 = 0.0;
                    nd = 0.0;
                    double[] otherCen = this.vertexList[s][4];
                    for (t = 0; t < 3; ++t) {
                        nd += norm[t] * (V0[t] - tetCen[t]);
                        nd2 += norm[t] * (otherCen[t] - tetCen[t]);
                    }
                    nd /= nd2;
                    for (t = 0; t < 3; ++t) {
                        vm[5 + l][t] = (1.0 - nd) * tetCen[t] + nd * otherCen[t];
                    }
                }
                int lvm = vm.length;
                if (this.sx[m] == null) {
                    this.sx[m] = new short[lvm];
                    this.sy[m] = new short[lvm];
                }
                for (l = 0; l < lvm; ++l) {
                    this.screenCoords(vm[l], this.sc, xc, yc);
                    this.sx[m][l] = this.sc[0];
                    this.sy[m][l] = this.sc[1];
                }
            }
            g.drawImage(this.stars, 0, 0, null);
            GraphicsUtils.setAA(g);
            int total_drawn = 0;
            for (i = 0; i < this.ntet; ++i) {
                this.drawn[i] = false;
            }
            int[] tx = new int[4];
            int[] ty = new int[4];
            while (total_drawn < this.ntet) {
                int ndraw = 0;
                for (i = 0; i < this.ntet; ++i) {
                    if (this.drawn[i]) continue;
                    boolean ok = true;
                    for (j = 0; j < 4; ++j) {
                        short[] tij = this.tetraList[i][j];
                        if (tij[2] >= 0 || (t = tij[0]) == 2000 || this.drawn[t] || this.tetraList[t][tij[1]][2] <= 0) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                    this.drawList[ndraw++] = (short)i;
                }
                for (m = 0; m < ndraw; ++m) {
                    short v = this.drawList[m];
                    this.drawn[v] = true;
                    ++total_drawn;
                    byte draw = this.drawTet[v];
                    short[] sxv = this.sx[v];
                    short[] syv = this.sy[v];
                    for (i = -1; i <= 1; ++i) {
                        short ix = 0;
                        short iy = 0;
                        int jx = 0;
                        int jy = 0;
                        if (i == 0 && draw != 0) {
                            g.setColor(Color.red);
                            ix = sxv[4];
                            iy = syv[4];
                            g.drawOval(ix - 1, iy - 1, 2, 2);
                        }
                        for (s = 0; s < 4; ++s) {
                            int[] fs = this.faces[s];
                            short[] tvs = this.tetraList[v][s];
                            if (!(draw == 2 || tvs[2] != i || draw != 1 && i != 1 || draw != 0 && s == 3)) {
                                for (l = 0; l < 4; ++l) {
                                    int vi = fs[l % 3];
                                    tx[l] = sxv[vi];
                                    ty[l] = syv[vi];
                                }
                                g.setColor(i == 1 ? Color.black : Color.blue);
                                g.fillPolygon(tx, ty, 3);
                                g.setColor(i == 1 ? Color.blue : Color.black);
                                g.drawPolygon(tx, ty, 4);
                            }
                            if (i != 0 || draw == 0) continue;
                            l = tvs[0];
                            if (l == 2000) {
                                int aa = fs[0];
                                int bb = fs[1];
                                int cc = fs[2];
                                jx = (sxv[aa] + sxv[bb] + sxv[cc]) / 3;
                                jy = (syv[aa] + syv[bb] + syv[cc]) / 3;
                            } else if (draw == 1) {
                                jx = sxv[5 + s];
                                jy = syv[5 + s];
                            } else {
                                jx = (ix + this.sx[l][4]) / 2;
                                jy = (iy + this.sy[l][4]) / 2;
                            }
                            g.drawLine(ix, iy, jx, jy);
                        }
                    }
                }
            }
        } else {
            this.tetraList = null;
            this.vertexList = null;
            this.zList = null;
            this.drawList = null;
            this.drawn = null;
            this.drawTet = null;
        }
        return C;
    }

    private void screenCoords(double[] pc, short[] sc, int xc, int yc) {
        for (int k = 0; k < 3; ++k) {
            this.dp[k] = 0.0;
            for (int t = 0; t < 3; ++t) {
                int n = k;
                this.dp[n] = this.dp[n] + (pc[t] - this.vp[t]) * this.sxyz[k][t];
            }
        }
        sc[0] = (short)(xc + (int)((double)xc * this.dp[0] / this.dp[2]));
        sc[1] = (short)(yc + (int)((double)xc * this.dp[1] / this.dp[2]));
    }
}

