/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public abstract class ScrollingApplet
extends Applet
implements Runnable,
WindowListener,
KeyListener,
MouseListener {
    int mainParameter = -1;
    int n1;
    int n2;
    boolean mouseIN;
    boolean scrolling = true;
    boolean redraw = true;
    boolean thisIsFramedApplet = false;
    boolean thereIsFramedApplet = false;
    ScrollingApplet keyTarget = this;
    ScrollingApplet childApplet = null;
    ScrollingApplet parentApplet = null;
    Frame appletFrame = null;
    Image J;
    Graphics H;
    int Jw;
    int Jh;
    int take;
    long lowY = 0L;
    long thisSeed;
    long tStep = 100L;
    long pt;
    private volatile Thread a;
    String statusString = "";

    void setTimeStep(long ts) {
        this.tStep = ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.thisIsFramedApplet) {
            this.addKeyListener(this);
        }
        this.addMouseListener(this);
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            ScrollingApplet scrollingApplet = this;
            synchronized (scrollingApplet) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(this.tStep / 2L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt > this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            int offH = 2 * h;
            int halfOH = offH / 2;
            if (this.redraw || this.J == null || this.Jw != w || this.Jh != offH) {
                this.J = this.createImage(w, offH);
                this.H = this.J.getGraphics();
                this.Jw = w;
                this.Jh = offH;
                this.d(this.H, w, 0, offH, this.lowY + (long)halfOH, this.redraw);
                this.redraw = false;
                this.take = 0;
            } else if (this.take + h >= offH) {
                this.lowY += (long)this.take;
                this.H.copyArea(0, this.take, w, offH - this.take, 0, -this.take);
                this.d(this.H, w, offH - this.take, offH, this.lowY + (long)((2 * offH - this.take) / 2), false);
                System.gc();
                this.take = 0;
            } else if (this.take < 0) {
                this.lowY += (long)this.take;
                this.H.copyArea(0, 0, w, offH + this.take, 0, -this.take);
                this.d(this.H, w, 0, -this.take, this.lowY + (long)(-this.take / 2), false);
                System.gc();
                this.take = 0;
            }
            g.drawImage(this.J, 0, -this.take, null);
            this.maybeShowStatus(g);
            if (this.scrolling) {
                this.take += 2;
            }
        }
    }

    void identifyFocus(Graphics g) {
        Component compFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(Color.white);
        g.fillRect(0, h / 2 - 20, w, 40);
        g.setColor(Color.black);
        g.drawString("" + compFocusOwner, 5, h / 2);
    }

    abstract ScrollingApplet getNewApplet();

    abstract void setup(long var1, int var3);

    abstract void d(Graphics var1, int var2, int var3, int var4, long var5, boolean var7);

    @Override
    public void showStatus(String s) {
        if (!this.thisIsFramedApplet) {
            super.showStatus(s);
        }
        this.statusString = s;
    }

    void maybeShowStatus(Graphics g) {
        if (this.statusString.length() != 0) {
            if (this.thisIsFramedApplet) {
                this.appletFrame.setTitle(this.statusString);
            } else {
                GraphicsUtils.showStatus(this.statusString, g, this);
            }
        }
    }

    void createFramedApplet() {
        if (this.thereIsFramedApplet) {
            return;
        }
        Rectangle b = this.getGraphicsConfiguration().getBounds();
        int w = (int)b.getWidth();
        int h = (int)b.getHeight();
        this.childApplet = this.getNewApplet();
        this.childApplet.parentApplet = this;
        this.childApplet.setSize(new Dimension(w, h));
        this.childApplet.addKeyListener(this);
        this.keyTarget = this.childApplet;
        this.childApplet.thisIsFramedApplet = true;
        this.childApplet.thereIsFramedApplet = true;
        this.thereIsFramedApplet = true;
        this.appletFrame = new Frame();
        this.appletFrame.addWindowListener(this);
        this.appletFrame.addKeyListener(this);
        this.appletFrame.setUndecorated(true);
        this.appletFrame.setResizable(true);
        this.appletFrame.add("Center", this.childApplet);
        this.appletFrame.setSize(w, h);
        this.childApplet.appletFrame = this.appletFrame;
        this.childApplet.init();
        this.childApplet.setup(this.thisSeed, this.mainParameter);
        this.childApplet.redraw = false;
        this.childApplet.scrolling = this.scrolling;
        this.appletFrame.setVisible(true);
        this.childApplet.lowY = this.lowY + (long)this.take + (long)(this.getSize().height / 2) - (long)(this.childApplet.getSize().height / 2);
        this.childApplet.start();
        this.childApplet.mouseEntered(null);
        this.stop();
    }

    void destroyFramedApplet() {
        if (this.thereIsFramedApplet && this.childApplet != null) {
            this.appletFrame.setVisible(false);
            this.childApplet.stop();
            this.childApplet.destroy();
            this.appletFrame.dispose();
            this.childApplet = null;
            this.appletFrame = null;
            this.thereIsFramedApplet = false;
            this.addKeyListener(this);
            this.keyTarget = this;
            this.start();
        }
    }

    synchronized void swapScrolling() {
        this.scrolling = !this.scrolling;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.destroyFramedApplet();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        int kc = e.getKeyCode();
        if (kc == 87) {
            this.createFramedApplet();
        } else if (kc == 67 || kc == 27) {
            this.destroyFramedApplet();
        } else if (kc == 32) {
            this.keyTarget.swapScrolling();
        } else if (kc == 33) {
            this.keyTarget.take -= this.keyTarget.getSize().height;
        } else if (kc == 34) {
            this.keyTarget.take += this.keyTarget.getSize().height;
        } else if (kc == 38 || kc == 224) {
            this.keyTarget.take -= this.keyTarget.getSize().height / 10;
        } else if (kc == 40 || kc == 225) {
            this.keyTarget.take += this.keyTarget.getSize().height / 10;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
        this.mouseIN = true;
        this.showStatus("n=" + this.mainParameter + " (click for " + this.n1 + ", SHIFT-click for " + this.n2 + ", CTRL-click for " + this.mainParameter + ")");
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
        this.mouseIN = false;
        this.showStatus("");
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        if ((e.getModifiersEx() & 0x1000) != 0) {
            if (this.thisIsFramedApplet && this.parentApplet != null) {
                this.parentApplet.destroyFramedApplet();
            }
        } else {
            boolean shift = e.isShiftDown();
            boolean ctrl = e.isControlDown();
            if (!shift || !ctrl) {
                this.redraw = true;
                this.lowY = 0L;
                if (!ctrl) {
                    this.mainParameter = shift ? this.n2 : this.n1;
                }
            }
        }
        this.mouseEntered(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

