/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.A2;
import egan.graphics.GraphicsUtils;
import egan.util.Utils;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Random;

public class Teranesia
extends A2 {
    private static final long serialVersionUID = 1L;
    boolean freeze = false;
    static final double wsize = 0.05;
    int nSwarm = 3;
    static final int nG = 18;
    static final int nB = 1296;
    static final int nBands = 3;
    double[][] wing = new double[][]{{0.0, 0.0}, {0.0, 0.2}, {0.707, 1.25}, {1.0, 0.2}};
    double[] wCen = new double[2];
    double[][][] wR;
    double[][] sxyz = new double[][]{{-0.336773, 0.914965, 0.221631}, {0.392268, 0.35024, -0.849847}, {0.855336, 0.199298, 0.476935}};
    double[] rx = new double[1296];
    double[][] pos = new double[1296][10];
    double[] wave = new double[]{701.0, 534.5, 422.5};
    int wL = this.wing.length;
    double thickness;
    double nsqm1;
    final int NPLANES = 2000;
    Image clouds;
    float[] nxcos;
    float[] nxsin;
    float[] nycos;
    float[] nysin;
    float[] vpfactor;
    static final int NWAVES = 6;
    double[][] waves = new double[6][2];

    @Override
    public boolean d(Graphics g, int w, int h, int p, int q, int f, boolean C, boolean TB, int L, int V) {
        double x;
        double y;
        double lambda;
        int j;
        int i0;
        int i;
        int k;
        boolean init;
        int mB = 0;
        int xc = w / 2;
        int yc = h / 2;
        int npix = w * yc;
        boolean bl = init = this.F == 1L;
        if (init) {
            int str;
            this.freeze = TB;
            int n = this.nSwarm = this.freeze ? 1 : 3;
            if (!TB) {
                float[] fk;
                float[][] cf = new float[2000][3];
                float[] dA = new float[w + 1];
                float[] dB = new float[w + 1];
                float[] dD = new float[w + 1];
                float maxd = 450.0f;
                Random r = new Random();
                this.clouds = this.createImage(w, yc);
                Graphics G = this.clouds.getGraphics();
                byte[] fPix = new byte[npix];
                float scale = 2.0f / (float)(h - 5);
                for (k = 0; k < 2000; ++k) {
                    fk = cf[k];
                    for (i = 0; i < 3; ++i) {
                        fk[i] = (float)(i == 2 ? 6 : 3) * (r.nextFloat() - 0.5f);
                    }
                }
                i0 = 0;
                for (j = 0; j < yc; ++j) {
                    lambda = 0.5 / (double)(j - yc);
                    y = lambda / (double)scale;
                    float A = 0.0f;
                    float B = 0.0f;
                    float D = 0.0f;
                    for (i = 0; i < w; ++i) {
                        dD[i] = 0.0f;
                        dB[i] = 0.0f;
                        dA[i] = 0.0f;
                    }
                    for (k = 0; k < 2000; ++k) {
                        fk = cf[k];
                        float a = fk[0];
                        float b = fk[1];
                        float c = fk[2];
                        int ia = xc + (int)((-1.0 - (double)b * y - (double)c) / (double)a / lambda);
                        int ib = xc + (int)((1.0 - (double)b * y - (double)c) / (double)a / lambda);
                        int ilo = Math.min(ia, ib);
                        int ihi = Math.max(ia, ib);
                        if (ilo < 0 && ihi >= 0) {
                            A += a;
                            B += b;
                            D += c;
                        } else if (ilo >= 0 && ilo < w) {
                            int n2 = ilo;
                            dA[n2] = dA[n2] + a;
                            int n3 = ilo;
                            dB[n3] = dB[n3] + b;
                            int n4 = ilo;
                            dD[n4] = dD[n4] + c;
                        }
                        if (ihi < 0 || ihi >= w) continue;
                        int n5 = ihi;
                        dA[n5] = dA[n5] - a;
                        int n6 = ihi;
                        dB[n6] = dB[n6] - b;
                        int n7 = ihi;
                        dD[n7] = dD[n7] - c;
                    }
                    for (i = 0; i < w; ++i) {
                        x = scale * (float)(i - xc);
                        float density = (float)((double)A * x + (double)B * y + (double)D) / maxd + 0.5f;
                        float dd = density < 0.0f ? 0.0f : (density > 1.0f ? 1.0f : density);
                        int ci = (int)(5.99 * (double)dd);
                        fPix[i0++] = (byte)(ci >= 3 ? (ci < 4 ? 215 : 172) : 5);
                        A += dA[i];
                        B += dB[i];
                        D += dD[i];
                    }
                }
                GraphicsUtils.drawPix(this, G, fPix, w, yc, w, 0, 0);
                G.dispose();
                for (i = 0; i < 6; ++i) {
                    for (j = 0; j < 2; ++j) {
                        this.waves[i][j] = 3.0 * (Math.random() - 0.5);
                    }
                }
            }
            this.thickness = Math.PI * this.wave[1] * (8.0 + 4.0 * Math.random());
            double refInd = 1.4 + 0.2 * Math.random();
            this.nsqm1 = refInd * refInd - 1.0;
            this.wCen[0] = 0.0;
            this.wCen[1] = 0.0;
            for (i = 0; i < this.wL; ++i) {
                for (j = 0; j < 2; ++j) {
                    this.wing[i][j] = this.wing[i][j];
                    this.wCen[j] = this.wCen[j] + this.wing[i][j] / (double)this.wL;
                }
            }
            this.wR = new double[3][this.wL][2];
            for (str = 0; str < 3; ++str) {
                double f2 = (double)str / 3.0;
                double f1 = 1.0 - f2;
                for (k = 0; k < this.wL; ++k) {
                    for (int l = 0; l < 2; ++l) {
                        this.wR[str][k][l] = f1 * this.wing[k][l] + f2 * this.wCen[l];
                    }
                }
            }
            for (i = -18; i <= 18; ++i) {
                for (j = -18; j <= 18; ++j) {
                    x = (double)(i - j) * 0.05;
                    y = (double)(i + j) * 0.05;
                    double ax = Math.abs(x);
                    double ay = Math.abs(y);
                    boolean OK = true;
                    for (str = 0; str < 3; ++str) {
                        for (k = 0; k < this.wL; ++k) {
                            double[] p1 = this.wR[str][k];
                            double[] p2 = this.wR[str][(k + 1) % this.wL];
                            if (!((ax - p1[1]) * (p2[0] - p1[0]) - (ay - p1[0]) * (p2[1] - p1[1]) > 0.0)) continue;
                            OK = false;
                            break;
                        }
                        if (!OK) break;
                    }
                    if (str <= 0) continue;
                    this.rx[mB] = Math.exp(2.0 * Math.random() - (x < 0.0 ? 2.6 : 1.9));
                    double[] pp = this.pos[mB++];
                    pp[4] = str;
                    pp[8] = x;
                    pp[9] = y;
                }
            }
            this.pos[mB][4] = 0.0;
        }
        double frameAngle = this.frameA * (double)f;
        double cosFrame = Math.cos(frameAngle);
        double sinFrame = Math.sin(frameAngle);
        if (C && !TB) {
            g.drawImage(this.clouds, 0, 0, null);
            double distance = 10.0;
            double depth = 10.0;
            double depthsq = depth * depth;
            byte[] fPix = new byte[npix];
            if (init) {
                this.nxcos = new float[npix];
                this.nxsin = new float[npix];
                this.nycos = new float[npix];
                this.nysin = new float[npix];
                this.vpfactor = new float[npix];
            }
            float[] nxc = this.nxcos;
            float[] nxs = this.nxsin;
            float[] nyc = this.nycos;
            float[] nys = this.nysin;
            float[] vpf = this.vpfactor;
            i0 = 0;
            double scale = 2.0f / (float)(h - 5);
            for (j = 0; j < yc; ++j) {
                lambda = depth / (double)(j + 5);
                y = lambda / scale * distance;
                double ysqzsq = y * y + depthsq;
                double yd = y + depth;
                double[] ydot = new double[6];
                if (init) {
                    for (k = 0; k < 6; ++k) {
                        ydot[k] = this.waves[k][1] * y;
                    }
                }
                for (i = 0; i < w; ++i) {
                    x = lambda * (double)(i - xc);
                    if (init) {
                        vpf[i0] = -0.707f / (float)Math.sqrt(x * x + ysqzsq);
                        double nxC = 0.0;
                        double nyC = 0.0;
                        double nxS = 0.0;
                        double nyS = 0.0;
                        for (k = 0; k < 6; ++k) {
                            double wv0 = this.waves[k][0];
                            double wv1 = this.waves[k][1];
                            double a = ydot[k] + wv0 * x;
                            double cp = Math.cos(a);
                            double sp = Math.sin(a);
                            nxC += wv0 * cp;
                            nyC += wv1 * cp;
                            nxS += wv0 * sp;
                            nyS += wv1 * sp;
                        }
                        nxc[i0] = (float)nxC;
                        nyc[i0] = (float)nyC;
                        nxs[i0] = (float)nxS;
                        nys[i0] = (float)nyS;
                    }
                    double nx = cosFrame * (double)nxc[i0] - sinFrame * (double)nxs[i0];
                    double ny = cosFrame * (double)nyc[i0] - sinFrame * (double)nys[i0];
                    double dp = (double)vpf[i0] * (yd - 2.0 * (x * nx + y * ny - depth) * (ny - 1.0) / (1.0 + nx * nx + ny * ny));
                    fPix[i0++] = (byte)(dp > 0.8 ? 214 : (dp < -0.75 ? 3 : 10));
                }
            }
            GraphicsUtils.drawPix(this, g, fPix, w, yc, w, 0, yc);
        } else {
            this.nxcos = null;
            this.nxsin = null;
            this.nycos = null;
            this.nysin = null;
            this.vpfactor = null;
        }
        int swarm = (int)((this.F - 1L) / (long)this.nframes);
        this.butterflies(g, f, swarm, frameAngle, w, h);
        return swarm != this.nSwarm - 1 || f != this.nframes - 1;
    }

    private void butterflies(Graphics g, int f, int swarm, double a, int w, int h) {
        int l;
        double o;
        double sfaS;
        double cfaS;
        double q1;
        double[] pp;
        int mB;
        int i;
        int[][] xy = new int[2][this.wL];
        int xc = w / 2;
        int yc = h / 2;
        double[] cfa = new double[6];
        double[] sfa = new double[6];
        double low = 1.0E10;
        double high = -1.0E10;
        double[] vs = new double[3];
        double delta = this.freeze ? 0.65 : (double)swarm + (double)f / (double)this.nframes;
        double ee = this.freeze ? 0.003 : Math.exp(-2.7 * delta);
        for (i = 0; i < 6; ++i) {
            double aa = a + 0.3 * (double)i;
            double fa = this.freeze ? 0.4 * (2.5 + Math.sin(a)) : 0.75 * (0.4 + Math.sin(aa * (double)(i < 2 ? 1 : 2)));
            cfa[i] = Math.cos(fa);
            sfa[i] = Math.sin(fa);
        }
        for (mB = 0; mB < 1296 && (pp = this.pos[mB])[4] != 0.0; ++mB) {
            double x = pp[8];
            double y = pp[9];
            int wsn = x < 0.0 ? 0 : 1;
            q1 = ee * this.rx[mB];
            double q2 = 1.0 - q1;
            pp[0] = -3.6 * delta + x * q2 + q1 * (30.0 * Math.abs(x) - 1.5) + 2.1;
            cfaS = cfa[wsn];
            pp[1] = cfaS * y + q1 * (double)(y < 0.0 ? -2 : 2);
            sfaS = sfa[wsn];
            pp[2] = sfaS * Math.abs(y) * (1.0 - ee) + (this.freeze ? -0.5 : 0.0);
            o = 0.0;
            for (l = 0; l < 3; ++l) {
                o += pp[l] * this.sxyz[2][l];
            }
            pp[3] = o;
            pp[5] = q2 * cfaS;
            pp[6] = q2 * (double)(y < 0.0 ? 1 : -1) * sfaS;
            pp[7] = q1;
            low = o < low ? o : low;
            high = o > high ? o : high;
        }
        Utils.qs(3, this.pos, 0, mB - 1, low, high);
        int pci = -1;
        for (int n = 0; n < mB; ++n) {
            pp = this.pos[n];
            o = (4.0 - pp[3]) / 3.5;
            if (o <= 0.1) continue;
            q1 = pp[7];
            for (int j = -1; j <= 1; j += 2) {
                for (int m = -1; m <= 1; m += 2) {
                    int fai = 2 + n % 3 + (m + 1) / 2;
                    cfaS = cfa[fai];
                    sfaS = sfa[fai];
                    double colCos = q1 * cfaS + pp[5];
                    double colSin = -q1 * (double)j * sfaS + pp[6];
                    int np = 0;
                    for (i = 0; i < this.wL; ++i) {
                        boolean adv = i == 0;
                        double[] qq = new double[]{pp[0] + (double)m * this.wing[i][1] * 0.05, pp[1] + (double)j * cfaS * this.wing[i][0] * 0.05, pp[2] + sfaS * this.wing[i][0] * 0.05};
                        for (int k = 0; k < 2; ++k) {
                            int[] zz = xy[k];
                            zz[np] = xc;
                            for (l = 0; l < 3; ++l) {
                                int n2 = np;
                                zz[n2] = zz[n2] + (int)((double)xc * qq[l] * this.sxyz[k][l] / o);
                            }
                            if (adv || zz[np] == zz[np - 1]) continue;
                            adv = true;
                        }
                        if (adv) {
                            ++np;
                        }
                        if (i != 2) continue;
                        int ci = 0;
                        if (pp[4] == 2.0) {
                            double vsn = 0.0;
                            for (l = 0; l < 3; ++l) {
                                vs[l] = 4.0 * this.sxyz[2][l] - qq[l];
                                vsn += vs[l] * vs[l];
                            }
                            double cai = vs[1] * colSin + vs[2] * colCos;
                            double dist = this.thickness * Math.sqrt(this.nsqm1 + cai * cai / vsn);
                            for (l = 0; l < 3; ++l) {
                                float mag = (float)Math.sin(dist / this.wave[l]);
                                ci = 6 * ci + Math.round(mag * mag / 0.2f);
                            }
                        }
                        if (ci == pci) continue;
                        g.setColor(GraphicsUtils.HTMLcolour(ci));
                        pci = ci;
                    }
                    int x1 = xy[0][0];
                    int y1 = xy[1][0];
                    if (np > 1 && x1 == xy[0][np - 1] && y1 == xy[1][np - 1]) {
                        --np;
                    }
                    if (np < 3) {
                        g.drawLine(x1, y1, xy[0][np - 1], xy[1][np - 1]);
                        continue;
                    }
                    g.fillPolygon(xy[0], xy[1], np);
                }
            }
        }
    }
}

