/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.TextFreqNode;
import egan.graphics.GraphicsUtils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public class Text
extends Applet
implements Runnable {
    private static final long serialVersionUID = 1L;
    static final int maxchars = 100;
    TextFreqNode tfn;
    int nSeq;
    int[] seq;
    boolean needCap = true;
    boolean inquotes = false;
    long wcount;
    long F = 0L;
    long tStep = 100L;
    long pt;
    private volatile Thread a;
    Image I;
    Graphics G;
    int fl;
    int fa;
    int fd;
    int fh;
    int tx;
    int ty;
    int cp;
    StringBuffer sb;
    boolean space;
    boolean endPar;
    final int fontSize = 16;
    Font font;
    FontMetrics fontMetric;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.a == thisThread) {
            long t = System.currentTimeMillis();
            Text text = this;
            synchronized (text) {
                if (t - this.pt > this.tStep || t < this.pt) {
                    this.repaint();
                }
            }
            try {
                Thread.sleep(40L);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    @Override
    public void start() {
        this.a = new Thread(this);
        this.a.start();
        this.a.setPriority(1);
    }

    @Override
    public void stop() {
        this.a = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public synchronized void update(Graphics g) {
        long t = System.currentTimeMillis();
        if (t - this.pt > this.tStep || t < this.pt) {
            this.pt = t;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.F == 0L) {
                this.I = this.createImage(w, h);
                this.G = this.I.getGraphics();
                this.G.setColor(Color.white);
                this.G.fillRect(0, 0, w, h);
                GraphicsUtils.setAA(this.G);
                try {
                    GZIPInputStream p = new GZIPInputStream(new URL(this.getCodeBase(), "egan/applets/TextStats.dat").openStream());
                    if (p != null) {
                        this.tfn = (TextFreqNode)TextFreqNode.read(p, 0);
                        ((InputStream)p).close();
                    }
                }
                catch (Exception e) {
                    this.tfn = null;
                }
                this.nSeq = TextFreqNode.nSeq;
                this.seq = new int[this.nSeq];
                Object ptr = this.tfn;
                for (int i = 0; i < this.nSeq && ptr != null; ++i) {
                    if (!(ptr instanceof TextFreqNode)) {
                        this.seq[i] = ((byte[])ptr)[0];
                        break;
                    }
                    TextFreqNode tf = ptr;
                    this.seq[i] = tf.symbol;
                    ptr = tf.child;
                }
                this.wcount = 0L;
                String fontName = GraphicsUtils.getNiceFont(this);
                this.font = new Font(fontName, 0, 16);
                this.fontMetric = this.getFontMetrics(this.font);
                this.G.setFont(this.font);
                this.fl = this.fontMetric.getLeading();
                this.fa = this.fontMetric.getAscent();
                this.fd = this.fontMetric.getDescent();
                this.fh = this.fontMetric.getHeight();
                this.tx = 0;
                this.ty = this.fa;
                this.sb = new StringBuffer(100);
                this.cp = 0;
            }
            this.d(this.G, w, h);
            g.drawImage(this.I, 0, 0, null);
            ++this.F;
        }
    }

    public void d(Graphics g, int w, int h) {
        if (this.tfn == null) {
            return;
        }
        if (this.cp == this.sb.length()) {
            if (this.endPar) {
                this.newLine(w, h);
                g.drawString("   ", this.tx, this.ty);
                this.tx = this.fontMetric.stringWidth("   ");
            }
            if (this.space) {
                g.drawString(" ", this.tx, this.ty);
                this.tx += this.fontMetric.charWidth(' ');
            }
            this.sb.setLength(0);
            this.cp = 0;
            block0: while (this.sb.length() == 0) {
                for (int ii = 0; ii < 100; ++ii) {
                    int j;
                    byte s = (byte)(1.0 + 127.0 * Math.random());
                    TextFreqNode ptr = this.tfn;
                    int lev = 0;
                    while (true) {
                        TextFreqNode pn;
                        int si = this.seq[lev];
                        while (ptr.symbol != si && (pn = ptr.next) != null) {
                            ptr = pn;
                        }
                        if (++lev == this.nSeq - 1) break;
                        ptr = (TextFreqNode)ptr.child;
                    }
                    byte[] ba = (byte[])ptr.child;
                    int baLen = ba.length;
                    for (j = 1; j < baLen && ba[j] < s; j += 2) {
                    }
                    int k = ba[j - 1];
                    char[] atom = TextFreqNode.atomList[k];
                    this.seq[this.nSeq - 1] = k;
                    for (int i = 1; i < this.nSeq; ++i) {
                        this.seq[i - 1] = this.seq[i];
                    }
                    if (k == 0) continue block0;
                    int cp = 0;
                    while (atom[cp] != '\u0000') {
                        if (cp == 0 && this.needCap) {
                            this.sb.append(Character.toUpperCase(atom[0]));
                        } else {
                            this.sb.append(atom[cp]);
                        }
                        ++cp;
                    }
                    this.needCap = false;
                }
            }
            if (this.wcount++ == 0L) {
                this.needCap = true;
                this.cp = this.sb.length();
                return;
            }
            this.endPar = false;
            if (Math.random() < 0.1) {
                this.sb.append('.');
                this.needCap = true;
                if (Math.random() < 0.2) {
                    this.endPar = true;
                }
            } else if (Math.random() < 0.1) {
                this.sb.append(',');
            }
            this.space = !this.endPar;
            String ss = this.sb.toString();
            int sw = this.fontMetric.stringWidth(ss);
            if (this.tx + sw > w) {
                this.newLine(w, h);
                this.tx = 0;
            }
        }
        char c = this.sb.charAt(this.cp++);
        g.setColor(Color.black);
        g.drawString(new Character(c).toString(), this.tx, this.ty);
        this.tx += this.fontMetric.charWidth(c);
    }

    void newLine(int w, int h) {
        this.tx = 0;
        this.ty += this.fh;
        if (this.ty + this.fd >= h) {
            this.ty -= this.fh;
            this.G.copyArea(0, 0, w, this.ty + this.fd, 0, -this.fh);
            this.G.setColor(Color.white);
            this.G.fillRect(0, this.ty - this.fa, w, this.fh);
        }
    }
}

