/*
 * Decompiled with CFR 0.152.
 */
package egan.applets;

import egan.applets.ScrollingApplet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.Random;

public class deBruijn
extends ScrollingApplet {
    private static final long serialVersionUID = 1L;
    int minD = 4;
    int maxD = 12;
    double coordWidth = 20.0;
    double inc;
    float bfac0 = 0.2f;
    double[] Gx;
    double[] Gy;
    double[] Gd;
    double[][] Dets;
    double marg;
    float[][] Tshape;
    float[][] Torient;
    float cfac;
    static final BasicStroke str = new BasicStroke(0.5f, 0, 2);
    static final RenderingHints aaON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    GeneralPath rhomb = new GeneralPath(0, 5);

    @Override
    ScrollingApplet getNewApplet() {
        return new deBruijn();
    }

    @Override
    public void setup(long rseed, int dim) {
        Random r = new Random(rseed);
        int numD = this.maxD - this.minD + 1;
        if (dim > 0) {
            this.mainParameter = dim;
        } else if (this.mainParameter < 0) {
            this.mainParameter = this.minD + (int)((double)numD * r.nextDouble());
        }
        int ng = this.mainParameter;
        this.n1 = this.minD + (ng - this.minD + 1) % numD;
        this.n2 = this.minD + (ng - this.minD + numD - 1) % numD;
        r = new Random(rseed);
        this.Gx = new double[ng];
        this.Gy = new double[ng];
        this.Gd = new double[ng];
        double phase = 6.0 * r.nextDouble();
        double sA = Math.PI / (double)ng;
        double hA = sA / 2.0;
        double theta = (double)(ng % 2 + 1) * sA;
        double norm = Math.sqrt(2.0 / (double)ng);
        for (int k = 0; k < ng; ++k) {
            double xg = norm * Math.cos(phase + theta * (double)k);
            double yg = norm * Math.sin(phase + theta * (double)k);
            this.Gx[k] = xg;
            this.Gy[k] = yg;
            this.Gd[k] = r.nextDouble();
        }
        this.marg = 0.5 * norm / Math.sin(hA);
        this.Tshape = new float[ng][ng];
        this.Torient = new float[ng][ng];
        this.Dets = new double[ng][ng];
        for (int fD = 0; fD < ng; ++fD) {
            for (int eD = 0; eD < ng; ++eD) {
                double xf = this.Gx[fD];
                double yf = this.Gy[fD];
                double xe = this.Gx[eD];
                double ye = this.Gy[eD];
                float t = (float)(Math.acos((xf * xe + yf * ye) / Math.sqrt((xf * xf + yf * yf) * (xe * xe + ye * ye))) / Math.PI);
                this.Tshape[fD][eD] = 2.0f * Math.min(t, 1.0f - t);
                this.Torient[fD][eD] = (float)Math.abs((Math.atan2(xf, yf) + Math.atan2(xe, ye)) / (Math.PI * 2));
                this.Dets[fD][eD] = ye * xf - xe * yf;
            }
        }
        this.cfac = r.nextFloat();
        double span0 = this.coordWidth / Math.sqrt(ng);
        this.inc = span0 / 300.0;
        if (this.mouseIN) {
            this.mouseEntered(null);
        }
    }

    @Override
    public void d(Graphics g, int w, int y1, int y2, long yoffs, boolean init) {
        int wc = w / 2;
        int h2 = (y2 - y1) / 2;
        int hc = y1 + h2;
        float yy = 0.0f;
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(str);
        g2.addRenderingHints(aaON);
        float[] xp = new float[4];
        float[] yp = new float[4];
        if (init) {
            this.thisSeed = new Random().nextLong();
            this.setup(this.thisSeed, -1);
        }
        int ng = this.mainParameter;
        double[] gx = this.Gx;
        double[] gy = this.Gy;
        double[] gd = this.Gd;
        double[][] dets = this.Dets;
        float[][] tshape = this.Tshape;
        float[][] torient = this.Torient;
        g.setColor(Color.black);
        g.fillRect(0, y1, w, y2 - y1);
        double xm1 = (double)wc * this.inc + this.marg;
        double xm0 = -xm1;
        double ym1 = (double)(yoffs + (long)h2) * this.inc + this.marg;
        double ym0 = (double)(yoffs - (long)h2) * this.inc - this.marg;
        double[] xm = new double[]{xm0, xm1};
        double[] ym = new double[]{ym0, ym1};
        double[] xep = new double[2];
        double[] yep = new double[2];
        for (int eD = 0; eD < ng; ++eD) {
            int k;
            float[] tse = tshape[eD];
            float[] toe = torient[eD];
            double xe = gx[eD];
            double ye = gy[eD];
            double de = gd[eD] + 0.5;
            int lc = Integer.MAX_VALUE;
            int uc = Integer.MIN_VALUE;
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 2; ++i) {
                    k = (int)Math.ceil(xe * xm[i] + ye * ym[j] + de);
                    if (k < lc) {
                        lc = k;
                    }
                    if (--k <= uc) continue;
                    uc = k;
                }
            }
            for (int eV = lc; eV <= uc; ++eV) {
                double y;
                double x;
                double ae = (double)eV - de;
                int nn = 0;
                for (int ii = 0; ii < 2 && nn < 2; ++ii) {
                    x = xm[ii];
                    y = (ae - gx[eD] * x) / gy[eD];
                    if (y >= ym0 && y <= ym1) {
                        xep[nn] = x;
                        yep[nn++] = y;
                        if (nn == 2) break;
                    }
                    if (!((x = (ae - gy[eD] * (y = ym[ii])) / gx[eD]) >= xm0) || !(x <= xm1)) continue;
                    xep[nn] = x;
                    yep[nn++] = y;
                }
                double xep0 = xep[0];
                double xep1 = xep[1];
                double yep0 = yep[0];
                double yep1 = yep[1];
                for (int fD = eD + 1; fD < ng; ++fD) {
                    float tsef = tse[fD];
                    float toef = toe[fD];
                    double xf = gx[fD];
                    double xfae = xf * ae;
                    double yf = gy[fD];
                    double yfae = yf * ae;
                    double df = gd[fD] + 0.5;
                    double dd = dets[eD][fD];
                    int lc0 = (int)Math.ceil(xf * xep0 + yf * yep0 + df);
                    int uc0 = (int)Math.floor(xf * xep1 + yf * yep1 + df);
                    if (uc0 < lc0) {
                        k = lc0;
                        lc0 = uc0 + 1;
                        uc0 = k - 1;
                    }
                    for (int fV = lc0; fV <= uc0; ++fV) {
                        int m;
                        double af = (double)fV - df;
                        x = (yfae - ye * af) / dd;
                        y = (xe * af - xfae) / dd;
                        double xs = 0.0;
                        double ys = 0.0;
                        for (m = 0; m < ng; ++m) {
                            if (m == eD || m == fD) continue;
                            double gxm = gx[m];
                            double gym = gy[m];
                            double gdm = gd[m];
                            double z = Math.floor(gxm * x + gym * y + gdm + 0.5) - gdm;
                            xs += z * gxm;
                            ys += z * gym;
                        }
                        for (m = 0; m < 4; ++m) {
                            double ee = ae + 0.5 - (double)(m / 2);
                            double ff = af + 0.5 - (double)((m + 1) % 4 / 2);
                            double xa = xs + ee * xe + ff * xf;
                            double ya = ys + ee * ye + ff * yf;
                            xp[m] = (float)((double)wc + xa / this.inc);
                            yp[m] = (float)((double)hc + ya / this.inc - (double)yoffs);
                            if (m != 0) continue;
                            yy = (float)ya;
                        }
                        float sfac1 = (float)(1.0 - Math.sin((double)yy / 171.0)) / 2.0f;
                        float bfac = this.bfac0 + (1.0f - this.bfac0) * sfac1;
                        Color col = new Color(Color.HSBtoRGB((this.cfac + tsef + yy / 111.0f) % 1.0f, 0.7f * sfac1 + 0.3f, bfac * toef + (1.0f - bfac)));
                        this.drawTile(g2, xp, yp, col, eD, fD, eV, fV);
                    }
                }
            }
        }
    }

    public void drawTile(Graphics2D g2, float[] xp, float[] yp, Color col, int eD, int fD, int eV, int fV) {
        this.rhomb.reset();
        for (int m = 0; m < 4; ++m) {
            if (m == 0) {
                this.rhomb.moveTo(xp[m], yp[m]);
                continue;
            }
            this.rhomb.lineTo(xp[m], yp[m]);
        }
        this.rhomb.closePath();
        g2.setPaint(col);
        g2.fill(this.rhomb);
        g2.setPaint(Color.black);
        g2.draw(this.rhomb);
    }
}

