/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.BSPobject;
import egan.geometry.PointManager;
import java.util.Vector;

public class BSP {
    public int dim;
    public double[] svec;
    public int ID;
    public double tolerance;
    public PointManager pm;
    public Vector<BSPobject> contents;
    public BSP[] npBSP;

    public BSP(int n, double[] dArray, int n2, double d, PointManager pointManager, Vector<BSPobject> vector) {
        this.dim = n;
        this.svec = dArray;
        this.ID = n2;
        this.tolerance = d;
        this.pm = pointManager;
        this.contents = vector;
        this.npBSP = new BSP[2];
    }

    public BSP(int n, double[] dArray, int n2, double d, PointManager pointManager, BSPobject bSPobject) {
        this(n, dArray, n2, d, pointManager, new Vector<BSPobject>(1));
        this.contents.addElement(bSPobject);
    }

    public void add(Vector<BSPobject> vector, double[] dArray, int n, boolean bl) {
        int n2 = vector.size();
        if (this.svec == null) {
            int n3;
            if (dArray != null) {
                this.svec = dArray;
                this.ID = n;
                n3 = this.contents.size();
                if (n3 != 0) {
                    int n4;
                    Vector<BSPobject> vector2 = new Vector<BSPobject>(n3);
                    Vector<BSPobject> vector3 = new Vector<BSPobject>(n3);
                    Vector<BSPobject> vector4 = new Vector<BSPobject>(n3);
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.contents.elementAt(n4).BSPsplit(dArray, n, bl ? vector : null, this.tolerance, this.pm, vector2, vector4, vector3);
                    }
                    this.contents = vector4;
                    for (n4 = 0; n4 < 2; ++n4) {
                        Vector<BSPobject> vector5;
                        Vector<BSPobject> vector6 = vector5 = n4 == 0 ? vector2 : vector3;
                        if (vector5.size() <= 0) continue;
                        this.npBSP[n4] = BSP.newBSP(this.dim, null, -1, this.tolerance, this.pm, vector5);
                    }
                }
            }
            this.contents.ensureCapacity(this.contents.size() + n2);
            for (n3 = 0; n3 < n2; ++n3) {
                this.contents.addElement(vector.elementAt(n3));
            }
        } else {
            int n5;
            Vector<BSPobject> vector7 = new Vector<BSPobject>(n2);
            Vector<BSPobject> vector8 = new Vector<BSPobject>(n2);
            for (n5 = 0; n5 < n2; ++n5) {
                vector.elementAt(n5).BSPsplit(this.svec, this.ID, bl ? this.contents : null, this.tolerance, this.pm, vector7, this.contents, vector8);
            }
            for (n5 = 0; n5 < 2; ++n5) {
                Vector<BSPobject> vector9 = n5 == 0 ? vector7 : vector8;
                int n6 = vector9.size();
                if (n6 <= 0) continue;
                if (this.npBSP[n5] == null) {
                    this.npBSP[n5] = new BSP(this.dim, dArray, n, this.tolerance, this.pm, vector9);
                    continue;
                }
                this.npBSP[n5].add(vector9, dArray, n, bl);
            }
        }
    }

    public void add(BSPobject bSPobject, double[] dArray, int n, boolean bl) {
        Vector<BSPobject> vector = new Vector<BSPobject>(1);
        vector.addElement(bSPobject);
        this.add(vector, dArray, n, bl);
    }

    public static BSP newBSP(int n, double[] dArray, int n2, double d, PointManager pointManager, Vector<BSPobject> vector) {
        return new BSP(n, dArray, n2, d, pointManager, vector);
    }

    public int count() {
        int n = 0;
        if (this.contents != null) {
            n += this.contents.size();
        }
        for (int i = 0; i < 2; ++i) {
            if (this.npBSP[i] == null) continue;
            n += this.npBSP[i].count();
        }
        return n;
    }

    public Vector<BSPobject> toVector() {
        Vector<BSPobject> vector = new Vector<BSPobject>(this.count());
        this.addToVector(vector);
        return vector;
    }

    private void addToVector(Vector<BSPobject> vector) {
        if (this.npBSP[0] != null) {
            this.npBSP[0].addToVector(vector);
        }
        if (this.contents != null) {
            int n = this.contents.size();
            for (int i = 0; i < n; ++i) {
                vector.addElement(this.contents.elementAt(i));
            }
        }
        if (this.npBSP[1] != null) {
            this.npBSP[1].addToVector(vector);
        }
    }
}

