/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.BSPobject;
import egan.geometry.GonND;
import egan.geometry.GraphEdge;
import egan.geometry.GraphNode;
import egan.geometry.PlanarGraph;
import java.util.Vector;

public class Gon2D
extends GonND {
    public boolean valid;
    public double[][] edges;
    public double minX;
    public double maxX;
    public double minY;
    public double maxY;
    public boolean clockwise;
    public long group;
    public boolean[][] parGons;
    public boolean[] inGons;
    public boolean[][][] edgeOwners;
    public int[] otherPiece;

    public Gon2D(double[][] dArray, int n) {
        super(2, dArray, n);
    }

    public Gon2D(double[][] dArray, int n, int n2) {
        super(2, dArray, n, n2);
    }

    public Gon2D(double[][] dArray, int n, boolean bl) {
        super(2, dArray, n, bl);
    }

    public Gon2D(double[][] dArray, int n, int n2, boolean bl) {
        super(2, dArray, n, n2, bl);
    }

    public Gon2D(int n) {
        super(2, null, n);
        this.vertices = new double[n][2];
        double d = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            double d2 = d * (double)i;
            double[] dArray = this.vertices[i];
            dArray[0] = Math.cos(d2);
            dArray[1] = Math.sin(d2);
        }
    }

    @Override
    public GonND newGon(double[][] dArray, int n, int n2) {
        return new Gon2D(dArray, n, n2);
    }

    public void validate() {
        if (this.valid) {
            return;
        }
        this.minY = Double.POSITIVE_INFINITY;
        this.minX = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.nvert; ++i) {
            double[] dArray = this.vertices[i];
            double d = dArray[0];
            double d2 = dArray[1];
            if (d < this.minX) {
                this.minX = d;
            }
            if (d > this.maxX) {
                this.maxX = d;
            }
            if (d2 < this.minY) {
                this.minY = d2;
            }
            if (!(d2 > this.maxY)) continue;
            this.maxY = d2;
        }
        this.edges = this.edgeVectors();
        if (this.area() < 0.0) {
            this.clockwise = !this.clockwise;
        }
        this.valid = true;
    }

    @Override
    public void translate(double[] dArray) {
        super.translate(dArray);
        if (this.valid) {
            this.minX += dArray[0];
            this.maxX += dArray[0];
            this.minY += dArray[1];
            this.maxY += dArray[1];
        }
    }

    @Override
    public void scale(double d) {
        super.scale(d);
        this.valid = false;
    }

    public double area() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i <= this.nvert; ++i) {
            double[] dArray = this.vertices[i % this.nvert];
            double d4 = dArray[0];
            double d5 = dArray[1];
            d += d2 * d5 - d3 * d4;
            d2 = d4;
            d3 = d5;
        }
        return (this.clockwise ? -0.5 : 0.5) * d;
    }

    public boolean contains(double[] dArray) {
        int n;
        boolean bl;
        this.validate();
        double d = dArray[0];
        double d2 = dArray[1];
        if (d < this.minX || d > this.maxX || d2 < this.minY || d2 > this.maxY) {
            return false;
        }
        if (this.convex()) {
            double d3 = this.clockwise ? -1.0 : 1.0;
            for (int i = 0; i < this.nvert; ++i) {
                double[] dArray2 = this.edges[i];
                double[] dArray3 = this.vertices[i];
                if (!(d3 * (dArray2[1] * (d - dArray3[0]) - dArray2[0] * (d2 - dArray3[1])) > 0.0)) continue;
                return false;
            }
            return true;
        }
        block1: do {
            double d4 = Math.random();
            double d5 = Math.random();
            n = 0;
            bl = true;
            for (int i = 0; i < this.nvert; ++i) {
                double d6;
                double[] dArray4 = this.vertices[i];
                double d7 = d - dArray4[0];
                double d8 = d2 - dArray4[1];
                double[] dArray5 = this.edges[i];
                double d9 = dArray5[1];
                double d10 = dArray5[0];
                double d11 = d9 * d4 - d10 * d5;
                if (Math.abs(d11) < 1.0E-8) {
                    bl = false;
                    continue block1;
                }
                double d12 = (d10 * d8 - d9 * d7) / d11;
                if (!(d12 > 0.0) || !((d6 = (d4 * d8 - d5 * d7) / d11) > 0.0) || !(d6 <= 1.0)) continue;
                if (d6 < 1.0E-8 || 1.0 - d6 < 1.0E-8) {
                    bl = false;
                    continue block1;
                }
                ++n;
            }
        } while (!bl);
        return n % 2 == 1;
    }

    public double[] interiorPoint() {
        if (this.convex()) {
            return this.com();
        }
        double[] dArray = this.vertices[0];
        double d = dArray[0];
        double d2 = dArray[1];
        double[] dArray2 = this.vertices[1];
        double d3 = dArray2[0];
        double d4 = dArray2[1];
        double d5 = (d + d3) / 2.0;
        double d6 = (d2 + d4) / 2.0;
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double d10 = -d8 / d9;
        double d11 = d7 / d9;
        double d12 = 0.0;
        for (int i = 2; i < this.nvert; ++i) {
            double[] dArray3 = this.vertices[i];
            double d13 = (dArray3[0] - d5) * d10 + (dArray3[1] - d6) * d11;
            d12 = Math.max(Math.abs(d13), d12);
        }
        double[] dArray4 = new double[2];
        for (int i = 0; i < 10; ++i) {
            d12 /= 2.0;
            for (int j = -1; j <= 1; j += 2) {
                dArray4[0] = d5 + (double)j * d12 * d10;
                dArray4[1] = d6 + (double)j * d12 * d11;
                if (!this.contains(dArray4)) continue;
                return dArray4;
            }
        }
        return this.vertices[0];
    }

    public static int disjoint(Gon2D[] gon2DArray, int n, Vector<BSPobject> vector, boolean bl, boolean bl2, double d) {
        Object object;
        Object object2;
        Object object3;
        int n2;
        Object object4;
        Object object5;
        int n3;
        Gon2D gon2D;
        int n4;
        GraphNode[][] graphNodeArrayArray;
        int n5 = n + 1;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            graphNodeArrayArray = gon2DArray[i];
            graphNodeArrayArray.validate();
            n6 += graphNodeArrayArray.nvert;
        }
        PlanarGraph planarGraph = new PlanarGraph(n6, n6, n6, n6, 2, d);
        graphNodeArrayArray = new GraphNode[n][];
        for (n4 = 0; n4 < n; ++n4) {
            gon2D = gon2DArray[n4];
            n3 = gon2D.nvert;
            object5 = gon2D.vertices;
            graphNodeArrayArray[n4] = new GraphNode[n3];
            object4 = graphNodeArrayArray[n4];
            for (n2 = 0; n2 < n3; ++n2) {
                object4[n2] = planarGraph.createNodeIfDistinct(object5[n2], null);
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            gon2D = gon2DArray[n4];
            n3 = gon2D.nvert;
            object5 = gon2D.vertices;
            object4 = graphNodeArrayArray[n4];
            n2 = gon2D.clockwise ? 1 : 0;
            for (int i = 0; i < n3; ++i) {
                GraphNode graphNode = object4[i];
                object3 = object4[(i + 1) % n3];
                object2 = graphNode.edgeTo((GraphNode)object3);
                if (object2 == null) {
                    object = new boolean[2][n5];
                    object[n2][n4] = true;
                    object2 = planarGraph.createEdge(graphNode, (GraphNode)object3, object);
                } else {
                    ((boolean[][])((GraphEdge)object2).extra)[((GraphEdge)object2).link1.node == graphNode ? n2 : 1 - n2][n4] = true;
                }
                ((GraphEdge)object2).group = gon2D.group;
            }
        }
        planarGraph.planarDecompose(n);
        n4 = planarGraph.GraphToGon2Ds(vector, n, bl2);
        if (bl) {
            for (int i = 0; i < n4; ++i) {
                Gon2D gon2D2 = (Gon2D)vector.elementAt(i);
                object5 = new boolean[n];
                object4 = gon2D2.parGons;
                GraphNode graphNode = object4[0];
                GraphNode graphNode2 = object4[1];
                System.arraycopy(graphNode, 0, object5, 0, n);
                for (int j = 0; j < n; ++j) {
                    if (graphNode2[j] != false || graphNode[j] != false) continue;
                    object3 = gon2D2.vertices;
                    object2 = object3[0];
                    object = object3[1];
                    double[] dArray = new double[]{(double)((object2[0] + object[0]) / 2.0), (double)((object2[1] + object[1]) / 2.0)};
                    object5[j] = (double[])gon2DArray[j].contains(dArray);
                }
                gon2D2.inGons = (boolean[])object5;
            }
        }
        planarGraph.destroy();
        return n4;
    }
}

