/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.BSPobject;
import egan.geometry.GonND;
import egan.geometry.PointManager;
import egan.util.Utils;
import java.util.Vector;

public class Gon3D
extends GonND {
    public Gon3D(double[][] dArray, int n) {
        super(3, dArray, n);
    }

    public Gon3D(double[][] dArray, int n, int n2) {
        super(3, dArray, n, n2);
    }

    public Gon3D(double[][] dArray, int n, boolean bl) {
        super(3, dArray, n, bl);
    }

    public Gon3D(double[][] dArray, int n, int n2, boolean bl) {
        super(3, dArray, n, n2, bl);
    }

    @Override
    public GonND newGon(double[][] dArray, int n, int n2) {
        return new Gon3D(dArray, n, n2);
    }

    public double[] plane() {
        int n;
        double[] dArray = new double[4];
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.nvert; ++n) {
            double[] dArray2 = this.vertices[n];
            double[] dArray3 = this.vertices[(n + 1) % this.nvert];
            double[] dArray4 = this.vertices[(n + 2) % this.nvert];
            d2 = 0.0;
            d = 0.0;
            for (int i = 0; i < 3; ++i) {
                double d3;
                int n2 = (i + 1) % 3;
                int n3 = (i + 2) % 3;
                dArray[i] = d3 = (dArray3[n2] - dArray2[n2]) * (dArray4[n3] - dArray3[n3]) - (dArray3[n3] - dArray2[n3]) * (dArray4[n2] - dArray3[n2]);
                d += d3 * d3;
                d2 += d3 * dArray2[i];
            }
            if (d > 1.0E-8) break;
        }
        d = Math.sqrt(d);
        n = 0;
        while (n < 3) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / d;
        }
        dArray[3] = d2 / d;
        return dArray;
    }

    @Override
    public void markEdges(double[] dArray, Vector<BSPobject> vector, int n, double d, PointManager pointManager) {
        int n2 = 0;
        if (vector == null || (n2 = vector.size()) == 0) {
            return;
        }
        double[] dArray2 = this.plane();
        double[] dArray3 = new double[2];
        int n3 = n | 0x4000000;
        for (int i = 0; i < n2; ++i) {
            BSPobject bSPobject = vector.elementAt(i);
            if (!(bSPobject instanceof Gon3D)) continue;
            Gon3D gon3D = (Gon3D)bSPobject;
            double[][][] dArray4 = gon3D.splitSegs(dArray2, d, pointManager, false, null);
            int n4 = dArray4.length;
            for (int j = 0; j < n4; ++j) {
                double[] dArray5 = dArray4[j][0];
                double[] dArray6 = dArray4[j][1];
                double[][] dArrayArray = new double[][]{dArray5, dArray6};
                double[] dArray7 = new double[3];
                for (int k = 0; k < 3; ++k) {
                    dArray7[k] = dArray6[k] - dArray5[k];
                }
                double d2 = Utils.normalise(dArray7);
                double d3 = Utils.dot(dArray7, dArray5);
                for (int k = 0; k < this.nvert; ++k) {
                    int n5;
                    if (this.edgeIDs[k] != n) continue;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    for (n5 = 0; n5 < 2; ++n5) {
                        double d4 = (Utils.dot(dArray7, this.vertices[(k + n5) % this.nvert]) - d3) / d2;
                        if (Math.abs(d4) < d) {
                            d4 = 0.0;
                            ++n7;
                        } else if (Math.abs(1.0 - d4) < d) {
                            d4 = 1.0;
                            ++n9;
                        } else if (d4 < 0.0) {
                            ++n6;
                        } else if (d4 > 1.0) {
                            ++n10;
                        } else {
                            ++n8;
                        }
                        dArray3[n5] = d4;
                    }
                    if (n6 + n10 == 0) {
                        this.edgeIDs[k] = n3;
                        continue;
                    }
                    if (n7 + n6 == 2 || n9 + n10 == 2) continue;
                    n5 = n6 + n10;
                    int[] nArray = new int[this.nvert + n5];
                    double[][] dArrayArray2 = new double[this.nvert + n5][];
                    int n11 = 0;
                    for (int i2 = 0; i2 < this.nvert; ++i2) {
                        dArrayArray2[n11] = this.vertices[i2];
                        nArray[n11++] = this.edgeIDs[i2];
                        if (i2 != k) continue;
                        int n12 = 0;
                        boolean bl = dArray3[0] >= 0.0 && dArray3[0] <= 1.0;
                        if (bl) {
                            nArray[n11 - 1] = n3;
                            ++n12;
                        }
                        for (int i3 = 0; i3 < n5; ++i3) {
                            bl = !bl;
                            dArrayArray2[n11] = dArrayArray[dArray3[1] > dArray3[0] ? n12 : 1 - n12];
                            ++n12;
                            nArray[n11++] = bl ? n3 : n;
                        }
                    }
                    k += n5;
                    this.nvert += n5;
                    this.edgeIDs = nArray;
                    this.vertices = dArrayArray2;
                }
            }
        }
    }
}

