/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.BSPobject;
import egan.geometry.PointManager;
import egan.util.Utils;
import java.util.Vector;

public class GonND
implements BSPobject {
    public int dim;
    public int nvert;
    public double[][] vertices;
    private int convexity;
    public int surfaceID;
    public int flags;
    public int[] edgeIDs;
    public static final int EDGE_ORIGINAL = 0x40000000;
    public static final int EDGE_INTERNAL = 0x20000000;
    public static final int EDGE_POSITIVE = 0x10000000;
    public static final int EDGE_NEGATIVE = 0x8000000;
    public static final int EDGE_FROM_SPLIT = 0x18000000;
    public static final int EDGE_IN_CONTENT = 0x4000000;
    public static final int EDGE_CUT_AT_START = 0x2000000;
    public static final int EDGE_CUT_AT_END = 0x1000000;
    public static final int EDGE_CUT = 0x3000000;
    public static final int EDGE_ID = 65535;

    public GonND(int n, double[][] dArray, int n2) {
        this.dim = n;
        this.vertices = dArray;
        this.nvert = n2;
        this.convexity = n2 <= 3 ? 1 : -1;
    }

    public GonND(int n, double[][] dArray, int n2, int n3) {
        this.dim = n;
        this.vertices = new double[n3][];
        for (int i = 0; i < n3; ++i) {
            this.vertices[i] = dArray[n2 + i];
        }
        this.nvert = n3;
        this.convexity = n3 <= 3 ? 1 : -1;
    }

    public GonND(int n, double[][] dArray, int n2, boolean bl) {
        this(n, dArray, n2);
        this.convexity = bl ? 1 : 0;
    }

    public GonND(int n, double[][] dArray, int n2, int n3, boolean bl) {
        this(n, dArray, n2, n3);
        this.convexity = bl ? 1 : 0;
    }

    public GonND newGon(double[][] dArray, int n, int n2) {
        return new GonND(this.dim, dArray, n, n2);
    }

    public void translate(double[] dArray) {
        for (int i = 0; i < this.nvert; ++i) {
            double[] dArray2 = this.vertices[i];
            for (int j = 0; j < this.dim; ++j) {
                int n = j;
                dArray2[n] = dArray2[n] + dArray[j];
            }
        }
    }

    public double[] com() {
        double[] dArray = new double[this.dim];
        for (int i = 0; i < this.nvert; ++i) {
            double[] dArray2 = this.vertices[i];
            for (int j = 0; j < this.dim; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j] / (double)this.nvert;
            }
        }
        return dArray;
    }

    public void scale(double d) {
        double[] dArray = this.com();
        for (int i = 0; i < this.nvert; ++i) {
            double[] dArray2 = this.vertices[i];
            for (int j = 0; j < this.dim; ++j) {
                dArray2[j] = dArray[j] + d * (dArray2[j] - dArray[j]);
            }
        }
    }

    public boolean convex() {
        if (this.convexity < 0) {
            boolean bl = true;
            if (this.nvert > 3) {
                double[][] dArray = this.edgeVectors();
                for (int i = 0; i < this.nvert; ++i) {
                    double[] dArray2 = dArray[i];
                    double[] dArray3 = dArray[(i + 1) % this.nvert];
                    double[] dArray4 = dArray[(i + 2) % this.nvert];
                    double d = 0.0;
                    for (int j = 0; j < this.dim; ++j) {
                        for (int k = j + 1; k < this.dim; ++k) {
                            d += (dArray2[j] * dArray3[k] - dArray2[k] * dArray3[j]) * (dArray3[j] * dArray4[k] - dArray3[k] * dArray4[j]);
                        }
                    }
                    if (!(d < 0.0)) continue;
                    bl = false;
                    break;
                }
            }
            this.convexity = bl ? 1 : 0;
        }
        return this.convexity == 1;
    }

    public double[][] edgeVectors() {
        double[][] dArray = new double[this.nvert][this.dim];
        for (int i = 0; i < this.nvert; ++i) {
            double[] dArray2 = this.vertices[i];
            double[] dArray3 = this.vertices[(i + 1) % this.nvert];
            double[] dArray4 = dArray[i];
            for (int j = 0; j < this.dim; ++j) {
                dArray4[j] = dArray3[j] - dArray2[j];
            }
        }
        return dArray;
    }

    public void setEdgeIDs() {
        this.edgeIDs = new int[this.nvert];
        for (int i = 0; i < this.nvert; ++i) {
            this.edgeIDs[i] = 0x40000000 | i;
        }
    }

    public int splitLinks(double[] dArray, double d, PointManager pointManager, int[] nArray, int[] nArray2, int[] nArray3, double[][] dArray2) {
        int n;
        int n2;
        int n3;
        double d2 = -dArray[this.dim];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double[] dArray3 = new double[this.nvert];
        for (n3 = 0; n3 < this.nvert; ++n3) {
            double d3 = d2;
            double[] dArray4 = this.vertices[n3];
            for (int i = 0; i < this.dim; ++i) {
                d3 += dArray[i] * dArray4[i];
            }
            dArray3[n3] = d3;
            if (Math.abs(d3) <= d) {
                nArray[n3] = 0;
                ++n6;
                continue;
            }
            if (d3 < 0.0) {
                nArray[n3] = -1;
                ++n5;
                continue;
            }
            nArray[n3] = 1;
            ++n4;
        }
        if (this.nvert > 3 && n6 != 0 && n6 != this.nvert) {
            for (n3 = 0; n3 < this.nvert; ++n3) {
                int n7;
                int n8 = (n3 + 1) % this.nvert;
                n2 = (n3 + 2) % this.nvert;
                if (nArray[n8] != 0 || (n7 = nArray[n3]) != nArray[n2]) continue;
                nArray[n8] = n7;
                --n6;
                if (n7 == 1) {
                    ++n4;
                    continue;
                }
                ++n5;
            }
        }
        if (n6 == this.nvert) {
            return 0;
        }
        if (n5 + n6 == this.nvert) {
            return -1;
        }
        if (n4 + n6 == this.nvert) {
            return 1;
        }
        if (nArray2 == null) {
            return 2;
        }
        double[][] dArrayArray = new double[2 * this.nvert][];
        int[] nArray4 = new int[2 * this.nvert];
        n2 = 0;
        for (int i = 0; i < this.nvert; ++i) {
            double d4 = nArray[i];
            if (d4 == 0.0) {
                dArrayArray[n2] = this.vertices[i];
                nArray4[n2++] = -1 - i;
                continue;
            }
            int n9 = (i + 1) % this.nvert;
            if (d4 * (double)nArray[n9] != -1.0) continue;
            double d5 = dArray3[i];
            double d6 = d5 / (d5 - dArray3[n9]);
            double d7 = 1.0 - d6;
            double[] dArray5 = new double[this.dim];
            double[] dArray6 = this.vertices[i];
            double[] dArray7 = this.vertices[n9];
            for (int j = 0; j < this.dim; ++j) {
                dArray5[j] = d6 * dArray7[j] + d7 * dArray6[j];
            }
            dArray2[i] = pointManager == null ? dArray5 : pointManager.findOrAdd((double[])dArray5, (int)0).pt;
            dArrayArray[n2] = dArray2[i];
            nArray4[n2++] = 1 + i;
        }
        if (n2 < 2) {
            return n4 > 0 ? 1 : -1;
        }
        double[] dArray8 = new double[n2];
        double[] dArray9 = dArrayArray[0];
        double[] dArray10 = dArrayArray[1];
        double[] dArray11 = new double[this.dim];
        for (n = 0; n < this.dim; ++n) {
            dArray11[n] = dArray10[n] - dArray9[n];
        }
        for (n = 0; n < n2; ++n) {
            dArray8[n] = Utils.dot(dArray11, dArrayArray[n]);
        }
        GonND.boundarySort(dArray8, nArray4, n2);
        n = -1;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            int n10;
            int n11;
            int n12 = nArray4[i];
            if (!bl && i + 1 < n2 && n12 < 0 && nArray4[i + 1] < 0 && ((n11 = -1 - n12) == ((n10 = -1 - nArray4[i + 1]) + 1) % this.nvert || n10 == (n11 + 1) % this.nvert)) continue;
            boolean bl2 = bl = !bl;
            if (bl) {
                n = n12;
                continue;
            }
            if (n < 0) {
                nArray3[-1 - n] = n12;
            } else {
                nArray2[n - 1] = n12;
            }
            if (n12 < 0) {
                nArray3[-1 - n12] = n;
                continue;
            }
            nArray2[n12 - 1] = n;
        }
        return 2;
    }

    public double[][][] splitSegs(double[] dArray, double d, PointManager pointManager, boolean bl, boolean[][] blArray) {
        int n;
        int n2;
        int[] nArray = new int[this.nvert];
        int[] nArray2 = new int[this.nvert];
        int[] nArray3 = new int[this.nvert];
        double[][] dArrayArray = new double[this.nvert][];
        this.splitLinks(dArray, d, pointManager, nArray, nArray2, nArray3, dArrayArray);
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.nvert; ++i) {
            if (nArray2[i] != 0 || nArray3[i] != 0) {
                ++n3;
            }
            if (!bl || nArray[i] != 0 || nArray[(i + 1) % this.nvert] != 0) continue;
            ++n4;
        }
        double[][][] dArray2 = new double[n4 += n3 / 2][2][];
        if (bl && blArray != null) {
            blArray[0] = new boolean[n4];
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.nvert; ++n2) {
            n = nArray3[n2];
            if (n == 0) continue;
            dArray2[n5][0] = this.vertices[n2];
            nArray3[n2] = 0;
            if (n < 0) {
                dArray2[n5][1] = this.vertices[-1 - n];
                nArray3[-1 - n] = 0;
            } else {
                dArray2[n5][1] = dArrayArray[n - 1];
                nArray2[n - 1] = 0;
            }
            ++n5;
        }
        for (n2 = 0; n2 < this.nvert; ++n2) {
            n = nArray2[n2];
            if (n == 0) continue;
            dArray2[n5][0] = dArrayArray[n2];
            nArray2[n2] = 0;
            if (n < 0) {
                dArray2[n5][1] = this.vertices[-1 - n];
                nArray3[-1 - n] = 0;
            } else {
                dArray2[n5][1] = dArrayArray[n - 1];
                nArray2[n - 1] = 0;
            }
            ++n5;
        }
        if (bl) {
            for (n2 = 0; n2 < this.nvert; ++n2) {
                if (nArray[n2] != 0 || nArray[(n2 + 1) % this.nvert] != 0) continue;
                dArray2[n5][0] = this.vertices[n2];
                dArray2[n5][1] = this.vertices[(n2 + 1) % this.nvert];
                if (blArray != null) {
                    blArray[0][n5] = true;
                }
                ++n5;
            }
        }
        return dArray2;
    }

    @Override
    public int BSPsplit(double[] dArray, int n, Vector<BSPobject> vector, double d, PointManager pointManager, Vector<BSPobject> vector2, Vector<BSPobject> vector3, Vector<BSPobject> vector4) {
        int[] nArray = new int[this.nvert];
        int[] nArray2 = new int[this.nvert];
        int[] nArray3 = new int[this.nvert];
        double[][] dArrayArray = new double[this.nvert][];
        int n2 = this.splitLinks(dArray, d, pointManager, nArray, nArray2, nArray3, dArrayArray);
        if (n2 != 2) {
            if (n2 == 0) {
                if (vector3 != null) {
                    vector3.addElement(this);
                }
            } else if (n2 == -1) {
                if (vector2 != null) {
                    vector2.addElement(this);
                }
            } else if (n2 == 1 && vector4 != null) {
                vector4.addElement(this);
            }
            return n2;
        }
        if (vector4 == null || vector2 == null) {
            return 2;
        }
        double[][] dArrayArray2 = new double[2 * this.nvert][];
        boolean bl = this.edgeIDs != null;
        int[] nArray4 = bl ? new int[2 * this.nvert] : null;
        int n3 = 0;
        boolean[] blArray = new boolean[this.nvert];
        while (true) {
            int n4;
            for (n4 = 0; n4 < this.nvert && ((n3 = nArray[n4]) == 0 || blArray[n4]); ++n4) {
            }
            if (n4 == this.nvert) break;
            int n5 = 0;
            int n6 = n4;
            int n7 = n | (n3 < 0 ? 0x8000000 : 0x10000000);
            do {
                int n8 = 0;
                dArrayArray2[n5] = this.vertices[n6];
                if (bl) {
                    nArray4[n5] = this.edgeIDs[n6];
                }
                ++n5;
                blArray[n6] = true;
                double[] dArray2 = dArrayArray[n6];
                if (dArray2 != null) {
                    dArrayArray2[n5] = dArray2;
                    if (bl) {
                        int n9 = n5 - 1;
                        nArray4[n9] = nArray4[n9] | 0x1000000;
                        nArray4[n5] = n7;
                    }
                    ++n5;
                    n8 = nArray2[n6];
                } else if (nArray[n6 = (n6 + 1) % this.nvert] == 0 && nArray3[n6] != 0) {
                    dArrayArray2[n5] = this.vertices[n6];
                    if (bl) {
                        nArray4[n5] = n7;
                    }
                    ++n5;
                    n8 = nArray3[n6];
                }
                if (n8 == 0) continue;
                if (n8 < 0) {
                    n6 = -1 - n8;
                    continue;
                }
                n6 = n8 - 1;
                dArrayArray2[n5] = dArrayArray[n6];
                if (bl) {
                    nArray4[n5] = this.edgeIDs[n6] | 0x2000000;
                }
                ++n5;
                n6 = (n6 + 1) % this.nvert;
            } while (n6 != n4);
            GonND gonND = this.newGon(dArrayArray2, 0, n5);
            gonND.surfaceID = this.surfaceID;
            gonND.flags = this.flags;
            if (bl) {
                gonND.edgeIDs = new int[n5];
                System.arraycopy(nArray4, 0, gonND.edgeIDs, 0, n5);
                if (vector != null) {
                    gonND.markEdges(dArray, vector, n7, d, pointManager);
                }
            }
            (n3 < 0 ? vector2 : vector4).addElement(gonND);
        }
        return 2;
    }

    static void boundarySort(double[] dArray, int[] nArray, int n) {
        for (int i = 0; i < n - 1; ++i) {
            int n2;
            double d = Double.POSITIVE_INFINITY;
            int n3 = -1;
            for (n2 = i; n2 < n; ++n2) {
                if (!(dArray[n2] < d)) continue;
                d = dArray[n2];
                n3 = n2;
            }
            if (n3 == i) continue;
            dArray[n3] = dArray[i];
            dArray[i] = d;
            n2 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray[i] = n2;
        }
    }

    public void markEdges(double[] dArray, Vector<BSPobject> vector, int n, double d, PointManager pointManager) {
    }
}

