/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.GraphEdge;
import egan.geometry.GraphNode;
import egan.geometry.PointManager;

public class Graph {
    public int nNodes;
    public int nEdges;
    public GraphNode[] nodes;
    public GraphEdge[] edges;
    int nodeCap;
    int edgeCap;
    int nodeInc;
    int edgeInc;
    int dim;
    double tol;
    PointManager pm;
    boolean planar;

    public Graph(int n, int n2, int n3, int n4, int n5, double d) {
        this.nodeCap = n;
        this.edgeCap = n3;
        this.nodeInc = n2;
        this.edgeInc = n4;
        this.nodes = new GraphNode[n];
        this.edges = new GraphEdge[n3];
        this.dim = n5;
        this.tol = d;
        if (n5 > 0) {
            this.pm = new PointManager(n5, d);
        }
    }

    private void nodeRoom() {
        if (this.nNodes == this.nodeCap) {
            GraphNode[] graphNodeArray = this.nodes;
            this.nodes = new GraphNode[this.nodeCap += this.nodeInc];
            System.arraycopy(graphNodeArray, 0, this.nodes, 0, this.nNodes);
        }
    }

    private void edgeRoom() {
        if (this.nEdges == this.edgeCap) {
            GraphEdge[] graphEdgeArray = this.edges;
            this.edges = new GraphEdge[this.edgeCap += this.edgeInc];
            System.arraycopy(graphEdgeArray, 0, this.edges, 0, this.nEdges);
        }
    }

    public GraphNode createNode(double[] dArray, Object object) {
        return this.createNode(dArray, object, 0);
    }

    public GraphNode createNode(double[] dArray, Object object, int n) {
        this.nodeRoom();
        if (this.pm != null) {
            this.pm.add(dArray, this.nNodes);
        }
        GraphNode graphNode = new GraphNode(dArray, object, this.planar, n);
        graphNode.ID = this.nNodes;
        this.nodes[this.nNodes++] = graphNode;
        return graphNode;
    }

    public GraphNode createNodeIfDistinct(double[] dArray, Object object) {
        int n = this.pm.findOrAdd((double[])dArray, (int)this.nNodes).ptI;
        if (n == this.nNodes) {
            this.nodeRoom();
            GraphNode graphNode = new GraphNode(dArray, object, this.planar);
            graphNode.ID = this.nNodes;
            this.nodes[this.nNodes++] = graphNode;
            return graphNode;
        }
        return this.nodes[n];
    }

    public GraphEdge createEdge(GraphNode graphNode, GraphNode graphNode2, Object object) {
        this.edgeRoom();
        GraphEdge graphEdge = new GraphEdge(graphNode, graphNode2, object);
        graphEdge.ID = this.nEdges;
        this.edges[this.nEdges++] = graphEdge;
        return graphEdge;
    }

    public GraphEdge createEdge(GraphNode graphNode, int n, GraphNode graphNode2, int n2, Object object) {
        this.edgeRoom();
        GraphEdge graphEdge = new GraphEdge(graphNode, n, graphNode2, n2, object);
        graphEdge.ID = this.nEdges;
        this.edges[this.nEdges++] = graphEdge;
        return graphEdge;
    }

    public GraphEdge splitEdge(GraphEdge graphEdge, GraphNode graphNode, Object object) {
        this.edgeRoom();
        GraphEdge graphEdge2 = new GraphEdge(graphEdge, graphNode, object);
        graphEdge2.ID = this.nEdges;
        this.edges[this.nEdges++] = graphEdge2;
        return graphEdge2;
    }

    public void destroy() {
        for (int i = 0; i < this.nEdges; ++i) {
            if (this.edges[i] == null) continue;
            this.edges[i].destroy();
        }
    }
}

