/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.GraphNode;
import egan.geometry.GraphNodeLink;

public class GraphEdge {
    public GraphNodeLink link1;
    public GraphNodeLink link2;
    public double[] vector;
    public Object extra;
    public int ID;
    public long group;
    public int piece1;
    public int piece2;
    public int eNum1;
    public int eNum2;

    public GraphEdge(GraphNode graphNode, GraphNode graphNode2, Object object) {
        this.extra = object;
        this.link1 = new GraphNodeLink(graphNode);
        this.link2 = new GraphNodeLink(graphNode2);
        this.setVector();
        this.link1.connectToEdge(this, true);
        this.link2.connectToEdge(this, false);
    }

    public GraphEdge(GraphNode graphNode, int n, GraphNode graphNode2, int n2, Object object) {
        this.extra = object;
        this.link1 = graphNode.link(n);
        this.link2 = graphNode2.link(n2);
        this.setVector();
        this.link1.connectToEdge(this, true);
        this.link2.connectToEdge(this, false);
    }

    public GraphEdge(GraphEdge graphEdge, GraphNode graphNode, Object object) {
        this.extra = object;
        this.link1 = new GraphNodeLink(graphNode);
        this.link2 = graphEdge.link2;
        this.link2.edge = this;
        this.setVector();
        this.link1.connectToEdge(this, true);
        graphEdge.link2 = new GraphNodeLink(graphNode);
        graphEdge.setVector();
        graphEdge.link2.connectToEdge(graphEdge, false);
    }

    public void destroy() {
        if (this.link1 != null) {
            this.link1.destroy();
        }
        if (this.link2 != null) {
            this.link2.destroy();
        }
        this.link1 = null;
        this.link2 = null;
        this.extra = null;
    }

    public void setVector() {
        double[] dArray = this.link1.node.coords;
        double[] dArray2 = this.link2.node.coords;
        if (dArray == null || dArray2 == null) {
            this.vector = null;
        } else {
            int n = Math.min(dArray.length, dArray2.length);
            this.vector = new double[n];
            for (int i = 0; i < n; ++i) {
                this.vector[i] = dArray2[i] - dArray[i];
            }
        }
    }
}

