/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.GraphEdge;
import egan.geometry.GraphNodeLink;

public class GraphNode {
    public int valence;
    public GraphNodeLink firstLink;
    public double[] coords;
    public Object extra;
    public boolean planar;
    public int ID;

    public GraphNode(double[] dArray, Object object, boolean bl) {
        this.coords = dArray;
        this.extra = object;
        this.planar = bl;
    }

    public GraphNode(double[] dArray, Object object, boolean bl, int n) {
        this(dArray, object, bl);
        for (int i = 0; i < n; ++i) {
            new GraphNodeLink(this);
        }
    }

    public GraphEdge edgeTo(GraphNode graphNode) {
        GraphNodeLink graphNodeLink = this.firstLink;
        for (int i = 0; i < this.valence; ++i) {
            GraphNodeLink graphNodeLink2 = graphNodeLink.edgeLink;
            if (graphNodeLink2 != null && graphNodeLink2.node == graphNode) {
                return graphNodeLink.edge;
            }
            graphNodeLink = graphNodeLink.next;
        }
        return null;
    }

    public GraphNodeLink link(int n) {
        if (n < 0 || n >= this.valence) {
            throw new IllegalArgumentException("GraphNodeLink position " + n + " out of bounds for valence " + this.valence);
        }
        GraphNodeLink graphNodeLink = this.firstLink;
        for (int i = 0; i < n; ++i) {
            graphNodeLink = graphNodeLink.next;
        }
        return graphNodeLink;
    }

    public void numberRing() {
        GraphNodeLink graphNodeLink = this.firstLink;
        int n = 0;
        while (n < this.valence) {
            graphNodeLink.ringNumber = n++;
            graphNodeLink = graphNodeLink.next;
        }
    }

    public void destroyLinksWith(GraphNode graphNode) {
        int n;
        GraphNodeLink graphNodeLink = this.firstLink;
        GraphEdge[] graphEdgeArray = new GraphEdge[this.valence];
        int n2 = 0;
        for (n = 0; n < this.valence; ++n) {
            GraphNodeLink graphNodeLink2 = graphNodeLink.edgeLink;
            if (graphNodeLink2 != null && graphNodeLink2.node == graphNode) {
                graphEdgeArray[n2++] = graphNodeLink.edge;
            }
            graphNodeLink = graphNodeLink.next;
        }
        for (n = 0; n < n2; ++n) {
            graphEdgeArray[n].destroy();
        }
    }

    public void mergeWith(GraphNode graphNode, boolean bl) {
        this.destroyLinksWith(graphNode);
        int n = graphNode.valence;
        if (n > 0) {
            GraphNodeLink graphNodeLink = graphNode.firstLink;
            for (int i = 0; i < n; ++i) {
                graphNodeLink.node = this;
                GraphEdge graphEdge = graphNodeLink.edge;
                if (graphEdge != null) {
                    graphEdge.setVector();
                }
                graphNodeLink = graphNodeLink.next;
            }
            GraphNodeLink graphNodeLink2 = graphNode.firstLink;
            if (this.firstLink == null) {
                this.firstLink = graphNodeLink2;
            } else {
                GraphNodeLink graphNodeLink3 = this.firstLink.prev;
                GraphNodeLink graphNodeLink4 = graphNodeLink2.prev;
                graphNodeLink4.next = this.firstLink;
                this.firstLink.prev = graphNodeLink4;
                graphNodeLink3.next = graphNodeLink2;
                graphNodeLink2.prev = graphNodeLink3;
                if (bl) {
                    this.firstLink = graphNodeLink2;
                }
            }
            this.valence += n;
            graphNode.valence = 0;
            graphNode.firstLink = null;
        }
    }
}

