/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.GraphEdge;
import egan.geometry.GraphNode;

public class GraphNodeLink {
    public GraphNode node;
    public GraphNodeLink next;
    public GraphNodeLink prev;
    public GraphNodeLink edgeLink;
    public int ringNumber;
    public GraphEdge edge;
    public int startEdge;
    public double ex;
    public double ey;

    public GraphNodeLink(GraphNode graphNode) {
        this.node = graphNode;
        ++this.node.valence;
        GraphNodeLink graphNodeLink = this.node.firstLink;
        if (graphNodeLink == null) {
            this.next = this;
            this.prev = this;
            this.node.firstLink = this;
        } else {
            this.next = graphNodeLink;
            this.prev = graphNodeLink.prev;
            this.next.prev = this;
            this.prev.next = this;
        }
    }

    public void connectToEdge(GraphEdge graphEdge, boolean bl) {
        this.edge = graphEdge;
        if (bl) {
            this.startEdge = 1;
            this.edgeLink = graphEdge.link2;
        } else {
            this.startEdge = -1;
            this.edgeLink = graphEdge.link1;
        }
        this.edgeLink.edgeLink = this;
        if (this.node.planar) {
            double d = graphEdge.vector[0];
            double d2 = graphEdge.vector[1];
            double d3 = (double)this.startEdge * Math.sqrt(d * d + d2 * d2);
            this.ex = d / d3;
            this.ey = d2 / d3;
            int n = this.node.valence;
            if (n > 1) {
                int n2;
                GraphNodeLink graphNodeLink = this.next;
                GraphNodeLink graphNodeLink2 = this.prev;
                double d4 = graphNodeLink.ex;
                double d5 = graphNodeLink.ey;
                double d6 = this.ex * d5 - this.ey * d4;
                for (n2 = 0; n2 < n - 1; ++n2) {
                    double d7 = graphNodeLink2.ex;
                    double d8 = graphNodeLink2.ey;
                    double d9 = d7 * this.ey - d8 * this.ex;
                    double d10 = d7 * d5 - d8 * d4;
                    if (n2 == n - 2 || d10 > 0.0 && d9 >= 0.0 && d6 > 0.0 || d10 < 0.0 && (d9 >= 0.0 || d6 > 0.0) || d10 == 0.0 && d7 * d4 + d8 * d5 < 0.0 && d9 >= 0.0) {
                        if (Math.abs(d9) < 1.0E-10) {
                            if (d7 * this.ex + d8 * this.ey < 0.0) {
                                this.ex = -d7;
                                this.ey = -d8;
                                break;
                            }
                            this.ex = d7;
                            this.ey = d8;
                            break;
                        }
                        if (!(Math.abs(d6) < 1.0E-10)) break;
                        if (d4 * this.ex + d5 * this.ey < 0.0) {
                            this.ex = -d4;
                            this.ey = -d5;
                            break;
                        }
                        this.ex = d4;
                        this.ey = d5;
                        break;
                    }
                    graphNodeLink = graphNodeLink2;
                    graphNodeLink2 = graphNodeLink.prev;
                    d4 = d7;
                    d5 = d8;
                    d6 = -d9;
                }
                if (n2 != 0) {
                    this.prev.next = this.next;
                    this.next.prev = this.prev;
                    graphNodeLink.prev = this;
                    this.next = graphNodeLink;
                    graphNodeLink2.next = this;
                    this.prev = graphNodeLink2;
                }
            }
        }
    }

    public void destroy() {
        --this.node.valence;
        if (this.node.firstLink == this) {
            this.node.firstLink = this.next == this ? null : this.next;
        }
        if (this.next != this) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
        }
        this.node = null;
        this.next = null;
        this.prev = null;
        this.edgeLink = null;
        this.edge = null;
    }
}

