/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.BSPobject;
import egan.geometry.Gon2D;
import egan.geometry.Graph;
import egan.geometry.GraphEdge;
import egan.geometry.GraphNode;
import egan.geometry.GraphNodeLink;
import java.util.Vector;

public class PlanarGraph
extends Graph {
    public PlanarGraph(int n, int n2, int n3, int n4, int n5, double d) {
        super(n, n2, n3, n4, n5, d);
        this.planar = true;
    }

    public void edgeIntersections(int[] nArray, int[][] nArray2, double[][] dArray) {
        this.edgeIntersections(nArray, nArray2, dArray, null);
    }

    private void edgeIntersections(int[] nArray, int[][] nArray2, double[][] dArray, GraphNode[][] graphNodeArray) {
        double d = -this.tol;
        double d2 = 1.0 + this.tol;
        double d3 = 2.0 * this.tol;
        boolean bl = graphNodeArray != null;
        for (int i = 0; i < this.nEdges - 1; ++i) {
            double d4;
            double d5;
            double d6;
            double d7;
            GraphEdge graphEdge = this.edges[i];
            GraphNode graphNode = graphEdge.link1.node;
            GraphNode graphNode2 = graphEdge.link2.node;
            double[] dArray2 = graphNode.coords;
            double[] dArray3 = graphNode2.coords;
            double d8 = dArray2[0];
            double d9 = dArray2[1];
            double d10 = dArray3[0];
            double d11 = dArray3[1];
            if (d8 < d10) {
                d7 = d8;
                d6 = d10;
            } else {
                d7 = d10;
                d6 = d8;
            }
            if (d9 < d11) {
                d5 = d9;
                d4 = d11;
            } else {
                d5 = d11;
                d4 = d9;
            }
            double[] dArray4 = graphEdge.vector;
            double d12 = dArray4[0];
            double d13 = dArray4[1];
            double d14 = d12 * d12 + d13 * d13;
            double d15 = d12 / d14;
            double d16 = d13 / d14;
            double[] dArray5 = dArray[i];
            GraphNode[] graphNodeArray2 = bl ? graphNodeArray[i] : null;
            long l = graphEdge.group;
            for (int j = i + 1; j < this.nEdges; ++j) {
                double d17;
                double d18;
                double d19;
                double d20;
                double d21;
                double d22;
                GraphEdge graphEdge2 = this.edges[j];
                if ((l & graphEdge2.group) != 0L) continue;
                GraphNode graphNode3 = graphEdge2.link1.node;
                GraphNode graphNode4 = graphEdge2.link2.node;
                double[] dArray6 = graphNode3.coords;
                double[] dArray7 = graphNode4.coords;
                double d23 = dArray6[0];
                double d24 = dArray6[1];
                double d25 = dArray7[0];
                double d26 = dArray7[1];
                if (d23 < d25) {
                    d22 = d23;
                    d21 = d25;
                } else {
                    d22 = d25;
                    d21 = d23;
                }
                if (d24 < d26) {
                    d20 = d24;
                    d19 = d26;
                } else {
                    d20 = d26;
                    d19 = d24;
                }
                if (d22 > d6 + d3 || d7 > d21 + d3 || d20 > d4 + d3 || d5 > d19 + d3) continue;
                double d27 = d23 - d8;
                double d28 = d25 - d8;
                double d29 = d24 - d9;
                double d30 = d26 - d9;
                double d31 = d15 * d27 + d16 * d29;
                double d32 = d15 * d28 + d16 * d30;
                double d33 = d15 * d29 - d16 * d27;
                double d34 = d15 * d30 - d16 * d28;
                double[] dArray8 = dArray[j];
                GraphNode[] graphNodeArray3 = bl ? graphNodeArray[j] : null;
                int n = -1;
                int n2 = -1;
                if (Math.abs(d33) <= this.tol && Math.abs(d34) <= this.tol) {
                    if (d31 > 0.0 && d31 < 1.0) {
                        int n3 = i;
                        int n4 = nArray[n3];
                        nArray[n3] = n4 + 1;
                        n = n4;
                        dArray5[n] = d31;
                        if (bl) {
                            graphNodeArray2[n] = graphNode3;
                        }
                    }
                    if (d32 > 0.0 && d32 < 1.0) {
                        int n5 = i;
                        int n6 = nArray[n5];
                        nArray[n5] = n6 + 1;
                        n = n6;
                        dArray5[n] = d32;
                        if (bl) {
                            graphNodeArray2[n] = graphNode4;
                        }
                    }
                    d18 = d31 / (d31 - d32);
                    d17 = (1.0 - d31) / (d32 - d31);
                    if (d18 > 0.0 && d18 < 1.0) {
                        int n7 = j;
                        int n8 = nArray[n7];
                        nArray[n7] = n8 + 1;
                        n2 = n8;
                        dArray8[n2] = d18;
                        if (bl) {
                            graphNodeArray3[n2] = graphNode;
                        }
                    }
                    if (d17 > 0.0 && d17 < 1.0) {
                        int n9 = j;
                        int n10 = nArray[n9];
                        nArray[n9] = n10 + 1;
                        n2 = n10;
                        dArray8[n2] = d17;
                        if (bl) {
                            graphNodeArray3[n2] = graphNode2;
                        }
                    }
                } else if (graphNode != graphNode3 && graphNode != graphNode4 && graphNode2 != graphNode3 && graphNode2 != graphNode4 && (d18 = d33 / (d33 - d34)) >= d && d18 <= d2 && (d17 = d31 + d18 * (d32 - d31)) >= d && d17 <= d2) {
                    int n11 = i;
                    int n12 = nArray[n11];
                    nArray[n11] = n12 + 1;
                    n = n12;
                    int n13 = j;
                    int n14 = nArray[n13];
                    nArray[n13] = n14 + 1;
                    n2 = n14;
                    dArray5[n] = d17;
                    dArray8[n2] = d18;
                    if (bl) {
                        double[] dArray9 = new double[]{d8 + d17 * d12, d9 + d17 * d13};
                        graphNodeArray3[n2] = graphNodeArray2[n] = this.createNodeIfDistinct(dArray9, null);
                    }
                }
                if (n >= 0) {
                    nArray2[i][n] = j;
                }
                if (n2 < 0) continue;
                nArray2[j][n2] = i;
            }
        }
    }

    public void planarDecompose(int n) {
        int n2;
        int n3;
        Object object;
        Object object2;
        int n4;
        int n5 = n + 1;
        GraphNode[][] graphNodeArray = new GraphNode[this.nEdges][this.nEdges];
        double[][] dArray = new double[this.nEdges][this.nEdges];
        int[] nArray = new int[this.nEdges];
        int[][] nArray2 = new int[this.nEdges][this.nEdges];
        this.edgeIntersections(nArray, nArray2, dArray, graphNodeArray);
        int n6 = this.nEdges;
        for (n4 = 0; n4 < n6; ++n4) {
            int n7 = nArray[n4];
            if (n7 <= 0) continue;
            GraphEdge graphEdge = this.edges[n4];
            object2 = dArray[n4];
            object = graphNodeArray[n4];
            for (int i = 0; i < n7; ++i) {
                Object object3 = -1.0;
                int n8 = -1;
                for (int j = 0; j < n7; ++j) {
                    if (!(object2[j] > object3)) continue;
                    object3 = object2[j];
                    n8 = j;
                }
                object2[n8] = -1.0;
                GraphNode graphNode = object[n8];
                if (graphNode == graphEdge.link1.node || graphNode == graphEdge.link2.node) continue;
                boolean[][] blArray = (boolean[][])graphEdge.extra;
                boolean[][] blArray2 = new boolean[2][n5];
                for (n3 = 0; n3 < 2; ++n3) {
                    System.arraycopy(blArray[n3], 0, blArray2[n3], 0, n5);
                }
                this.splitEdge(graphEdge, graphNode, blArray2);
            }
        }
        n4 = 0;
        for (n2 = 0; n2 < this.nEdges; ++n2) {
            object2 = this.edges[n2];
            if (((GraphEdge)object2).link1 == null) continue;
            object = ((GraphEdge)object2).link1;
            GraphNodeLink graphNodeLink = object.next;
            GraphNode graphNode = object.node;
            GraphNode graphNode2 = ((GraphEdge)object2).link2.node;
            boolean[][] blArray = (boolean[][])((GraphEdge)object2).extra;
            int n9 = graphNode.valence;
            for (int i = 1; i < n9; ++i) {
                object = graphNodeLink;
                graphNodeLink = object.next;
                if (object.edgeLink.node != graphNode2) continue;
                int n10 = 0;
                n3 = 0;
                if (object.startEdge == 1) {
                    n3 = 1;
                } else {
                    n10 = 1;
                    n3 = -1;
                }
                GraphEdge graphEdge = object.edge;
                boolean[][] blArray3 = (boolean[][])graphEdge.extra;
                for (int j = 0; j < 2; ++j) {
                    int n11 = n10 + n3 * j;
                    for (int k = 0; k < n5; ++k) {
                        boolean[] blArray4 = blArray[j];
                        int n12 = k;
                        blArray4[n12] = blArray4[n12] | blArray3[n11][k];
                    }
                }
                graphEdge.destroy();
                ++n4;
            }
        }
        if (n4 > 0) {
            n2 = 0;
            for (int i = 0; i < this.nEdges; ++i) {
                object = this.edges[i];
                if (object.link1 == null) continue;
                object.ID = n2;
                this.edges[n2++] = object;
            }
            this.nEdges = n2;
        }
    }

    public int GraphToGon2Ds(Vector<BSPobject> vector, int n, boolean bl) {
        int n2;
        int n3;
        int n4 = 0;
        double[][] dArrayArray = new double[this.nNodes][];
        GraphEdge[] graphEdgeArray = null;
        byte[] byArray = null;
        if (bl) {
            graphEdgeArray = new GraphEdge[this.nNodes];
            byArray = new byte[this.nNodes];
            for (n3 = 0; n3 < this.nEdges; ++n3) {
                GraphEdge graphEdge = this.edges[n3];
                if (graphEdge == null) continue;
                graphEdge.piece2 = -1;
                graphEdge.piece1 = -1;
            }
        }
        n3 = 0;
        while (true) {
            int n5;
            Object object;
            Object object2;
            Object object3;
            GraphEdge graphEdge;
            int n6 = 0;
            block2: for (n2 = n3; n2 < this.nEdges; ++n2) {
                graphEdge = this.edges[n2];
                if (graphEdge == null) continue;
                object3 = (boolean[][])graphEdge.extra;
                for (n6 = 0; n6 < 2; ++n6) {
                    if (!object3[n6][n]) break block2;
                }
            }
            if (n2 == this.nEdges) break;
            graphEdge = this.edges[n2];
            object3 = n6 == 0 ? graphEdge.link1 : graphEdge.link2;
            if (n6 == 1) {
                n3 = n2 + 1;
            }
            int n7 = 0;
            boolean[][] blArray = new boolean[2][n];
            double[] dArray = null;
            while (true) {
                object2 = object3.node.coords;
                if (n7 == 0) {
                    dArray = object2;
                } else if (object2 == dArray) break;
                if (bl) {
                    graphEdgeArray[n7] = graphEdge;
                    byArray[n7] = (byte)n6;
                }
                dArrayArray[n7++] = object2;
                object = (boolean[][])graphEdge.extra;
                object[n6][n] = true;
                for (n5 = 0; n5 < n; ++n5) {
                    for (int i = 0; i < 2; ++i) {
                        boolean[] blArray2 = blArray[i];
                        int n8 = n5;
                        blArray2[n8] = blArray2[n8] | object[n6 == 0 ? i : 1 - i][n5];
                    }
                }
                object3 = object3.edgeLink.prev;
                n6 = (1 - object3.startEdge) / 2;
                graphEdge = object3.edge;
            }
            object2 = new double[n7][];
            System.arraycopy(dArrayArray, 0, object2, 0, n7);
            object = new Gon2D((double[][])object2, n7);
            if (((Gon2D)object).area() < 0.0) continue;
            ((Gon2D)object).parGons = blArray;
            if (bl) {
                ((Gon2D)object).edgeOwners = new boolean[n7][][];
                ((Gon2D)object).otherPiece = new int[n7];
                for (n5 = 0; n5 < n7; ++n5) {
                    GraphEdge graphEdge2 = graphEdgeArray[n5];
                    ((Gon2D)object).edgeOwners[n5] = (boolean[][])graphEdge2.extra;
                    ((Gon2D)object).otherPiece[n5] = -1;
                    if (byArray[n5] == 0) {
                        graphEdge2.piece1 = n4;
                        graphEdge2.eNum1 = n5;
                        continue;
                    }
                    graphEdge2.piece2 = n4;
                    graphEdge2.eNum2 = n5;
                }
            }
            vector.addElement((BSPobject)object);
            ++n4;
        }
        if (bl) {
            for (n2 = 0; n2 < this.nEdges; ++n2) {
                GraphEdge graphEdge = this.edges[n2];
                if (graphEdge == null) continue;
                if (graphEdge.piece1 >= 0) {
                    ((Gon2D)vector.elementAt((int)graphEdge.piece1)).otherPiece[graphEdge.eNum1] = graphEdge.piece2;
                }
                if (graphEdge.piece2 < 0) continue;
                ((Gon2D)vector.elementAt((int)graphEdge.piece2)).otherPiece[graphEdge.eNum2] = graphEdge.piece1;
            }
        }
        return n4;
    }
}

