/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.util.Utils;

public class PointManager {
    public double[] pt;
    public int ptI;
    int dim;
    double tol;
    double tolSq;
    double[] pVec;
    double pC;
    PointManager neg;
    PointManager pos;

    public PointManager(int n, double d) {
        this.dim = n;
        this.tol = d;
        this.tolSq = d * d;
    }

    public PointManager(int n, double d, double[] dArray, int n2) {
        this(n, d);
        this.pt = dArray;
        this.ptI = n2;
    }

    private PointManager branch(double[] dArray) {
        double d = this.pC;
        for (int i = 0; i < this.dim; ++i) {
            d += this.pVec[i] * dArray[i];
        }
        return d < 0.0 ? this.neg : this.pos;
    }

    public PointManager add(double[] dArray, int n) {
        if (this.pVec != null) {
            return this.branch(dArray).add(dArray, n);
        }
        if (this.pt != null) {
            this.neg = new PointManager(this.dim, this.tol, this.pt, this.ptI);
            this.pos = new PointManager(this.dim, this.tol, dArray, n);
            this.pVec = new double[this.dim];
            double d = 0.0;
            for (int i = 0; i < this.dim; ++i) {
                double d2;
                this.pVec[i] = d2 = dArray[i] - this.pt[i];
                d += d2 * (dArray[i] + 1.027 * this.pt[i]);
            }
            this.pt = null;
            this.pC = -d / 2.027;
            return this.pos;
        }
        this.pt = dArray;
        this.ptI = n;
        return this;
    }

    public PointManager find(double[] dArray) {
        return this.findOrAdd(dArray, -1);
    }

    public PointManager findOrAdd(double[] dArray, int n) {
        if (this.pVec != null) {
            return this.branch(dArray).findOrAdd(dArray, n);
        }
        if (this.pt == null) {
            if (n >= 0) {
                this.pt = dArray;
                this.ptI = n;
                return this;
            }
            return null;
        }
        double d = this.tolSq;
        for (int i = 0; i < this.dim; ++i) {
            double d2;
            double d3 = this.pt[i] - dArray[i];
            this.tolSq -= d3 * d3;
            if (!(d2 < 0.0)) continue;
            if (n >= 0) {
                return this.add(dArray, n);
            }
            return null;
        }
        return this;
    }

    public void transform(double[][] dArray) {
        if (this.pt != null) {
            Utils.transform(dArray, this.pt);
        }
        if (this.pVec != null) {
            this.neg.transform(dArray);
            this.pos.transform(dArray);
        }
    }
}

