/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.geometry.BSPobject;
import egan.geometry.Gon3D;
import egan.geometry.GonND;
import egan.geometry.SphericalTriangle;
import egan.util.Utils;
import java.util.Vector;

public class Polyhedron {
    public int NF;
    public int NE;
    public int NV;
    public double[][] vertices;
    public double[][] faces;
    public int[][] face_vertices;
    public int[][] face_edges;
    public boolean[][] face_edge_rev;
    public int[][] edge_vertices;
    public int[][] edge_faces;
    public int[][] vertex_vertices;
    public int[][] vertex_edges;
    public int[][] vertex_faces;
    public double[][][] isometries;
    public boolean[] even_isometry;
    public int[][] vertex_permutations;
    public int[][] face_permutations;
    static final int[][][] regularWythoff = new int[][][]{new int[][]{{1, 3}, {1, 2}, {1, 3}, {1, 24}}, new int[][]{{1, 3}, {1, 2}, {1, 4}, {1, 48}}, new int[][]{{1, 4}, {1, 2}, {1, 3}, {1, 48}}, new int[][]{{1, 3}, {1, 2}, {1, 5}, {1, 120}}, new int[][]{{1, 5}, {1, 2}, {1, 3}, {1, 120}}};
    public static final int POLYHEDRON_0 = 1;
    public static final int POLYHEDRON_1 = 2;
    public static final int ALL_POLYHEDRA = 3;
    public static final int INTERIOR_PIECE = 4;
    public static final int EXTERIOR_PIECE = 8;
    public static final int ALL_PIECES = 12;
    public static final int FRONT_FACE = 16;
    public static final int BACK_FACE = 32;
    public static final int ALL_FACES = 48;

    public Polyhedron(double[][] dArray, int n, int[][] nArray) {
        int n2;
        int n3;
        int n4;
        int[] nArray2;
        int n5;
        this.vertices = dArray;
        this.NV = n;
        this.vertex_vertices = nArray;
        this.vertex_edges = new int[n][];
        this.vertex_faces = new int[n][];
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            int n7 = nArray[i].length;
            this.vertex_edges[i] = new int[n7];
            this.vertex_faces[i] = new int[n7];
            n6 += n7;
        }
        this.NE = n6 /= 2;
        this.edge_vertices = new int[n6][2];
        this.edge_faces = new int[n6][2];
        int[][] nArray3 = new int[n][n];
        int[][] nArray4 = new int[n][n];
        int n8 = 0;
        for (n5 = 0; n5 < n; ++n5) {
            nArray2 = nArray[n5];
            n4 = nArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                int n9 = nArray2[n3];
                nArray4[n5][n9] = n3;
                if (n9 <= n5) continue;
                this.edge_vertices[n8][0] = n5;
                this.edge_vertices[n8][1] = n9;
                int n10 = n8++;
                nArray3[n9][n5] = n10;
                nArray3[n5][n9] = n10;
            }
        }
        for (n5 = 0; n5 < n; ++n5) {
            nArray2 = nArray[n5];
            n4 = nArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                this.vertex_edges[n5][n3] = nArray3[n5][nArray2[n3]];
            }
        }
        n5 = n6;
        this.face_vertices = new int[n5][];
        this.face_edges = new int[n5][];
        this.face_edge_rev = new boolean[n5][];
        this.faces = new double[n5][4];
        for (n2 = 0; n2 < n; ++n2) {
            n4 = this.vertex_faces[n2].length;
            for (n3 = 0; n3 < n4; ++n3) {
                this.vertex_faces[n2][n3] = -1;
            }
        }
        n2 = 0;
        int[] nArray5 = new int[n];
        int[] nArray6 = new int[n];
        boolean[] blArray = new boolean[n];
        while (true) {
            int n11;
            int n12;
            int n13 = 0;
            int n14 = 0;
            block8: for (n13 = 0; n13 < n; ++n13) {
                n12 = this.vertex_faces[n13].length;
                for (n14 = 0; n14 < n12; ++n14) {
                    if (this.vertex_faces[n13][n14] < 0) break block8;
                }
            }
            if (n13 == n) break;
            n12 = 0;
            do {
                int n15;
                nArray5[n12] = n13;
                this.vertex_faces[n13][n14] = n2;
                n11 = nArray[n13][n14];
                nArray6[n12] = n15 = nArray3[n13][n11];
                blArray[n12] = n13 != this.edge_vertices[n15][0];
                this.edge_faces[n15][blArray[n12] ? 1 : 0] = n2;
                ++n12;
                int n16 = nArray[n11].length;
                n14 = (nArray4[n11][n13] + n16 - 1) % n16;
                n13 = n11;
            } while (n11 != nArray5[0]);
            double[] dArray2 = this.faces[n2];
            double[] dArray3 = dArray[nArray5[0]];
            double[] dArray4 = dArray[nArray5[1]];
            double[] dArray5 = dArray[nArray5[2]];
            for (int i = 0; i < 3; ++i) {
                int n17 = (i + 1) % 3;
                int n18 = (i + 2) % 3;
                dArray2[i] = (dArray4[n17] - dArray3[n17]) * (dArray5[n18] - dArray4[n18]) - (dArray4[n18] - dArray3[n18]) * (dArray5[n17] - dArray4[n17]);
            }
            Utils.normalise(dArray2, 3);
            dArray2[3] = Utils.dot(dArray2, dArray3, 3);
            this.face_vertices[n2] = new int[n12];
            int[] nArray7 = this.face_vertices[n2];
            this.face_edges[n2] = new int[n12];
            int[] nArray8 = this.face_edges[n2];
            this.face_edge_rev[n2] = new boolean[n12];
            boolean[] blArray2 = this.face_edge_rev[n2];
            for (int i = 0; i < n12; ++i) {
                nArray7[i] = nArray5[i];
                nArray8[i] = nArray6[i];
                blArray2[i] = blArray[i];
            }
            ++n2;
        }
        this.NF = n5 = n2;
    }

    public Polyhedron(double[][] object, int n, double d, boolean bl, boolean bl2) {
        int n2;
        Object[] objectArray;
        this.faces = object;
        this.NF = n;
        this.face_vertices = new int[n][];
        this.face_edges = new int[n][];
        this.face_edge_rev = new boolean[n][];
        int n3 = 0;
        boolean[] blArray = new boolean[n];
        int n4 = 0;
        boolean[] blArray2 = new boolean[n];
        double[][] dArray = new double[n][n];
        double[][][] dArray2 = new double[n][n][2];
        for (int i = 0; i < n; ++i) {
            objectArray = object[i];
            for (int j = 0; j <= i; ++j) {
                double d2;
                double d3 = d2 = Utils.dot(objectArray, object[j], 3);
                dArray2[j][i][0] = d3;
                dArray2[i][j][0] = d3;
                dArray[j][i] = d3;
                dArray[i][j] = d3;
                dArray2[i][j][1] = j;
                dArray2[j][i][1] = i;
                if (blArray[j] || j == i || !(d2 > 1.0 - d)) continue;
                blArray[j] = true;
                ++n3;
            }
        }
        int[][][] nArray = new int[n][n][];
        objectArray = new int[n];
        boolean[][] blArray3 = new boolean[n][n];
        int[][][][] nArray2 = new int[n][n][][];
        int[] nArray3 = new int[n];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Vector<double[]> vector = new Vector<double[]>(30, 30);
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        int[] nArray6 = new int[n];
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        int n10 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            nArray3[n2] = n2;
        }
        block3: for (n2 = 0; n2 < n; ++n2) {
            int n11;
            int n12 = nArray3[n2];
            if (objectArray[n12] == false && n2 < n - 1) {
                for (int i = n2 + 1; i < n; ++i) {
                    n11 = nArray3[i];
                    if (objectArray[n11] <= 0) continue;
                    nArray3[i] = n12;
                    n12 = n11;
                    break;
                }
            }
            if (blArray[n12]) continue;
            double[] dArray6 = object[n12];
            if (objectArray[n12] == false) {
                if (n4 > 0) {
                    blArray[n12] = true;
                    ++n3;
                    for (n11 = n2 + 1; n11 < n; ++n11) {
                        int n13 = nArray3[n11];
                        if (blArray[n13]) continue;
                        blArray[n13] = true;
                        ++n3;
                    }
                    break;
                }
                Utils.qs(0, dArray2[n12], 0, n - 1);
                n10 = 0;
                for (n11 = n - 2; n11 >= 0; --n11) {
                    nArray8[n10++] = (int)dArray2[n12][n11][1];
                }
            } else {
                n10 = 1;
                nArray8[0] = (int)(objectArray[n12] - true);
            }
            n11 = 0;
            n7 = -1;
            block7: while (true) {
                Object[] objectArray2;
                double d4 = 0.0;
                double d5 = 0.0;
                int n14 = 0;
                int n15 = 0;
                block8: for (n15 = 0; n15 < n10 && nArray[n12][n14 = nArray8[n15]] == null; ++n15) {
                    int n16;
                    int n17;
                    int n18;
                    boolean bl3;
                    int n19;
                    int n20;
                    if (blArray[n14] || blArray3[n12][n14]) continue;
                    d4 = dArray[n12][n14];
                    d5 = 1.0 - d4 * d4;
                    if (d5 < d) {
                        blArray3[n14][n12] = true;
                        blArray3[n12][n14] = true;
                        continue;
                    }
                    objectArray2 = object[n14];
                    Utils.cross(dArray6, objectArray2, dArray3);
                    double d6 = Double.NEGATIVE_INFINITY;
                    double d7 = Double.POSITIVE_INFINITY;
                    int n21 = 0;
                    int n22 = 0;
                    n8 = -1;
                    boolean[] blArray4 = new boolean[n];
                    int[][] nArray9 = nArray2[n12][n14];
                    int n23 = 1;
                    if (nArray9 != null) {
                        if (Utils.dot(dArray3, object[nArray9[0][1]], 3) > 0.0) {
                            n23 = -1;
                        }
                        for (n20 = 0; n20 < 2; ++n20) {
                            int[] nArray10 = nArray9[n20];
                            if (nArray10 == null) continue;
                            int n24 = nArray10.length;
                            if (n20 == 0 && n23 == 1 || n20 == 1 && n23 == -1) {
                                if (n7 > 0 && n7 != nArray10[0]) continue block8;
                                n7 = nArray10[0];
                                for (n19 = 1; n19 < n24; ++n19) {
                                    int n25 = n21++;
                                    int n26 = nArray10[n19];
                                    nArray6[n25] = n26;
                                    blArray4[n26] = true;
                                }
                                continue;
                            }
                            n8 = nArray10[0];
                            for (n19 = 1; n19 < n24; ++n19) {
                                int n27 = n22++;
                                int n28 = nArray10[n19];
                                nArray7[n27] = n28;
                                blArray4[n28] = true;
                            }
                        }
                        if (n8 == n7) continue;
                    }
                    n20 = n7 < 0 ? 1 : 0;
                    boolean bl4 = bl3 = n8 < 0;
                    if (n20 != 0 || bl3) {
                        int n29;
                        if (n20 != 0) {
                            double d8 = dArray6[3];
                            int n30 = objectArray2[3];
                            double d9 = (d8 - d4 * n30) / d5;
                            int n31 = (n30 - d4 * d8) / d5;
                            for (n18 = 0; n18 < 3; ++n18) {
                                dArray4[n18] = d9 * dArray6[n18] + n31 * objectArray2[n18];
                            }
                            dArray5 = dArray4;
                        } else {
                            dArray5 = (double[])vector.elementAt(n7);
                            d6 = 0.0;
                        }
                        int[] nArray11 = new int[n];
                        n19 = 0;
                        for (n29 = 0; n29 < n; ++n29) {
                            if (!blArray4[n29]) continue;
                            nArray11[n19++] = n29;
                        }
                        for (n29 = 0; n29 < n; ++n29) {
                            if (blArray4[n29] || blArray[n29] || n29 == n12 || n29 == n14 || blArray2[n29]) continue;
                            nArray11[n19++] = n29;
                        }
                        for (n29 = 0; n29 < n19; ++n29) {
                            n17 = nArray11[n29];
                            double[] dArray7 = object[n17];
                            double d10 = Utils.dot(dArray7, dArray5, 3);
                            double d11 = Utils.dot(dArray7, dArray3, 3);
                            if (Math.abs(d11) < d) {
                                if (d10 <= dArray7[3] + d) continue;
                                blArray3[n14][n12] = true;
                                blArray3[n12][n14] = true;
                                continue block8;
                            }
                            double d12 = (dArray7[3] - d10) / d11;
                            if (d11 > 0.0) {
                                if (d12 < d7 - d) {
                                    d7 = d12;
                                    if (bl3) {
                                        nArray7[0] = n17;
                                        n22 = 1;
                                    }
                                } else if (d12 < d7 + d && bl3) {
                                    nArray7[n22++] = n17;
                                }
                            } else if (d12 > d6 + d) {
                                d6 = d12;
                                if (n20 != 0) {
                                    nArray6[0] = n17;
                                    n21 = 1;
                                }
                            } else if (d12 > d6 - d && n20 != 0) {
                                nArray6[n21++] = n17;
                            }
                            if (!(d7 < d6 + d)) continue;
                            blArray3[n14][n12] = true;
                            blArray3[n12][n14] = true;
                            continue block8;
                        }
                    }
                    if (n21 == 0 || n22 == 0) {
                        this.NF = 0;
                        return;
                    }
                    int[] nArray12 = new int[4];
                    nArray[n12][n14] = nArray12;
                    int[] nArray13 = nArray12;
                    int[] nArray14 = new int[4];
                    nArray[n14][n12] = nArray14;
                    int[] nArray15 = nArray14;
                    nArray15[2] = n5++;
                    nArray13[2] = nArray15[2];
                    if (n20 != 0) {
                        double[] dArray8 = new double[3];
                        for (n17 = 0; n17 < 3; ++n17) {
                            dArray8[n17] = dArray5[n17] + d6 * dArray3[n17];
                        }
                        n7 = n6++;
                        vector.addElement(dArray8);
                        nArray6[n21++] = n12;
                        nArray6[n21++] = n14;
                        for (n17 = 0; n17 < n21 - 1; ++n17) {
                            for (int i = n17 + 1; i < n21; ++i) {
                                int[] nArray16 = new int[n21 - 1];
                                nArray16[0] = n7;
                                int n32 = nArray6[n17];
                                int n33 = nArray6[i];
                                n18 = 0;
                                if (nArray2[n32][n33] == null) {
                                    int[][] nArrayArray = new int[2][];
                                    nArray2[n33][n32] = nArrayArray;
                                    nArray2[n32][n33] = nArrayArray;
                                } else {
                                    n18 = 1;
                                }
                                nArray2[n32][n33][n18] = nArray16;
                                int n34 = 1;
                                for (n16 = 0; n16 < n21; ++n16) {
                                    if (n16 == n17 || n16 == i) continue;
                                    nArray16[n34++] = nArray6[n16];
                                }
                            }
                        }
                    }
                    nArray13[0] = nArray15[1] = n7;
                    if (bl3) {
                        double[] dArray9 = new double[3];
                        for (n17 = 0; n17 < 3; ++n17) {
                            dArray9[n17] = dArray5[n17] + d7 * dArray3[n17];
                        }
                        n8 = n6++;
                        vector.addElement(dArray9);
                        nArray7[n22++] = n12;
                        nArray7[n22++] = n14;
                        for (n17 = 0; n17 < n22 - 1; ++n17) {
                            for (int i = n17 + 1; i < n22; ++i) {
                                int[] nArray17 = new int[n22 - 1];
                                nArray17[0] = n8;
                                int n35 = nArray7[n17];
                                int n36 = nArray7[i];
                                n18 = 0;
                                if (nArray2[n35][n36] == null) {
                                    int[][] nArrayArray = new int[2][];
                                    nArray2[n36][n35] = nArrayArray;
                                    nArray2[n35][n36] = nArrayArray;
                                } else {
                                    n18 = 1;
                                }
                                nArray2[n35][n36][n18] = nArray17;
                                int n37 = 1;
                                for (n16 = 0; n16 < n22; ++n16) {
                                    if (n16 == n17 || n16 == i) continue;
                                    nArray17[n37++] = nArray7[n16];
                                }
                            }
                        }
                    }
                    nArray13[1] = nArray15[0] = n8;
                    nArray13[3] = nArray2[n12][n14][0][0] == n7 ? 0 : 1;
                    nArray15[3] = 1 - nArray13[3];
                    break;
                }
                if (n15 == n10 || n11 == n) {
                    if (blArray[n12]) continue block3;
                    blArray[n12] = true;
                    ++n3;
                    continue block3;
                }
                objectArray2 = nArray[n12][n14];
                if (n11 == 0) {
                    n9 = objectArray2[0];
                }
                objectArray[n14] = 1 + n12;
                nArray4[n11] = objectArray2[0];
                nArray5[n11] = objectArray2[2];
                ++n11;
                n7 = objectArray2[1];
                if (n7 == n9) break;
                int[] nArray18 = nArray2[n12][n14][1 - objectArray2[3]];
                n10 = nArray18.length - 1;
                int n38 = 0;
                while (true) {
                    if (n38 >= n10) continue block7;
                    nArray8[n38] = nArray18[n38 + 1];
                    ++n38;
                }
                break;
            }
            ++n4;
            blArray2[n12] = true;
            this.face_vertices[n12] = new int[n11];
            int[] nArray19 = this.face_vertices[n12];
            this.face_edges[n12] = new int[n11];
            int[] nArray20 = this.face_edges[n12];
            for (int i = 0; i < n11; ++i) {
                nArray19[i] = nArray4[i];
                nArray20[i] = nArray5[i];
            }
        }
        if (n3 > 0) {
            n2 = n - n3;
            double[][] dArrayArray = new double[n2][];
            int[][] nArrayArray = new int[n2][];
            int[][] nArrayArray2 = new int[n2][];
            int n39 = 0;
            for (int i = 0; i < n; ++i) {
                if (blArray[i]) continue;
                dArrayArray[n39] = object[i];
                nArrayArray[n39] = this.face_vertices[i];
                nArrayArray2[n39] = this.face_edges[i];
                ++n39;
            }
            object = dArrayArray;
            this.faces = dArrayArray;
            this.NF = n = n39;
            this.face_vertices = nArrayArray;
            this.face_edges = nArrayArray2;
        }
        this.NE = n5;
        if (bl) {
            this.edge_vertices = new int[n5][];
            this.edge_faces = new int[n5][2];
            for (n2 = 0; n2 < n; ++n2) {
                int n40 = this.face_edges[n2].length;
                this.face_edge_rev[n2] = new boolean[n40];
                for (int i = 0; i < n40; ++i) {
                    int n41 = this.face_edges[n2][i];
                    int n42 = this.face_vertices[n2][i];
                    int n43 = this.face_vertices[n2][(i + 1) % n40];
                    if (this.edge_vertices[n41] == null) {
                        this.edge_vertices[n41] = new int[2];
                        int[] nArray21 = this.edge_vertices[n41];
                        nArray21[0] = n42;
                        nArray21[1] = n43;
                        this.edge_faces[n41][0] = n2;
                        continue;
                    }
                    this.face_edge_rev[n2][i] = true;
                    this.edge_faces[n41][1] = n2;
                }
            }
        }
        this.NV = n6;
        this.vertices = new double[n6][3];
        for (n2 = 0; n2 < n6; ++n2) {
            this.vertices[n2] = (double[])vector.elementAt(n2);
        }
        if (bl2) {
            this.vertex_vertices = new int[n6][];
            this.vertex_edges = new int[n6][];
            this.vertex_faces = new int[n6][];
        }
    }

    public static Polyhedron regularPolyhedron(int n) {
        return Polyhedron.wythoffPolyhedron(regularWythoff[n], false, false, false);
    }

    public static Polyhedron wythoffPolyhedron(int[][] nArray, boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        int n4;
        int[][] nArray2 = nArray;
        int n5 = nArray[3][1];
        int n6 = nArray[3][0];
        int n7 = nArray2[0][1];
        int n8 = nArray2[0][0];
        SphericalTriangle sphericalTriangle = new SphericalTriangle(nArray2);
        SphericalTriangle[] sphericalTriangleArray = sphericalTriangle.tiling(n5);
        Object object = null;
        int[][] nArray3 = null;
        int n9 = 0;
        if (n6 == 0) {
            SphericalTriangle sphericalTriangle2;
            n4 = 3;
            boolean[] blArray = new boolean[3];
            for (int i = 0; i < 3; ++i) {
                blArray[i] = nArray2[i][1] == 2;
                if (blArray[i]) continue;
                ++n4;
            }
            double[] dArray = new double[n4];
            int n10 = 0;
            for (int i = 0; i < 3; ++i) {
                dArray[n10++] = 3.0;
                if (blArray[i]) continue;
                dArray[n10++] = (double)nArray2[i][1] / (double)nArray2[i][0];
            }
            double d = Polyhedron.computeGeometry(dArray, 1, null, null);
            double d2 = Math.cos(2.0 * d);
            objectArray = new double[3];
            for (int i = 0; i < 3; ++i) {
                double d3 = Math.cos(Math.PI * 2 * (double)nArray2[i][0] / (double)nArray2[i][1]);
                objectArray[i] = Math.sqrt((d2 - d3) / (1.0 - d3));
            }
            double[] dArray2 = sphericalTriangle.pointFromAngles((double[])objectArray);
            n9 = n5 / 2;
            object = new double[n9][3];
            SphericalTriangle[] sphericalTriangleArray2 = new SphericalTriangle[n9];
            int n11 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                sphericalTriangle2 = sphericalTriangleArray[n3];
                if (sphericalTriangle2.id != 0 || sphericalTriangle2.parity != 1) continue;
                sphericalTriangleArray2[n11] = sphericalTriangle2;
                for (n2 = 0; n2 < 3; ++n2) {
                    double d4 = 0.0;
                    for (int i = 0; i < 3; ++i) {
                        d4 += sphericalTriangle2.isometry[i][n2] * dArray2[i];
                    }
                    object[n11][n2] = d4;
                }
                sphericalTriangle2.id = 1 + n11;
                ++n11;
            }
            nArray3 = new int[n9][n4];
            for (n3 = 0; n3 < n9; ++n3) {
                sphericalTriangle2 = sphericalTriangleArray2[n3];
                n2 = 0;
                for (int i = 0; i < 3; ++i) {
                    SphericalTriangle sphericalTriangle3 = sphericalTriangle2.links[i];
                    nArray3[n3][n2++] = sphericalTriangle3.links[(2 - i + 1) % 3].id - 1;
                    if (blArray[(i + 2) % 3]) continue;
                    nArray3[n3][n2++] = sphericalTriangle3.links[(2 - i + 2) % 3].id - 1;
                }
            }
        } else if (n6 == 1) {
            SphericalTriangle sphericalTriangle4;
            int n12;
            n9 = n5 / (2 * n7);
            object = new double[n9][];
            SphericalTriangle[] sphericalTriangleArray3 = new SphericalTriangle[n9];
            int n13 = 0;
            for (n12 = 0; n12 < n5; ++n12) {
                SphericalTriangle sphericalTriangle5 = sphericalTriangleArray[n12];
                if (sphericalTriangle5.id != 0) continue;
                sphericalTriangleArray3[n13] = sphericalTriangle5;
                object[n13] = sphericalTriangle5.vertices[sphericalTriangle5.parity == 1 ? 0 : 2];
                sphericalTriangle4 = sphericalTriangle5;
                do {
                    sphericalTriangle4.id = 1 + n13;
                } while ((sphericalTriangle4 = sphericalTriangle4.links[sphericalTriangle4.parity == 1 ? 1 : 0]) != sphericalTriangle5);
                ++n13;
            }
            n12 = nArray2[1][1] == 2 ? 1 : 0;
            n4 = n12 != 0 ? n7 : 2 * n7;
            nArray3 = new int[n9][n4];
            for (int i = 0; i < n9; ++i) {
                sphericalTriangle4 = sphericalTriangleArray3[i];
                for (int j = 0; j < n4; ++j) {
                    int n14;
                    int n15;
                    int n16;
                    if (sphericalTriangle4.parity == 1) {
                        n16 = 0;
                        n15 = 1;
                        n14 = 0;
                    } else {
                        n16 = 2;
                        n15 = 0;
                        n14 = 1;
                    }
                    nArray3[i][j] = sphericalTriangle4.links[n16].id - 1;
                    sphericalTriangle4 = sphericalTriangle4.links[n15];
                    if (n12 == 0) continue;
                    sphericalTriangle4 = sphericalTriangle4.links[n14];
                }
            }
        } else if (n6 == 2) {
            int n17;
            double d = Math.PI * (double)nArray2[0][0] / (double)nArray2[0][1];
            double d5 = Math.PI * (double)nArray2[2][0] / (double)nArray2[2][1] / 2.0;
            double d6 = Math.cos(d);
            double d7 = Math.sin(d);
            double d8 = Math.cos(d5);
            double d9 = Math.sin(d5);
            double d10 = sphericalTriangle.vertices[2][2];
            double d11 = Math.sqrt(1.0 - d10 * d10);
            double d12 = Math.atan(d11 / (d6 * d10 + d7 * d8 / d9));
            double[] dArray = new double[]{Math.sin(d12), 0.0, Math.cos(d12)};
            n9 = n5 / 2;
            object = new double[n9][3];
            SphericalTriangle[] sphericalTriangleArray4 = new SphericalTriangle[n9];
            int n18 = 0;
            for (n17 = 0; n17 < n5; ++n17) {
                SphericalTriangle sphericalTriangle6 = sphericalTriangleArray[n17];
                if (sphericalTriangle6.id != 0 || sphericalTriangle6.parity != 1) continue;
                sphericalTriangleArray4[n18] = sphericalTriangle6;
                for (int i = 0; i < 3; ++i) {
                    double d13 = 0.0;
                    for (int j = 0; j < 3; ++j) {
                        d13 += sphericalTriangle6.isometry[j][i] * dArray[j];
                    }
                    object[n18][i] = d13;
                }
                sphericalTriangle6.links[2].id = sphericalTriangle6.id = 1 + n18;
                ++n18;
            }
            n17 = nArray2[0][1] == 2 ? 1 : 0;
            n4 = n17 != 0 ? 3 : 4;
            nArray3 = new int[n9][n4];
            for (int i = 0; i < n9; ++i) {
                SphericalTriangle sphericalTriangle7 = sphericalTriangleArray4[i];
                nArray3[i][0] = sphericalTriangle7.links[0].id - 1;
                nArray3[i][1] = sphericalTriangle7.links[1].id - 1;
                if (n17 == 0) {
                    nArray3[i][2] = sphericalTriangle7.links[2].links[1].id - 1;
                }
                nArray3[i][n4 - 1] = sphericalTriangle7.links[2].links[2].id - 1;
            }
        } else if (n6 == 3) {
            int n19;
            SphericalTriangle sphericalTriangle8;
            int n20;
            double[] dArray = sphericalTriangle.inCentre();
            n9 = n5;
            object = new double[n9][3];
            for (n20 = 0; n20 < n5; ++n20) {
                sphericalTriangle8 = sphericalTriangleArray[n20];
                for (n19 = 0; n19 < 3; ++n19) {
                    double d = 0.0;
                    for (int i = 0; i < 3; ++i) {
                        d += sphericalTriangle8.isometry[i][n19] * dArray[i];
                    }
                    object[n20][n19] = d;
                }
                sphericalTriangle8.id = 1 + n20;
            }
            n4 = 3;
            nArray3 = new int[n9][n4];
            for (n20 = 0; n20 < n9; ++n20) {
                sphericalTriangle8 = sphericalTriangleArray[n20];
                for (n19 = 0; n19 < 3; ++n19) {
                    nArray3[n20][n19] = sphericalTriangle8.links[n19].id - 1;
                }
            }
        }
        Polyhedron polyhedron = new Polyhedron((double[][])object, n9, nArray3);
        boolean bl4 = n6 == 0;
        int n21 = n = bl4 ? n5 / 2 : n5;
        if (bl) {
            polyhedron.isometries = new double[n][][];
            polyhedron.even_isometry = new boolean[n];
            int n22 = 0;
            for (int i = 0; i < n5; ++i) {
                boolean bl5;
                boolean bl6 = bl5 = sphericalTriangleArray[i].parity == 1;
                if (bl4 && !bl5) continue;
                polyhedron.isometries[n22] = sphericalTriangleArray[i].isometry;
                polyhedron.even_isometry[n22++] = bl5;
            }
        }
        if (bl2 || bl3) {
            polyhedron.vertex_permutations = new int[n][n9];
            int n23 = 0;
            for (int i = 0; i < n5; ++i) {
                if (bl4 && sphericalTriangleArray[i].parity != 1) continue;
                Polyhedron.visitTile(sphericalTriangle, sphericalTriangleArray[i], sphericalTriangleArray[i].parity, polyhedron.vertex_permutations[n23++], bl4);
            }
        }
        if (bl3) {
            int n24 = polyhedron.NF;
            polyhedron.face_permutations = new int[n][n24];
            int n25 = 1 + n9 / 31;
            int[][] nArrayArray = new int[n24][];
            for (int i = 0; i < n; ++i) {
                objectArray = polyhedron.vertex_permutations[i];
                int[] nArray4 = polyhedron.face_permutations[i];
                block24: for (int j = 0; j < n24; ++j) {
                    int[] nArray5 = polyhedron.face_vertices[j];
                    n3 = nArray5.length;
                    int[] nArray6 = new int[n25];
                    for (n2 = 0; n2 < n3; ++n2) {
                        double d = objectArray[nArray5[n2]];
                        double d14 = d / 31;
                        nArray6[d14] = nArray6[d14] | 1 << d % 31;
                    }
                    if (i == 0) {
                        nArrayArray[j] = nArray6;
                        nArray4[j] = j;
                        continue;
                    }
                    for (n2 = 0; n2 < n24; ++n2) {
                        int n26;
                        for (n26 = 0; n26 < n25 && nArray6[n26] == nArrayArray[n2][n26]; ++n26) {
                        }
                        if (n26 != n25) continue;
                        nArray4[j] = n2;
                        continue block24;
                    }
                }
            }
            if (!bl2) {
                polyhedron.vertex_permutations = null;
            }
        }
        return polyhedron;
    }

    private static void visitTile(SphericalTriangle sphericalTriangle, SphericalTriangle sphericalTriangle2, int n, int[] nArray, boolean bl) {
        if (!bl || sphericalTriangle.parity == 1) {
            nArray[sphericalTriangle.id - 1] = sphericalTriangle2.id - 1;
        }
        for (int i = 0; i < 3; ++i) {
            if ((sphericalTriangle.tilingFlags & 1 << i) == 0) continue;
            Polyhedron.visitTile(sphericalTriangle.links[i], sphericalTriangle2.links[n == 1 ? i : 2 - i], n, nArray, bl);
        }
    }

    public static double computeGeometry(double[] dArray, int n, double[] dArray2, double[] dArray3) {
        int n2;
        int n3;
        double d;
        int n4;
        int n5 = dArray.length;
        double[] dArray4 = new double[n5];
        int[] nArray = new int[n5];
        int n6 = 0;
        int n7 = 0;
        int[] nArray2 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            int n8;
            double d2 = dArray[i];
            for (n8 = 0; n8 < n6 && dArray4[n8] != d2; ++n8) {
            }
            if (n8 == n6) {
                dArray4[n6++] = d2;
                if (d2 > dArray4[n7]) {
                    n7 = n8;
                }
            }
            nArray2[i] = n8;
            int n9 = n8;
            nArray[n9] = nArray[n9] + 1;
        }
        double[] dArray5 = new double[n6];
        double[] dArray6 = new double[n6];
        double d3 = Math.PI * (double)n;
        for (n4 = 0; n4 < n6; ++n4) {
            double d4 = Math.PI / dArray4[n4];
            dArray5[n4] = Math.cos(d4);
        }
        if (n6 == 1) {
            dArray6[0] = d3 / (double)n5;
            d = dArray5[0] / Math.sin(dArray6[0]);
        } else {
            for (n4 = 0; n4 < n6; ++n4) {
                dArray6[n4] = Math.PI * (0.5 - 1.0 / dArray4[n4]);
            }
            d = dArray5[n7] / Math.sin(dArray6[n7]);
            block4: while (true) {
                int n10;
                double d5 = d3;
                for (n3 = 0; n3 < n6; ++n3) {
                    d5 -= (double)nArray[n3] * dArray6[n3];
                }
                if (Math.abs(d5) < 1.0E-10) break;
                double d6 = 0.0;
                for (n10 = 0; n10 < n6; ++n10) {
                    d6 += (double)nArray[n10] * Math.tan(dArray6[n10]);
                }
                int n11 = n7;
                dArray6[n11] = dArray6[n11] + d5 * Math.tan(dArray6[n7]) / d6;
                d = dArray5[n7] / Math.sin(dArray6[n7]);
                n10 = 0;
                while (true) {
                    if (n10 >= n6) continue block4;
                    if (n10 != n7) {
                        dArray6[n10] = Math.asin(dArray5[n10] / d);
                    }
                    ++n10;
                }
                break;
            }
        }
        double[] dArray7 = new double[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            dArray7[n2] = Math.acos(1.0 / (Math.tan(Math.PI / dArray4[n2]) * Math.tan(dArray6[n2])));
        }
        for (n2 = 0; n2 < n5; ++n2) {
            n3 = nArray2[n2];
            if (dArray2 != null) {
                dArray2[n2] = dArray6[n3];
            }
            if (dArray3 == null) continue;
            dArray3[n2] = dArray7[n3];
        }
        return Math.acos(d);
    }

    public void transform(double[][] dArray, double d) {
        int n;
        double[] dArray2 = new double[3];
        double[][][] dArrayArray = new double[][][]{this.vertices, this.faces};
        int[] nArray = new int[]{this.NV, this.NF};
        boolean bl = d != 1.0;
        for (n = 0; n < 2; ++n) {
            boolean bl2 = bl && n == 0;
            double[][] dArray3 = dArrayArray[n];
            int n2 = nArray[n];
            for (int i = 0; i < n2; ++i) {
                int n3;
                double[] dArray4 = dArray3[i];
                for (n3 = 0; n3 < 3; ++n3) {
                    dArray2[n3] = 0.0;
                    double[] dArray5 = dArray[n3];
                    for (int j = 0; j < 3; ++j) {
                        int n4 = n3;
                        dArray2[n4] = dArray2[n4] + dArray5[j] * dArray4[j];
                    }
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    dArray4[n3] = bl2 ? d * dArray2[n3] : dArray2[n3];
                }
            }
        }
        if (bl) {
            for (n = 0; n < this.NF; ++n) {
                double[] dArray6 = this.faces[n];
                dArray6[3] = dArray6[3] * d;
            }
        }
    }

    public boolean contains(double[] dArray) {
        int n = this.NF;
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = this.faces[i];
            double d = -dArray2[3];
            for (int j = 0; j < 3; ++j) {
                d += dArray[j] * dArray2[j];
            }
            if (!(d > 0.0)) continue;
            return false;
        }
        return true;
    }

    public int edgeIntersections(Polyhedron polyhedron, int[][] nArray, double[][] dArray) {
        int n;
        int n2;
        Object[] objectArray;
        int n3 = this.NV;
        int n4 = polyhedron.NF;
        double[][] dArray2 = new double[n3][n4];
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = this.vertices[i];
            objectArray = dArray2[i];
            for (n2 = 0; n2 < n4; ++n2) {
                double[] dArray4 = polyhedron.faces[n2];
                double d = -dArray4[3];
                for (n = 0; n < 3; ++n) {
                    d += dArray4[n] * dArray3[n];
                }
                objectArray[n2] = d;
            }
        }
        double[] dArray5 = new double[2];
        int n5 = this.NE;
        objectArray = new int[2];
        n2 = 0;
        block3: for (int i = 0; i < n5; ++i) {
            int[] nArray2 = nArray[i];
            nArray2[0] = 0;
            int[] nArray3 = this.edge_vertices[i];
            n = nArray3[0];
            int n6 = nArray3[1];
            double[] dArray6 = dArray2[n];
            double[] dArray7 = dArray2[n6];
            double d = 0.0;
            double d2 = 1.0;
            int n7 = 0;
            int n8 = 0;
            for (int j = 0; j < n4; ++j) {
                double d3 = dArray6[j];
                double d4 = dArray7[j] - d3;
                if (d4 == 0.0) {
                    if (!(d3 > 0.0)) continue;
                    continue block3;
                }
                double d5 = -d3 / d4;
                if (d4 < 0.0) {
                    if (d5 > d) {
                        d = d5;
                        n7 = j;
                    }
                } else if (d5 < d2) {
                    d2 = d5;
                    n8 = j;
                }
                if (d > d2) continue block3;
            }
            dArray5[0] = d;
            dArray5[1] = d2;
            objectArray[0] = n7;
            objectArray[1] = n8;
            double[] dArray8 = this.vertices[n];
            double[] dArray9 = this.vertices[n6];
            int n9 = 0;
            for (int j = 0; j < 2; ++j) {
                double d6 = dArray5[j];
                if (!(d6 > 0.0) || !(d6 < 1.0)) continue;
                double[] dArray10 = new double[3];
                double d7 = 1.0 - d6;
                for (int k = 0; k < 3; ++k) {
                    dArray10[k] = d7 * dArray8[k] + d6 * dArray9[k];
                }
                dArray[n2] = dArray10;
                nArray2[2 * n9 + 1] = (int)objectArray[j];
                nArray2[2 * n9++ + 2] = n2++;
            }
            nArray2[0] = n9;
        }
        return n2;
    }

    public static Vector<BSPobject> faceIntersections(Polyhedron[] polyhedronArray, int n) {
        int n2;
        Object object;
        int n3;
        Object object2;
        Object object3;
        int n4;
        int n5;
        boolean bl = (n & 4) != 0;
        boolean bl2 = (n & 8) != 0;
        int[][][] nArrayArray = new int[2][][];
        double[][][] dArrayArray = new double[2][][];
        int n6 = polyhedronArray[0].NF;
        int n7 = polyhedronArray[1].NF;
        int[][][][] nArrayArray2 = new int[2][][][];
        int[][][] nArray = nArrayArray2[0] = new int[n6][n7][13];
        int[][][] nArray2 = nArrayArray2[1] = new int[n7][n6][];
        for (int i = 0; i < n6; ++i) {
            for (n5 = 0; n5 < n7; ++n5) {
                nArray2[n5][i] = nArray[i][n5];
            }
        }
        int[][] nArrayArray3 = new int[2][];
        for (n5 = 0; n5 < 2; ++n5) {
            Polyhedron polyhedron = polyhedronArray[n5];
            n4 = polyhedron.NE;
            nArrayArray[n5] = new int[n4][5];
            object3 = nArrayArray[n5];
            object2 = nArrayArray2[n5];
            double[][] dArrayArray2 = new double[2 * n4][];
            dArrayArray[n5] = dArrayArray2;
            polyhedron.edgeIntersections(polyhedronArray[1 - n5], (int[][])object3, dArrayArray2);
            nArrayArray3[n5] = new int[polyhedron.NF];
            int[] nArray3 = nArrayArray3[n5];
            for (n3 = 0; n3 < n4; ++n3) {
                int[] nArray4 = object3[n3];
                int n8 = nArray4[0];
                object = polyhedron.edge_faces[n3];
                double[] dArray = object[0];
                double[] dArray2 = object[1];
                for (int i = 0; i < n8; ++i) {
                    nArray3[dArray] = nArray3[dArray] + 1;
                    nArray3[dArray2] = nArray3[dArray2] + 1;
                    int n9 = nArray4[2 * i + 1];
                    int[] nArray5 = object2[dArray][n9];
                    int[] nArray6 = object2[dArray2][n9];
                    n2 = nArray5[0];
                    int n10 = nArray6[0];
                    int n11 = n5;
                    nArray6[n10 + 1] = n11;
                    nArray5[n2 + 1] = n11;
                    int n12 = n3;
                    nArray6[n10 + 2] = n12;
                    nArray5[n2 + 2] = n12;
                    int n13 = i;
                    nArray6[n10 + 3] = n13;
                    nArray5[n2 + 3] = n13;
                    int n14 = nArray4[2 * i + 2];
                    nArray6[n10 + 4] = n14;
                    nArray5[n2 + 4] = n14;
                    nArray5[n2 + 5] = (int)dArray2;
                    nArray6[n10 + 5] = (int)dArray;
                    nArray5[n2 + 6] = n10;
                    nArray6[n10 + 6] = n2;
                    nArray5[0] = nArray5[0] + 6;
                    nArray6[0] = nArray6[0] + 6;
                }
            }
        }
        Vector<BSPobject> vector = new Vector<BSPobject>(n6 + n7);
        for (int i = 0; i < 2; ++i) {
            n4 = 1 << i;
            if ((n4 & n) == 0) continue;
            object3 = polyhedronArray[i];
            object2 = polyhedronArray[1 - i];
            int n15 = ((Polyhedron)object3).NF;
            n3 = ((Polyhedron)object2).NF;
            int n16 = ((Polyhedron)object3).NV + 2 * n3;
            double[][] dArray = ((Polyhedron)object3).vertices;
            object = dArrayArray[i];
            double[][] dArrayArray3 = new double[n16][];
            int[] nArray7 = new int[n16];
            int[][] nArray8 = nArrayArray[i];
            int[][][] nArray9 = nArrayArray2[i];
            for (int j = 0; j < n15; ++j) {
                Gon3D gon3D;
                int n17;
                int n18;
                int n19 = ((Polyhedron)object3).face_vertices[j].length;
                int n20 = n2 = ((Polyhedron)object3).faces[j][2] > 0.0 ? 16 : 32;
                if ((n2 & n) == 0) continue;
                int[][] nArray10 = nArray9[j];
                int[] nArray11 = ((Polyhedron)object3).face_vertices[j];
                int[] nArray12 = ((Polyhedron)object3).face_edges[j];
                for (n18 = 0; n18 < n3 && nArray10[n18][0] != 12; ++n18) {
                }
                if (n18 < n3) {
                    n17 = nArrayArray3[i][j] == 0 ? 1 : 0;
                    gon3D = null;
                    boolean[] blArray = new boolean[n19];
                    block8: for (int k = 0; k < 2; ++k) {
                        Gon3D gon3D2;
                        int n21;
                        Object[] objectArray;
                        Object object4;
                        Object object5;
                        Object object6;
                        int n22;
                        int n23;
                        int n24 = n23 = k == 0 ? 4 : 8;
                        if ((n17 == 0 || k != 0) && (n23 & n) == 0) continue;
                        int n25 = n22 = k == 0 ? 0x8000000 : 0x10000000;
                        if (k == 1 && n17 != 0) {
                            object6 = gon3D.nvert;
                            int[] nArray13 = gon3D.edgeIDs;
                            double[][] dArray3 = gon3D.vertices;
                            object5 = ((Polyhedron)object3).faceToGon3D(j);
                            Vector<BSPobject> vector2 = new Vector<BSPobject>(1);
                            Vector<BSPobject> vector3 = new Vector<BSPobject>(1);
                            Vector<BSPobject> vector4 = new Vector<BSPobject>(1);
                            ((GonND)object5).BSPsplit(((Polyhedron)object2).faces[n18], 0x20000000, null, 0.0, null, vector2, vector3, vector4);
                            for (int i2 = 0; i2 < 2; ++i2) {
                                int n26;
                                int n27;
                                int n28;
                                Object object7 = object4 = i2 == 0 ? vector2 : vector4;
                                if (((Vector)object4).size() != 1) continue;
                                Gon3D gon3D3 = (Gon3D)((Vector)object4).elementAt(0);
                                double[][] dArray4 = gon3D3.vertices;
                                int n29 = gon3D3.nvert;
                                objectArray = gon3D3.edgeIDs;
                                if (i2 == 1) {
                                    n28 = n29 + 2;
                                    n27 = 1;
                                    n26 = 0;
                                } else {
                                    n28 = n29 + object6;
                                    n27 = 0;
                                    n26 = 1;
                                }
                                double[][] dArrayArray4 = new double[n28][];
                                int[] nArray14 = new int[n28];
                                n21 = 0;
                                for (int i3 = 0; i3 < n29; ++i3) {
                                    dArrayArray4[n21] = dArray4[i3];
                                    double d = objectArray[i3];
                                    nArray14[n21++] = (int)d;
                                    if ((d & 0x20000000) == 0) continue;
                                    int n30 = n27;
                                    while (true) {
                                        dArrayArray4[n21] = dArray3[n30];
                                        nArray14[n21++] = nArray13[(n30 + object6 - 1) % object6];
                                        if (n30 == n26) break;
                                        n30 = (n30 + object6 - 1) % object6;
                                    }
                                    nArray14[n21 - 1] = 0x20000000;
                                }
                                Gon3D gon3D4 = new Gon3D(dArrayArray4, n28);
                                gon3D4.edgeIDs = nArray14;
                                gon3D4.surfaceID = j;
                                gon3D4.flags = n4 | n23 | n2;
                                vector.addElement(gon3D4);
                            }
                            continue;
                        }
                        do {
                            boolean bl3;
                            boolean bl4;
                            object6 = 0;
                            int n31 = 0;
                            int n32 = 0;
                            object5 = null;
                            Object object8 = 0;
                            Object object9 = 0;
                            Object object10 = 0;
                            double[] dArray5 = null;
                            object4 = null;
                            if (k == 0) {
                                object5 = nArray10[n18];
                                double[] dArray6 = ((Polyhedron)object3).faces[j];
                                objectArray = ((Polyhedron)object2).faces[n18];
                                double[] dArray7 = dArrayArray[object5[1]][object5[4]];
                                double[] dArray8 = dArrayArray[object5[7]][object5[10]];
                                double d = 0.0;
                                for (int i4 = 0; i4 < 3; ++i4) {
                                    n21 = (i4 + 1) % 3;
                                    int n33 = (i4 + 2) % 3;
                                    d += (dArray8[i4] - dArray7[i4]) * (dArray6[n21] * objectArray[n33] - dArray6[n33] * objectArray[n21]);
                                }
                                if (d > 0.0) {
                                    object6 = 0;
                                    dArray5 = dArray7;
                                } else {
                                    object6 = 6;
                                    dArray5 = dArray8;
                                }
                                bl4 = false;
                                bl3 = true;
                                object10 = n18;
                            } else {
                                for (n32 = 0; n32 < n19 && (blArray[n32] || !bl && ((Polyhedron)object2).contains(dArray[nArray11[n32]])); ++n32) {
                                }
                                if (n32 == n19) continue block8;
                                dArray5 = dArray[nArray11[n32]];
                                blArray[n32] = true;
                                bl4 = false;
                                bl3 = false;
                            }
                            dArrayArray3[0] = dArray5;
                            while (true) {
                                if (bl3) {
                                    nArray7[n31++] = n22 | object10;
                                    object6 = 6 - object6;
                                    object5 = nArray10[object10];
                                    Object object11 = object5[object6 + 1];
                                    double[] dArray9 = dArrayArray[object11][object5[object6 + 4]];
                                    object4 = dArray9;
                                    if (dArray9 == dArray5) break;
                                    dArrayArray3[n31] = (double[])object4;
                                    if (object11 == i) {
                                        bl3 = false;
                                        object8 = object5[object6 + 2];
                                        object9 = object5[object6 + 3];
                                        n32 = -1;
                                        bl4 = false;
                                        continue;
                                    }
                                    object10 = object5[object6 + 5];
                                    object6 = object5[object6 + 6];
                                    continue;
                                }
                                if (n32 >= 0) {
                                    if (bl4) {
                                        double[] dArray10 = dArray[nArray11[n32]];
                                        object4 = dArray10;
                                        if (dArray10 == dArray5) break;
                                        dArrayArray3[n31] = (double[])object4;
                                        bl4 = false;
                                        blArray[n32] = true;
                                    }
                                    nArray7[n31++] = 0x40000000;
                                    object8 = nArray12[n32];
                                    int n34 = nArray8[object8][0];
                                    if (n34 == 0) {
                                        n32 = (n32 + 1) % n19;
                                    } else {
                                        object9 = n34 == 1 ? 0 : (((Polyhedron)object3).face_edge_rev[j][n32] ? 1 : 0);
                                        n32 = -1;
                                    }
                                    bl4 = true;
                                    continue;
                                }
                                if (bl4) {
                                    object10 = nArray8[object8][2 * object9 + 1];
                                    object5 = nArray10[object10];
                                    if (object5[object6 + 1] != i || object5[object6 + 2] != object8) {
                                        object6 = 6 - object6;
                                    }
                                    double[] dArray11 = dArrayArray[i][object5[object6 + 4]];
                                    object4 = dArray11;
                                    if (dArray11 == dArray5) break;
                                    dArrayArray3[n31] = (double[])object4;
                                    bl4 = false;
                                    bl3 = true;
                                    continue;
                                }
                                nArray7[n31++] = 0x40000000;
                                int n35 = nArray8[object8][0];
                                if (n35 == 2 && k == 0) {
                                    object9 = 1 - object9;
                                } else {
                                    for (n32 = 0; n32 < n19 && nArray12[n32] != object8; ++n32) {
                                    }
                                    if (n35 == 1 || object9 == (((Polyhedron)object3).face_edge_rev[j][n32] ? 0 : 1)) {
                                        n32 = (n32 + 1) % n19;
                                    } else {
                                        object9 = 1 - object9;
                                    }
                                }
                                bl4 = true;
                            }
                            gon3D2 = new Gon3D((double[][])dArrayArray3, 0, n31);
                            gon3D2.surfaceID = j;
                            gon3D2.flags = n4 | n23 | n2;
                            gon3D2.edgeIDs = new int[n31];
                            System.arraycopy(nArray7, 0, gon3D2.edgeIDs, 0, n31);
                            if (k == 0 && !bl) continue;
                            vector.addElement(gon3D2);
                        } while (k != 0);
                        gon3D = gon3D2;
                    }
                    continue;
                }
                int n36 = n17 = ((Polyhedron)object2).contains(dArray[nArray11[0]]) ? 4 : 8;
                if ((n17 & n) == 0) continue;
                gon3D = ((Polyhedron)object3).faceToGon3D(j);
                gon3D.surfaceID = j;
                gon3D.flags = n4 | n17 | n2;
                vector.addElement(gon3D);
            }
        }
        return vector;
    }

    public Gon3D faceToGon3D(int n) {
        int[] nArray = this.face_vertices[n];
        int n2 = nArray.length;
        double[][] dArrayArray = new double[n2][];
        for (int i = 0; i < n2; ++i) {
            dArrayArray[i] = this.vertices[nArray[i]];
        }
        Gon3D gon3D = new Gon3D(dArrayArray, n2);
        gon3D.surfaceID = n;
        gon3D.setEdgeIDs();
        return gon3D;
    }
}

