/*
 * Decompiled with CFR 0.152.
 */
package egan.geometry;

import egan.util.Utils;

public class SphericalTriangle {
    public int[][] vA;
    public double[][] vertices;
    private double[] sideCos;
    private double[] sideSin;
    public SphericalTriangle[] vertexOwner;
    public int[] vertexNumber;
    public double[][] edgeNormals;
    public SphericalTriangle[] links;
    public int[] linkEdges;
    public double[][] isometry;
    public int parity;
    public int tilingFlags;
    public int nsteps;
    public int[] steps;
    public int id;

    public SphericalTriangle(int[][] nArray) {
        int n;
        this.vA = nArray;
        this.links = new SphericalTriangle[3];
        this.linkEdges = new int[3];
        double d = Math.PI * (double)nArray[0][0] / (double)nArray[0][1];
        double d2 = Math.PI * (double)nArray[1][0] / (double)nArray[1][1];
        double d3 = Math.PI * (double)nArray[2][0] / (double)nArray[2][1];
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        double d6 = Math.cos(d2);
        double d7 = Math.sin(d2);
        double d8 = Math.cos(d3);
        double d9 = Math.sin(d3);
        double d10 = (d6 + d4 * d8) / (d5 * d9);
        double d11 = Math.sqrt(Math.abs(1.0 - d10 * d10));
        double d12 = d4 * d11;
        double d13 = Math.sqrt(Math.abs(1.0 - d12 * d12 - d10 * d10));
        double d14 = Math.abs(d4) < 1.0E-10 ? d5 * d8 / d7 : (d10 * d9 - d6 * d5) / (d4 * d7);
        double d15 = d9 * d11 / d7;
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 1.0}, {d15, 0.0, d14}, {d12, d13, d10}};
        this.vertices = dArrayArray;
        this.vertexOwner = new SphericalTriangle[3];
        this.vertexNumber = new int[3];
        for (n = 0; n < 3; ++n) {
            this.vertexOwner[n] = this;
            this.vertexNumber[n] = n;
        }
        this.computeEdgeNormals();
        this.isometry = new double[3][3];
        for (n = 0; n < 3; ++n) {
            this.isometry[n][n] = 1.0;
        }
        this.parity = 1;
    }

    public SphericalTriangle(SphericalTriangle sphericalTriangle, int n) {
        int n2;
        this.vA = new int[3][];
        for (n2 = 0; n2 < 3; ++n2) {
            this.vA[n2] = sphericalTriangle.vA[2 - n2];
        }
        this.links = new SphericalTriangle[3];
        this.linkEdges = new int[3];
        n2 = 2 - n;
        sphericalTriangle.links[n] = this;
        sphericalTriangle.linkEdges[n] = n2;
        this.links[n2] = sphericalTriangle;
        this.linkEdges[n2] = n;
        int n3 = (n + 1) % 3;
        int n4 = (n + 2) % 3;
        this.vertices = new double[3][];
        double[] dArray = sphericalTriangle.vertices[n3];
        this.vertices[2 - n3] = dArray;
        double[] dArray2 = dArray;
        double[] dArray3 = sphericalTriangle.vertices[n4];
        this.vertices[2 - n4] = dArray3;
        double[] dArray4 = dArray3;
        this.vertexOwner = new SphericalTriangle[3];
        this.vertexNumber = new int[3];
        this.vertexOwner[n2] = this;
        this.vertexNumber[n2] = n2;
        this.vertexOwner[2 - n3] = sphericalTriangle.vertexOwner[n3];
        this.vertexNumber[2 - n3] = sphericalTriangle.vertexNumber[n3];
        this.vertexOwner[2 - n4] = sphericalTriangle.vertexOwner[n4];
        this.vertexNumber[2 - n4] = sphericalTriangle.vertexNumber[n4];
        double[] dArray5 = sphericalTriangle.edgeNormals[n];
        double[][] dArray6 = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray6[i][j] = (i == j ? 1.0 : 0.0) - 2.0 * dArray5[i] * dArray5[j];
            }
        }
        this.vertices[n2] = new double[3];
        double[] dArray7 = this.vertices[n2];
        double[] dArray8 = sphericalTriangle.vertices[n];
        for (int i = 0; i < 3; ++i) {
            double d = 0.0;
            for (int j = 0; j < 3; ++j) {
                d += dArray6[i][j] * dArray8[j];
            }
            dArray7[i] = d;
        }
        this.computeEdgeNormals();
        this.isometry = new double[3][3];
        double[][] dArray9 = sphericalTriangle.isometry;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double d = 0.0;
                for (int k = 0; k < 3; ++k) {
                    d += dArray9[i][k] * dArray6[k][j];
                }
                this.isometry[i][j] = d;
            }
        }
        this.parity = -sphericalTriangle.parity;
    }

    public SphericalTriangle[] tiling(int n) {
        SphericalTriangle[] sphericalTriangleArray = new SphericalTriangle[n];
        sphericalTriangleArray[0] = this;
        this.tilingFlags = 0;
        this.nsteps = 0;
        this.steps = null;
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = 0;
            block1: for (n6 = n2; n6 < i; ++n6) {
                for (n7 = 0; n7 < 3; ++n7) {
                    if (sphericalTriangleArray[n6].links[n7] == null) break block1;
                }
            }
            if (n6 == i) break;
            n2 = n6;
            SphericalTriangle sphericalTriangle = sphericalTriangleArray[n6];
            SphericalTriangle sphericalTriangle2 = sphericalTriangleArray[i] = new SphericalTriangle(sphericalTriangle, n7);
            sphericalTriangle.tilingFlags |= 1 << n7;
            int n8 = sphericalTriangle.nsteps;
            int[] nArray = sphericalTriangle.steps;
            int n9 = sphericalTriangle2.nsteps = n8 + 1;
            sphericalTriangle2.steps = new int[n9];
            int[] nArray2 = sphericalTriangle2.steps;
            for (n5 = 0; n5 < n8; ++n5) {
                nArray2[n5] = nArray[n5];
            }
            nArray2[n8] = n7;
            n5 = 2 - n7;
            double[][] dArray = sphericalTriangle2.vertices;
            double[] dArray2 = dArray[n5];
            block4: for (n4 = 0; n4 < i; ++n4) {
                sphericalTriangle = sphericalTriangleArray[n4];
                for (n3 = 0; n3 < 3; ++n3) {
                    if (sphericalTriangle.vertexOwner[n3] != sphericalTriangle || !SphericalTriangle.equals(dArray2, sphericalTriangle.vertices[n3])) continue;
                    dArray[n5] = sphericalTriangle.vertices[n3];
                    dArray2 = dArray[n5];
                    sphericalTriangle2.vertexOwner[n5] = sphericalTriangle;
                    sphericalTriangle2.vertexNumber[n5] = n3;
                    break block4;
                }
            }
            n4 = -sphericalTriangle2.parity;
            block6: for (n3 = 1; n3 <= 2; ++n3) {
                int n10 = (n5 + n3) % 3;
                double[] dArray3 = dArray[n10];
                int n11 = (n5 + 3 - n3) % 3;
                int n12 = 2 - n11;
                for (n6 = n2; n6 < i; ++n6) {
                    double[][] dArray4;
                    sphericalTriangle = sphericalTriangleArray[n6];
                    if (sphericalTriangle.parity != n4 || sphericalTriangle.links[n12] != null || (dArray4 = sphericalTriangle.vertices)[2 - n5] != dArray2 || dArray4[2 - n10] != dArray3) continue;
                    sphericalTriangle2.links[n11] = sphericalTriangle;
                    sphericalTriangle2.linkEdges[n11] = n12;
                    sphericalTriangle.links[n12] = sphericalTriangle2;
                    sphericalTriangle.linkEdges[n12] = n11;
                    continue block6;
                }
            }
        }
        return sphericalTriangleArray;
    }

    private void computeEdgeNormals() {
        this.edgeNormals = new double[3][];
        for (int i = 0; i < 3; ++i) {
            int n = (i + 1) % 3;
            int n2 = (i + 2) % 3;
            this.edgeNormals[i] = Utils.cross(this.vertices[n], this.vertices[n2]);
            Utils.normalise(this.edgeNormals[i]);
        }
    }

    private static boolean equals(double[] dArray, double[] dArray2) {
        double d = -1.0;
        for (int i = 0; i < 3; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return Math.abs(d) < 1.0E-10;
    }

    public void rotate(double[][] dArray) {
        for (int i = 0; i < 3; ++i) {
            if (this.vertexOwner[i] == this) {
                Utils.transform(dArray, this.vertices[i]);
            }
            Utils.transform(dArray, this.edgeNormals[i]);
        }
        double[][] dArray2 = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double[] dArray3 = dArray2[i];
                    int n = j;
                    dArray3[n] = dArray3[n] + this.isometry[i][k] * dArray[j][k];
                }
            }
        }
        this.isometry = dArray2;
    }

    public double[] inCentre() {
        int n;
        this.computeSideTrig();
        double d = 0.0;
        double[] dArray = new double[3];
        for (n = 0; n < 3; ++n) {
            d += this.sideSin[n] * this.sideSin[n] + 2.0 * this.sideCos[n] * this.sideSin[(n + 1) % 3] * this.sideSin[(n + 2) % 3];
        }
        d = Math.sqrt(d);
        for (n = 0; n < 3; ++n) {
            dArray[n] = this.sideSin[n] / d;
        }
        double[] dArray2 = new double[3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n2 = j;
                dArray2[n2] = dArray2[n2] + dArray[i] * this.vertices[i][j];
            }
        }
        return dArray2;
    }

    public double[] pointFromAngles(double[] dArray) {
        int n;
        int n2;
        this.computeSideTrig();
        double d = this.sideCos[0];
        double d2 = this.sideCos[1];
        double d3 = this.sideCos[2];
        double d4 = 1.0 - d * d - d2 * d2 - d3 * d3 + 2.0 * d * d2 * d3;
        double[][] dArray2 = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (n2 = 0; n2 < 3; ++n2) {
                dArray2[i][n2] = (i == n2 ? this.sideSin[i] * this.sideSin[i] : this.sideCos[i] * this.sideCos[n2] - this.sideCos[3 - i - n2]) / d4;
            }
        }
        double[] dArray3 = new double[3];
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                int n3 = n2;
                dArray3[n3] = dArray3[n3] + dArray2[n2][n] * dArray[n];
            }
        }
        double[] dArray4 = new double[3];
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 3; ++i) {
                int n4 = i;
                dArray4[n4] = dArray4[n4] + dArray3[n] * this.vertices[n][i];
            }
        }
        return dArray4;
    }

    private void computeSideTrig() {
        this.sideCos = new double[3];
        this.sideSin = new double[3];
        for (int i = 0; i < 3; ++i) {
            double d = 0.0;
            double[] dArray = this.vertices[(i + 1) % 3];
            double[] dArray2 = this.vertices[(i + 2) % 3];
            for (int j = 0; j < 3; ++j) {
                d += dArray[j] * dArray2[j];
            }
            this.sideCos[i] = d;
            this.sideSin[i] = Math.sqrt(1.0 - d * d);
        }
    }
}

